/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.data;

import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.data.ColumnCollection;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataViewCollection;
import com.kingdee.bos.metadata.data.ForeignKeyCollection;
import com.kingdee.bos.metadata.data.IndexCollection;
import com.kingdee.bos.metadata.data.PrimaryKeyInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.validate.ValidateList;
import com.kingdee.bos.metadata.validate.ValidateMetaData;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class AbstractTableInfo
extends AbstractMetaDataValue
implements Serializable {
    private static final int langNumber = 3;
    private transient Map nameColumnMap = new HashMap(4);

    public AbstractTableInfo() {
        this.put("columns", new ColumnCollection());
        this.put("indexes", new IndexCollection());
        this.put("foreignKeys", new ForeignKeyCollection());
        this.put("dataViews", new DataViewCollection());
    }

    protected AbstractTableInfo(boolean init) {
        super(init);
        this.put("columns", new ColumnCollection());
        this.put("indexes", new IndexCollection());
        this.put("foreignKeys", new ForeignKeyCollection());
    }

    public ColumnCollection getColumns() {
        return (ColumnCollection)this.get("columns");
    }

    public PrimaryKeyInfo getPrimaryKey() {
        return (PrimaryKeyInfo)this.get("primaryKey");
    }

    public void setPrimaryKey(PrimaryKeyInfo primaryKey) {
        this.put("primaryKey", primaryKey);
    }

    public IndexCollection getIndexes() {
        return (IndexCollection)this.get("indexes");
    }

    public ForeignKeyCollection getForeignKeys() {
        return (ForeignKeyCollection)this.get("foreignKeys");
    }

    public DataViewCollection getDataViews() {
        return (DataViewCollection)this.get("dataViews");
    }

    @Override
    public ValidateList validate() {
        ForeignKeyCollection fks;
        ColumnCollection cls;
        super.validate();
        ValidateMetaData vld = this.getValidate();
        vld.validateKsqlIdentifier("Table Name", this.getName());
        if (this.getName().length() > 30) {
            vld.addError("The name's length of table '" + this.getName() + "' should shorter than 30 charactors");
        }
        if ((cls = this.getColumns()) == null || cls.size() == 0) {
            vld.addFatal("No column defined.");
        } else {
            int columnSize = 0;
            HashMap<String, ColumnInfo> map = new HashMap<String, ColumnInfo>();
            int times = 1;
            for (int i = 0; i < cls.size(); ++i) {
                ColumnInfo column = cls.get(i);
                vld.addValidateList(column.validate());
                if (map.containsKey(column.getName().toUpperCase())) {
                    vld.addError("Duplicated column name: " + column.getName());
                } else {
                    map.put(column.getName().toUpperCase(), column);
                }
                times = column.isMultilingual() ? 3 : 1;
                SQLType typeName = column.getTypeName();
                if (SQLType.CHAR.equals(typeName)) {
                    columnSize += column.getLength() * times;
                } else if (SQLType.NCHAR.equals(typeName)) {
                    columnSize += column.getLength() * times;
                } else if (SQLType.VARCHAR.equals(typeName)) {
                    columnSize += column.getLength() * times;
                } else if (SQLType.NVARCHAR.equals(typeName)) {
                    columnSize += column.getLength() * times;
                } else if (SQLType.NUMERIC.equals(typeName)) {
                    columnSize += 17 * times;
                } else if (SQLType.BINARY.equals(typeName)) {
                    columnSize += column.getLength() * times;
                } else if (SQLType.VARBINARY.equals(typeName)) {
                    columnSize += column.getLength() * times;
                } else if (SQLType.BLOB.equals(typeName)) {
                    columnSize += 16 * times;
                } else if (SQLType.CLOB.equals(typeName)) {
                    columnSize += 16 * times;
                } else if (SQLType.NCLOB.equals(typeName)) {
                    columnSize += 16 * times;
                } else if (SQLType.DATETIME.equals(typeName)) {
                    columnSize += 4 * times;
                } else if (SQLType.INT.equals(typeName)) {
                    columnSize += 4 * times;
                }
                if (columnSize <= 8000) continue;
                vld.addError("Total size of all column is more than 8000.");
            }
        }
        if (this.getPrimaryKey() == null) {
            vld.addWarning("Table must contains a Primary Key.");
        } else {
            vld.addValidateList(this.getPrimaryKey().validate());
        }
        IndexCollection idxes = this.getIndexes();
        if (idxes != null) {
            for (int i = 0; i < idxes.size(); ++i) {
                vld.addValidateList(idxes.get(i).validate());
            }
        }
        if ((fks = this.getForeignKeys()) != null) {
            for (int i = 0; i < fks.size(); ++i) {
                vld.addValidateList(fks.get(i).validate());
            }
        }
        return vld.getValidateList();
    }

    public boolean existsColumn(ColumnInfo column) {
        for (int i = 0; i < this.getColumns().size(); ++i) {
            if (!this.getColumns().get(i).equalsDB(column)) continue;
            return true;
        }
        return false;
    }

    public String getOldTableName() {
        return (String)this.get("oldTableName");
    }

    public void setOldTableName(String oldTableName) {
        this.put("oldTableName", oldTableName);
    }

    @Override
    public BOSObjectType getBOSType() {
        return MetaDataTypeList.ABSTRACTTABLE;
    }

    public ColumnInfo getColumnByName(String name) {
        if (StringUtils.isEmpty((String)name)) {
            return null;
        }
        ColumnCollection columns = this.getColumns();
        if (columns == null) {
            System.out.println("table is:" + this.getName() + " columns is null" + name);
            return null;
        }
        int n = columns.size();
        for (int i = 0; i < n; ++i) {
            if (!name.equalsIgnoreCase(columns.get(i).getName())) continue;
            return columns.get(i);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColumnInfo getColumnByNameRuntime(String name) {
        assert (!StringUtils.isEmpty((String)name));
        ColumnInfo column = (ColumnInfo)this.nameColumnMap.get(name);
        if (column != null) {
            return column.cvalue();
        }
        Map map = this.nameColumnMap;
        synchronized (map) {
            column = (ColumnInfo)this.nameColumnMap.get(name);
            if (column == null) {
                column = ColumnInfo.cnulls(this.getColumnByName(name));
                this.nameColumnMap.put(name, column);
            }
            return column.cvalue();
        }
    }

    @Override
    public void setUserDefined(boolean isUserDefined) {
        this.put("userDefined", isUserDefined);
    }

    @Override
    public boolean isUserDefined() {
        return this.getBoolean("userDefined");
    }

    public void setBizUnitPK(String bizUnitPK) {
        this.put("bizUnitPK", bizUnitPK);
    }

    public String getBizUnitPK() {
        return this.getString("bizUnitPK");
    }
}

