/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.data;

import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.data.AbstractTableInfo;
import com.kingdee.bos.metadata.data.ExtendedTableCollection;
import com.kingdee.bos.metadata.data.ExtendedTableInfo;
import com.kingdee.bos.metadata.validate.ValidateList;
import com.kingdee.bos.metadata.validate.ValidateMetaData;
import com.kingdee.bos.util.BOSObjectType;
import java.io.Serializable;
import java.util.HashMap;

public class DataTableInfo
extends AbstractTableInfo
implements Serializable {
    public DataTableInfo() {
        this.put("extendedTables", new ExtendedTableCollection());
    }

    protected DataTableInfo(boolean init) {
        super(init);
        this.put("extendedTables", new ExtendedTableCollection());
    }

    @Override
    public BOSObjectType getBOSType() {
        return MetaDataTypeList.DATATABLE;
    }

    public ExtendedTableCollection getExtendedTables() {
        return (ExtendedTableCollection)this.get("extendedTables");
    }

    @Override
    public String getOldTableName() {
        return (String)this.get("oldTableName");
    }

    @Override
    public void setOldTableName(String oldTableName) {
        this.put("oldTableName", oldTableName);
    }

    public boolean existsExtendedTable(ExtendedTableInfo extTable) {
        for (int i = 0; i < this.getExtendedTables().size(); ++i) {
            if (!this.getExtendedTables().get(i).getFullName().equals(extTable.getFullName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public ValidateList validate() {
        super.validate();
        ValidateMetaData vld = this.getValidate();
        if (this.getExtendedTables() != null && this.getExtendedTables().size() > 0) {
            HashMap<String, ExtendedTableInfo> map = new HashMap<String, ExtendedTableInfo>();
            for (int i = 0; i < this.getExtendedTables().size(); ++i) {
                ExtendedTableInfo ext = this.getExtendedTables().get(i);
                if (map.containsKey(ext.getFullName())) {
                    vld.addError("Duplicated extended table: " + ext.getFullName());
                } else {
                    map.put(ext.getFullName(), ext);
                }
                if (this.getPrimaryKey().equalsDB(ext.getPrimaryKey())) continue;
                vld.addError("ExtendedTable '" + ext.getFullName() + "' must has the same PrimaryKey with BaseTable.");
            }
        }
        return vld.getValidateList();
    }
}

