/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.data;

import com.kingdee.bos.dao.xml.impl.AbstractMDElement;
import com.kingdee.bos.metadata.data.AbstractTableInfo;
import com.kingdee.bos.metadata.data.FKColumnPairCollection;
import com.kingdee.bos.metadata.data.FKColumnPairInfo;
import com.kingdee.bos.metadata.validate.ValidateList;
import com.kingdee.bos.metadata.validate.ValidateMetaData;
import com.kingdee.bos.sql.formater.DrSQLFormater;
import com.kingdee.bos.util.BOSObjectType;
import java.io.Serializable;

public class ForeignKeyInfo
extends AbstractMDElement
implements Serializable {
    private static final BOSObjectType BOS_TYPE = BOSObjectType.create((String)"fgky");

    public ForeignKeyInfo() {
        this.put("fkColumnPairs", new FKColumnPairCollection());
    }

    public String getName() {
        return this.getString("name");
    }

    public void setName(String name) {
        this.setString("name", name);
    }

    public boolean isUserDefined() {
        return this.getBoolean("userDefined");
    }

    public void setUserDefined(boolean userDefined) {
        this.setBoolean("userDefined", userDefined);
    }

    public AbstractTableInfo getRefTable() {
        return (AbstractTableInfo)this.get("refTable");
    }

    public void setRefTable(AbstractTableInfo table) {
        this.put("refTable", table);
    }

    public FKColumnPairCollection getFKColumnPairs() {
        return (FKColumnPairCollection)this.get("fkColumnPairs");
    }

    public boolean equals1(Object that) {
        return this.equalsName(that);
    }

    public boolean euqlas2(Object that) {
        return this.equalsDB(that);
    }

    public ValidateList validate() {
        ValidateMetaData vld = new ValidateMetaData();
        DrSQLFormater formater = new DrSQLFormater();
        if (!formater.isValidateConstraintName(this.getName())) {
            vld.addError("Invalid ForeignKey name :" + this.getName());
        }
        if (this.getRefTable() == null) {
            vld.addError("Primary Table can not be null.");
        }
        if (this.getFKColumnPairs() == null || this.getFKColumnPairs().size() == 0) {
            vld.addError("ForeignKey must contains one pair of column at least.");
        } else {
            for (int i = 0; i < this.getFKColumnPairs().size(); ++i) {
                FKColumnPairInfo fkPair = this.getFKColumnPairs().get(i);
                if (fkPair.getPrimaryKeyColumn() == null || fkPair.getForeignKeyColumn() == null) {
                    vld.addError("Invalid ForeignKey column pairs.");
                    continue;
                }
                if (this.getName().length() <= 18) continue;
                vld.addError("The name's length of foreign key\uff1a '" + this.getName() + "' should shorter than 18 charactors");
            }
        }
        return vld.getValidateList();
    }

    public boolean equalsName(Object that) {
        if (that == this) {
            return true;
        }
        if (that == null || !(that instanceof ForeignKeyInfo)) {
            return false;
        }
        ForeignKeyInfo c1 = (ForeignKeyInfo)that;
        if (this.getName() == null) {
            return c1.getName() == null;
        }
        return this.getName().equalsIgnoreCase(c1.getName());
    }

    public boolean equalsDB(Object that) {
        if (!this.equalsName(that)) {
            return false;
        }
        ForeignKeyInfo fk1 = (ForeignKeyInfo)that;
        if (!this.getRefTable().equals(fk1.getRefTable())) {
            return false;
        }
        FKColumnPairCollection thisColumns = this.getFKColumnPairs();
        FKColumnPairCollection fk1Columns = fk1.getFKColumnPairs();
        if (thisColumns == null) {
            return fk1Columns == null;
        }
        if (thisColumns.size() != fk1Columns.size()) {
            return false;
        }
        int n = thisColumns.size();
        for (int i = 0; i < n; ++i) {
            if (thisColumns.get(i).equalsDB(fk1Columns.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public BOSObjectType getBOSType() {
        return BOS_TYPE;
    }
}

