/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.data;

import com.kingdee.bos.dao.xml.impl.AbstractMDElement;
import com.kingdee.bos.metadata.data.IndexColumnCollection;
import com.kingdee.bos.metadata.data.IndexColumnInfo;
import com.kingdee.bos.metadata.data.IndexScriptCollection;
import com.kingdee.bos.metadata.validate.ValidateList;
import com.kingdee.bos.metadata.validate.ValidateMetaData;
import com.kingdee.bos.sql.formater.DrSQLFormater;
import com.kingdee.bos.util.BOSObjectType;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;

public class IndexInfo
extends AbstractMDElement
implements Serializable {
    private static final BOSObjectType BOS_TYPE = BOSObjectType.create((String)"indx");

    public IndexInfo() {
        this.put("indexColumns", new IndexColumnCollection());
        this.put("scripts", new IndexScriptCollection());
    }

    public String getName() {
        return this.getString("name");
    }

    public void setName(String name) {
        this.setString("name", name);
    }

    public boolean isUserDefined() {
        return this.getBoolean("userDefined");
    }

    public void setUserDefined(boolean userDefined) {
        this.setBoolean("userDefined", userDefined);
    }

    public boolean isClusteredIndex() {
        return this.getBoolean("isClusteredIndex");
    }

    public void setClusteredIndex(boolean b) {
        this.setBoolean("isClusteredIndex", b);
    }

    public boolean isUnique() {
        return this.getBoolean("isUnique");
    }

    public void setUnique(boolean b) {
        this.setBoolean("isUnique", b);
    }

    public IndexColumnCollection getIndexColumns() {
        return (IndexColumnCollection)this.get("indexColumns");
    }

    public void setIndexColumns(IndexColumnCollection indexColumns) {
        this.put("indexColumns", indexColumns);
    }

    public IndexScriptCollection getScripts() {
        return (IndexScriptCollection)this.get("scripts");
    }

    public ValidateList validate() {
        ValidateMetaData vld = new ValidateMetaData();
        DrSQLFormater formater = new DrSQLFormater();
        if (!formater.isValidateConstraintName(this.getName())) {
            vld.addError("Invalid index name :" + this.getName());
        }
        if (this.getName().length() > 18) {
            vld.addError("The name's length of index: '" + this.getName() + "' should shorter than 18 charactors");
        }
        if (this.getIndexColumns() == null || this.getIndexColumns().size() == 0) {
            vld.addError("Index must contains one column at least.");
        } else {
            IndexColumnInfo idxColumn;
            HashMap<String, IndexColumnInfo> map = new HashMap<String, IndexColumnInfo>();
            for (int i = 0; i < this.getIndexColumns().size(); ++i) {
                idxColumn = this.getIndexColumns().get(i);
                String name = idxColumn.getColumn().getName();
                if (map.containsKey(name)) {
                    vld.addError("Duplicated column in primaryKey: '" + name + "'");
                    continue;
                }
                map.put(name, idxColumn);
            }
            if (this.isUnique()) {
                Iterator iter = map.values().iterator();
                idxColumn = null;
                boolean isNullable = true;
                String name = "";
                while (iter.hasNext()) {
                    idxColumn = (IndexColumnInfo)iter.next();
                    if (!idxColumn.getColumn().isNullable()) {
                        isNullable = false;
                        break;
                    }
                    name = name + idxColumn.getColumn().getName() + "  ";
                }
                if (isNullable) {
                    vld.addError("UniqueIndex can't contains Nullable Column(s): '" + name + "'");
                }
            }
        }
        return vld.getValidateList();
    }

    public boolean equals1(Object that) {
        return this.equalsName(that);
    }

    public boolean equals2(Object that) {
        return this.equalsDB(that);
    }

    public boolean equalsName(Object that) {
        if (that == this) {
            return true;
        }
        if (!(that instanceof IndexInfo)) {
            return false;
        }
        IndexInfo c1 = (IndexInfo)that;
        if (this.getName() == null) {
            return c1.getName() == null;
        }
        return this.getName().equalsIgnoreCase(c1.getName());
    }

    public boolean equalsDB(Object that) {
        if (!this.equalsName(that)) {
            return false;
        }
        IndexInfo index1 = (IndexInfo)that;
        IndexColumnCollection thisColumns = this.getIndexColumns();
        IndexColumnCollection index1Columns = index1.getIndexColumns();
        if (thisColumns == null) {
            return index1Columns == null;
        }
        if (thisColumns.size() != index1Columns.size()) {
            return false;
        }
        int n = thisColumns.size();
        for (int i = 0; i < n; ++i) {
            if (thisColumns.get(i).equalsDB(index1Columns.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public BOSObjectType getBOSType() {
        return BOS_TYPE;
    }
}

