/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.eai;

import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.eai.AdapterCollection;
import com.kingdee.bos.metadata.eai.AdapterInfo;
import com.kingdee.bos.metadata.eai.DataSourceInfo;
import com.kingdee.bos.metadata.validate.ValidateList;
import com.kingdee.bos.metadata.validate.ValidateMetaData;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.io.Serializable;

public class ApplicationNodeInfo
extends AbstractMetaDataValue
implements Serializable {
    public ApplicationNodeInfo() {
        this.put("adapters", new AdapterCollection());
        this.setString("innerID", Uuid.create().toString());
    }

    protected ApplicationNodeInfo(boolean init) {
        super(init);
    }

    public String getInnerID() {
        return this.getString("innerID");
    }

    public void setUser(String user) {
        this.setString("user", user);
    }

    public String getUser() {
        return this.getString("user");
    }

    public void setPassword(String passw) {
        this.setString("password", passw);
    }

    public String getPassword() {
        return this.getString("password");
    }

    public void setOnline(boolean online) {
        this.setBoolean("online", online);
    }

    public boolean isOnline() {
        return this.getBoolean("online");
    }

    public AdapterCollection getAdapters() {
        return (AdapterCollection)this.get("adapters");
    }

    @Override
    public BOSObjectType getBOSType() {
        return MetaDataTypeList.APPLICATION_NODE_TYPE;
    }

    @Override
    public ValidateList validate() {
        AdapterCollection adapters;
        super.validate();
        ValidateMetaData vld = super.getValidate();
        if (StringUtils.isEmpty((String)this.getUser())) {
            vld.addError("Don't define user.");
        }
        if (this.getPassword() == null) {
            vld.addError("Don't define password.");
        }
        if ((adapters = this.getAdapters()) != null) {
            for (int i = 0; i < adapters.size(); ++i) {
                DataSourceInfo ds;
                AdapterInfo adapter = adapters.get(i);
                if (adapter == null) continue;
                if (StringUtils.isJavaClassName((String)adapter.getAdapterClass())) {
                    vld.addError("Defined wrong adapter class.");
                }
                if (adapter.getApplication() == null) {
                    vld.addError("Don't associate application.");
                }
                if ((ds = adapter.getDataSource()) == null) {
                    vld.addError("Don't define datasource.");
                }
                if (ds.getPort() == 0 && !StringUtils.isEmpty((String)ds.getDBName()) && !StringUtils.isEmpty((String)ds.getHost()) && !StringUtils.isEmpty((String)ds.getUser()) && !StringUtils.isEmpty((String)ds.getJDBCType())) continue;
                vld.addError("DataSource's infomation isn't integrity.");
            }
        }
        return vld.getValidateList();
    }
}

