/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.entity;

import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Uuid;
import com.kingdee.util.enums.Enum;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DataType
extends Enum
implements Serializable {
    public static final DataType SHORT = new DataType("Short");
    public static final DataType INTEGER = new DataType("Integer");
    public static final DataType LONG = new DataType("Long");
    public static final DataType FLOAT = new DataType("Float");
    public static final DataType DOUBLE = new DataType("Double");
    public static final DataType DECIMAL = new DataType("BigDecimal");
    public static final DataType DATE = new DataType("Date");
    public static final DataType TIME = new DataType("Time");
    public static final DataType TIMESTAMP = new DataType("TimeStamp");
    public static final DataType CHAR = new DataType("Char");
    public static final DataType BOOLEAN = new DataType("Boolean");
    public static final DataType BYTE = new DataType("Byte");
    public static final DataType STRING = new DataType("String");
    public static final DataType BYTEARRAY = new DataType("ByteArray");
    public static final DataType OBJECTPK = new DataType("ObjectPK");
    public static final DataType ROWSET = new DataType("RowSet");
    public static final DataType BOSUUID = new DataType("BOSUuid");
    public static final DataType UUID = new DataType("Uuid");
    public static final DataType ENUM = new DataType("Enum");
    public static final DataType OBJECTVALUE = new DataType("ObjectValue");
    public static final DataType OBJECTCOLLECTION = new DataType("ObjectCollection");

    private DataType(String dataType) {
        super(dataType);
    }

    public static DataType getEnum(String dataType) {
        return (DataType)DataType.getEnum(DataType.class, (String)dataType);
    }

    public static Map getEnumMap() {
        return DataType.getEnumMap(DataType.class);
    }

    public static List getEnumList() {
        return DataType.getEnumList(DataType.class);
    }

    public static Iterator iterator() {
        return DataType.iterator(DataType.class);
    }

    public String getJavaTypeName() {
        if (this.equals(SHORT)) {
            return "short";
        }
        if (this.equals(INTEGER)) {
            return "int";
        }
        if (this.equals(LONG)) {
            return "long";
        }
        if (this.equals(FLOAT)) {
            return "float";
        }
        if (this.equals(DOUBLE)) {
            return "double";
        }
        if (this.equals(DECIMAL)) {
            return "java.math.BigDecimal";
        }
        if (this.equals(DATE)) {
            return "java.util.Date";
        }
        if (this.equals(TIME)) {
            return "java.sql.Time";
        }
        if (this.equals(TIMESTAMP)) {
            return "java.sql.Timestamp";
        }
        if (this.equals(CHAR)) {
            return "char";
        }
        if (this.equals(BOOLEAN)) {
            return "boolean";
        }
        if (this.equals(BYTE)) {
            return "byte";
        }
        if (this.equals(STRING)) {
            return "String";
        }
        if (this.equals(OBJECTPK)) {
            return IObjectPK.class.getName();
        }
        if (this.equals(BOSUUID)) {
            return BOSUuid.class.getName();
        }
        if (this.equals(UUID)) {
            return Uuid.class.getName();
        }
        if (this.equals(ENUM)) {
            return Enum.class.getName();
        }
        if (this.equals(OBJECTVALUE)) {
            return IObjectValue.class.getName();
        }
        if (this.equals(OBJECTCOLLECTION)) {
            return IObjectCollection.class.getName();
        }
        if (this.equals(ROWSET)) {
            return IRowSet.class.getName();
        }
        if (this.equals(BYTEARRAY)) {
            return "byte[]";
        }
        return null;
    }

    public SQLType getSQLType(boolean isMultilingual) {
        if (this.equals(BYTE) || this.equals(CHAR) || this.equals(SHORT) || this.equals(INTEGER) || this.equals(LONG)) {
            return SQLType.INT;
        }
        if (this.equals(FLOAT) || this.equals(DOUBLE) || this.equals(DECIMAL)) {
            return SQLType.NUMERIC;
        }
        if (this.equals(DATE) || this.equals(TIME) || this.equals(TIMESTAMP)) {
            return SQLType.DATETIME;
        }
        if (this.equals(BOOLEAN)) {
            return SQLType.INT;
        }
        if (this.equals(STRING)) {
            return isMultilingual ? SQLType.NVARCHAR : SQLType.VARCHAR;
        }
        if (this.equals(BOSUUID) || this.equals(UUID)) {
            return SQLType.CHAR;
        }
        return null;
    }

    public boolean isDateTime() {
        return this.equals(DATE) || this.equals(TIME) || this.equals(TIMESTAMP);
    }

    public boolean isValidPropertyType() {
        return !this.equals(OBJECTPK) && !this.equals(ROWSET) && !this.equals(OBJECTVALUE) && !this.equals(OBJECTCOLLECTION);
    }

    public boolean isValidBasicType() {
        return !this.equals(OBJECTPK) && !this.equals(ROWSET) && !this.equals(OBJECTVALUE) && !this.equals(OBJECTCOLLECTION) && !this.equals(BOSUUID) && !this.equals(UUID) && !this.equals(ENUM);
    }

    public boolean isNeedMetaDataRef() {
        return this.equals(ENUM) || this.equals(OBJECTVALUE) || this.equals(OBJECTCOLLECTION);
    }

    public static String[] getPropertyDataTypes() {
        List enums = DataType.getEnumList();
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < enums.size(); ++i) {
            DataType dt = (DataType)enums.get(i);
            if (!dt.isValidPropertyType()) continue;
            names.add(dt.getName());
        }
        String[] aStr = new String[names.size()];
        names.toArray(aStr);
        return aStr;
    }

    public static String[] getBasicDataTypes() {
        List enums = DataType.getEnumList();
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < enums.size(); ++i) {
            DataType dt = (DataType)enums.get(i);
            if (!dt.isValidBasicType()) continue;
            names.add(dt.getName());
        }
        String[] aStr = new String[names.size()];
        names.toArray(aStr);
        return aStr;
    }

    public String getAlias(Locale locale) {
        return this.getName();
    }
}

