/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.entity;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.InvalidMetaDataException;
import com.kingdee.bos.dao.xml.impl.AbstractMDElement;
import com.kingdee.bos.metadata.entity.CompartExprParser;
import com.kingdee.bos.metadata.entity.EntryFilterKeyWord;
import com.kingdee.bos.metadata.entity.EntryFilterType;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.OQLKeyWord;
import com.kingdee.bos.metadata.query.token.CollectionFormulaParser;
import com.kingdee.bos.metadata.query.token.LogicToken;
import com.kingdee.bos.metadata.query.token.TokenKey;
import com.kingdee.bos.metadata.query.util.QueryUtil;
import com.kingdee.bos.metadata.util.ViewParseUtils;
import com.kingdee.bos.metadata.validate.ValidateList;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.dom.expr.SqlBinaryOpExpr;
import com.kingdee.bos.sql.dom.expr.SqlExistsExpr;
import com.kingdee.bos.sql.dom.expr.SqlExpr;
import com.kingdee.bos.sql.dom.expr.SqlIdentifierExpr;
import com.kingdee.bos.sql.dom.expr.SqlInListExpr;
import com.kingdee.bos.sql.dom.expr.SqlInSubQueryExpr;
import com.kingdee.bos.sql.dom.expr.SqlMethodInvokeExpr;
import com.kingdee.bos.sql.formater.DrSQLFormater;
import com.kingdee.bos.sql.formater.FormaterException;
import com.kingdee.bos.sql.parser.KeyWord;
import com.kingdee.bos.sql.parser.Lexer;
import com.kingdee.bos.sql.parser.SqlExprParser;
import com.kingdee.bos.sql.parser.StringReader;
import com.kingdee.bos.sql.parser.TokenList;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import com.kingdee.util.marshal.Marshaller;
import com.kingdee.util.marshal.Unmarshaller;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class FilterInfo
extends AbstractMDElement
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 6810334382704114230L;
    public static final String FLAG_MASK = "#";
    private EntryFilterType entryFilterType;
    private String entryName;
    private static Logger logger = Logger.getLogger(FilterInfo.class);
    private int maskItemIndex = 0;
    private static final BOSObjectType BOS_TYPE = BOSObjectType.create((String)"filt");
    boolean[] mark;

    public FilterInfo() {
        this.entryFilterType = EntryFilterType.NORMAL;
        this.put("filterItems", new FilterItemCollection());
    }

    public FilterInfo(SqlExpr expr) throws ParserException {
        this(expr, null);
    }

    public FilterInfo(SqlExpr expr, boolean bAppend) throws ParserException {
        this(expr, null, bAppend);
    }

    public FilterInfo(SqlExpr expr, String entryName) throws ParserException {
        this(expr, entryName, false);
    }

    public FilterInfo(SqlExpr expr, String entryName, boolean bAppend) throws ParserException {
        this.init(expr, entryName, bAppend);
    }

    public FilterInfo(String filterExpr) throws ParserException {
        this(filterExpr, false);
    }

    public FilterInfo(String filterExpr, boolean bAppend) throws ParserException {
        this(filterExpr, null, bAppend);
    }

    public FilterInfo(String filterExpr, String entryName) throws ParserException {
        this(filterExpr, entryName, false);
    }

    public FilterInfo(String filterExpr, String entryName, boolean bAppend) throws ParserException {
        this(ViewParseUtils.parseFilterExpr(filterExpr), entryName, bAppend);
    }

    private void init(String filterExpr, String entryName, boolean bAppend) throws ParserException {
        this.init(ViewParseUtils.parseFilterExpr(filterExpr), entryName, bAppend);
    }

    private void init(SqlExpr expr, String entryName, boolean bAppend) throws ParserException {
        this.entryName = entryName;
        this.entryFilterType = EntryFilterType.NORMAL;
        this.put("filterItems", new FilterItemCollection());
        this.readFilterItem(expr);
        StringBuffer maskStrBuff = new StringBuffer();
        if (bAppend) {
            this.buildMaskString(expr, maskStrBuff);
        } else {
            this.buildMaskStringSimple(expr, maskStrBuff);
        }
        this.setMaskString(maskStrBuff.toString());
    }

    public FilterInfo(EntryFilterType type) {
        this();
        this.entryFilterType = type;
    }

    private void readFilterItem(SqlExpr expr) throws ParserException {
        if (expr == null) {
            return;
        }
        if (expr instanceof SqlBinaryOpExpr) {
            SqlBinaryOpExpr binaryOpExpr = (SqlBinaryOpExpr)expr;
            switch (binaryOpExpr.operator) {
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 18: 
                case 23: 
                case 40: 
                case 41: {
                    FilterItemInfo item = new FilterItemInfo();
                    item.parseOQL((SqlExpr)binaryOpExpr);
                    this.getFilterItems().add(item);
                    return;
                }
                case 7: 
                case 8: {
                    this.readFilterItem(binaryOpExpr.left);
                    this.readFilterItem(binaryOpExpr.right);
                    return;
                }
            }
            throw new ParserException("Illegal Format of FilterInfo : " + expr.toString());
        }
        if (expr instanceof SqlInListExpr) {
            FilterItemInfo item = new FilterItemInfo();
            FilterItemInfo.parseSqlInListExpr(item, (SqlInListExpr)expr);
            this.getFilterItems().add(item);
        } else if (expr instanceof SqlInSubQueryExpr) {
            FilterItemInfo item = new FilterItemInfo();
            FilterItemInfo.parseSqlInSubQueryExpr(item, (SqlInSubQueryExpr)expr);
            this.getFilterItems().add(item);
        } else if (expr instanceof SqlExistsExpr) {
            FilterItemInfo item = new FilterItemInfo();
            FilterItemInfo.parseSqlExistsQueryExpr(item, (SqlExistsExpr)expr);
            this.getFilterItems().add(item);
        }
    }

    private static boolean isIdentifierExpr(Object expr) {
        if (expr instanceof SqlIdentifierExpr) {
            return true;
        }
        return expr instanceof SqlBinaryOpExpr && ((SqlBinaryOpExpr)expr).operator == 20 && FilterInfo.isIdentifierExpr(((SqlBinaryOpExpr)expr).left) && FilterInfo.isIdentifierExpr(((SqlBinaryOpExpr)expr).right);
    }

    private void buildMaskString(SqlExpr expr, StringBuffer maskStrBuff) {
        if (expr instanceof SqlBinaryOpExpr) {
            SqlBinaryOpExpr binaryOpExpr = (SqlBinaryOpExpr)expr;
            if (binaryOpExpr.operator == 7) {
                maskStrBuff.append("(");
                this.buildMaskString(binaryOpExpr.left, maskStrBuff);
                maskStrBuff.append(")");
                maskStrBuff.append(" and (");
                this.buildMaskString(binaryOpExpr.right, maskStrBuff);
                maskStrBuff.append(")");
            } else if (binaryOpExpr.operator == 8) {
                maskStrBuff.append("(");
                this.buildMaskString(binaryOpExpr.left, maskStrBuff);
                maskStrBuff.append(")");
                maskStrBuff.append(" or (");
                this.buildMaskString(binaryOpExpr.right, maskStrBuff);
                maskStrBuff.append(")");
            } else {
                maskStrBuff.append('#');
                maskStrBuff.append(this.maskItemIndex++);
            }
        } else {
            maskStrBuff.append('#');
            maskStrBuff.append(this.maskItemIndex++);
        }
    }

    private void buildMaskStringSimple(SqlExpr expr, StringBuffer maskStrBuff) {
        if (expr instanceof SqlBinaryOpExpr) {
            SqlBinaryOpExpr binaryOpExpr = (SqlBinaryOpExpr)expr;
            if (binaryOpExpr.operator == 7) {
                this.buildMaskStringSimple(binaryOpExpr.left, maskStrBuff);
                maskStrBuff.append(" and ");
                this.buildMaskStringSimple(binaryOpExpr.right, maskStrBuff);
            } else if (binaryOpExpr.operator == 8) {
                maskStrBuff.append("(");
                this.buildMaskStringSimple(binaryOpExpr.left, maskStrBuff);
                maskStrBuff.append(" or ");
                this.buildMaskStringSimple(binaryOpExpr.right, maskStrBuff);
                maskStrBuff.append(")");
            } else {
                maskStrBuff.append('#');
                maskStrBuff.append(this.maskItemIndex++);
            }
        } else {
            maskStrBuff.append('#');
            maskStrBuff.append(this.maskItemIndex++);
        }
    }

    public String getMaskString() {
        return this.getString("maskString");
    }

    public void setMaskString(String maskString) {
        this.setString("maskString", maskString);
    }

    public EntryFilterType getEntryFilterType() {
        return this.entryFilterType;
    }

    public void setEntryilterType(EntryFilterType type) {
        this.entryFilterType = type;
    }

    public String getEntryName() {
        return this.entryName;
    }

    public void setEntryName(String name) {
        this.entryName = name;
    }

    public FilterItemCollection getFilterItems() {
        return (FilterItemCollection)this.get("filterItems");
    }

    private void setFilterItems(FilterItemCollection coll) {
        this.put("filterItems", coll);
    }

    @Override
    public BOSObjectType getBOSType() {
        return BOS_TYPE;
    }

    public ValidateList validate() {
        return null;
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer();
        this.output(buff);
        return buff.toString();
    }

    public void output(StringBuffer buff) {
        this.innerOutput(buff);
        if (!StringUtils.isEmpty((String)this.entryName)) {
            buff.append(" ON ");
            buff.append(this.entryName);
        }
    }

    private void innerOutput(StringBuffer buff) {
        String maskString = this.getMaskString();
        if (maskString != null && maskString.length() != 0) {
            try {
                StringReader strReader = new StringReader(maskString);
                Lexer lexer = new Lexer(OQLKeyWord.instance, null, strReader);
                TokenList tokList = new TokenList(lexer);
                SqlExprParser parser = new SqlExprParser(tokList);
                parser.setInSubQueryKeyword(KeyWord.instance);
                SqlExpr expr = parser.expr();
                this.mark = new boolean[this.getFilterItems().size()];
                expr = this.replaceBFS(expr);
                for (int i = 0; i < this.mark.length; ++i) {
                    if (this.mark[i]) continue;
                    String str = "one or more filteritems(size:" + this.getFilterItems().size() + ") are not used. markString is: " + maskString;
                    logger.warn((Object)str, (Throwable)new IllegalArgumentException(str));
                }
                DrSQLFormater formater = new DrSQLFormater(buff);
                try {
                    formater.formatExpr(expr);
                }
                catch (FormaterException e1) {
                    logger.debug((Object)e1.getMessage());
                }
                catch (NullPointerException e1) {
                    logger.debug((Object)e1.getMessage());
                }
            }
            catch (ParserException e) {
                logger.debug((Object)e.getMessage());
            }
        } else {
            Iterator iter = this.getFilterItems().iterator();
            boolean flag = false;
            while (iter.hasNext()) {
                if (flag) {
                    buff.append(" AND ");
                }
                FilterItemInfo filterItem = (FilterItemInfo)iter.next();
                filterItem.output(buff);
                flag = true;
            }
        }
    }

    private SqlExpr replaceBFS(SqlExpr expr) throws ParserException {
        LinkedList<SqlExpr> que = new LinkedList<SqlExpr>();
        if (expr instanceof SqlIdentifierExpr) {
            expr = this.replaceSqlIdentifierExpr((SqlIdentifierExpr)expr);
            return expr;
        }
        que.add(expr);
        while (!que.isEmpty()) {
            SqlExpr epr = (SqlExpr)que.remove(0);
            if (!(epr instanceof SqlBinaryOpExpr)) continue;
            SqlBinaryOpExpr binaryOpExpr = (SqlBinaryOpExpr)epr;
            if (binaryOpExpr.left instanceof SqlIdentifierExpr) {
                binaryOpExpr.left = this.replaceSqlIdentifierExpr((SqlIdentifierExpr)binaryOpExpr.left);
            } else if (binaryOpExpr.left instanceof SqlBinaryOpExpr) {
                que.add(binaryOpExpr.left);
            }
            if (binaryOpExpr.right instanceof SqlIdentifierExpr) {
                binaryOpExpr.right = this.replaceSqlIdentifierExpr((SqlIdentifierExpr)binaryOpExpr.right);
                continue;
            }
            if (!(binaryOpExpr.right instanceof SqlBinaryOpExpr)) continue;
            que.add(binaryOpExpr.right);
        }
        return expr;
    }

    private SqlExpr replaceSqlIdentifierExpr(SqlIdentifierExpr identExpr) throws ParserException {
        String identStr = identExpr.value;
        if (identStr.startsWith(FLAG_MASK)) {
            String numStr = identStr.substring(1);
            int num = Integer.parseInt(numStr);
            FilterItemInfo item = this.getFilterItems().get(num);
            if (item == null) {
                throw new IndexOutOfBoundsException(FLAG_MASK + num + " not found in filterItems " + this.getFilterItems() + ",MaskString is [" + this.getMaskString() + "]");
            }
            if (this.mark != null && this.mark.length > num) {
                this.mark[num] = true;
            }
            String itemStr = item.toString();
            StringReader strReader = new StringReader(itemStr);
            Lexer lexer = new Lexer(OQLKeyWord.instance, null, strReader);
            TokenList tokList = new TokenList(lexer);
            SqlExprParser parser = new SqlExprParser(tokList);
            parser.setInSubQueryKeyword(KeyWord.instance);
            SqlExpr itemExpr = parser.expr();
            return itemExpr;
        }
        return identExpr;
    }

    public void mergeFilter(FilterInfo filter, String logic) throws BOSException {
        if (filter == null || filter == this || filter.getFilterItems().size() == 0) {
            return;
        }
        if (this.getFilterItems().size() == 0) {
            this.getFilterItems().addObjectCollection(filter.getFilterItems());
            String newMaskString = QueryUtil.processMaskString(filter.getFilterItems().size(), filter.getMaskString());
            this.setMaskString(newMaskString);
            return;
        }
        String oldMaskString = QueryUtil.processMaskString(this.getFilterItems().size(), this.getMaskString());
        String newMaskString = QueryUtil.processMaskString(filter.getFilterItems().size(), filter.getMaskString());
        if (!TokenKey.isLogicWord(logic)) {
            throw new InvalidMetaDataException("The logic operator is not avaliable.");
        }
        CollectionFormulaParser parserNew = new CollectionFormulaParser(StringUtils.addBracket((String)newMaskString), filter.getFilterItems());
        CollectionFormulaParser parserOld = new CollectionFormulaParser(StringUtils.addBracket((String)oldMaskString), this.getFilterItems());
        parserOld.tokenList.add(new LogicToken(logic));
        parserOld.tokenList.addAll(parserNew.tokenList);
        if (!StringUtils.isEmpty((String)oldMaskString) && this.getMaskSize(oldMaskString) == this.getFilterItems().size()) {
            this.setFilterItems(parserOld.tokenList.getFilterItems());
        } else {
            this.getFilterItems().addObjectCollection(filter.getFilterItems());
        }
        this.setMaskString(parserOld.tokenList.showOrginValue());
    }

    private int getMaskSize(String maskString) {
        int count = 0;
        if (!StringUtils.isEmpty((String)maskString)) {
            for (int i = 0; i < maskString.length(); ++i) {
                if ('#' != maskString.charAt(i)) continue;
                ++count;
            }
        }
        return count;
    }

    public void appendFilterItem(String key, Object value) {
        this.getFilterItems().add(new FilterItemInfo(key, value));
    }

    @Override
    public void marshal(Marshaller marshaller) throws IOException {
        super.marshal(marshaller);
        marshaller.writeObject((Object)this.entryFilterType);
        marshaller.writeObject((Object)this.entryName);
        marshaller.writeInt(this.maskItemIndex);
    }

    @Override
    public void unmarshal(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        super.unmarshal(unmarshaller);
        this.entryFilterType = (EntryFilterType)((Object)unmarshaller.readObject());
        this.entryName = (String)unmarshaller.readObject();
        this.maskItemIndex = unmarshaller.readInt();
    }

    public String encode() {
        String sExpr = this.toString();
        if (!StringUtils.isEmpty((String)this.entryName)) {
            sExpr = sExpr + " TYPE " + this.entryFilterType.toString();
        }
        return sExpr;
    }

    public void decode(String encoded) throws ParserException {
        StringReader strReader = new StringReader(encoded);
        Lexer lexer = new Lexer(EntryFilterKeyWord.instance, null, strReader);
        TokenList tokList = new TokenList(lexer);
        CompartExprParser parser = new CompartExprParser(tokList);
        ArrayList list = parser.build();
        if (list.size() == 1) {
            String sOQL = (String)list.get(0);
            this.init(sOQL, null, true);
        } else if (list.size() == 3) {
            String sOQL = (String)list.get(0);
            String sEntryName = StringUtils.trim((String)((String)list.get(1)));
            String sEntryType = StringUtils.trim((String)((String)list.get(2)));
            this.init(sOQL, sEntryName, true);
            if (!StringUtils.isEmpty((String)sEntryType)) {
                this.setEntryilterType(EntryFilterType.getEnum(sEntryType.trim()));
            }
        } else {
            throw new ParserException("Illegal argument for decode!");
        }
    }

    public String toSql() {
        String val = "";
        if (!StringUtils.isEmpty((String)this.entryName) && EntryFilterType.NORMAL.equals((Object)this.entryFilterType)) {
            StringBuffer buff = new StringBuffer();
            this.innerOutput(buff);
            String tempStr = buff.toString();
            val = this.getRealEntryFilterExpress(tempStr, this.getEntryName());
        } else {
            val = this.toString();
        }
        return val;
    }

    private String getRealEntryFilterExpress(String sql, String entryName) {
        String val = "";
        try {
            String strExpr = sql;
            StringReader strReader = new StringReader(strExpr);
            Lexer lexer = new Lexer(KeyWord.instance, null, strReader);
            TokenList tokList = new TokenList(lexer);
            SqlExprParser parser = new SqlExprParser(tokList);
            SqlExpr whereExpr = parser.expr();
            this.innerGetFuncExprWithRealName(whereExpr, entryName);
            StringBuffer leftExprBuff = new StringBuffer();
            DrSQLFormater formater = new DrSQLFormater(leftExprBuff);
            try {
                formater.formatExpr(whereExpr);
            }
            catch (FormaterException e) {
                logger.error((Object)e, (Throwable)e);
                throw new ParserException("readFilterItem Error.");
            }
            val = leftExprBuff.toString();
        }
        catch (ParserException e) {
            logger.error((Object)(e.getMessage() + ", sql:" + sql + ",  entryName=" + entryName), (Throwable)e);
        }
        return val;
    }

    private void innerGetFuncExprWithRealName(SqlExpr expr, String entryName) {
        block8: {
            block6: {
                SqlExpr rightExpr;
                block7: {
                    SqlIdentifierExpr newExpr;
                    String strTmp;
                    if (!(expr instanceof SqlBinaryOpExpr)) break block6;
                    SqlBinaryOpExpr bExpr = (SqlBinaryOpExpr)expr;
                    SqlExpr leftExpr = ((SqlBinaryOpExpr)expr).left;
                    rightExpr = ((SqlBinaryOpExpr)expr).right;
                    if (FilterInfo.isIdentifierExpr(leftExpr)) {
                        strTmp = entryName + "." + leftExpr.toString();
                        newExpr = new SqlIdentifierExpr(strTmp);
                        bExpr.left = newExpr;
                    } else if (leftExpr instanceof SqlMethodInvokeExpr || leftExpr instanceof SqlBinaryOpExpr) {
                        this.innerGetFuncExprWithRealName(leftExpr, entryName);
                    }
                    if (!FilterInfo.isIdentifierExpr(rightExpr)) break block7;
                    strTmp = entryName + "." + rightExpr.toString();
                    newExpr = new SqlIdentifierExpr(strTmp);
                    bExpr.right = newExpr;
                    break block8;
                }
                if (!(rightExpr instanceof SqlMethodInvokeExpr) && !(rightExpr instanceof SqlBinaryOpExpr)) break block8;
                this.innerGetFuncExprWithRealName(rightExpr, entryName);
                break block8;
            }
            if (expr instanceof SqlMethodInvokeExpr) {
                SqlMethodInvokeExpr mExpr = (SqlMethodInvokeExpr)expr;
                List paras = mExpr.parameters;
                Object obj = null;
                for (int i = 0; i < paras.size(); ++i) {
                    obj = paras.get(i);
                    if (FilterInfo.isIdentifierExpr(obj)) {
                        String strTmp = entryName + "." + obj.toString();
                        SqlIdentifierExpr newExpr = new SqlIdentifierExpr(strTmp);
                        paras.set(i, newExpr);
                        continue;
                    }
                    if (!(obj instanceof SqlMethodInvokeExpr) && !(obj instanceof SqlBinaryOpExpr)) continue;
                    this.innerGetFuncExprWithRealName((SqlExpr)((SqlMethodInvokeExpr)obj), entryName);
                }
            }
        }
    }

    @Override
    public Object clone() {
        FilterInfo cloned = new FilterInfo();
        cloned.setEntryilterType(this.getEntryFilterType());
        cloned.setFilterItems((FilterItemCollection)this.getFilterItems().clone());
        cloned.setEntryName(this.getEntryName());
        cloned.setMaskString(this.getMaskString());
        return cloned;
    }

    public static void main(String[] args) throws ParserException {
        String s1 = "";
        String s2 = "";
        FilterInfo newFilter = null;
        FilterInfo assistant = new FilterInfo(EntryFilterType.NORMAL);
        assistant.setEntryName("assistant.entries");
        FilterItemInfo item = new FilterItemInfo("assistNote", (Object)"aaaaa.b");
        assistant.getFilterItems().add(item);
        s1 = assistant.toString();
        System.out.println("s1 = " + s1);
        s2 = assistant.toSql();
        System.out.println("s2 = " + s2);
        newFilter = new FilterInfo();
        System.out.println("equals=" + assistant.equals(newFilter));
    }
}

