/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.entity;

import com.kingdee.bos.metadata.entity.CompartExprParser;
import com.kingdee.bos.metadata.entity.EntityUnitBaseInfo;
import com.kingdee.bos.metadata.entity.SelectorItemKeyWord;
import com.kingdee.bos.metadata.validate.ValidateList;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.parser.Lexer;
import com.kingdee.bos.sql.parser.StringReader;
import com.kingdee.bos.sql.parser.TokenList;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Locale;

public class SelectorItemInfo
extends EntityUnitBaseInfo
implements Cloneable,
Serializable {
    private transient String propertyName = null;
    private transient String aliasName = null;
    private static final BOSObjectType BOS_TYPE = BOSObjectType.create((String)"slim");

    public SelectorItemInfo() {
        this.setPKField("propertyName");
        this.init();
    }

    public SelectorItemInfo(String propertyName) {
        this(propertyName, null);
    }

    public SelectorItemInfo(String propertyName, String aliasName) {
        this();
        this.setPropertyName(propertyName);
        this.setAliasName(aliasName);
    }

    @Override
    protected void clearVariableWhenValueChanged(String key) {
        super.clearVariableWhenValueChanged(key);
        if ("propertyName".equals(key)) {
            this.propertyName = null;
            return;
        }
        if ("aliasName".equals(key)) {
            this.aliasName = null;
            return;
        }
    }

    public String getPropertyName() {
        if (this.propertyName == null) {
            this.propertyName = this.getString("propertyName");
        }
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.setPropertyName(propertyName, true);
    }

    public String getAliasName() {
        if (this.aliasName == null) {
            this.aliasName = this.getString("aliasName");
        }
        return this.aliasName;
    }

    public void setAliasName(String aliasName) {
        if (!StringUtils.isEmpty((String)aliasName) && aliasName.charAt(0) == '\"') {
            aliasName = aliasName.substring(1, aliasName.length() - 1);
        }
        this.setString("aliasName", aliasName);
    }

    public String getDisplayName() {
        return this.getDisplayName(null);
    }

    public void setDisplayName(String item) {
        this.setDisplayName(item, null);
    }

    public String getDisplayName(Locale locale) {
        return (String)this.get("displayName", locale);
    }

    public void setDisplayName(String item, Locale locale) {
        this.put("displayName", item, locale);
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    public String getFormulaString() {
        return this.getString("formulaString");
    }

    public void setFormulaString(String formula) {
        this.setString("formulaString", formula);
    }

    public boolean isUserDefined() {
        return this.getBoolean("userDefined");
    }

    public void setUserDefined(boolean userDefined) {
        this.setBoolean("userDefined", userDefined);
    }

    @Override
    public BOSObjectType getBOSType() {
        return BOS_TYPE;
    }

    public ValidateList validate() {
        return null;
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer();
        this.output(buff);
        return buff.toString();
    }

    public void output(StringBuffer buff) {
        buff.append(this.getPropertyName());
        String alias = this.getAliasName();
        if (!StringUtils.isEmpty((String)alias)) {
            buff.append(" ");
            buff.append('\"');
            buff.append(alias);
            buff.append('\"');
        }
    }

    public String encode() {
        String sExpr = this.toString();
        sExpr = sExpr + " # " + this.getFormulaString();
        sExpr = sExpr + " # " + this.getDisplayName();
        sExpr = sExpr + " # " + this.isUserDefined();
        return sExpr;
    }

    public void decode(String encoded) throws ParserException {
        StringReader strReader = new StringReader(encoded);
        Lexer lexer = new Lexer(SelectorItemKeyWord.instance, null, strReader);
        TokenList tokList = new TokenList(lexer);
        CompartExprParser parser = new CompartExprParser(tokList);
        ArrayList list = parser.build();
        if (list.size() != 4) {
            throw new ParserException("Illegal argument for decode!");
        }
        String sPropName = (String)list.get(0);
        String sFormula = (String)list.get(1);
        String sDisplay = (String)list.get(2);
        String sUserDefine = (String)list.get(3);
        this.setPropertyName(sPropName);
        this.setFormulaString(sFormula);
        this.setDisplayName(sDisplay);
        this.setUserDefined(Boolean.valueOf(sUserDefine));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof SelectorItemInfo)) {
            return false;
        }
        return SelectorItemInfo.equals(this.getPropertyName(), ((SelectorItemInfo)o).getPropertyName());
    }
}

