/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.management;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.xml.CheckReportItem;
import com.kingdee.bos.dao.xml.ICheckReport;
import com.kingdee.bos.dao.xml.XMLAccessEngine;
import com.kingdee.bos.metadata.AbstractMetaDataContainer;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityObjectCtrl;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.management.IPackageCtrl;
import com.kingdee.bos.metadata.management.ISolutionCtrl;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.management.application.MetaDataCollection;
import com.kingdee.bos.util.BOSObjectType;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Hashtable;

public class SolutionCtrl
extends AbstractMetaDataContainer
implements ISolutionCtrl {
    public SolutionCtrl() {
        super.registerInterface(ISolutionCtrl.class, (Object)this);
        this.loadSelfMetametaData(MetaDataPK.create("metametadata.management", "solution"));
    }

    public SolutionCtrl(Context ctx) {
        super(ctx);
        super.registerInterface(ISolutionCtrl.class, (Object)this);
        this.loadSelfMetametaData(MetaDataPK.create("metametadata.management", "solution"));
    }

    @Override
    public BOSObjectType getType() {
        return MetaDataTypeList.SOLUTION;
    }

    @Override
    public void addnew(IMetaDataPK pk, SolutionInfo solutionInfo) throws BOSException {
        this.getDAO().addnew(pk, solutionInfo);
    }

    @Override
    public IMetaDataPK addnew(SolutionInfo solutionInfo) throws BOSException {
        return (IMetaDataPK)this.getDAO().addnew(solutionInfo);
    }

    @Override
    public void update(IMetaDataPK metaType, SolutionInfo solutionInfo) throws BOSException {
        this.getDAO().update(metaType, solutionInfo);
    }

    @Override
    public SolutionInfo getValue(IMetaDataPK metaType) throws BOSException {
        if (metaType == null) {
            return this.getValue();
        }
        return (SolutionInfo)this.getDAO().getValue(metaType);
    }

    public void setVersion(String version) throws BOSException {
        SolutionInfo info = this.getValue();
        info.setVersion(version);
        this.update(MetaDataPK.create(null, info.getName()), info);
    }

    @Override
    public MetaDataCollection getMetaDatas() throws DataAccessException {
        try {
            IPackageCtrl pgCtrl = (IPackageCtrl)((Object)BOSObjectFactory.createBOSObject(this.getContext(), MetaDataTypeList.PACKAGE));
            return pgCtrl.getMetaDatas();
        }
        catch (BOSException e) {
            if (e instanceof DataAccessException) {
                throw (DataAccessException)e;
            }
            throw new DataAccessException(e);
        }
    }

    @Override
    public MetaDataCollection getMetaDatasByType(BOSObjectType type) throws DataAccessException {
        try {
            IPackageCtrl pgCtrl = (IPackageCtrl)((Object)BOSObjectFactory.createBOSObject(this.getContext(), MetaDataTypeList.PACKAGE));
            return pgCtrl.getMetaDatasByType(type);
        }
        catch (BOSException e) {
            if (e instanceof DataAccessException) {
                throw (DataAccessException)e;
            }
            throw new DataAccessException(e);
        }
    }

    @Override
    public MetaDataCollection getMetaDatas(String name) throws DataAccessException {
        return this.getMetaDatas();
    }

    @Override
    public MetaDataCollection getMetaDatasByType(BOSObjectType type, String name) throws DataAccessException {
        return this.getMetaDatasByType(type);
    }

    @Override
    public SolutionInfo getValue() throws BOSException {
        IMetaDataPK[] pks = XMLAccessEngine.getXMLLoader((Context)this.getContext()).getMetaDataClassLoader().getMDContext().pkIndexs.getMetaDataPKs(MetaDataTypeList.SOLUTION);
        if (pks == null || pks.length <= 0) {
            throw new ObjectNotFoundException("Cannot found solution");
        }
        return this.getValue(pks[0]);
    }

    @Override
    public void checkBOSTypeUnique(ICheckReport report, OutputStream os) throws BOSException {
        EntityObjectCtrl entityCtrl = new EntityObjectCtrl(this.getContext());
        IMetaDataPK[] pks = entityCtrl.getPKList();
        Hashtable<IMetaDataPK, EntityObjectInfo> temp = new Hashtable<IMetaDataPK, EntityObjectInfo>();
        int length = pks.length;
        for (int i = 0; i < length; ++i) {
            EntityObjectInfo entity = entityCtrl.getValue(pks[i]);
            BOSObjectType bosType = entity.getType();
            if (temp.containsKey(bosType)) {
                EntityObjectInfo dupEntity = (EntityObjectInfo)temp.get(bosType);
                CheckReportItem item = new CheckReportItem(2, pks[i], MetaDataTypeList.ENTITY, dupEntity.getPackage() + "." + dupEntity.getName(), 12, new String[]{"The bostype is duplicate", "Object1: " + dupEntity.getPackage() + "." + dupEntity.getName(), "Object2: " + entity.getPackage() + "." + entity.getName()});
                if (report != null) {
                    report.addItem(item);
                }
                if (report == null && os == null) {
                    os = System.out;
                }
                if (os == null) continue;
                PrintStream ps = new PrintStream(os);
                ps.println("CheckObject: " + item.getKey() + "\tState: " + item.getState());
                if (item.getMessages() == null) continue;
                String[] msgs = item.getMessages();
                for (int j = 0; j < msgs.length; ++j) {
                    ps.println("    " + msgs[j]);
                }
                continue;
            }
            temp.put(pks[i], entity);
        }
    }
}

