/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.management;

import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.metadata.management.SuffixCollection;
import com.kingdee.bos.metadata.validate.IValidate;
import com.kingdee.bos.metadata.validate.ValidateList;
import com.kingdee.bos.metadata.validate.ValidateMetaData;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.util.Locale;

public class SolutionInfo
extends AbstractMetaDataValue
implements Serializable,
IValidate {
    private transient LanguageCollection langCol = null;
    private transient LanguageInfo defaultLang = null;

    public SolutionInfo() {
        this.put("languages", new LanguageCollection());
        this.put("suffixes", new SuffixCollection());
    }

    protected SolutionInfo(boolean init) {
        super(init);
        this.put("languages", new LanguageCollection());
        this.put("suffixes", new SuffixCollection());
    }

    @Override
    protected void clearVariableWhenValueChanged(String key) {
        super.clearVariableWhenValueChanged(key);
        if ("languages".equals(key)) {
            this.langCol = null;
            return;
        }
        if ("defaultLang".equals(key)) {
            this.defaultLang = null;
            return;
        }
    }

    @Override
    public String getName() {
        return super.getName();
    }

    @Override
    public void setName(String name) {
        super.setName(name);
    }

    @Override
    public String getAlias() {
        return this.getString("alias");
    }

    @Override
    public void setAlias(String alias) {
        this.setString("alias", alias);
    }

    @Override
    public String getDescription() {
        return this.getString("description");
    }

    @Override
    public void setDescription(String description) {
        this.setString("description", description);
    }

    public LanguageCollection getLanguages() {
        if (this.langCol == null) {
            this.langCol = (LanguageCollection)this.get("languages");
        }
        return this.langCol;
    }

    public void setLanguages(LanguageCollection languages) {
        if (languages != null) {
            this.put("languages", languages);
        }
    }

    public LanguageInfo getDefaultLanguage() {
        if (this.defaultLang == null) {
            this.defaultLang = (LanguageInfo)this.get("defaultLang");
        }
        return this.defaultLang;
    }

    public void setDefaultLanguage(LanguageInfo defaultLang) {
        this.put("defaultLang", defaultLang);
    }

    public void addLanguage(LanguageInfo langInfo) {
        this.getLanguages().add(langInfo);
    }

    public void removeLanguage(LanguageInfo langInfo) {
        this.getLanguages().remove(langInfo);
    }

    public SuffixCollection getSuffixes() {
        return (SuffixCollection)this.get("suffixes");
    }

    public String getPerfix() {
        return this.getString("perfix");
    }

    public void setPerfix(String perfix) {
        this.setString("perfix", perfix);
    }

    public String getPKPerfix() {
        return this.getString("pkPerfix");
    }

    public void setPKPerfix(String pkPerfix) {
        this.setString("pkPerfix", pkPerfix);
    }

    public String getVersion() {
        return this.getString("version");
    }

    public void setVersion(String version) {
        this.setString("version", version);
    }

    public String getMetaVersion() {
        return this.getString("metaVersion");
    }

    public void setMetaVersion(String version) {
        this.setString("metaVersion", version);
    }

    @Override
    public BOSObjectType getBOSType() {
        return MetaDataTypeList.SOLUTION;
    }

    @Override
    public ValidateList validate() {
        ValidateMetaData vld = new ValidateMetaData();
        vld.validateMetaDataName(this.getName());
        LanguageCollection langCol = this.getLanguages();
        if (langCol != null) {
            for (int i = 0; i < langCol.size(); ++i) {
                vld.addValidateList(langCol.get(i).validate());
            }
        }
        if (this.getDefaultLanguage() == null) {
            vld.addError("Solution must include default language!");
        }
        return vld.getValidateList();
    }

    public Locale getSolutionDefaultLocale() {
        return this.getDefaultLanguage().getOriginalLocale();
    }

    public Locale[] getSupportedLocales() {
        LanguageCollection langs = this.getLanguages();
        Locale[] locales = new Locale[langs.size()];
        int len = langs.size();
        for (int i = 0; i < len; ++i) {
            locales[i] = langs.get(i).getOriginalLocale();
        }
        return locales;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof SolutionInfo)) {
            return false;
        }
        if (StringUtils.isEmpty((String)this.getName())) {
            return super.equals(o);
        }
        return this.getName().equalsIgnoreCase(((SolutionInfo)o).getName());
    }
}

