/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.mdquery;

import com.kingdee.bos.dao.xml.impl.AbstractMDElement;
import com.kingdee.bos.metadata.mdquery.DataSourceInfo;
import com.kingdee.bos.metadata.mdquery.DataSourceType;
import com.kingdee.bos.metadata.mdquery.DimensionBaseType;
import com.kingdee.bos.metadata.mdquery.HierarchyCollection;
import com.kingdee.bos.metadata.mdquery.HierarchyInfo;
import com.kingdee.bos.metadata.mdquery.LevelBaseType;
import com.kingdee.bos.metadata.mdquery.LevelCollection;
import com.kingdee.bos.metadata.mdquery.LevelInfo;
import com.kingdee.bos.metadata.mdquery.PropertyCollection;
import com.kingdee.bos.metadata.mdquery.PropertyInfo;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.PropertyUnitCollection;
import com.kingdee.bos.metadata.query.UnionQueryInfo;
import com.kingdee.bos.metadata.validate.ValidateList;
import com.kingdee.bos.metadata.validate.ValidateMetaData;
import com.kingdee.bos.util.BOSObjectType;
import java.io.Serializable;
import java.util.HashSet;

public class DimensionInfo
extends AbstractMDElement
implements Serializable {
    public DimensionInfo() {
        this.put("hierarchies", new HierarchyCollection());
    }

    public String getName() {
        return this.getString("name");
    }

    public void setName(String name) {
        this.setString("name", name);
    }

    public boolean isUserDefined() {
        return this.getBoolean("userDefined");
    }

    public void setUserDefined(boolean userDefined) {
        this.setBoolean("userDefined", userDefined);
    }

    public String getAlias() {
        return this.getString("alias");
    }

    public void setAlias(String alias) {
        this.setString("alias", alias);
    }

    public String getDescription() {
        return this.getString("description");
    }

    public void setDescription(String description) {
        this.setString("description", description);
    }

    public DataSourceInfo getDataSourceInfo() {
        return (DataSourceInfo)this.get("dataSource");
    }

    public void setDataSourceInfo(DataSourceInfo info) {
        this.put("dataSource", info);
    }

    public DimensionBaseType getBaseType() {
        return DimensionBaseType.getEnum(this.getString("baseType"));
    }

    public void setBaseType(DimensionBaseType type) {
        String typeString = type == null ? "" : type.getName();
        this.setString("baseType", typeString);
    }

    public String getPrimaryKey() {
        return this.getString("primaryKey");
    }

    public void setPrimaryKey(String primaryKey) {
        this.setString("primaryKey", primaryKey);
    }

    public HierarchyCollection getHierarchyCollection() {
        return (HierarchyCollection)this.get("hierarchies");
    }

    @Override
    public BOSObjectType getBOSType() {
        return BOSObjectType.create((String)"mqdi");
    }

    public ValidateList validate() {
        DataSourceInfo ds;
        DimensionBaseType baseType;
        ValidateMetaData vld = new ValidateMetaData();
        HashSet<String> hieraSet = new HashSet<String>();
        HashSet<String> levelSet = new HashSet<String>();
        HashSet<String> propertySet = new HashSet<String>();
        boolean isTimeType = false;
        String name = this.getName();
        if (name == null || name.equals("")) {
            vld.addError("The name of the dimension has not defined");
        }
        if ((baseType = this.getBaseType()) != null && baseType.equals((Object)DimensionBaseType.TIME)) {
            isTimeType = true;
        }
        if ((ds = this.getDataSourceInfo()) == null) {
            vld.addError("The dataSource of the dimension has not defined");
        } else {
            DataSourceType sourceType = ds.getBaseType();
            HierarchyCollection hiers = this.getHierarchyCollection();
            if (hiers.size() == 0) {
                vld.addError("The hierarchy has not been defined in the dimension named: " + this.getName());
            }
            for (int i = 0; i < hiers.size(); ++i) {
                HierarchyInfo hier = hiers.get(i);
                name = hier.getName();
                if (name == null || name.equals("")) {
                    vld.addError("The name of the hierarchy has not defined");
                }
                if (name.indexOf(".") > -1) {
                    vld.addError("The hierarchy's name can't include '.'");
                }
                if (hieraSet.contains(name.toLowerCase())) {
                    vld.addError("Duplicated hierarchy name: " + name);
                } else {
                    hieraSet.add(name.toLowerCase());
                }
                LevelCollection levels = hier.getLevelCollection();
                if (levels.size() == 0) {
                    vld.addError("Levels have not been defined in hierarchy. The hierarchy's name: " + name);
                }
                levelSet.clear();
                for (int j = 0; j < levels.size(); ++j) {
                    String levelParentColumn;
                    String levelColumn;
                    LevelInfo level = levels.get(j);
                    name = level.getName();
                    if (name == null || name.equals("")) {
                        vld.addError("The name of the level has not defined");
                    }
                    if (name.indexOf(".") > -1) {
                        vld.addError("The level's name can't include '.'");
                    }
                    if (levelSet.contains(name.toLowerCase())) {
                        vld.addError("Duplicated level name: " + name);
                    } else {
                        levelSet.add(name.toLowerCase());
                    }
                    LevelBaseType levelBaseType = level.getBaseType();
                    if (isTimeType && levelBaseType != null && levelBaseType.equals((Object)LevelBaseType.STANDARD)) {
                        vld.addError("Since you have been defined a dimension of time-type, so you must define all levels of the dimension to be the same type");
                    }
                    if ((levelColumn = level.getColumn()) == null || levelColumn.equals("")) {
                        vld.addError("Column has not been defined in the level named: " + level.getName());
                    }
                    if (!this.validateColumnFromDataSource(ds, sourceType, levelColumn)) {
                        vld.addError("Column does not exists in dataSource. The column's name: " + levelColumn);
                    }
                    if ((levelParentColumn = level.getParentColumn()) != null && !levelParentColumn.equals("") && !this.validateColumnFromDataSource(ds, sourceType, levelParentColumn)) {
                        vld.addError("ParentColumn does not exists in dataSource. The parentColumn's name: " + levelParentColumn);
                    }
                    PropertyCollection props = level.getPropertyCollection();
                    propertySet.clear();
                    for (int t = 0; t < props.size(); ++t) {
                        PropertyInfo prop = props.get(t);
                        name = prop.getName();
                        if (name == null || name.equals("")) {
                            vld.addError("The name of the property has not defined");
                        }
                        if (name.indexOf(".") > -1) {
                            vld.addError("The property's name can't include '.'");
                        }
                        if (propertySet.contains(name.toLowerCase())) {
                            vld.addError("Duplicated property name: " + name);
                        } else {
                            propertySet.add(name.toLowerCase());
                        }
                        String propColumn = prop.getColumnName();
                        if (this.validateColumnFromDataSource(ds, sourceType, propColumn)) continue;
                        vld.addError("Property does not exists in dataSource. The Property's name: " + propColumn);
                    }
                }
            }
        }
        return vld.getValidateList();
    }

    private boolean validateColumnFromDataSource(DataSourceInfo ds, DataSourceType type, String column) {
        UnionQueryInfo unionQuery;
        PropertyUnitCollection propUnits = null;
        if (type == null) {
            return false;
        }
        if (type.equals((Object)DataSourceType.JOINQUERY)) {
            JoinQueryInfo joinQuery = ds.getJoinQueryObject();
            if (joinQuery != null) {
                propUnits = joinQuery.getUnits();
            }
        } else if (type.equals((Object)DataSourceType.UNIONQUERY) && (unionQuery = ds.getUnionQueryObject()) != null) {
            propUnits = unionQuery.getUnits();
        }
        if (propUnits != null) {
            return propUnits.contains(column);
        }
        return true;
    }
}

