/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.mdquery;

import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.mdquery.ConfigItemCollection;
import com.kingdee.bos.metadata.mdquery.CubeInfo;
import com.kingdee.bos.metadata.mdquery.DataSourceCollection;
import com.kingdee.bos.metadata.mdquery.DataSourceInfo;
import com.kingdee.bos.metadata.mdquery.DataSourceType;
import com.kingdee.bos.metadata.mdquery.DimensionCollection;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.UnionQueryInfo;
import com.kingdee.bos.metadata.validate.ValidateList;
import com.kingdee.bos.metadata.validate.ValidateMetaData;
import com.kingdee.bos.util.BOSObjectType;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;

public class MDQueryInfo
extends AbstractMetaDataValue
implements Serializable {
    public MDQueryInfo() {
        this.put("configs", new ConfigItemCollection());
        this.put("dataSources", new DataSourceCollection());
        this.put("dimensions", new DimensionCollection());
        this.put("cube", new CubeInfo());
    }

    protected MDQueryInfo(boolean init) {
        super(init);
        this.put("configs", new ConfigItemCollection());
        this.put("dataSources", new DataSourceCollection());
        this.put("dimensions", new DimensionCollection());
        this.put("cube", new CubeInfo());
    }

    @Override
    public BOSObjectType getBOSType() {
        return MetaDataTypeList.MDQUERY;
    }

    public ConfigItemCollection getConfigCollection() {
        return (ConfigItemCollection)this.get("configs");
    }

    public DataSourceCollection getDataSourceCollection() {
        return (DataSourceCollection)this.get("dataSources");
    }

    public DimensionCollection getDimensionCollection() {
        return (DimensionCollection)this.get("dimensions");
    }

    public CubeInfo getCube() {
        return (CubeInfo)this.get("cube");
    }

    @Override
    public ValidateList validate() {
        String name;
        super.validate();
        ValidateMetaData vld = this.getValidate();
        HashSet<String> set = new HashSet<String>();
        ConfigItemCollection configs = this.getConfigCollection();
        int length = configs.size();
        for (int i = 0; i < length; ++i) {
            name = configs.get(i).getName().toString();
            if (set.contains(name.toLowerCase())) {
                vld.addError("Duplicated config name: " + name);
                continue;
            }
            set.add(name.toLowerCase());
        }
        set.clear();
        DataSourceCollection dataSources = this.getDataSourceCollection();
        length = dataSources.size();
        if (length == 0) {
            vld.addError("DataSources have not been defined.");
        }
        HashMap<String, DataSourceType> sourceMap = new HashMap<String, DataSourceType>();
        String sourceName = "";
        DataSourceType sourceType = null;
        for (int i = 0; i < length; ++i) {
            DataSourceInfo dataSourceInfo = dataSources.get(i);
            name = dataSourceInfo.getName();
            sourceType = dataSourceInfo.getBaseType();
            if (sourceType != null) {
                if (sourceType.equals((Object)DataSourceType.ENTITY)) {
                    EntityObjectInfo entityInfo = dataSourceInfo.getEntityObject();
                    sourceName = entityInfo.getName();
                } else if (sourceType.equals((Object)DataSourceType.JOINQUERY)) {
                    JoinQueryInfo joinQueryInfo = dataSourceInfo.getJoinQueryObject();
                    sourceName = joinQueryInfo.getName();
                } else if (sourceType.equals((Object)DataSourceType.UNIONQUERY)) {
                    UnionQueryInfo unionQueryInfo = dataSourceInfo.getUnionQueryObject();
                    sourceName = unionQueryInfo.getName();
                }
                if (set.contains(name.toLowerCase())) {
                    vld.addError("Duplicated dataSource name: " + name);
                } else {
                    set.add(name.toLowerCase());
                }
                DataSourceType type = (DataSourceType)((Object)sourceMap.get(sourceName.toLowerCase()));
                if (sourceMap.size() > 0 && type != null && type.equals((Object)sourceType)) {
                    vld.addError("\u51fa\u73b0\u4e86\u4e24\u4e2a\u6570\u636e\u6e90\u4f7f\u7528\u540c\u4e00\u5b9e\u4f53\u6216\u67e5\u8be2\u5b9e\u4f53\u7684\u60c5\u51b5\u3002\u7c7b\u578b\uff1a" + sourceType.toString() + " \u540d\u79f0\uff1a" + sourceName);
                } else if (!sourceName.equals("")) {
                    sourceMap.put(sourceName.toLowerCase(), sourceType);
                }
                vld.addValidateList(dataSources.get(i).validate());
                continue;
            }
            vld.addError("SourceType have not been defined. SourceName:" + name);
        }
        set.clear();
        DimensionCollection dimensions = this.getDimensionCollection();
        length = dimensions.size();
        if (length == 0) {
            vld.addError("Dimensions have not been defined.");
        }
        for (int i = 0; i < dimensions.size(); ++i) {
            name = dimensions.get(i).getName();
            if (name.indexOf(".") > -1) {
                vld.addError("The dimension's name can't include '.'");
            }
            if (set.contains(name.toLowerCase())) {
                vld.addError("Duplicated dimension name: " + name);
            } else {
                set.add(name.toLowerCase());
            }
            vld.addValidateList(dimensions.get(i).validate());
        }
        CubeInfo cube = this.getCube();
        if (cube == null) {
            vld.addError("Cube has not been defined.");
        } else {
            vld.addValidateList(cube.validate());
        }
        return vld.getValidateList();
    }
}

