/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.query;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.InvalidMetaDataException;
import com.kingdee.bos.dao.AbstractBaseObjectCollection;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipCollection;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.query.JoinInfo;
import com.kingdee.bos.metadata.query.JoinItemInfo;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.PropertyRefInfo;
import com.kingdee.bos.metadata.query.PropertyUnitInfo;
import com.kingdee.bos.metadata.query.QueryDele;
import com.kingdee.bos.metadata.query.RelationCreator;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.query.util.JoinType;
import com.kingdee.util.Assert;
import com.kingdee.util.StringUtils;

public class JoinCreator {
    private SubEntityInfo left;
    private SubEntityInfo right;
    private JoinType type;
    private LinkPropertyInfo lnkProp;
    private RelationshipInfo rela;

    public JoinCreator(SubEntityInfo left, SubEntityInfo right, JoinType type, LinkPropertyInfo lnkProp, RelationshipInfo rela) throws BOSException {
        this.left = left;
        this.right = right;
        this.type = type;
        this.lnkProp = lnkProp;
        this.rela = rela;
    }

    public JoinCreator(SubEntityInfo left, SubEntityInfo right, RelationshipInfo rela) throws BOSException {
        this(left, right, null, rela);
        this.initType(rela);
    }

    public JoinCreator(SubEntityInfo left, SubEntityInfo right, JoinType type, RelationshipInfo rela) throws BOSException {
        this.left = left;
        this.right = right;
        this.type = type;
        if (rela != null && rela.getClientPropertyDesignTime() != null && rela.getClientPropertyDesignTime() instanceof LinkPropertyInfo) {
            this.lnkProp = (LinkPropertyInfo)rela.getClientPropertyDesignTime();
        } else {
            this.rela = rela;
        }
    }

    private void initType(RelationshipInfo rela) {
        if (this.type != null) {
            return;
        }
        this.type = JoinType.INNERJOIN;
        boolean clientIsLeft = false;
        if (rela.getClientObject() != null) {
            for (EntityObjectInfo _entity = this.left.getEntityRef(); !clientIsLeft && _entity != null; _entity = _entity.getBaseEntity()) {
                clientIsLeft = _entity.getFullName().equalsIgnoreCase(rela.getClientObject().getFullName());
            }
        }
        Assert.that((boolean)clientIsLeft, (String)"getJoinWithEntities not support Reversed Relationship!");
        CardinalityType supCard = rela.getSupplierCardinality();
        if (CardinalityType.ZERO_TO_ONE.equals((Object)supCard) || CardinalityType.ZERO_TO_UNBOUNDED.equals((Object)supCard)) {
            this.type = JoinType.LEFTJOIN;
        }
    }

    public JoinInfo create(Carrier crr) throws BOSException {
        JoinInfo join = new JoinInfo(crr.getQuery());
        AbstractBaseObjectCollection rels = null;
        if (this.lnkProp == null && this.rela != null) {
            String relaClientEntityName = this.rela.getClientObject().getFullName();
            String relaSupplierEntityName = this.rela.getSupplierObject().getFullName();
            String leftEntityName = this.left.getEntityRef().getFullName();
            String rightEntityName = this.right.getEntityRef().getFullName();
            if (leftEntityName.equals(relaClientEntityName) && rightEntityName.equals(relaSupplierEntityName) || leftEntityName.equals(relaSupplierEntityName) && rightEntityName.equals(relaClientEntityName)) {
                rels = new RelationshipCollection();
                ((RelationshipCollection)rels).add(this.rela);
            }
        }
        if (rels == null) {
            rels = new RelationCreator(this.left.getEntityRef(), this.right.getEntityRef(), this.lnkProp).create();
        }
        if (rels.size() == 0) {
            throw new InvalidMetaDataException("The entities's relationship is null between: " + this.left.getEntityRef().getFullName() + " and " + this.right.getEntityRef().getFullName());
        }
        join.setLeftObject(this.left);
        join.setRightObject(this.right);
        if (this.lnkProp != null && !StringUtils.isEmpty((String)this.lnkProp.getName()) && !this.lnkProp.getName().equals(this.right.getName())) {
            this.right.setName(crr.getNewSubObjectName(this.lnkProp.getName()));
        }
        for (int i = 0; i < rels.size(); ++i) {
            JoinItemInfo joinItem = new JoinItemInfo(join);
            PropertyUnitInfo unit = new PropertyUnitInfo(crr.getQuery());
            PropertyRefInfo ref = null;
            ref = this.left != null && this.left.getEntityRef() != null && ((RelationshipCollection)rels).get(i) != null && this.left.getEntityRef().isSubFrom(((RelationshipCollection)rels).get(i).getClientObject()) ? this.newClientProperty(unit, this.left, ((RelationshipCollection)rels).get(i)) : this.newSupplierProperty(unit, this.left, ((RelationshipCollection)rels).get(i));
            unit.getPropertyRefs().add(ref);
            unit.setName(crr.getNewUnitName());
            joinItem.setLeftField(unit);
            crr.addUnit(unit);
            unit = new PropertyUnitInfo(crr.getQuery());
            ref = this.right != null && this.right.getEntityRef() != null && ((RelationshipCollection)rels).get(i) != null && this.right.getEntityRef().isSubFrom(((RelationshipCollection)rels).get(i).getSupplierObject()) ? this.newSupplierProperty(unit, this.right, ((RelationshipCollection)rels).get(i)) : this.newClientProperty(unit, this.right, ((RelationshipCollection)rels).get(i));
            unit.getPropertyRefs().add(ref);
            unit.setName(crr.getNewUnitName());
            joinItem.setRightField(unit);
            crr.addUnit(unit);
            joinItem.setCompareType(CompareType.EQUALS);
            joinItem.setName(join.getNewJoinItemName());
            join.getJoinItems().add(joinItem);
            String formula = join.getFormulaString();
            if (i != 0) {
                formula = formula + " and #" + i;
            }
            join.setFormulaString(formula);
            join.setName(crr.getNewJoinName());
        }
        join.setJoinType(this.type);
        return join;
    }

    private PropertyRefInfo newClientProperty(PropertyUnitInfo unit, SubEntityInfo entity, RelationshipInfo rel) throws BOSException {
        PropertyRefInfo ref = null;
        ref = rel.isMultiRelation() && rel.getSupplierObject().equals(entity.getEntityRef()) ? new PropertyRefInfo(unit, entity, rel.getSupplierPropertyDesignTime()) : new PropertyRefInfo(unit, entity, rel.getClientPropertyDesignTime());
        return ref;
    }

    private PropertyRefInfo newSupplierProperty(PropertyUnitInfo unit, SubEntityInfo entity, RelationshipInfo rel) throws BOSException {
        PropertyRefInfo ref = null;
        ref = rel.isMultiRelation() && rel.getClientObject().equals(entity.getEntityRef()) ? new PropertyRefInfo(unit, entity, rel.getClientPropertyDesignTime()) : new PropertyRefInfo(unit, entity, rel.getSupplierPropertyDesignTime());
        return ref;
    }

    static class Carrier {
        private QueryDele dele;
        private JoinQueryInfo query;

        Carrier(QueryDele dele) {
            this.dele = dele;
        }

        Carrier(JoinQueryInfo query) {
            this.query = query;
        }

        JoinQueryInfo getQuery() {
            if (this.query != null) {
                return this.query;
            }
            return (JoinQueryInfo)this.dele.getTarget();
        }

        String getNewSubObjectName(String name) {
            if (this.query != null) {
                return this.query.getNewSubObjectName(name);
            }
            return this.dele.getNewSubObjectName(name);
        }

        String getNewUnitName() {
            if (this.query != null) {
                return this.query.getNewUnitName();
            }
            return this.dele.getNewUnitName();
        }

        void addUnit(PropertyUnitInfo unit) {
            if (this.query != null) {
                this.query.getUnits().add(unit);
                return;
            }
            this.dele.getUnits().add(unit);
        }

        String getNewJoinName() {
            if (this.query != null) {
                return this.query.getNewJoinName();
            }
            return this.dele.getNewJoinName();
        }
    }
}

