/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.query;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.query.PropertyRefCollection;
import com.kingdee.bos.metadata.query.PropertyRefInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.VirtualFieldInfo;
import com.kingdee.bos.metadata.query.util.ConstDataType;
import com.kingdee.bos.metadata.query.util.ConstFieldCollection;
import com.kingdee.bos.metadata.query.util.GroupType;
import com.kingdee.bos.metadata.query.util.QueryUtil;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.util.Locale;

public class PropertyUnitInfo
extends VirtualFieldInfo
implements Serializable {
    private static final BOSObjectType BOS_TYPE = BOSObjectType.create((String)"qput");
    private transient String name = null;
    private transient ConstDataType returnType = null;

    public PropertyUnitInfo() {
        this.put("propertyRefs", new PropertyRefCollection());
    }

    public PropertyUnitInfo(QueryInfo query) {
        this();
        this.setQuery(query);
    }

    public PropertyUnitInfo(QueryInfo query, PropertyRefInfo propRef) {
        this(query);
        this.getPropertyRefs().add(propRef);
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = this.getString("name");
        }
        return this.name;
    }

    @Override
    public void setName(String item) {
        this.setString("name", item);
        this.name = item;
    }

    public boolean isCaculateUnit() {
        return this.getPropertyRefs().size() != 1 || this.getConstFields().size() != 0;
    }

    public String getFormulaString() {
        String s = this.getString("formulaString");
        if (StringUtils.isEmpty((String)s)) {
            s = this.getPropertyRefs().size() == 1 && this.getConstFields().size() == 0 ? "#0" : "";
        }
        return s;
    }

    public void setFormulaString(String formula) {
        this.setString("formulaString", formula);
    }

    public ConstFieldCollection getConstFields() {
        String s = this.getConstString();
        if (s == null) {
            s = "";
        }
        return new ConstFieldCollection(s);
    }

    protected String getConstString() {
        return this.getString("constString");
    }

    private void setConstString(String item) {
        this.setString("constString", item);
    }

    public PropertyRefCollection getPropertyRefs() {
        PropertyRefCollection col = (PropertyRefCollection)this.get("propertyRefs");
        if (col == null) {
            col = new PropertyRefCollection();
            this.put("propertyRefs", col);
        }
        return col;
    }

    public String getRefPropertyName() {
        if (this.getPropertyRefs().size() == 0 || this.getPropertyRefs().size() > 1) {
            return "";
        }
        PropertyInfo propInfo = this.getPropertyRefs().get(0).getRefProperty();
        return propInfo.getName();
    }

    @Override
    public String getDisplayName() {
        return this.getDisplayName(null);
    }

    @Override
    public void setDisplayName(String item) {
        this.setDisplayName(item, null);
    }

    @Override
    public String getDisplayName(Locale locale) {
        return (String)this.get("displayName", locale);
    }

    @Override
    public void setDisplayName(String item, Locale locale) {
        this.put("displayName", item, locale);
    }

    @Override
    public GroupType getGroupType() {
        String s = this.getString("groupType");
        if (StringUtils.isEmpty((String)s) || s.length() == 0) {
            return GroupType.NONE;
        }
        return GroupType.getEnum(this.getString("groupType"));
    }

    @Override
    public void setGroupType(GroupType item) {
        this.setString("groupType", item.getName());
    }

    @Override
    public boolean isIsSelector() {
        return this.getBoolean("isSelector");
    }

    @Override
    public void setIsSelector(boolean item) {
        this.setBoolean("isSelector", item);
    }

    @Override
    public boolean isIsFilter() {
        return this.getBoolean("isFilter");
    }

    @Override
    public void setIsFilter(boolean item) {
        this.setBoolean("isFilter", item);
    }

    @Override
    public boolean isIsSorter() {
        return this.getBoolean("isSorter");
    }

    @Override
    public void setIsSorter(boolean item) {
        this.setBoolean("isSorter", item);
    }

    public boolean isIsParameter() {
        return this.getBoolean("isParameter");
    }

    public void setIsParameter(boolean item) {
        this.setBoolean("isParameter", item);
    }

    @Override
    public QueryInfo getQuery() {
        return (QueryInfo)this.get("query");
    }

    public void setQuery(QueryInfo item) {
        this.put("query", item);
    }

    @Override
    public BOSObjectType getBOSType() {
        return BOS_TYPE;
    }

    @Override
    public ConstDataType getReturnType() throws BOSException {
        if (this.returnType == null) {
            String s = this.getString("returnType");
            this.returnType = !StringUtils.isEmpty((String)s) ? ConstDataType.getEnum(s) : (this.getPropertyRefs().size() == 1 ? this.getPropertyRefType(this.getPropertyRefs().get(0)) : ConstDataType.OBJECT);
        }
        return this.returnType;
    }

    @Override
    public void setReturnType(ConstDataType item) {
        this.setString("returnType", item.getName());
        this.returnType = item;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    private ConstDataType getPropertyRefType(PropertyRefInfo ref) throws BOSException {
        if (ref.getSubEntity() == null) {
            if (ref.getSubQuery() != null && ref.getRefUnit() != null) {
                return ref.getRefUnit().getReturnType();
            }
        } else {
            if (ref.getRefProperty() != null && ref.getRefProperty() instanceof OwnPropertyInfo) {
                OwnPropertyInfo prop = (OwnPropertyInfo)ref.getRefProperty();
                return QueryUtil.getConstDataType(prop.getDataType());
            }
            ColumnInfo col = QueryUtil.getColumnInfoByProp(ref.getRefProperty(), ref.getSubEntity());
            if (col != null) {
                return QueryUtil.getConstDataType(col.getTypeName());
            }
        }
        return ConstDataType.OBJECT;
    }

    @Override
    public int hashCode() {
        if (this.getName() != null) {
            return this.getName().hashCode();
        }
        return super.hashCode();
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || !(that instanceof PropertyUnitInfo)) {
            return false;
        }
        return PropertyUnitInfo.equals(this.getName(), ((PropertyUnitInfo)that).getName());
    }

    public void setUserDefined(boolean isUserDefined) {
        this.put("userDefined", isUserDefined);
    }

    public boolean isUserDefined() {
        return this.getBoolean("userDefined");
    }

    public boolean isConfigured() {
        return "true".equalsIgnoreCase(this.getExtendedProperty("configured"));
    }

    public void setConfigured(boolean configured) {
        super.setExtendedProperty("configured", String.valueOf(configured));
    }
}

