/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.query;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.RTQueryJoinCollection;
import com.kingdee.bos.metadata.entity.RTQueryJoinInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.PropertyUnitDele;
import com.kingdee.bos.metadata.query.QueryDele;
import com.kingdee.bos.metadata.query.QueryFieldCollectionDele;
import com.kingdee.bos.metadata.query.QueryPKDele;
import com.kingdee.bos.metadata.query.util.QueryDeleUtil;
import java.util.Iterator;

public class QueryDeleUpdater {
    private final QueryDele query;

    public QueryDeleUpdater(QueryDele query) {
        this.query = query;
    }

    public void updateQuery(EntityViewInfo view) throws BOSException {
        if (view == null) {
            return;
        }
        if (this.query.getType() == 0) {
            RTQueryJoinInfo info;
            int i;
            RTQueryJoinCollection coll = view.getRTQueryJoins();
            for (i = 0; i < coll.size(); ++i) {
                info = coll.get(i);
                QueryDeleUtil.addRTJoinInfo(this.query, info);
            }
            this.innerUpdateQuery(view);
            for (i = 0; i < coll.size(); ++i) {
                info = coll.get(i);
                QueryDeleUtil.addRTQueryKey(this.query, info, view);
            }
        } else {
            this.innerUpdateQuery(view);
        }
        this.processPkField4DsynSelector(view);
    }

    private void innerUpdateQuery(EntityViewInfo view) throws BOSException {
        if (view == null) {
            return;
        }
        try {
            this.updateQueryField(view.getSelector());
            this.updateQueryField(view.getFilter());
        }
        catch (BOSException e) {
            BOSException e2 = new BOSException(e.getMessage() + ",  query : " + this.query.getTarget() + ",  view : " + view);
            e2.setStackTrace(e.getStackTrace());
            throw e2;
        }
    }

    private void updateQueryField(SelectorItemCollection selector) throws BOSException {
        Iterator ite = selector.iterator();
        while (ite.hasNext()) {
            SelectorItemInfo info = (SelectorItemInfo)ite.next();
            if (!info.isFuncCol()) {
                PropertyUnitDele fld = this.query.getUnits().getQueryFieldByName(info.getPropertyName());
                if (fld == null && (fld = QueryDeleUtil.processPropertyName(this.query, info.getPropertyName(), true)) != null) {
                    fld.setFormulaString(info.getFormulaString());
                    fld.setDisplayName(info.getDisplayName());
                }
                if (fld == null) continue;
                fld.getExtendedProperties().putAll(info.getExtendedProperties());
                continue;
            }
            Object[] fields = info.getFieldsArray();
            for (int i = 0; i < fields.length; ++i) {
                String propName = (String)fields[i];
                PropertyUnitDele fld = this.query.getUnits().getQueryFieldByName(propName);
                if (fld == null) {
                    fld = QueryDeleUtil.processPropertyName(this.query, propName, true);
                }
                if (fld == null) continue;
                fld.getExtendedProperties().putAll(info.getExtendedProperties());
            }
        }
    }

    private void updateQueryField(FilterInfo filter) throws BOSException {
        if (filter == null) {
            return;
        }
        FilterItemCollection fic = filter.getFilterItems();
        if (fic != null) {
            Iterator ite = fic.iterator();
            while (ite.hasNext()) {
                FilterItemInfo info = (FilterItemInfo)ite.next();
                if (!info.isFuncCol()) {
                    PropertyUnitDele fld = this.query.getUnits().getQueryFieldByName(info.getPropertyName());
                    if (fld == null) {
                        fld = QueryDeleUtil.processPropertyName(this.query, info.getPropertyName(), false);
                    }
                    if (fld == null) continue;
                    fld.getExtendedProperties().putAll(info.getExtendedProperties());
                    continue;
                }
                Object[] fields = info.getFieldsArray();
                for (int i = 0; i < fields.length; ++i) {
                    String propName = (String)fields[i];
                    PropertyUnitDele fld = this.query.getUnits().getQueryFieldByName(propName);
                    if (fld == null) {
                        fld = QueryDeleUtil.processPropertyName(this.query, propName, false);
                    }
                    if (fld == null) continue;
                    fld.getExtendedProperties().putAll(info.getExtendedProperties());
                }
            }
        }
    }

    private void processPkField4DsynSelector(EntityViewInfo view) throws BOSException {
        QueryFieldCollectionDele pkCollection;
        QueryPKDele queryPK;
        if (view == null) {
            return;
        }
        if (view.isRemoveEntry() && (queryPK = this.query.getQueryPK()) != null && (pkCollection = queryPK.getKeyPropertys()) != null) {
            int size = pkCollection.size();
            for (int i = size - 1; i >= 0; --i) {
                PropertyUnitDele pkField = pkCollection.get(i);
                if (QueryDeleUtil.checkQueryFieldRefSubObjectInList(this.query, this.query.getHeadSubObjects(), pkField)) continue;
                pkCollection.removeObject(i);
            }
        }
    }
}

