/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.query;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.InvalidMetaDataException;
import com.kingdee.bos.dao.xml.impl.AbstractMDElement;
import com.kingdee.bos.metadata.query.QueryFilterItemCollection;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.token.CollectionFormulaParser;
import com.kingdee.bos.metadata.query.token.LogicToken;
import com.kingdee.bos.metadata.query.token.TokenKey;
import com.kingdee.bos.metadata.query.util.QueryUtil;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.io.Serializable;

public class QueryFilterInfo
extends AbstractMDElement
implements Serializable,
Cloneable {
    public QueryFilterInfo() {
        this.put("filterItems", new QueryFilterItemCollection());
    }

    public QueryFilterInfo(QueryInfo query) {
        this();
        this.setQuery(query);
    }

    @Override
    public Object clone() {
        QueryFilterInfo filter = new QueryFilterInfo(this.getQuery());
        filter.setName(this.getName());
        filter.setFormulaString(this.getFormulaString());
        filter.getFilterItems().addObjectCollection((QueryFilterItemCollection)this.getFilterItems().clone());
        return filter;
    }

    public QueryFilterItemCollection getFilterItems() {
        return (QueryFilterItemCollection)this.get("filterItems");
    }

    public String getName() {
        String name = this.getString("name");
        if (StringUtils.isEmpty((String)name)) {
            name = "defaultFilter";
        }
        return name;
    }

    public void setName(String item) {
        this.setString("name", item);
    }

    public String getFormulaString() {
        String s = this.getString("formulaString");
        if (StringUtils.isEmpty((String)s)) {
            s = this.getFilterItems().size() == 1 ? "#0" : "";
        }
        return s;
    }

    public void setFormulaString(String formulaString) {
        this.setString("formulaString", formulaString);
    }

    public void mergeFilter(QueryFilterInfo filter, String logic) throws BOSException {
        String oldMaskString = QueryUtil.processMaskString(this.getFilterItems().size(), this.getFormulaString());
        String newMaskString = QueryUtil.processMaskString(filter.getFilterItems().size(), filter.getFormulaString());
        if (!TokenKey.isLogicWord(logic)) {
            throw new InvalidMetaDataException("The logic operator is not avaliable.");
        }
        CollectionFormulaParser parserNew = new CollectionFormulaParser(StringUtils.addBracket((String)newMaskString), filter.getFilterItems());
        CollectionFormulaParser parserOld = new CollectionFormulaParser(StringUtils.addBracket((String)oldMaskString), this.getFilterItems());
        parserOld.tokenList.add(new LogicToken(logic));
        parserOld.tokenList.addAll(parserNew.tokenList);
        this.getFilterItems().addObjectCollection(filter.getFilterItems());
        this.setFormulaString(parserOld.tokenList.showOrginValue());
    }

    public void addFilterItem(QueryFilterInfo filter) throws BOSException {
        String maskString = QueryUtil.processMaskString(filter.getFilterItems().size(), filter.getFormulaString());
        this.setFormulaString(maskString);
        this.getFilterItems().addObjectCollection(filter.getFilterItems());
    }

    public QueryInfo getQuery() {
        return (QueryInfo)this.get("query");
    }

    void setQuery(QueryInfo item) {
        this.put("query", item);
    }

    @Override
    public BOSObjectType getBOSType() {
        return BOSObjectType.create((String)"qfit");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof QueryFilterInfo)) {
            return false;
        }
        QueryFilterInfo that = (QueryFilterInfo)o;
        return QueryFilterInfo.equals(this.getQuery(), that.getQuery()) && QueryFilterInfo.equals(this.getName(), that.getName()) && QueryFilterInfo.equals(this.getFormulaString(), that.getFormulaString()) && QueryFilterInfo.equals(this.getFilterItems(), that.getFilterItems());
    }

    @Override
    public int hashCode() {
        int h = super.hashCode();
        h += QueryFilterInfo.hashCode(this.getQuery());
        return h += QueryFilterInfo.hashCode(this.getName());
    }
}

