/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.query;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.InvalidMetaDataException;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.query.PropertyUnitDele;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryFilterItemDele;
import com.kingdee.bos.metadata.query.QueryFilterItemInfo;
import com.kingdee.bos.metadata.query.token.IToken;
import com.kingdee.bos.metadata.query.token.TokenType;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.query.util.CompareValueType;
import com.kingdee.bos.metadata.query.util.ConstDataType;
import com.kingdee.bos.metadata.query.util.ConstField;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.parser.Lexer;
import com.kingdee.bos.sql.parser.Token;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.TypeConversionUtils;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

class QueryFilterToken
implements IToken {
    private static final Logger logger = Logger.getLogger(QueryFilterToken.class);
    private static final int ZERO = 0;
    private QueryFilterItem queryFilterItem_ = null;

    QueryFilterToken(QueryFilterItemInfo item) {
        this.queryFilterItem_ = new QueryFilterItem(item);
    }

    QueryFilterToken(QueryFilterItemDele item) {
        this.queryFilterItem_ = new QueryFilterItem(item);
    }

    @Override
    public TokenType getTokenType() {
        return TokenType.OBJECTVALUE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String showValue() throws BOSException {
        StringBuffer val = new StringBuffer();
        ConstDataType type = null;
        CompareType compareType = this.queryFilterItem_.getCompareType();
        if (CompareType.EXISTS.equals((Object)compareType) || CompareType.NOTEXISTS.equals((Object)compareType)) {
            type = ConstDataType.UNKNOWN;
        } else if (!this.queryFilterItem_.isFuncCol()) {
            QueryField queryField_ = this.queryFilterItem_.getQueryField();
            if (queryField_ == null) {
                throw new InvalidMetaDataException("Query filterItem's mapping query field is null.");
            }
            val.append(this.replaceContactString(queryField_.getShowValue()));
            type = queryField_.getReturnType();
        } else {
            String expr = this.queryFilterItem_.getExprTemplate();
            int idx = 0;
            List fieldList = this.queryFilterItem_.getFieldList();
            for (int i = 0; i < fieldList.size(); ++i) {
                String fName = (String)fieldList.get(i);
                QueryField field = this.queryFilterItem_.getQueryFieldByName(fName);
                if (field == null) {
                    throw new BOSException("field isn't exist :" + fName + ",  query:" + this.queryFilterItem_.getQueryName());
                }
                expr = expr.replaceAll("#" + idx, field.getShowValue());
                ++idx;
            }
            val.append(expr);
            type = this.queryFilterItem_.getExprReturnType();
        }
        try {
            Object obj = this.queryFilterItem_.getCompareValue();
            if (type == null) {
                throw new InvalidMetaDataException("Query filterItem must set 'returnType'.");
            }
            ConstDataType nType = type;
            ConstField fld = null;
            if (obj != null) {
                if (obj instanceof Set) {
                    fld = new ConstField("", nType);
                } else {
                    String value = null;
                    if (type.equals((Object)ConstDataType.DATE)) {
                        value = obj instanceof Date ? DateTimeUtils.format((Date)((Date)obj), (String)"yyyy-MM-dd HH:mm:ss") : obj.toString();
                    } else if (type.equals((Object)ConstDataType.TIME)) {
                        value = obj instanceof Date ? DateTimeUtils.format((Date)((Date)obj), (String)"HH:mm:ss") : obj.toString();
                    } else if (type.equals((Object)ConstDataType.TIMESTAMP)) {
                        value = obj instanceof Date ? DateTimeUtils.format((Date)((Date)obj), (String)"yyyy-MM-dd HH:mm:ss") : obj.toString();
                    } else if (type.equals((Object)ConstDataType.NUMBER)) {
                        value = obj instanceof Number ? TypeConversionUtils.numberToPlainString((Object)obj) : obj.toString();
                    } else {
                        value = obj.toString();
                        if (obj instanceof QueryFieldInfo) {
                            value = ((QueryFieldInfo)obj).getShowValue();
                        } else if (obj instanceof PropertyUnitDele) {
                            value = ((PropertyUnitDele)obj).getShowValue();
                        }
                    }
                    fld = value != null ? new ConstField(value, nType) : new ConstField("null", nType);
                }
            } else {
                fld = new ConstField("null", nType);
            }
            if ((compareType.equals((Object)CompareType.IS) || compareType.equals((Object)CompareType.ISNOT)) && CompareValueType.TYPE_EMPTY.equals(obj)) {
                if (compareType.equals((Object)CompareType.IS)) {
                    val.append(" IS NULL");
                } else if (compareType.equals((Object)CompareType.ISNOT)) {
                    val.append(" IS NOT NULL");
                }
                if (!this.queryFilterItem_.getQueryField().getReturnType().equals((Object)ConstDataType.STRING)) return val.toString();
                if (compareType.equals((Object)CompareType.IS)) {
                    StringBuffer tmp = val;
                    val = new StringBuffer("(");
                    val.append(tmp);
                    val.append(" OR LEN(").append(this.queryFilterItem_.getQueryField().getShowValue()).append(")=0)");
                    return val.toString();
                } else {
                    if (!compareType.equals((Object)CompareType.ISNOT)) return val.toString();
                    StringBuffer tmp = val;
                    val = new StringBuffer("(");
                    val.append(tmp);
                    val.append(" AND LEN(").append(this.queryFilterItem_.getQueryField().getShowValue()).append(")>0)");
                }
                return val.toString();
            } else if (fld.isNull()) {
                if (compareType.equals((Object)CompareType.EQUALS) || compareType.equals((Object)CompareType.IS)) {
                    val.append(" IS NULL");
                    return val.toString();
                } else if (compareType.equals((Object)CompareType.NOTEQUALS) || compareType.equals((Object)CompareType.ISNOT)) {
                    val.append(" IS NOT NULL");
                    return val.toString();
                } else if (compareType.equals((Object)CompareType.GREATER)) {
                    val.append(" > ''");
                    return val.toString();
                } else if (compareType.equals((Object)CompareType.GREATER_EQUALS)) {
                    val.append(" >= ''");
                    return val.toString();
                } else if (compareType.equals((Object)CompareType.LESS)) {
                    val.append(" < ''");
                    return val.toString();
                } else {
                    if (!compareType.equals((Object)CompareType.LESS_EQUALS)) throw new BOSException("The ConstField 's value is null, the CompareType must be EQUELS or NOTEQUALS.");
                    val.append(" <= ''");
                }
                return val.toString();
            } else {
                if (CompareType.INNER.equals((Object)compareType)) {
                    val.append(" IN ");
                } else if (CompareType.NOTINNER.equals((Object)compareType)) {
                    val.append(" NOT IN ");
                } else if (CompareType.EXISTS.equals((Object)compareType)) {
                    val.append(" EXISTS ");
                } else if (CompareType.NOTEXISTS.equals((Object)compareType)) {
                    val.append(" NOT EXISTS ");
                } else {
                    val.append(" ").append(compareType.getName()).append(" ");
                }
                if (obj instanceof Collection) {
                    Collection collection = (Collection)obj;
                    if (collection.size() <= 0) throw new BOSException("The CompareValue is NULL.");
                    val.append("(");
                    ArrayList<String> liString = new ArrayList<String>();
                    for (Object o : collection) {
                        String s = "";
                        s = this.queryFilterItem_.getQueryField().getReturnType().equals((Object)ConstDataType.STRING) || this.queryFilterItem_.getQueryField().getReturnType().equals((Object)ConstDataType.DATE) ? '\'' + o.toString() + '\'' + "," : (this.queryFilterItem_.getQueryField().getReturnType().equals((Object)ConstDataType.BOOLEAN) ? (o.toString().equalsIgnoreCase("true") ? "1," : (o.toString().equalsIgnoreCase("false") ? "0," : o + ",")) : o.toString() + ",");
                        liString.add(s);
                    }
                    Collections.sort(liString);
                    Iterator it = liString.iterator();
                    while (it.hasNext()) {
                        val.append(it.next().toString());
                    }
                    val = new StringBuffer(val.substring(0, val.length() - 1));
                    val.append(")");
                    return val.toString();
                } else if (obj instanceof QueryFieldInfo || obj instanceof PropertyUnitDele) {
                    String val_ = null;
                    if (obj instanceof QueryFieldInfo) {
                        val_ = ((QueryFieldInfo)obj).getShowValue();
                    } else if (obj instanceof PropertyUnitDele) {
                        val_ = ((PropertyUnitDele)obj).getShowValue();
                    }
                    if (CompareType.INNER.equals((Object)compareType) || CompareType.NOTINNER.equals((Object)compareType) || CompareType.EXISTS.equals((Object)compareType) || CompareType.NOTEXISTS.equals((Object)compareType)) {
                        val.append("(").append(val_).append(")");
                        return val.toString();
                    } else {
                        val.append(val_);
                    }
                    return val.toString();
                } else if (CompareType.INNER.equals((Object)compareType) || CompareType.NOTINNER.equals((Object)compareType) || CompareType.EXISTS.equals((Object)compareType) || CompareType.NOTEXISTS.equals((Object)compareType)) {
                    val.append("(").append(obj).append(")");
                    return val.toString();
                } else if ((CompareType.LIKE.equals((Object)compareType) || CompareType.NOTLIKE.equals((Object)compareType)) && !fld.toString().startsWith("'")) {
                    val.append("'").append(fld.toString()).append("'");
                    return val.toString();
                } else {
                    val.append(fld.toString());
                }
            }
            return val.toString();
        }
        catch (Exception err) {
            throw new BOSException("The ConstField convert datatype is error.   filterItemInfo:" + this + ", ReturnType:" + (Object)((Object)this.queryFilterItem_.getExprReturnType()) + ", isFuncCol:" + this.queryFilterItem_.isFuncCol(), (Throwable)err);
        }
    }

    private String replaceContactString(String formula) {
        Lexer lexer = new Lexer(formula);
        StringBuffer buff = new StringBuffer();
        boolean flag = false;
        try {
            while (true) {
                Token token = lexer.next();
                if (token.type != 12) {
                    if (flag) {
                        buff.append(' ');
                    }
                    if (token.type == 4 && token.value.equals("&")) {
                        buff.append("||");
                    } else {
                        token.output(buff);
                    }
                    flag = true;
                    continue;
                }
                break;
            }
        }
        catch (ParserException e) {
            logger.error((Object)"error", (Throwable)e);
        }
        buff.append(' ');
        return buff.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String showValue(boolean bParaType, Map<Integer, Object> paraMap) throws BOSException {
        if (!bParaType) {
            return this.showValue();
        }
        StringBuffer val = new StringBuffer();
        StringBuffer sCompare = new StringBuffer();
        Object oPara = null;
        ConstDataType type = null;
        CompareType compareType = this.queryFilterItem_.getCompareType();
        if (CompareType.EXISTS.equals((Object)compareType) || CompareType.NOTEXISTS.equals((Object)compareType)) {
            type = ConstDataType.UNKNOWN;
        } else if (!this.queryFilterItem_.isFuncCol()) {
            if (this.queryFilterItem_.getQueryField() == null) {
                throw new InvalidMetaDataException("Query filterItem's mapping query field is null.");
            }
            val.append(this.replaceContactString(this.queryFilterItem_.getQueryField().getShowValue()));
            type = this.queryFilterItem_.getQueryField().getReturnType();
        } else {
            String expr = this.queryFilterItem_.getExprTemplate();
            int idx = 0;
            List fieldList = this.queryFilterItem_.getFieldList();
            for (int i = 0; i < fieldList.size(); ++i) {
                String fName = (String)fieldList.get(i);
                QueryField field = this.queryFilterItem_.getQueryFieldByName(fName);
                if (field == null) {
                    throw new BOSException("field isn't exist :" + fName + ",  query:" + this.queryFilterItem_.getQueryName());
                }
                expr = expr.replaceAll("#" + idx, field.getShowValue());
                ++idx;
            }
            val.append(expr);
            type = this.queryFilterItem_.getExprReturnType();
        }
        try {
            Object obj = this.queryFilterItem_.getCompareValue();
            ConstDataType nType = type;
            ConstField fld = null;
            if (obj != null) {
                if (obj instanceof Set) {
                    fld = new ConstField("", nType, bParaType);
                } else {
                    String value = null;
                    if (type.equals((Object)ConstDataType.DATE)) {
                        value = obj instanceof Date ? DateTimeUtils.format((Date)((Date)obj), (String)"yyyy-MM-dd HH:mm:ss") : obj.toString();
                    } else if (type.equals((Object)ConstDataType.TIME)) {
                        value = obj instanceof Date ? DateTimeUtils.format((Date)((Date)obj), (String)"HH:mm:ss") : obj.toString();
                    } else if (type.equals((Object)ConstDataType.TIMESTAMP)) {
                        value = obj instanceof Date ? DateTimeUtils.format((Date)((Date)obj), (String)"yyyy-MM-dd HH:mm:ss") : obj.toString();
                    } else if (type.equals((Object)ConstDataType.NUMBER)) {
                        value = obj instanceof Number ? TypeConversionUtils.numberToPlainString((Object)obj) : obj.toString();
                    } else {
                        value = obj.toString();
                        if (obj instanceof QueryFieldInfo) {
                            value = ((QueryFieldInfo)obj).getShowValue();
                        } else if (obj instanceof PropertyUnitDele) {
                            value = ((PropertyUnitDele)obj).getShowValue();
                        }
                    }
                    fld = value != null ? new ConstField(value, nType, bParaType) : new ConstField("null", nType, bParaType);
                }
            } else {
                fld = new ConstField("null", nType);
            }
            if ((compareType.equals((Object)CompareType.IS) || compareType.equals((Object)CompareType.ISNOT)) && CompareValueType.TYPE_EMPTY.equals(obj)) {
                if (compareType.equals((Object)CompareType.IS)) {
                    val.append(" IS NULL");
                } else if (compareType.equals((Object)CompareType.ISNOT)) {
                    val.append(" IS NOT NULL");
                }
                if (!this.queryFilterItem_.getQueryField().getReturnType().equals((Object)ConstDataType.STRING)) return val.toString();
                if (compareType.equals((Object)CompareType.IS)) {
                    StringBuffer tmp = val;
                    val = new StringBuffer("(");
                    val.append(tmp);
                    val.append(" OR LEN(").append(this.queryFilterItem_.getQueryField().getShowValue()).append(")=0)");
                    return val.toString();
                } else {
                    if (!compareType.equals((Object)CompareType.ISNOT)) return val.toString();
                    StringBuffer tmp = val;
                    val = new StringBuffer("(");
                    val.append(tmp);
                    val.append(" AND LEN(").append(this.queryFilterItem_.getQueryField().getShowValue()).append(")>0)");
                }
                return val.toString();
            } else if (fld.isNull()) {
                if (compareType.equals((Object)CompareType.EQUALS) || compareType.equals((Object)CompareType.IS)) {
                    val.append(" IS NULL");
                    return val.toString();
                } else if (compareType.equals((Object)CompareType.NOTEQUALS) || compareType.equals((Object)CompareType.ISNOT)) {
                    val.append(" IS NOT NULL");
                    return val.toString();
                } else if (compareType.equals((Object)CompareType.GREATER)) {
                    val.append(" > ''");
                    return val.toString();
                } else if (compareType.equals((Object)CompareType.GREATER_EQUALS)) {
                    val.append(" >= ''");
                    return val.toString();
                } else if (compareType.equals((Object)CompareType.LESS)) {
                    val.append(" < ''");
                    return val.toString();
                } else {
                    if (!compareType.equals((Object)CompareType.LESS_EQUALS)) throw new BOSException("The ConstField 's value is null, the CompareType must be EQUELS or NOTEQUALS.");
                    val.append(" <= ''");
                }
                return val.toString();
            } else {
                if (CompareType.INNER.equals((Object)compareType)) {
                    val.append(" IN ");
                } else if (CompareType.NOTINNER.equals((Object)compareType)) {
                    val.append(" NOT IN ");
                } else if (CompareType.EXISTS.equals((Object)compareType)) {
                    val.append(" EXISTS ");
                } else if (CompareType.NOTEXISTS.equals((Object)compareType)) {
                    val.append(" NOT EXISTS ");
                } else {
                    val.append(compareType.getName()).append(" ");
                }
                if (obj instanceof Collection) {
                    Collection collection = (Collection)obj;
                    this.handleCollection(paraMap, val, collection);
                    return val.toString();
                } else if (obj instanceof QueryFieldInfo || obj instanceof PropertyUnitDele) {
                    String val_ = null;
                    if (obj instanceof QueryFieldInfo) {
                        val_ = ((QueryFieldInfo)obj).getShowValue();
                    } else if (obj instanceof PropertyUnitDele) {
                        val_ = ((PropertyUnitDele)obj).getShowValue();
                    }
                    if (CompareType.INNER.equals((Object)compareType) || CompareType.NOTINNER.equals((Object)compareType) || CompareType.EXISTS.equals((Object)compareType) || CompareType.NOTEXISTS.equals((Object)compareType)) {
                        val.append("(").append(val_).append(")");
                        return val.toString();
                    } else {
                        val.append(val_);
                    }
                    return val.toString();
                } else if (CompareType.INNER.equals((Object)compareType) || CompareType.NOTINNER.equals((Object)compareType) || CompareType.EXISTS.equals((Object)compareType) || CompareType.NOTEXISTS.equals((Object)compareType)) {
                    sCompare = new StringBuffer((String)obj);
                    val.append("(").append(sCompare).append(")");
                    return val.toString();
                } else {
                    val.append("?");
                    SQLType tmpSqlType = null;
                    if (type.equals((Object)ConstDataType.BOOLEAN)) {
                        if (obj.toString().equalsIgnoreCase("true") || obj.toString().equalsIgnoreCase("1")) {
                            this.putParaObject(paraMap, this.queryFilterItem_.getQueryField().getMappingFieldType(), new Integer("1"));
                            return val.toString();
                        } else {
                            if (!obj.toString().equalsIgnoreCase("false") && !obj.toString().equalsIgnoreCase("0")) throw new BOSException("The ConstField convert datatype is error.");
                            this.putParaObject(paraMap, this.queryFilterItem_.getQueryField().getMappingFieldType(), new Integer("0"));
                        }
                        return val.toString();
                    } else if (type.equals((Object)ConstDataType.DATE)) {
                        if (obj instanceof Date) {
                            this.putParaObject(paraMap, SQLType.DATETIME, new Timestamp(((Date)obj).getTime()));
                            return val.toString();
                        } else {
                            if (!(obj instanceof String)) throw new BOSException("The ConstField convert datatype is error.");
                            this.putParaObject(paraMap, SQLType.DATETIME, new Timestamp(DateTimeUtils.parseDate((String)((String)obj)).getTime()));
                        }
                        return val.toString();
                    } else if (type.equals((Object)ConstDataType.TIME)) {
                        if (obj instanceof Date) {
                            this.putParaObject(paraMap, SQLType.DATETIME, new Time(((Date)obj).getTime()));
                            return val.toString();
                        } else {
                            if (!(obj instanceof String)) throw new BOSException("The ConstField convert datatype is error.");
                            this.putParaObject(paraMap, SQLType.DATETIME, new Time(DateTimeUtils.parseDate((String)((String)obj)).getTime()));
                        }
                        return val.toString();
                    } else if (type.equals((Object)ConstDataType.TIMESTAMP)) {
                        if (obj instanceof Date) {
                            this.putParaObject(paraMap, SQLType.DATETIME, new Timestamp(((Date)obj).getTime()));
                            return val.toString();
                        } else {
                            if (!(obj instanceof String)) throw new BOSException("The ConstField convert datatype is error.");
                            this.putParaObject(paraMap, SQLType.DATETIME, new Timestamp(DateTimeUtils.parseDate((String)((String)obj)).getTime()));
                        }
                        return val.toString();
                    } else if (type.equals((Object)ConstDataType.STRING)) {
                        String sTmpValue = obj.toString();
                        tmpSqlType = SQLType.NVARCHAR;
                        if (!this.queryFilterItem_.isFuncCol() && "#0".equalsIgnoreCase(this.queryFilterItem_.getQueryField().getFormulaString())) {
                            tmpSqlType = this.queryFilterItem_.getQueryField().getMappingFieldType();
                        }
                        this.putParaObject(paraMap, tmpSqlType, sTmpValue);
                        return val.toString();
                    } else if (type.equals((Object)ConstDataType.INT)) {
                        this.putParaObject(paraMap, SQLType.INT, new Integer(obj.toString()));
                        return val.toString();
                    } else if (type.equals((Object)ConstDataType.NUMBER)) {
                        this.putParaObject(paraMap, SQLType.NUMERIC, new Double(obj.toString()));
                        return val.toString();
                    } else {
                        this.putParaObject(paraMap, SQLType.NVARCHAR, obj);
                    }
                }
            }
            return val.toString();
        }
        catch (Exception err) {
            throw new BOSException("The ConstField convert datatype is error.   filterItemInfo:" + this + ", ReturnType:" + (Object)((Object)this.queryFilterItem_.getExprReturnType()) + ", isFuncCol:" + this.queryFilterItem_.isFuncCol(), (Throwable)err);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleCollection(Map<Integer, Object> paraMap, StringBuffer val, Collection collection) throws BOSException, ParseException {
        StringBuffer sCompare = null;
        if (collection.size() <= 0) throw new BOSException("The CompareValue is NULL.");
        sCompare = new StringBuffer();
        ArrayList<String> liString = new ArrayList<String>();
        Iterator it = collection.iterator();
        SQLType tmpSqlType = null;
        if (collection.size() < 100) {
            while (it.hasNext()) {
                Object obj2 = it.next();
                Object s = "";
                sCompare.append("?,");
                if (this.queryFilterItem_.getQueryField().getReturnType().equals((Object)ConstDataType.STRING)) {
                    s = obj2.toString();
                    tmpSqlType = SQLType.VARCHAR;
                } else if (ConstDataType.INT.equals((Object)this.queryFilterItem_.getQueryField().getReturnType())) {
                    s = obj2.toString();
                    tmpSqlType = SQLType.INT;
                } else if (this.queryFilterItem_.getQueryField().getReturnType().equals((Object)ConstDataType.DATE)) {
                    tmpSqlType = SQLType.DATETIME;
                    if (obj2 instanceof Date) {
                        s = new Timestamp(((Date)obj2).getTime());
                    } else {
                        if (!(obj2 instanceof String)) throw new BOSException("The ConstField convert datatype is error.");
                        s = new Timestamp(DateTimeUtils.parseDate((String)((String)obj2)).getTime());
                    }
                } else if (this.queryFilterItem_.getQueryField().getReturnType().equals((Object)ConstDataType.BOOLEAN)) {
                    if (obj2.toString().equalsIgnoreCase("true")) {
                        s = "1";
                        tmpSqlType = SQLType.INT;
                    } else if (obj2.toString().equalsIgnoreCase("false")) {
                        s = "0";
                        tmpSqlType = SQLType.INT;
                    } else {
                        s = obj2;
                        tmpSqlType = SQLType.NVARCHAR;
                    }
                } else {
                    s = obj2.toString();
                    tmpSqlType = SQLType.VARCHAR;
                }
                this.putParaObject(paraMap, tmpSqlType, s);
            }
        } else {
            while (it.hasNext()) {
                Object obj2 = it.next();
                String s = "";
                s = this.queryFilterItem_.getQueryField().getReturnType().equals((Object)ConstDataType.STRING) || this.queryFilterItem_.getQueryField().getReturnType().equals((Object)ConstDataType.DATE) ? '\'' + obj2.toString() + '\'' + "," : (this.queryFilterItem_.getQueryField().getReturnType().equals((Object)ConstDataType.BOOLEAN) ? (obj2.toString().equalsIgnoreCase("true") ? "1," : (obj2.toString().equalsIgnoreCase("false") ? "0," : obj2 + ",")) : obj2.toString() + ",");
                liString.add(s);
            }
            Collections.sort(liString);
            it = liString.iterator();
            while (it.hasNext()) {
                sCompare.append(it.next().toString());
            }
        }
        val.append("(").append(sCompare.substring(0, sCompare.length() - 1)).append(")");
    }

    private void putParaObject(Map paraMap, SQLType type, Object value) throws BOSException {
        if (paraMap == null || type == null) {
            throw new BOSException("The parameters can't be null!     paraMap=" + paraMap + "  type=" + type);
        }
        Object[] paramValueObj = new Object[]{type, value};
        int newIdx = paraMap.size() + 1;
        paraMap.put(newIdx, paramValueObj);
    }

    private static class QueryField {
        private QueryFieldInfo field = null;
        private PropertyUnitDele fieldDele = null;

        QueryField(QueryFieldInfo field) {
            this.field = field;
        }

        QueryField(PropertyUnitDele fieldDele) {
            this.fieldDele = fieldDele;
        }

        public String getShowValue() throws BOSException {
            if (this.field != null) {
                return this.field.getShowValue();
            }
            if (this.fieldDele != null) {
                return this.fieldDele.getShowValue();
            }
            return null;
        }

        public ConstDataType getReturnType() throws BOSException {
            if (this.field != null) {
                return this.field.getReturnType();
            }
            if (this.fieldDele != null) {
                return this.fieldDele.getReturnType();
            }
            return null;
        }

        SQLType getMappingFieldType() throws BOSException {
            if (this.field != null) {
                return this.field.getMappingFieldType();
            }
            if (this.fieldDele != null) {
                return this.fieldDele.getMappingFieldType();
            }
            return null;
        }

        String getFormulaString() {
            if (this.field != null) {
                return this.field.getFormulaString();
            }
            if (this.fieldDele != null) {
                return this.fieldDele.getFormulaString();
            }
            return null;
        }
    }

    private static class QueryFilterItem {
        private QueryFilterItemInfo item = null;
        private QueryFilterItemDele itemDele = null;

        QueryFilterItem(QueryFilterItemInfo item) {
            this.item = item;
        }

        QueryFilterItem(QueryFilterItemDele item) {
            this.itemDele = item;
        }

        CompareType getCompareType() {
            if (this.item != null) {
                return this.item.getCompareType();
            }
            if (this.itemDele != null) {
                return this.itemDele.getCompareType();
            }
            return null;
        }

        boolean isFuncCol() {
            if (this.item != null) {
                return this.item.isFuncCol();
            }
            if (this.itemDele != null) {
                return this.itemDele.isFuncCol();
            }
            return false;
        }

        QueryField getQueryField() {
            if (this.item != null) {
                return new QueryField(this.item.getQueryField());
            }
            if (this.itemDele != null) {
                return new QueryField(this.itemDele.getQueryField());
            }
            return null;
        }

        QueryField getQueryFieldByName(String name) {
            if (this.item != null) {
                return new QueryField(this.item.getQueryFieldByName(name));
            }
            if (this.itemDele != null) {
                return new QueryField(this.itemDele.getQueryFieldByName(name));
            }
            return null;
        }

        String getExprTemplate() {
            if (this.item != null) {
                return this.item.getExprTemplate();
            }
            if (this.itemDele != null) {
                return this.itemDele.getExprTemplate();
            }
            return null;
        }

        ConstDataType getExprReturnType() throws BOSException {
            if (this.item != null) {
                return this.item.getExprReturnType();
            }
            if (this.itemDele != null) {
                return this.itemDele.getExprReturnType();
            }
            return null;
        }

        List getFieldList() {
            if (this.item != null) {
                return this.item.getFieldList();
            }
            if (this.itemDele != null) {
                return this.itemDele.getFieldList();
            }
            return null;
        }

        Object getCompareValue() {
            if (this.item != null) {
                return this.item.getCompareValue();
            }
            if (this.itemDele != null) {
                return this.itemDele.getCompareValue();
            }
            return null;
        }

        String getQueryName() {
            if (this.item != null && this.item.getFilter() != null && this.item.getFilter().getQuery() != null) {
                return this.item.getFilter().getQuery().getName();
            }
            if (this.itemDele != null && this.itemDele.getFilter() != null && this.itemDele.getFilter().getQuery() != null) {
                return this.itemDele.getFilter().getQuery().getName();
            }
            return null;
        }
    }
}

