/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.query;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.DeleContext;
import com.kingdee.bos.dao.DeleContextUtil;
import com.kingdee.bos.metadata.AbstractMDValueDele;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.query.JoinCollection;
import com.kingdee.bos.metadata.query.JoinCollectionDele;
import com.kingdee.bos.metadata.query.JoinDele;
import com.kingdee.bos.metadata.query.QueryCtxUtil;
import com.kingdee.bos.metadata.query.QueryDele;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.query.SubQueryInfo;
import com.kingdee.bos.metadata.query.token.IToken;
import com.kingdee.bos.metadata.query.token.TokenType;
import com.kingdee.bos.metadata.query.util.QueryUtil;
import java.util.Map;

public class SubObjectDele
extends AbstractMDValueDele
implements IToken {
    public static final int ENTITY = 0;
    public static final int QUERY = 1;
    public static final int OTHER = -1;
    private int type;
    private String nameAlias = null;
    private String sql = null;

    private SubObjectDele(SubObjectInfo target, DeleContext ctx) {
        super(target, ctx);
        this.setType();
        this.setQuery(QueryCtxUtil.getQuery(ctx, target.getQuery()));
    }

    public static SubObjectDele getInstance(SubObjectInfo target, DeleContext ctx) {
        if (target == null) {
            return null;
        }
        SubObjectDele dele = (SubObjectDele)DeleContextUtil.get(target.getBOSType(), ctx, target);
        if (dele == null) {
            dele = new SubObjectDele(target, ctx);
        }
        return dele;
    }

    public static SubObjectDele newSubEntity(QueryDele query, EntityObjectInfo en) {
        SubObjectDele dele = new SubObjectDele(new SubEntityInfo((QueryInfo)query.getTarget(), en), query.getContext());
        dele.isTgtNew = true;
        dele.setQuery(query);
        return dele;
    }

    public QueryDele getQuery() {
        return (QueryDele)this.get("query");
    }

    public void setQuery(QueryDele item) {
        this.put("query", item);
    }

    private void setType() {
        if (this.target instanceof SubEntityInfo) {
            this.type = 0;
        } else if (this.target instanceof SubQueryInfo) {
            this.type = 1;
        }
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        return this.getString("name");
    }

    public void setName(String item) {
        if (this.isTgtNew) {
            ((SubObjectInfo)this.target).setName(item);
        } else {
            this.setString("name", item);
        }
    }

    public EntityObjectInfo getEntityRef() {
        if (this.type == 0) {
            return (EntityObjectInfo)this.get("entityRef");
        }
        return null;
    }

    public QueryInfo getQueryRef() {
        return (QueryInfo)this.get("queryRef");
    }

    public JoinCollectionDele getJoinsFromClient() {
        JoinCollectionDele joins = new JoinCollectionDele(new JoinCollection(), this.ctx);
        QueryDele query = this.getQuery();
        if (query == null || query.getType() == 1) {
            return joins;
        }
        int size = query.getJoins().size();
        for (int i = 0; i < size; ++i) {
            JoinDele join = query.getJoins().get(i);
            if (!join.getLeftObject().getName().equals(this.getName()) || joins.contains(join.getName())) continue;
            joins.add(join);
        }
        return joins;
    }

    public JoinCollectionDele getJoinsFromSupplier() {
        JoinCollectionDele joins = new JoinCollectionDele(new JoinCollection(), this.ctx);
        QueryDele query = this.getQuery();
        if (query == null || query.getType() == 1) {
            return joins;
        }
        int size = query.getJoins().size();
        for (int i = 0; i < size; ++i) {
            JoinDele join = query.getJoins().get(i);
            if (!join.getRightObject().getName().equals(this.getName()) || joins.contains(join.getName())) continue;
            joins.add(join);
        }
        return joins;
    }

    public String getSql() {
        if (this.type != 1) {
            return null;
        }
        if (this.sql == null) {
            return ((SubQueryInfo)this.target).getSql();
        }
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    @Override
    public TokenType getTokenType() {
        if (this.type != 1) {
            return null;
        }
        return ((SubQueryInfo)this.target).getTokenType();
    }

    @Override
    public String showValue() throws BOSException {
        return " " + this.getSql() + " ";
    }

    public String showValue(boolean paraType, Map paraMap) throws BOSException {
        return this.showValue();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof SubObjectDele)) {
            return false;
        }
        SubObjectDele that = (SubObjectDele)o;
        return SubObjectDele.equals(this.getName(), that.getName()) && SubObjectDele.equals(this.getQuery(), that.getQuery());
    }

    public String getNameAlias() {
        if (this.nameAlias == null) {
            this.nameAlias = QueryUtil.getEntityAlias(this.getName());
        }
        return this.nameAlias;
    }
}

