/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.query.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.PropertyUnitDele;
import com.kingdee.bos.metadata.query.QuerySorterItemCollectionDele;
import com.kingdee.bos.metadata.query.QuerySorterItemDele;
import com.kingdee.bos.metadata.query.token.CollectionFormulaParser;
import com.kingdee.bos.metadata.query.util.AbstractBuilder;
import com.kingdee.bos.metadata.query.util.BuilderState;
import com.kingdee.bos.metadata.query.util.QueryDeleUtil;
import com.kingdee.bos.metadata.query.util.QuerySqlAccessBase;
import com.kingdee.bos.metadata.query.util.QueryUtil;
import java.util.ArrayList;

public class OrderBuilder
extends AbstractBuilder {
    private StringBuffer order;
    private boolean isIgnoreOrder = false;
    private QuerySorterItemCollectionDele sorterItems = null;

    public OrderBuilder(QuerySqlAccessBase qsa) {
        super(qsa);
    }

    @Override
    public String getSql() throws BOSException {
        if (this.order == null) {
            this.buildOrder();
        }
        return this.order.toString();
    }

    private void buildOrder() throws BOSException {
        this.order = new StringBuffer();
        QuerySorterItemCollectionDele sorts = this.getSorterItems();
        if (sorts.size() == 0) {
            return;
        }
        ArrayList<PropertyUnitDele> flds = this.qsa.select.getSelector();
        this.order.append(" ORDER BY ");
        int n = sorts.size();
        for (int i = 0; i < n; ++i) {
            PropertyUnitDele field;
            if (i != 0) {
                this.order.append(',');
            }
            if ((field = sorts.get(i).getQueryField()) == null) {
                throw new BOSException("Can't found QueryFeild define: " + sorts.get(i).getPropertyName());
            }
            if (this.query.getType() == 1) {
                this.order.append("\"" + field.getName() + "\"");
            } else {
                int index = this.indexofIgnoreCase(flds, field);
                if (index != -1) {
                    if (sorts.get(i).getPropertyName().length() < 30) {
                        this.order.append("\"" + sorts.get(i).getPropertyName() + "\"");
                    } else {
                        this.order.append("\"" + this.getSelectorAlias(field, index) + "\"");
                    }
                } else {
                    this.order.append(OrderBuilder.getOrderString(field));
                }
            }
            if (sorts.get(i).getNLSSortType() != null) {
                this.order.append(' ' + sorts.get(i).getNLSSortType().getName());
            }
            this.order.append(' ' + sorts.get(i).getSortType().getName());
        }
    }

    public QuerySorterItemCollectionDele getSorterItems() throws BOSException {
        if (this.sorterItems == null) {
            this.sorterItems = this.buildSorterItems();
        }
        return this.sorterItems;
    }

    private int indexofIgnoreCase(ArrayList fields, PropertyUnitDele field) {
        int size = fields.size();
        for (int i = 0; i < size; ++i) {
            PropertyUnitDele unit = (PropertyUnitDele)fields.get(i);
            if (unit != field && !unit.getName().equalsIgnoreCase(field.getName())) continue;
            return i;
        }
        return -1;
    }

    protected QuerySorterItemCollectionDele buildSorterItems() throws BOSException {
        QuerySorterItemCollectionDele items = this.query.getDefaultSorters();
        EntityViewInfo viewInfo = this.qsa.state.getView();
        items = this.isIgnoreOrder || viewInfo != null && viewInfo.isIngorePreOrders() ? QuerySorterItemCollectionDele.newInstance(this.query.getContext()) : this.query.getDefaultSorters();
        SorterItemCollection sorter = viewInfo.getSorter();
        int n = sorter.size();
        for (int i = 0; i < n; ++i) {
            SorterItemInfo sitem = sorter.get(i);
            PropertyUnitDele fld = this.query.getUnits().getIgnoreCase(sitem.getPropertyName());
            if (fld == null) {
                fld = QueryDeleUtil.processPropertyName(this.query, sitem.getPropertyName(), false);
            }
            if (fld == null) continue;
            QuerySorterItemDele item = QuerySorterItemDele.newInstance(this.query);
            item.setQueryField(fld);
            item.setSortType(sitem.getSortType());
            item.setNLSSortType(sitem.getNLSSortType());
            if (items.containsByName(item)) continue;
            items.add(item);
        }
        return items;
    }

    private static String getOrderString(PropertyUnitDele field) throws BOSException {
        CollectionFormulaParser paser = new CollectionFormulaParser(field.getFormulaString(), field.getPropertyRefs());
        String val = paser.tokenList.showValue();
        return QueryUtil.replaceContactFormulaString(val);
    }

    public void setIgnoreOrder(boolean isIgnoreOrder) {
        if (this.isIgnoreOrder != isIgnoreOrder) {
            this.order = null;
            this.sorterItems = null;
            this.isIgnoreOrder = isIgnoreOrder;
        }
    }

    @Override
    public void clear(BuilderState.ChangeEvent e) {
        if (e.type == 0) {
            this.order = null;
            this.sorterItems = null;
        }
    }
}

