/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.query.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DeleContext;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.query.PropertyUnitDele;
import com.kingdee.bos.metadata.query.QueryDele;
import com.kingdee.bos.metadata.query.QueryDeleUpdater;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.util.BuilderState;
import com.kingdee.bos.metadata.query.util.FromBuilder;
import com.kingdee.bos.metadata.query.util.GroupType;
import com.kingdee.bos.metadata.query.util.OrderBuilder;
import com.kingdee.bos.metadata.query.util.QuerySQLFormater;
import com.kingdee.bos.metadata.query.util.SelectBuilder;
import com.kingdee.bos.metadata.query.util.WhereBuilder;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.dom.SqlSelect;
import com.kingdee.bos.sql.dom.SqlSelectBase;
import com.kingdee.bos.sql.dom.SqlSelectItem;
import com.kingdee.bos.sql.dom.SqlSubQueryTableSource;
import com.kingdee.bos.sql.dom.SqlUnionSelect;
import com.kingdee.bos.sql.dom.expr.SqlAllColumnExpr;
import com.kingdee.bos.sql.dom.expr.SqlExpr;
import com.kingdee.bos.sql.formater.FormaterException;
import com.kingdee.bos.sql.parser.SelectParser;
import com.kingdee.bos.sql.parser.SqlExprParser;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class QuerySqlAccessBase
implements Serializable {
    private static final long serialVersionUID = -2907168329016435372L;
    protected static Logger logger = Logger.getLogger(QuerySqlAccessBase.class);
    public final QueryDele query;
    public final SelectBuilder select;
    public final FromBuilder from;
    public final WhereBuilder where;
    public final OrderBuilder order;
    public final BuilderState state;

    public QuerySqlAccessBase(Context ctx, QueryInfo query) {
        DeleContext deleCtx = new DeleContext();
        deleCtx.bosCtx = ctx;
        this.query = QueryDele.getInstance(query, deleCtx);
        this.select = this.getSelectBuilder();
        this.from = this.getFromBuilder();
        this.where = this.getWhereBuilder();
        this.order = this.getOrderBuilder();
        this.state = this.getBuilderState();
        this.state.registerChangeListener(this.select);
        this.state.registerChangeListener(this.from);
        this.state.registerChangeListener(this.where);
        this.state.registerChangeListener(this.order);
    }

    protected SelectBuilder getSelectBuilder() {
        return new SelectBuilder(this);
    }

    protected FromBuilder getFromBuilder() {
        return new FromBuilder(this);
    }

    protected WhereBuilder getWhereBuilder() {
        return new WhereBuilder(this);
    }

    protected OrderBuilder getOrderBuilder() {
        return new OrderBuilder(this);
    }

    protected BuilderState getBuilderState() {
        return new BuilderState(this);
    }

    protected abstract QuerySqlAccessBase newInstance(Context var1, QueryInfo var2) throws BOSException;

    public void init(EntityViewInfo view, Map<String, EntityViewInfo> views) throws BOSException {
        EntityViewInfo currView = this.state.getViewFromMap(views);
        if (currView == null) {
            currView = view;
        }
        if (currView != null) {
            new QueryDeleUpdater(this.query).updateQuery(currView);
        }
        this.state.set(view, views);
    }

    public String getSql() throws BOSException {
        return this.getSql(false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSql(boolean bParaType, Map<Integer, Object> paraMap) throws BOSException {
        QueryDele queryDele = this.query;
        synchronized (queryDele) {
            StringBuffer sql = new StringBuffer();
            String returnSQL = "";
            if (this.query.getType() == 0) {
                String selectSql = this.select.getSql();
                this.where.setParam(bParaType, paraMap);
                String whereSql = this.where.getSql();
                String fromsql = this.from.getSql();
                String orderSql = this.order.getSql();
                sql.append(selectSql);
                sql.append(fromsql);
                sql.append(whereSql);
                sql.append(orderSql);
                returnSQL = this.isGroup() ? this.processGroup(sql.toString()) : this.formatSQL(sql.toString());
                if (this.select.hasTOPAndDISTINCT()) {
                    returnSQL = this.processTopAndDistinct(returnSQL);
                }
            } else if (this.query.getType() == 1) {
                String fromSql = this.from.getSql();
                String orderSql = this.order.getSql();
                this.where.setParam(bParaType, paraMap);
                String whereSql = this.where.getSql();
                if (orderSql.length() != 0 || whereSql.length() != 0) {
                    StringBuffer temp = new StringBuffer();
                    temp.append("SELECT * FROM ( ");
                    temp.append(fromSql);
                    temp.append(" ) AS ");
                    temp.append(this.query.getMainObject().getName());
                    sql.append(temp.toString());
                } else {
                    sql.append(fromSql);
                }
                sql.append(whereSql);
                sql.append(orderSql);
                returnSQL = this.formatSQL(sql.toString());
            }
            return returnSQL;
        }
    }

    protected String processTopAndDistinct(String sql) throws BOSException {
        SqlSelect sqlSelect = null;
        SelectParser parser = null;
        StringBuffer buff = new StringBuffer();
        QuerySQLFormater formater = new QuerySQLFormater(buff);
        try {
            parser = new SelectParser(sql);
            SqlSelectBase selectBase = parser.select();
            if (selectBase instanceof SqlSelect) {
                sqlSelect = (SqlSelect)selectBase;
                if (sqlSelect != null) {
                    SqlSelect newSqlSelect = new SqlSelect();
                    newSqlSelect.selectList.add(new SqlSelectItem((SqlExpr)new SqlAllColumnExpr(), null));
                    newSqlSelect.limit = sqlSelect.limit;
                    newSqlSelect.orderBy = new ArrayList(sqlSelect.orderBy);
                    sqlSelect.limit = null;
                    sqlSelect.orderBy.clear();
                    sqlSelect.distinct = 1;
                    SqlSubQueryTableSource subTabSrc = new SqlSubQueryTableSource();
                    subTabSrc.alias = "TABLE_BOS";
                    subTabSrc.subQuery = sqlSelect;
                    newSqlSelect.tableSource = subTabSrc;
                    formater.formatSelectBase((SqlSelectBase)newSqlSelect);
                } else {
                    throw new BOSException("Get SqlSelect failed!");
                }
            }
            return buff.toString();
        }
        catch (ParserException parseException) {
            throw new BOSException("parse sql error, sql = " + sql, (Throwable)parseException);
        }
        catch (FormaterException formaterExcption) {
            throw new BOSException("format sql error, sql = " + sql, (Throwable)formaterExcption);
        }
    }

    protected String toString(SqlExpr expr) throws BOSException {
        StringBuffer buff = new StringBuffer();
        QuerySQLFormater formater = new QuerySQLFormater(buff);
        try {
            formater.formatExpr(expr);
        }
        catch (FormaterException e) {
            throw new BOSException((Throwable)e);
        }
        return buff.toString();
    }

    protected SqlExpr getSqlExpr(String expr) throws BOSException {
        SqlExprParser exprParser = null;
        SqlExpr returnExpr = null;
        try {
            exprParser = new SqlExprParser(expr);
            returnExpr = exprParser.expr();
        }
        catch (ParserException e) {
            throw new BOSException((Throwable)e);
        }
        return returnExpr;
    }

    protected String processGroup(String sql) throws BOSException {
        SqlSelect sqlSelect = null;
        SelectParser parser = null;
        try {
            parser = new SelectParser(sql);
            SqlSelectBase selectBase = parser.select();
            if (selectBase instanceof SqlSelect) {
                sqlSelect = (SqlSelect)selectBase;
                List selectItemCol = sqlSelect.selectList;
                ArrayList<PropertyUnitDele> fields = this.query.getSelector().getFields();
                if (fields.size() == selectItemCol.size()) {
                    sqlSelect.groupBy.clear();
                    sqlSelect.setGroupByWord(" GROUP BY ");
                    int n = selectItemCol.size();
                    for (int i = 0; i < n; ++i) {
                        PropertyUnitDele field = (PropertyUnitDele)fields.get(i);
                        SqlSelectItem selectItem = (SqlSelectItem)selectItemCol.get(i);
                        if (!field.isIsSelector()) continue;
                        if (field.getGroupType() == GroupType.GROUPING) {
                            sqlSelect.groupBy.add(selectItem.expr);
                            continue;
                        }
                        if (field.getGroupType() == GroupType.NONE) continue;
                        StringBuffer strBuffer = new StringBuffer();
                        strBuffer.append(field.getGroupType().toString());
                        strBuffer.append("(");
                        strBuffer.append(this.toString(selectItem.expr));
                        strBuffer.append(")");
                        selectItem.expr = this.getSqlExpr(strBuffer.toString());
                    }
                }
            } else {
                throw new BOSException("selector Number is not equal!");
            }
            StringBuffer buff = new StringBuffer();
            QuerySQLFormater formater = new QuerySQLFormater(buff);
            formater.formatSelect(sqlSelect);
            return buff.toString();
        }
        catch (ParserException parseException) {
            throw new BOSException("parse sql error, sql = " + sql, (Throwable)parseException);
        }
        catch (FormaterException formaterExcption) {
            throw new BOSException("format sql error, sql = " + sql, (Throwable)formaterExcption);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String formatSQL(String sql) throws BOSException {
        SqlSelect sqlSelect = null;
        SqlUnionSelect sqlUnionSelect = null;
        SelectParser parser = null;
        StringBuffer buff = new StringBuffer();
        QuerySQLFormater formater = new QuerySQLFormater(buff);
        try {
            parser = new SelectParser(sql);
            SqlSelectBase selectBase = parser.select();
            if (selectBase instanceof SqlSelect) {
                sqlSelect = (SqlSelect)selectBase;
                if (sqlSelect == null) throw new BOSException("Get SqlSelect failed!");
                formater.formatSelectBase((SqlSelectBase)sqlSelect);
                return buff.toString();
            } else {
                if (!(selectBase instanceof SqlUnionSelect)) return buff.toString();
                sqlUnionSelect = (SqlUnionSelect)selectBase;
                if (sqlUnionSelect == null) throw new BOSException("Get sqlUnionSelect failed!");
                formater.formatSelectBase((SqlSelectBase)sqlUnionSelect);
            }
            return buff.toString();
        }
        catch (ParserException parseException) {
            throw new BOSException("parse sql error, sql = " + sql, (Throwable)parseException);
        }
        catch (FormaterException formaterExcption) {
            throw new BOSException("format sql error, sql = " + sql, (Throwable)formaterExcption);
        }
    }

    protected boolean isGroup() throws BOSException {
        if (this.query != null) {
            ArrayList<PropertyUnitDele> fields = this.query.getSelector().getFields();
            int n = fields.size();
            for (int i = 0; i < n; ++i) {
                if (((PropertyUnitDele)fields.get(i)).getGroupType() == GroupType.NONE) continue;
                return true;
            }
        }
        return false;
    }

    public static String getRevertedSql(EntityObjectInfo mainObject, String[] selectors, String[] sortters, RevertRelateParameter[] revertParameters) throws BOSException {
        int i;
        if (mainObject == null) {
            throw new BOSException("main object can not be null...");
        }
        StringBuffer sql = new StringBuffer("SELECT ");
        if (selectors != null && selectors.length > 0) {
            for (int i2 = 0; i2 < selectors.length; ++i2) {
                if (mainObject.getPropertyByNameRuntime(selectors[i2]) == null) continue;
                sql.append(selectors[i2] + ", ");
            }
        }
        if (QuerySqlAccessBase.checkRelationship(mainObject, revertParameters) && revertParameters != null && revertParameters.length > 0) {
            for (i = 0; i < revertParameters.length; ++i) {
                List<String> selectorList = revertParameters[i].getSelectorList();
                if (selectorList.size() <= 0) continue;
                int j = 0;
                while (j < selectorList.size()) {
                    sql.append(selectorList.get(j) + ", ");
                    ++i;
                }
            }
        }
        sql.replace(sql.length() - 1, sql.length(), "");
        sql.append(" FROM ");
        String mainObjectTableName = mainObject.getTable().getName();
        sql.append(mainObjectTableName);
        if (QuerySqlAccessBase.checkRelationship(mainObject, revertParameters) && revertParameters != null && revertParameters.length > 0) {
            sql.append("left join ");
            for (int i3 = 0; i3 < revertParameters.length; ++i3) {
                List<String> propertyList = revertParameters[i3].getParameterList();
                EntityObjectInfo entity = revertParameters[i3].getEntity();
                String entityTableName = entity.getTable().getName();
                if (propertyList.size() <= 0) continue;
                for (int j = 0; j < propertyList.size(); ++j) {
                    sql.append(entityTableName + " ON " + entityTableName + "." + propertyList.get(j) + "=" + mainObjectTableName + ".ID ");
                }
            }
        }
        sql.append("ORDER BY ");
        if (sortters != null && sortters.length > 0) {
            for (i = 0; i < sortters.length; ++i) {
                if (mainObject.getPropertyByNameRuntime(sortters[i]) == null) continue;
                sql.append(sortters[i] + ", ");
            }
        }
        sql.replace(sql.length() - 1, sql.length(), "");
        return sql.toString();
    }

    protected static boolean checkRelationship(EntityObjectInfo mainObject, RevertRelateParameter[] params) {
        if (params != null && params.length > 0) {
            for (int i = 0; i < params.length; ++i) {
                EntityObjectInfo entity = params[i].getEntity();
                List<String> propertyList = params[i].getParameterList();
                if (entity == null || propertyList == null || propertyList.size() <= 0) continue;
                for (int j = 0; j < propertyList.size(); ++j) {
                    PropertyInfo property = entity.getPropertyByNameRuntime(propertyList.get(j).toString());
                    if (!(property instanceof LinkPropertyInfo) || ((LinkPropertyInfo)property).getRelationship().isReverseLink(mainObject)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public String getQueryInfoName() {
        if (this.query != null) {
            return this.query.getFullName();
        }
        return "";
    }

    public class RevertRelateParameter {
        private EntityObjectInfo entity;
        private List<String> propertyList;
        private List<String> selectorList;

        public RevertRelateParameter(EntityObjectInfo entity) {
            this.entity = entity;
            this.propertyList = new ArrayList<String>();
            this.selectorList = new ArrayList<String>();
        }

        public EntityObjectInfo getEntity() {
            return this.entity;
        }

        public void addParemeter(String property) {
            if (this.entity.getPropertyByNameRuntime(property) != null) {
                this.propertyList.add(property);
            }
        }

        public List<String> getParameterList() {
            return this.propertyList;
        }

        public void clearPropertyList() {
            this.propertyList.clear();
        }

        public void addSelector(String select) {
            if (this.entity.getPropertyByNameRuntime(select) != null) {
                this.selectorList.add(select);
            }
        }

        public List<String> getSelectorList() {
            return this.selectorList;
        }

        public void clearSelectorList() {
            this.selectorList.clear();
        }
    }
}

