/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.report;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import org.apache.log4j.Logger;

public class FileUtil {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.metadata.report.FileUtil");

    private FileUtil() {
    }

    public static byte[] loadFile2Stream(String filePath) {
        File f = new File(filePath);
        return FileUtil.loadFile2Stream(f);
    }

    public static byte[] loadFile2Stream(File file) {
        int len = new Long(file.length()).intValue();
        byte[] template = new byte[len];
        try {
            FileInputStream fis = new FileInputStream(file);
            fis.read(template);
            fis.close();
        }
        catch (FileNotFoundException e) {
            logger.error((Object)e, (Throwable)e);
            return null;
        }
        catch (IOException e) {
            logger.error((Object)e, (Throwable)e);
            return null;
        }
        return template;
    }

    public static String loadFile2Text(String filePath) {
        StringBuffer sb = new StringBuffer();
        try {
            RandomAccessFile file = new RandomAccessFile(filePath, "r");
            long filePointer = 0L;
            long length = file.length();
            while (filePointer < length) {
                String s = file.readLine();
                sb.append(s).append("\n");
                filePointer = file.getFilePointer();
            }
            file.close();
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
        return sb.toString();
    }

    public static void appendText2File(String filePath, String text) {
        try {
            File f = new File(filePath);
            if (!f.exists()) {
                f.createNewFile();
            }
            RandomAccessFile file = new RandomAccessFile(filePath, "rw");
            file.seek(file.length());
            file.write(text.getBytes());
            file.close();
        }
        catch (IOException e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    public static byte[] loadStream2byte(InputStream stream) {
        ByteArrayOutputStream swapStream = new ByteArrayOutputStream();
        byte[] buff = new byte[100];
        int rc = 0;
        try {
            while ((rc = stream.read(buff, 0, 100)) > 0) {
                swapStream.write(buff, 0, rc);
            }
        }
        catch (IOException e) {
            logger.error((Object)e, (Throwable)e);
        }
        return swapStream.toByteArray();
    }
}

