/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.resource;

import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.resource.BizEnumValueCollection;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueType;
import com.kingdee.bos.metadata.validate.ValidateList;
import com.kingdee.bos.metadata.validate.ValidateMetaData;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.IllegalConversionException;
import com.kingdee.util.TypeConversionUtils;
import java.io.Serializable;
import java.util.HashMap;

public class BizEnumInfo
extends AbstractMetaDataValue
implements Serializable {
    public BizEnumInfo() {
        this.put("enumValues", new BizEnumValueCollection());
    }

    protected BizEnumInfo(boolean init) {
        super(init);
        this.put("enumValues", new BizEnumValueCollection());
    }

    public String getClassName() {
        return this.getString("className");
    }

    public void setClassName(String className) {
        this.setString("className", className);
    }

    public BizEnumValueCollection getEnumValue() {
        return (BizEnumValueCollection)this.get("enumValues");
    }

    public BizEnumValueInfo getInnerEnumValue(String value) {
        if (this.getDataType() != BizEnumValueType.STRING) {
            return null;
        }
        BizEnumValueCollection values = this.getEnumValue();
        int n = values.size();
        for (int i = 0; i < n; ++i) {
            BizEnumValueInfo enumValue = values.get(i);
            if (enumValue == null || !enumValue.getString().equalsIgnoreCase(value)) continue;
            return enumValue;
        }
        return null;
    }

    public BizEnumValueInfo getInnerEnumValue(int value) {
        if (this.getDataType() != BizEnumValueType.INTEGER) {
            return null;
        }
        BizEnumValueCollection values = this.getEnumValue();
        int n = values.size();
        for (int i = 0; i < n; ++i) {
            BizEnumValueInfo enumValue = values.get(i);
            if (enumValue == null || enumValue.getInt() != value) continue;
            return enumValue;
        }
        return null;
    }

    public BizEnumValueInfo getInnerEnumValue(float value) {
        if (this.getDataType() != BizEnumValueType.FLOAT) {
            return null;
        }
        BizEnumValueCollection values = this.getEnumValue();
        for (int i = 0; i < values.size(); ++i) {
            BizEnumValueInfo enumValue = values.get(i);
            if (enumValue == null || enumValue.getFloat() != value) continue;
            return enumValue;
        }
        return null;
    }

    public BizEnumValueInfo getInnerEnumValue(double value) {
        if (this.getDataType() != BizEnumValueType.DOUBLE) {
            return null;
        }
        BizEnumValueCollection values = this.getEnumValue();
        for (int i = 0; i < values.size(); ++i) {
            BizEnumValueInfo enumValue = values.get(i);
            if (enumValue == null || enumValue.getDouble() != value) continue;
            return enumValue;
        }
        return null;
    }

    public BizEnumValueInfo getInnerEnumValue(long value) {
        if (this.getDataType() != BizEnumValueType.LONG) {
            return null;
        }
        BizEnumValueCollection values = this.getEnumValue();
        for (int i = 0; i < values.size(); ++i) {
            BizEnumValueInfo enumValue = values.get(i);
            if (enumValue == null || enumValue.getLong() != value) continue;
            return values.get(i);
        }
        return null;
    }

    public BizEnumValueType getDataType() {
        BizEnumValueType dataType = BizEnumValueType.getEnum(this.getString("enumDataType"));
        if (dataType != null) {
            return dataType;
        }
        return BizEnumValueType.STRING;
    }

    public void setDataType(BizEnumValueType dataType) {
        if (dataType != null) {
            this.setString("enumDataType", dataType.getName());
        }
    }

    @Override
    public String toString() {
        return this.getPackage() + "." + this.getName();
    }

    @Override
    public BOSObjectType getBOSType() {
        return MetaDataTypeList.BIZENUM;
    }

    @Override
    public ValidateList validate() {
        super.validate();
        ValidateMetaData vld = this.getValidate();
        vld.validateClassName("Enum class name", this.getClassName());
        BizEnumValueCollection bizEnumCol = this.getEnumValue();
        if (bizEnumCol == null || bizEnumCol.size() == 0) {
            vld.addWarning("Enum value empty.");
        } else {
            HashMap<String, BizEnumValueInfo> map = new HashMap<String, BizEnumValueInfo>();
            for (int i = 0; i < bizEnumCol.size(); ++i) {
                BizEnumValueInfo val = bizEnumCol.get(i);
                Object o = val.getValue();
                if (o == null) {
                    vld.addError("Enum value can not be null.");
                } else {
                    try {
                        if (this.getDataType() == BizEnumValueType.STRING) {
                            TypeConversionUtils.objToString((Object)o);
                        } else if (this.getDataType() == BizEnumValueType.INTEGER) {
                            TypeConversionUtils.objToInt((Object)o);
                        } else if (this.getDataType() == BizEnumValueType.LONG) {
                            TypeConversionUtils.objToLong((Object)o);
                        } else if (this.getDataType() == BizEnumValueType.FLOAT) {
                            TypeConversionUtils.objToFloat((Object)o);
                        } else if (this.getDataType() == BizEnumValueType.DOUBLE) {
                            TypeConversionUtils.objToDouble((Object)o);
                        }
                    }
                    catch (IllegalConversionException ice) {
                        vld.addError("Enum Value '" + o.toString() + "' invalid datatype");
                    }
                }
                if (map.containsKey(val.getName())) {
                    vld.addError("Duplicated enum item: " + val.getName());
                } else {
                    map.put(val.getName(), val);
                }
                vld.addValidateList(val.validate());
            }
        }
        return vld.getValidateList();
    }

    @Override
    public void setUserDefined(boolean isUserDefined) {
        this.put("userDefined", isUserDefined);
    }

    @Override
    public boolean isUserDefined() {
        return this.getBoolean("userDefined");
    }
}

