/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.resource;

import com.kingdee.util.InvalidEncodingException;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;

public class UTF8ResourceBundle {
    private final ResourceBundle bundle;

    private UTF8ResourceBundle(ResourceBundle bundle) {
        this.bundle = bundle;
    }

    public static UTF8ResourceBundle getBundle(String baseName) {
        return new UTF8ResourceBundle(ResourceBundle.getBundle(baseName));
    }

    public static UTF8ResourceBundle getBundle(String baseName, Locale locale) {
        return new UTF8ResourceBundle(ResourceBundle.getBundle(baseName, locale));
    }

    public static UTF8ResourceBundle getBundle(String baseName, Locale locale, ClassLoader loader) {
        return new UTF8ResourceBundle(ResourceBundle.getBundle(baseName, locale, loader));
    }

    public Enumeration getKeys() {
        return this.bundle.getKeys();
    }

    public Locale getLocale() {
        return this.bundle.getLocale();
    }

    public Object getObject(String key) {
        return this.bundle.getObject(key);
    }

    public String getString(String key) {
        try {
            String tmp = this.bundle.getString(key);
            if (tmp != null) {
                return new String(tmp.getBytes("ISO-8859-1"), "UTF-8");
            }
            return null;
        }
        catch (UnsupportedEncodingException uee) {
            throw new InvalidEncodingException(uee.getMessage());
        }
    }

    public String[] getStringArray(String key) {
        try {
            String[] tmp = this.bundle.getStringArray(key);
            if (tmp != null) {
                String[] strs = new String[tmp.length];
                for (int i = 0; i < tmp.length; ++i) {
                    strs[i] = new String(tmp[i].getBytes("ISO-8859-1"), "UTF-8");
                }
                return strs;
            }
            return null;
        }
        catch (UnsupportedEncodingException uee) {
            throw new InvalidEncodingException(uee.getMessage());
        }
    }
}

