/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.rule.formula;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.rule.RuleExecuteException;
import com.kingdee.bos.metadata.rule.RuleExecutor;
import com.kingdee.bos.metadata.rule.formula.Compiler;
import com.kingdee.bos.metadata.rule.formula.FormulaExecuteException;
import com.kingdee.util.TypeConversionUtils;
import java.math.BigDecimal;
import org.apache.log4j.Logger;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.UniqueTag;
import org.mozilla.javascript.Wrapper;

public class FormulaExecutor {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.metadata.rule.formula.FormulaExecutor");

    private FormulaExecutor() {
    }

    public static Object execute(Context ctx, String formula, IObjectValue ov) throws FormulaExecuteException {
        if (ov == null) {
            throw new FormulaExecuteException("ObjectValue cannot be null!");
        }
        try {
            String script = Compiler.compile(ctx, formula, ov);
            logger.debug((Object)script);
            RuleExecutor rule = new RuleExecutor(ctx, script);
            rule.addParameter("SOURCE", ov);
            rule.addParameter("META", MetaDataLoaderFactory.getMetaDataLoader(ctx).getEntity(ov.getBOSType()));
            Object o = rule.execute().getResult();
            if (o != null) {
                if (o instanceof Undefined) {
                    return o;
                }
                if (o instanceof Boolean) {
                    return o;
                }
                if (o instanceof Number) {
                    return o;
                }
                if (o instanceof String) {
                    return o;
                }
                if (o instanceof Wrapper) {
                    return ((Wrapper)o).unwrap();
                }
                if (o instanceof UniqueTag) {
                    throw new FormulaExecuteException(o.toString());
                }
                return org.mozilla.javascript.Context.toString((Object)o);
            }
            return null;
        }
        catch (RuleExecuteException e) {
            throw new FormulaExecuteException((Throwable)((Object)e));
        }
    }

    public static Object executeProperty(Context ctx, String formula, IObjectValue ov, String propertyName) throws FormulaExecuteException {
        if (ov == null) {
            throw new FormulaExecuteException("ObjectValue cannot be null!");
        }
        try {
            String script = Compiler.compile(ctx, formula, ov);
            logger.debug((Object)script);
            RuleExecutor rule = new RuleExecutor(ctx, script);
            rule.addParameter("SOURCE", ov);
            EntityObjectInfo entity = MetaDataLoaderFactory.getMetaDataLoader(ctx).getEntity(ov.getBOSType());
            rule.addParameter("META", entity);
            rule.addParameter("VALUE", ov == null ? null : ov.get(propertyName));
            rule.addParameter("PROPERTY", entity == null ? null : entity.getPropertyByName(propertyName));
            Object o = rule.execute().getResult();
            if (o != null) {
                if (o instanceof Undefined) {
                    return o;
                }
                if (o instanceof Boolean) {
                    return o;
                }
                if (o instanceof Number) {
                    return o;
                }
                if (o instanceof String) {
                    return o;
                }
                if (o instanceof Wrapper) {
                    return ((Wrapper)o).unwrap();
                }
                if (o instanceof UniqueTag) {
                    throw new FormulaExecuteException(o.toString());
                }
                DataType type = null;
                PropertyInfo propertyInfo = entity.getPropertyByName(propertyName);
                if (propertyInfo != null && propertyInfo instanceof OwnPropertyInfo) {
                    type = ((OwnPropertyInfo)propertyInfo).getDataType();
                }
                return FormulaExecutor.ConvertJSData2Java(type, o);
            }
            return null;
        }
        catch (RuleExecuteException e) {
            throw new FormulaExecuteException((Throwable)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object ConvertJSData2Java(DataType dataType, Object jsData) {
        Object objData;
        block19: {
            org.mozilla.javascript.Context ctx = org.mozilla.javascript.Context.enter(null);
            objData = null;
            try {
                if (dataType == null || jsData == null) {
                    objData = jsData;
                    break block19;
                }
                if (DataType.BOOLEAN.equals(dataType)) {
                    objData = ScriptRuntime.toBoolean((Object)jsData);
                    break block19;
                }
                if (DataType.BOSUUID.equals(dataType)) {
                    objData = TypeConversionUtils.objToBOSUuid((Object)ScriptRuntime.toString((Object)jsData));
                    break block19;
                }
                if (DataType.BYTE.equals(dataType)) {
                    objData = new Byte((byte)ScriptRuntime.toInt32((Object)jsData));
                    break block19;
                }
                if (DataType.BYTEARRAY.equals(dataType)) {
                    objData = TypeConversionUtils.objToBytes((Object)ScriptRuntime.toString((Object)jsData));
                    break block19;
                }
                if (DataType.CHAR.equals(dataType)) {
                    objData = ScriptRuntime.toString((Object)jsData);
                    break block19;
                }
                if (DataType.DATE.equals(dataType)) {
                    objData = TypeConversionUtils.objToDate((Object)ScriptRuntime.toString((Object)jsData));
                    break block19;
                }
                if (DataType.DECIMAL.equals(dataType)) {
                    objData = new BigDecimal(ScriptRuntime.toNumber((Object)jsData));
                    break block19;
                }
                if (DataType.DOUBLE.equals(dataType)) {
                    objData = new Double(ScriptRuntime.toNumber((Object)jsData));
                    break block19;
                }
                if (DataType.FLOAT.equals(dataType)) {
                    objData = new Float(ScriptRuntime.toNumber((Object)jsData));
                    break block19;
                }
                if (DataType.INTEGER.equals(dataType)) {
                    objData = ScriptRuntime.toInt32((Object)jsData);
                    break block19;
                }
                if (DataType.LONG.equals(dataType)) {
                    objData = (long)ScriptRuntime.toInt32((Object)jsData);
                    break block19;
                }
                if (DataType.OBJECTVALUE.equals(dataType)) {
                    objData = jsData;
                    break block19;
                }
                if (DataType.SHORT.equals(dataType)) {
                    objData = new Short((short)ScriptRuntime.toInt32((Object)jsData));
                    break block19;
                }
                if (DataType.STRING.equals(dataType)) {
                    objData = ScriptRuntime.toString((Object)jsData);
                    break block19;
                }
                if (DataType.TIME.equals(dataType)) {
                    objData = TypeConversionUtils.objToTime((Object)ScriptRuntime.toString((Object)jsData));
                    break block19;
                }
                if (DataType.TIMESTAMP.equals(dataType)) {
                    objData = TypeConversionUtils.objToTimestamp((Object)ScriptRuntime.toString((Object)jsData));
                    break block19;
                }
                if (!DataType.UUID.equals(dataType)) break block19;
                objData = TypeConversionUtils.objToUuid((Object)ScriptRuntime.toString((Object)jsData));
            }
            catch (Throwable throwable) {
                ctx.exit();
                throw throwable;
            }
        }
        ctx.exit();
        return objData;
    }
}

