/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.ui;

import com.kingdee.bos.dao.xml.impl.AbstractMDElement;
import com.kingdee.bos.metadata.bizrule.common.RuleCollection;
import com.kingdee.bos.metadata.ui.AbstractUIObjectInfo;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.EventBindingCollection;
import com.kingdee.bos.metadata.ui.LayoutInfo;
import com.kingdee.bos.metadata.ui.PropertyBindingCollection;
import com.kingdee.bos.metadata.ui.PropertyCollection;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.metadata.ui.WebEventCollection;
import com.kingdee.bos.metadata.util.ContextManager;
import com.kingdee.bos.ui.dtp.StringConverter;
import com.kingdee.bos.ui.dtp.kdlayout.KDLayoutConstraint;
import com.kingdee.bos.ui.dtp.smartlayout.SmartLayoutData;
import com.kingdee.bos.ui.dtp.tablelayout.TableData;
import com.kingdee.bos.ui.dtp.webborderlayout.WebBorderLayoutData;
import com.kingdee.bos.ui.dtp.weblayout.WebLayoutData;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import com.kingdee.util.marshal.Marshaller;
import com.kingdee.util.marshal.Unmarshaller;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ComponentInfo
extends AbstractMDElement
implements Serializable,
Cloneable {
    public static final String NAME = "name";
    public static final String ISCONTAINER = "isContainer";
    public static final String LAYOUTINFO = "layoutInfo";
    public static final String PROPERTIES = "properties";
    public static final String PROPERTYBINDINGS = "propertyBindings";
    public static final String EVENTBINDINGS = "eventBindings";
    public static final String PARENT = "parent";
    public static final String COMPONENTS = "components";
    public static final String CLASSTYPE = "classType";
    public static final String TABINDEX = "tabIndex";
    public static final String HERITED = "herited";
    public static final String CONSTRAINTS = "constraints";
    public static final String RULES = "rules";
    public static final String ALIAS = "alias";
    public static final String BIMUIOBJECTPK = "bimUIObjectPK";
    protected PropertyCollection allHeritedProperties;
    protected boolean overrideConstraint = false;
    protected boolean overrideTabIndex = false;
    protected boolean overrideParent = false;
    protected boolean overrideRules = false;
    protected boolean locked = false;
    protected Object constraint;
    protected String classType;
    public static final String ISSERVICECOMPONENT = "isServiceComponent";
    public static final String COMPONENTMETADATAPK = "componentMetaDataPK";
    public static final String WEBEVENTS = "webEvents";
    protected String componentMetaDataPK;
    public static final String SYS_VALUE = "value";
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.metadata.ui.ComponentInfo");

    public void setAllHeritedProperties(PropertyCollection collection) {
        this.allHeritedProperties = collection;
    }

    public PropertyCollection getAllHeritedProperties() {
        return this.allHeritedProperties;
    }

    public ComponentInfo() {
        this.setDefaultLocale(ContextManager.getContext().getLocale());
        this.setPKField(NAME);
    }

    public ComponentInfo(String classType) {
        this();
        this.setClassType(classType);
    }

    @Override
    public BOSObjectType getBOSType() {
        return BOSObjectType.create((String)"comp");
    }

    public boolean isContainer() {
        return this.getBoolean(ISCONTAINER);
    }

    public void setContainer(boolean isContainer) {
        this.setBoolean(ISCONTAINER, isContainer);
    }

    public Object _getConstraint() {
        return this.get(CONSTRAINTS);
    }

    public Object getConstraint() {
        if (this.constraint == null) {
            String str = this.getString(CONSTRAINTS);
            ComponentInfo parent = this.getParent();
            if (parent != null && parent.getLayoutInfo() != null) {
                String layoutType = parent.getLayoutInfo().getType();
                if ("BorderLayout".equalsIgnoreCase(layoutType)) {
                    this.constraint = str;
                } else if ("FlowLayout".equalsIgnoreCase(layoutType)) {
                    try {
                        this.constraint = Integer.valueOf(str);
                    }
                    catch (Exception e) {
                        this.constraint = 0;
                    }
                } else if ("TreeViewLayout".equalsIgnoreCase(layoutType)) {
                    this.constraint = str;
                } else if ("TabbedPaneLayout".equalsIgnoreCase(layoutType)) {
                    this.constraint = str;
                } else if ("SplitLayout".equalsIgnoreCase(layoutType)) {
                    this.constraint = str;
                } else if ("WebSplitLayout".equalsIgnoreCase(layoutType)) {
                    this.constraint = str;
                } else if ("SameGridLayout".equalsIgnoreCase(layoutType)) {
                    this.constraint = StringConverter.convertToRectangle(str);
                } else if ("XYLayout".equalsIgnoreCase(layoutType)) {
                    this.constraint = StringConverter.convertToRectangle(str);
                } else if ("KDLayout".equalsIgnoreCase(layoutType)) {
                    this.constraint = StringConverter.convertToKDLayoutConstraint(str);
                } else if ("SmartLayout".equalsIgnoreCase(layoutType)) {
                    this.constraint = SmartLayoutData.parse(str);
                } else if ("WebLayout".equalsIgnoreCase(layoutType)) {
                    this.constraint = WebLayoutData.parse(str);
                } else if ("WebBorderLayout".equalsIgnoreCase(layoutType)) {
                    this.constraint = WebBorderLayoutData.parse(str);
                } else if ("WebToolBarLayout".equalsIgnoreCase(layoutType)) {
                    this.constraint = Integer.valueOf(str);
                } else if ("TableLayout".equalsIgnoreCase(layoutType)) {
                    this.constraint = TableData.parse(str);
                    if (this.constraint == null) {
                        this.constraint = str;
                    }
                } else {
                    this.constraint = str;
                }
            } else if (parent != null) {
                String parentType = parent.getClassType();
                if ("com.kingdee.bos.ctrl.swing.KDTabbedPane".equals(parentType)) {
                    this.constraint = str;
                } else if ("com.kingdee.bos.ctrl.swing.KDTreeView".equals(parentType)) {
                    this.constraint = str;
                } else if ("com.kingdee.bos.ctrl.swing.KDScrollPane".equals(parentType)) {
                    this.constraint = StringConverter.convertToRectangle(str);
                } else if ("com.kingdee.bos.ctrl.swing.KDSplitPane".equals(parentType)) {
                    this.constraint = str;
                } else if ("com.kingdee.bos.ctrl.swing.KDToolBar".equals(parentType) || "com.kingdee.bos.ctrl.swing.KDMenuBar".equals(parentType) || "com.kingdee.bos.ctrl.swing.KDMenu".equals(parentType)) {
                    try {
                        this.constraint = Integer.valueOf(str);
                    }
                    catch (Exception e) {
                        this.constraint = new Integer(0);
                    }
                } else {
                    this.constraint = StringConverter.convertToRectangle(str);
                }
            } else {
                this.constraint = StringConverter.convertToRectangle(str);
                if (this.constraint == null) {
                    this.constraint = str;
                }
            }
        }
        return this.constraint;
    }

    public void setConstraint(Object constraint) {
        Object oldConstraint = this.constraint;
        this.constraint = null;
        if (constraint instanceof Rectangle) {
            Rectangle rect = (Rectangle)constraint;
            this.setString(CONSTRAINTS, StringConverter.convertToString("java.awt.Rectangle", (Object)rect));
        } else if (constraint instanceof String) {
            this.setString(CONSTRAINTS, (String)constraint);
        } else if (constraint instanceof Integer) {
            this.setString(CONSTRAINTS, ((Integer)constraint).toString());
        } else if (constraint instanceof KDLayoutConstraint) {
            this.setString(CONSTRAINTS, StringConverter.convertToString((KDLayoutConstraint)constraint));
        } else if (constraint instanceof WebLayoutData) {
            this.setString(CONSTRAINTS, constraint.toString());
        } else if (constraint instanceof SmartLayoutData) {
            this.setString(CONSTRAINTS, constraint.toString());
        } else {
            this.setString(CONSTRAINTS, constraint == null ? "" : constraint.toString());
        }
    }

    public void setConstraint(Object constraint, boolean isNeedFireChange) {
        this.setConstraint(constraint);
    }

    public void addChild(ComponentInfo child) {
        if (child == null) {
            return;
        }
        child.setParent(this);
        this.getComponents().add(child);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addChild(AbstractUIObjectInfo model, ComponentInfo child) {
        if (child == null || model == null) {
            return false;
        }
        AbstractUIObjectInfo abstractUIObjectInfo = model;
        synchronized (abstractUIObjectInfo) {
            if ("com.kingdee.bos.ctrl.swing.KDToolBar".equals(child.getClassType())) {
                ComponentInfo panel = model.getToolbarsPanel();
                child.setParent(null);
                panel.addChild(child);
                model.getComponents().add(child);
                this.getComponents().add(child);
                return true;
            }
            ComponentCollection bulk = model.getComponents();
            bulk.add(child);
            this.innerAddComponent(bulk, child);
            this.addParentChildRelation(child);
        }
        return true;
    }

    private void innerAddComponent(ComponentCollection bulk, ComponentInfo component) {
        Iterator iter = component.getComponents().iterator();
        ComponentInfo tempComponent = null;
        while (iter.hasNext()) {
            tempComponent = (ComponentInfo)iter.next();
            bulk.add(tempComponent);
            this.innerAddComponent(bulk, tempComponent);
        }
    }

    public PropertyInfo getPropertyByName(String name) {
        if (StringUtils.isEmpty((String)name)) {
            return null;
        }
        return this.getProperties().get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeChild(AbstractUIObjectInfo model, ComponentInfo child) {
        if (child == null || model == null) {
            return false;
        }
        AbstractUIObjectInfo abstractUIObjectInfo = model;
        synchronized (abstractUIObjectInfo) {
            boolean ret = this.deleteParentChildRelation(child);
            if (!ret) {
                return false;
            }
            ComponentCollection bulk = model.getComponents();
            bulk.remove(child);
            this.innerRemoveComponent(bulk, child);
            return true;
        }
    }

    public void removeAllChild(AbstractUIObjectInfo model) {
        if (model == null) {
            return;
        }
        ComponentCollection children = this.getComponents();
        for (int i = children.size() - 1; i >= 0; --i) {
            this.removeChild(model, children.get(i));
        }
    }

    private void innerRemoveComponent(ComponentCollection bulk, ComponentInfo component) {
        Iterator iter = component.getComponents().iterator();
        ComponentInfo tempComponent = null;
        while (iter.hasNext()) {
            tempComponent = (ComponentInfo)iter.next();
            bulk.remove(tempComponent);
            this.innerRemoveComponent(bulk, tempComponent);
        }
    }

    public String getName() {
        return this.getString(NAME);
    }

    public void setName(String name) {
        this.setName(name, true);
    }

    public void setName(String name, boolean isSetText) {
        this.setString(NAME, name);
    }

    public LayoutInfo getLayoutInfo() {
        return (LayoutInfo)this.get(LAYOUTINFO);
    }

    public void setLayoutInfo(LayoutInfo info) {
        this.put(LAYOUTINFO, info);
    }

    public PropertyCollection getProperties() {
        Object obj = this.get(PROPERTIES);
        if (obj == null) {
            PropertyCollection properties = new PropertyCollection();
            this.setProperties(properties);
            return properties;
        }
        return (PropertyCollection)obj;
    }

    public void setProperties(PropertyCollection properties) {
        this.put(PROPERTIES, properties);
    }

    public PropertyBindingCollection getPropertyBindings() {
        Object obj = this.get(PROPERTYBINDINGS);
        if (obj == null) {
            PropertyBindingCollection bindings = new PropertyBindingCollection();
            this.setPropertyBindings(bindings);
            return bindings;
        }
        return (PropertyBindingCollection)obj;
    }

    public void setPropertyBindings(PropertyBindingCollection propertybindings) {
        this.put(PROPERTYBINDINGS, propertybindings);
    }

    public EventBindingCollection getEventBindings() {
        Object obj = this.get(EVENTBINDINGS);
        if (obj == null) {
            EventBindingCollection bindings = new EventBindingCollection();
            this.setEventBindings(bindings);
            return bindings;
        }
        return (EventBindingCollection)obj;
    }

    public void setEventBindings(EventBindingCollection eventbindings) {
        this.put(EVENTBINDINGS, eventbindings);
    }

    public ComponentInfo getParent() {
        Object obj = this.get(PARENT);
        if (obj == null) {
            return null;
        }
        return (ComponentInfo)obj;
    }

    public void setParent(ComponentInfo parent) {
        this.put(PARENT, parent);
    }

    public void removeParent() {
        this.remove(PARENT);
    }

    public boolean deleteParentChildRelation(ComponentInfo child) {
        if (child == null || child.getParent() != this || !this.getComponents().contains(child)) {
            return false;
        }
        this.getComponents().remove(child);
        child.removeParent();
        return true;
    }

    public void addParentChildRelation(ComponentInfo child) {
        child.setParent(this);
        this.getComponents().add(child);
    }

    public synchronized ComponentCollection getComponents() {
        Object obj = this.get(COMPONENTS);
        if (obj == null) {
            ComponentCollection components = new ComponentCollection();
            this.setComponents(components);
            return components;
        }
        obj = this.order((ComponentCollection)obj);
        this.setComponents((ComponentCollection)obj);
        return (ComponentCollection)obj;
    }

    private ComponentCollection order(ComponentCollection cc) {
        boolean hasOrder = false;
        for (int i = 0; i < cc.size(); ++i) {
            if (cc.get(i).getOrder() == -1) continue;
            hasOrder = true;
            break;
        }
        if (!hasOrder) {
            return cc;
        }
        ComponentCollection newCC = new ComponentCollection();
        int size = cc.size();
        for (int i = 0; i < size; ++i) {
            ComponentInfo pi = cc.get(0);
            for (int j = 1; j < cc.size(); ++j) {
                if (newCC.contains(cc.get(j)) || cc.get(j).getOrder() >= pi.getOrder()) continue;
                pi = cc.get(j);
            }
            newCC.add(pi);
            cc.remove(pi);
        }
        return newCC;
    }

    public int getOrder() {
        String order = this.getExtendedProperty("order");
        if (!StringUtils.isEmpty((String)order)) {
            return Integer.parseInt(order);
        }
        return -1;
    }

    public void setComponents(ComponentCollection components) {
        this.put(COMPONENTS, components);
    }

    public String getClassType() {
        if (this.classType == null) {
            this.classType = this.getString(CLASSTYPE);
        }
        return this.classType;
    }

    public void setClassType(String classType) {
        this.classType = classType;
        this.setString(CLASSTYPE, classType);
    }

    public int getTabIndex() {
        return this.getInt(TABINDEX);
    }

    public void setTabIndex(int tabIndex) {
        this.setInt(TABINDEX, tabIndex);
    }

    public boolean isHerited() {
        return this.getBoolean(HERITED);
    }

    public void setHerited(boolean herited) {
        this.setBoolean(HERITED, herited);
    }

    public boolean isOverrideConstraint() {
        return this.overrideConstraint;
    }

    public void setOverrideConstraint(boolean override) {
        this.overrideConstraint = override;
    }

    public boolean isOverrideTabIndex() {
        return this.overrideTabIndex;
    }

    public void setOverrideTabIndex(boolean override) {
        this.overrideTabIndex = override;
    }

    public void setOverrideParent(boolean overrideParent) {
        this.overrideParent = overrideParent;
    }

    public boolean isOverrideParent() {
        return this.overrideParent;
    }

    public boolean isOverrideRules() {
        return this.overrideRules;
    }

    public void setOverrideRules(boolean overrideRules) {
        this.overrideRules = overrideRules;
    }

    public RuleCollection getRules() {
        Object obj = this.get(RULES);
        if (obj == null) {
            RuleCollection collection = new RuleCollection();
            this.put(RULES, collection);
            return collection;
        }
        return (RuleCollection)obj;
    }

    public void setRules(RuleCollection rules) {
        this.put(RULES, rules);
    }

    public void setAlias(String alias) {
        this.put(ALIAS, alias);
    }

    public void setAlias(String alias, Locale locale) {
        this.put(ALIAS, alias, locale);
    }

    public String getAlias() {
        return this.getString(ALIAS);
    }

    public String getAlias(Locale locale) {
        return (String)this.get(ALIAS, locale);
    }

    public String getBimUIObjectPK() {
        return (String)this.get(BIMUIOBJECTPK);
    }

    public void setBimUIObjectPK(String bimUIObjectPK) {
        this.put(BIMUIOBJECTPK, bimUIObjectPK);
    }

    public ComponentInfo cloneOnlySelf() {
        ComponentInfo newInfo = null;
        try {
            newInfo = (ComponentInfo)this.getClass().newInstance();
            newInfo.setName(this.getName(), false);
            newInfo.setContainer(this.isContainer());
            if (this.getLayoutInfo() != null) {
                newInfo.setLayoutInfo((LayoutInfo)this.getLayoutInfo().clone());
            }
            newInfo.setClassType(this.getClassType());
            if (this.isOverrideConstraint()) {
                newInfo.setString(CONSTRAINTS, this.getString(CONSTRAINTS));
            }
            if (this.isOverrideTabIndex()) {
                newInfo.setTabIndex(this.getTabIndex());
            }
            newInfo.setAlias(this.getAlias());
            newInfo.setHerited(this.isHerited());
            newInfo.setOverrideParent(this.isOverrideParent());
            newInfo.setOverrideConstraint(this.isOverrideConstraint());
            newInfo.setOverrideTabIndex(this.isOverrideTabIndex());
            newInfo.setBimUIObjectPK(this.getBimUIObjectPK());
            newInfo.setUserDefined(this.isUserDefined());
            newInfo.setComponentMetaDataPK(this.getComponentMetaDataPK());
            newInfo.setServiceComponent(this.isServiceComponent());
        }
        catch (InstantiationException e) {
            logger.error((Object)"error", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)"error", (Throwable)e);
        }
        return newInfo;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that == this) {
            return true;
        }
        if (!(that instanceof ComponentInfo)) {
            return false;
        }
        if (!this.getClass().getName().equals(that.getClass().getName())) {
            return false;
        }
        String thisName = this.getName();
        String thisType = this.getClassType();
        String thatName = ((ComponentInfo)that).getName();
        String thatType = ((ComponentInfo)that).getClassType();
        if (thisName == null && thatName == null) {
            return true;
        }
        if (thisType != null && thisType.equals(thatType)) {
            return thisName != null && thisName.equals(thatName);
        }
        return false;
    }

    @Override
    public int hashCode() {
        String thisName = this.getName();
        String thisType = this.getClassType();
        if (StringUtils.isEmpty((String)thisName) || StringUtils.isEmpty((String)thisType)) {
            return super.hashCode();
        }
        int result = 17;
        result = 37 * result + thisName.hashCode();
        result = 37 * result + thisType.hashCode();
        return result;
    }

    public void setUserDefined(boolean isUserDefined) {
        this.put("userDefined", isUserDefined);
    }

    public boolean isUserDefined() {
        return this.getBoolean("userDefined");
    }

    public PropertyInfo getHeritedProperty(String propName) {
        if (this.allHeritedProperties == null) {
            return null;
        }
        return this.allHeritedProperties.get(propName);
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    @Override
    public void marshal(Marshaller marshaller) throws IOException {
        super.marshal(marshaller);
        marshaller.writeObject((Object)this.classType);
        marshaller.writeObject(this.constraint);
        marshaller.writeBoolean(this.locked);
        marshaller.writeBoolean(this.overrideConstraint);
        marshaller.writeBoolean(this.overrideParent);
        marshaller.writeBoolean(this.overrideRules);
        marshaller.writeBoolean(this.overrideTabIndex);
        marshaller.writeObject((Object)this.allHeritedProperties);
    }

    @Override
    public void unmarshal(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        super.unmarshal(unmarshaller);
        this.classType = (String)unmarshaller.readObject();
        this.constraint = unmarshaller.readObject();
        this.locked = unmarshaller.readBoolean();
        this.overrideConstraint = unmarshaller.readBoolean();
        this.overrideParent = unmarshaller.readBoolean();
        this.overrideRules = unmarshaller.readBoolean();
        this.overrideTabIndex = unmarshaller.readBoolean();
        this.allHeritedProperties = (PropertyCollection)unmarshaller.readObject();
    }

    public boolean isConfigured() {
        return "true".equalsIgnoreCase(this.getExtendedProperty("configured"));
    }

    public void setConfigured(boolean configured) {
        if (configured) {
            this.setExtendedProperty("configured", "true");
        } else {
            this.removeExtendedProperty("configured");
        }
    }

    public void setServiceComponent(boolean isServiceComponent) {
        this.put(ISSERVICECOMPONENT, isServiceComponent);
    }

    public boolean isServiceComponent() {
        return this.getBoolean(ISSERVICECOMPONENT);
    }

    public String getComponentMetaDataPK() {
        if (this.componentMetaDataPK == null) {
            this.componentMetaDataPK = this.getString(COMPONENTMETADATAPK);
        }
        return this.componentMetaDataPK;
    }

    public void setComponentMetaDataPK(String componentMetaDataPK) {
        this.componentMetaDataPK = componentMetaDataPK;
        this.setString(COMPONENTMETADATAPK, componentMetaDataPK);
    }

    public WebEventCollection getWebEvents() {
        Object obj = this.get(WEBEVENTS);
        if (obj == null) {
            WebEventCollection webEvents = new WebEventCollection();
            this.put(WEBEVENTS, webEvents);
            return webEvents;
        }
        return (WebEventCollection)obj;
    }

    public void setWebEvents(WebEventCollection webEvents) {
        this.put(WEBEVENTS, webEvents);
    }

    @Override
    public String toString() {
        return this.getName();
    }
}

