/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.ui;

import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.ui.AbstractUIObjectInfo;
import com.kingdee.bos.metadata.ui.ActionCollection;
import com.kingdee.bos.metadata.ui.ActionInfo;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.DataObjectCollection;
import com.kingdee.bos.metadata.ui.DataObjectInfo;
import com.kingdee.bos.metadata.ui.EventBindingCollection;
import com.kingdee.bos.metadata.ui.EventBindingInfo;
import com.kingdee.bos.metadata.ui.LayoutInfo;
import com.kingdee.bos.metadata.ui.PropertyBindingCollection;
import com.kingdee.bos.metadata.ui.PropertyBindingInfo;
import com.kingdee.bos.metadata.ui.PropertyCollection;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.metadata.ui.StatusCollection;
import com.kingdee.bos.metadata.ui.StatusInfo;
import com.kingdee.bos.metadata.ui.StatusItemCollection;
import com.kingdee.bos.metadata.ui.StatusItemInfo;
import com.kingdee.bos.metadata.ui.UIControlOrderHelper;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.metadata.util.UIUtils;
import com.kingdee.bos.metadata.webui.WebUIObjectInfo;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import org.apache.log4j.Logger;

public class UIObjectAssembler {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.metadata.ui.UIObjectAssembler");

    public static UIObjectInfo parseUI(Context ctx, UIObjectInfo completeModel) {
        return (UIObjectInfo)UIObjectAssembler.parseUI0(ctx, completeModel);
    }

    public static WebUIObjectInfo parseUI(Context ctx, WebUIObjectInfo completeModel) {
        return (WebUIObjectInfo)UIObjectAssembler.parseUI0(ctx, completeModel);
    }

    private static AbstractUIObjectInfo parseUI0(Context ctx, AbstractUIObjectInfo completeModel) {
        UIObjectAssembler.compatibleHandleComponentTree(completeModel);
        if (UIUtils.getParent(completeModel) == null) {
            return completeModel;
        }
        long startTime = System.currentTimeMillis();
        AbstractUIObjectInfo resultModel = null;
        if (completeModel instanceof UIObjectInfo) {
            resultModel = new UIObjectInfo();
        } else if (completeModel instanceof WebUIObjectInfo) {
            resultModel = new WebUIObjectInfo();
        }
        UIObjectAssembler.initUIInfo(completeModel, resultModel);
        resultModel.setComponents(UIObjectAssembler.parseComposites(completeModel.getComponents()));
        resultModel.setActions(UIObjectAssembler.parseActions(completeModel.getActions()));
        resultModel.setDataObjects(UIObjectAssembler.parseDataObjects(completeModel.getDataObjects()));
        resultModel.setStatuses(UIObjectAssembler.parseStatuses(completeModel.getStatuses()));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u89e3\u6790UI\u5171\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startTime)));
        }
        resultModel.put("Resource_Last_Modified", completeModel.get("Resource_Last_Modified"));
        return resultModel;
    }

    private static void compatibleHandleComponentTree(AbstractUIObjectInfo completeModel) {
        ComponentCollection collections = completeModel.getComponents();
        if (collections == null || collections.size() == 0) {
            return;
        }
        Iterator iter = collections.iterator();
        ComponentInfo info = null;
        LinkedList<ComponentInfo> list = new LinkedList<ComponentInfo>();
        while (iter.hasNext()) {
            info = (ComponentInfo)iter.next();
            list.add(info);
        }
        if (list.isEmpty()) {
            return;
        }
        iter = list.iterator();
        while (iter.hasNext()) {
            UIObjectAssembler.compatibleHandleComponentTree(completeModel, (ComponentInfo)iter.next());
        }
    }

    private static void compatibleHandleComponentTree(AbstractUIObjectInfo completeModel, ComponentInfo parentInfo) {
        if (parentInfo == null) {
            return;
        }
        ComponentCollection collections = parentInfo.getComponents();
        if (collections == null || collections.size() == 0) {
            return;
        }
        Iterator iter = collections.iterator();
        ComponentInfo info = null;
        while (iter.hasNext()) {
            info = (ComponentInfo)iter.next();
            if (completeModel.containsComponentInfo(info)) continue;
            completeModel.getComponents().add(info);
            UIObjectAssembler.compatibleHandleComponentTree(completeModel, info);
        }
    }

    public static StatusCollection getAllStatus(Context ctx, UIObjectInfo originalModel) {
        return UIStatusNameAssemble.getAllStatus(ctx, originalModel);
    }

    public static UIObjectInfo assembleUI(Context ctx, UIObjectInfo originalModel) {
        return UIObjectAssembler.assembleUI(ctx, originalModel, false);
    }

    private static void preAssembleComposite(ComponentCollection completeModel, ComponentCollection currentModel) {
        assert (currentModel != null && completeModel != null);
        Iterator iter = currentModel.iterator();
        ComponentInfo currentComponent = null;
        ComponentInfo completeComponent = null;
        Object tempComponent = null;
        Object tempParent = null;
        while (iter.hasNext()) {
            currentComponent = (ComponentInfo)iter.next();
            completeComponent = completeModel.getComponentInfo(currentComponent.getName());
            if (completeComponent != null) continue;
            completeModel.add((ComponentInfo)currentComponent.clone());
        }
    }

    public static UIObjectInfo assembleUI(Context ctx, UIObjectInfo originalModel, boolean needCompositePropBinding) {
        int i;
        long startTime = System.currentTimeMillis();
        if (originalModel == null) {
            logger.warn((Object)"The second argument originalModel is null");
            return null;
        }
        if (originalModel.isAssembled()) {
            return originalModel;
        }
        if (originalModel.getParent() == null) {
            UIObjectAssembler.handleParentChildRelation(originalModel);
            UIControlOrderHelper.getInstance().orderUIControl(originalModel);
            originalModel.setAssembled(true);
            return originalModel;
        }
        UIObjectInfo originalModelClone = (UIObjectInfo)originalModel.clone();
        UIObjectInfo parent = null;
        UIObjectInfo child = originalModelClone;
        UIObjectInfo completeModel = new UIObjectInfo();
        UIObjectAssembler.initUIInfo(originalModelClone, completeModel);
        ArrayList<UIObjectInfo> parentUIList = new ArrayList<UIObjectInfo>();
        while ((parent = child.getParent()) != null) {
            parentUIList.add(parent);
            child = parent;
        }
        for (i = parentUIList.size() - 1; i >= 0; --i) {
            UIObjectAssembler.preAssembleComposite(completeModel.getComponents(), ((UIObjectInfo)parentUIList.get(i)).getComponents());
        }
        for (i = parentUIList.size() - 1; i >= 0; --i) {
            UIObjectAssembler.assembleParentUI(completeModel, (UIObjectInfo)parentUIList.get(i), needCompositePropBinding);
        }
        UIObjectAssembler.setHeritedPropty(completeModel, true);
        UIObjectAssembler.setOverridePropty(originalModelClone, true);
        UIObjectAssembler.assembleParentUI(completeModel, originalModelClone, needCompositePropBinding);
        UIObjectAssembler.handleParentChildRelation(completeModel);
        UIControlOrderHelper.getInstance().orderUIControl(completeModel);
        UIObjectAssembler.handleTolerantDefault(completeModel);
        completeModel.setAssembled(true);
        completeModel.put("Resource_Last_Modified", originalModel.get("Resource_Last_Modified"));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u88c5\u914dUI\u5171\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startTime)));
        }
        return completeModel;
    }

    private static void assembleParentUI(UIObjectInfo completeModel, UIObjectInfo parentModel, boolean needCompositePropBinding) {
        UIObjectAssembler.assembleComposite(completeModel.getComponents(), parentModel.getComponents(), needCompositePropBinding);
        UIObjectAssembler.assembleDataObjects(completeModel.getDataObjects(), parentModel.getDataObjects());
        UIObjectAssembler.assembleActions(completeModel.getActions(), parentModel.getActions());
        UIObjectAssembler.assembleStatuses(completeModel.getStatuses(), parentModel.getStatuses());
    }

    private static void assembleComposite(ComponentCollection completeModel, ComponentCollection currentModel, boolean needCompositePropBinding) {
        assert (currentModel != null && completeModel != null);
        Iterator iter = currentModel.iterator();
        ComponentInfo currentComponent = null;
        ComponentInfo completeComponent = null;
        ComponentInfo tempComponent = null;
        ComponentInfo tempParent = null;
        while (iter.hasNext()) {
            Locale[] locales;
            String alias;
            LayoutInfo layoutInfo;
            int tabIndex;
            Object constraint;
            currentComponent = (ComponentInfo)iter.next();
            completeComponent = completeModel.getComponentInfo(currentComponent.getName());
            if (completeComponent == null) {
                completeModel.add(currentComponent);
                continue;
            }
            tempComponent = currentComponent.getParent();
            if (tempComponent != null) {
                tempParent = completeModel.getComponentInfo(tempComponent.getName());
                if (tempParent == null) {
                    tempParent = currentModel.getComponentInfo(tempComponent.getName());
                }
                completeComponent.setParent(tempParent);
                completeComponent.setOverrideParent(currentComponent.isOverrideParent());
            }
            if (!((constraint = currentComponent._getConstraint()) == null || constraint instanceof String && StringUtils.isEmpty((String)((String)constraint)))) {
                completeComponent.setConstraint(constraint, false);
                completeComponent.setOverrideConstraint(currentComponent.isOverrideConstraint());
            }
            if ((tabIndex = currentComponent.getTabIndex()) > 0) {
                completeComponent.setTabIndex(tabIndex);
                completeComponent.setOverrideTabIndex(currentComponent.isOverrideTabIndex());
            }
            if ((layoutInfo = currentComponent.getLayoutInfo()) != null) {
                completeComponent.setLayoutInfo(layoutInfo);
            }
            if (!StringUtils.isEmpty((String)(alias = currentComponent.getAlias()))) {
                completeComponent.setAlias(alias);
            }
            if ((locales = BOSLocaleUtil.getSupportedOriginLocales()) != null) {
                for (Locale locale : locales) {
                    alias = currentComponent.getAlias(locale);
                    if (StringUtils.isEmpty((String)alias)) continue;
                    completeComponent.setAlias(alias, locale);
                }
            }
            PropertyCollection childComponentProperties = currentComponent.getProperties();
            for (int j = 0; j < childComponentProperties.size(); ++j) {
                PropertyInfo currentComponentProp = childComponentProperties.get(j);
                PropertyInfo completeComponentProp = completeComponent.getProperties().get(currentComponentProp.getName());
                if (completeComponentProp == null) {
                    completeComponent.getProperties().add(currentComponentProp);
                    continue;
                }
                completeComponentProp.setOverride(currentComponentProp.isOverride());
                completeComponentProp.setValue(currentComponentProp.getValue());
                if (!currentComponentProp.isMultiLanguage() || locales == null) continue;
                for (Locale locale : locales) {
                    completeComponentProp.setValue(currentComponentProp.getValue(locale), locale);
                }
            }
            PropertyBindingCollection currentComponentPropertyBindings = currentComponent.getPropertyBindings();
            for (int j = 0; j < currentComponentPropertyBindings.size(); ++j) {
                PropertyBindingInfo currentPBInfo = currentComponentPropertyBindings.get(j);
                PropertyBindingInfo completePBInfo = (PropertyBindingInfo)completeComponent.getPropertyBindings().getObject(currentPBInfo.getPropertyName());
                if (completePBInfo == null) {
                    completeComponent.getPropertyBindings().add(currentPBInfo);
                    continue;
                }
                completePBInfo.setOverride(currentPBInfo.isOverride());
                completePBInfo.setBindingObject(currentPBInfo.getBindingObject());
                completePBInfo.setBingdingField(currentPBInfo.getBingdingField());
            }
            EventBindingCollection currentEventBindings = currentComponent.getEventBindings();
            for (int j = 0; j < currentEventBindings.size(); ++j) {
                EventBindingInfo currentEBInfo = currentEventBindings.get(j);
                EventBindingInfo completeEBInfo = (EventBindingInfo)completeComponent.getEventBindings().getObject(currentEBInfo.getEventName());
                if (completeEBInfo == null) {
                    completeComponent.getEventBindings().add(currentEBInfo);
                    continue;
                }
                completeEBInfo.setCode(currentEBInfo.getCode());
                completeEBInfo.setOverride(currentEBInfo.isOverride());
            }
            completeComponent.setRules(currentComponent.getRules());
            Map extendMap = currentComponent.getExtendedProperties();
            Iterator iterator = extendMap.keySet().iterator();
            while (iterator.hasNext()) {
                String key = iterator.next().toString();
                completeComponent.setExtendedProperty(key, (String)extendMap.get(key));
            }
        }
    }

    private static void assembleDataObjects(DataObjectCollection completeModel, DataObjectCollection currentModel) {
        assert (completeModel != null && currentModel != null);
        Iterator iter = currentModel.iterator();
        DataObjectInfo currentDataObjInfo = null;
        DataObjectInfo completeDataObjInfo = null;
        while (iter.hasNext()) {
            currentDataObjInfo = (DataObjectInfo)iter.next();
            completeDataObjInfo = completeModel.getDataObject(currentDataObjInfo.getName());
            if (completeDataObjInfo == null) {
                completeModel.add((DataObjectInfo)currentDataObjInfo.clone());
                continue;
            }
            completeDataObjInfo.setOverride(currentDataObjInfo.isOverride());
            completeDataObjInfo.setType(currentDataObjInfo.getType());
            completeDataObjInfo.setDescription(currentDataObjInfo.getDescription());
            Locale[] locales = BOSLocaleUtil.getSupportedOriginLocales();
            if (locales == null) continue;
            for (Locale locale : locales) {
                completeDataObjInfo.setDescription(currentDataObjInfo.getDescription());
            }
        }
    }

    private static void assembleActions(ActionCollection completeModel, ActionCollection currentModel) {
        assert (completeModel != null && currentModel != null);
        Iterator iter = currentModel.iterator();
        ActionInfo currentInfo = null;
        ActionInfo completeInfo = null;
        while (iter.hasNext()) {
            currentInfo = (ActionInfo)iter.next();
            completeInfo = completeModel.getActionByName(currentInfo.getName());
            if (completeInfo == null) {
                completeModel.add(currentInfo);
                continue;
            }
            completeInfo.setAcceleratorKey(currentInfo.getAcceleratorKey());
            completeInfo.setActionCommandKey(currentInfo.getActionCommandKey());
            completeInfo.setActionExtendProperty(currentInfo.getActionExtendProperty());
            completeInfo.setActionPerformed(currentInfo.getActionPerformed());
            completeInfo.setBeforeActionPerformed(currentInfo.getBeforeActionPerformed());
            completeInfo.setAfterActionPerformed(currentInfo.getAfterActionPerformed());
            completeInfo.setFinallyActionPerformed(currentInfo.getFinallyActionPerformed());
            completeInfo.setMnemonicKey(currentInfo.getMnemonicKey());
            completeInfo.setServices(currentInfo.getServices());
            completeInfo.setBindWorkFlow(currentInfo.isBindWorkFlow());
            completeInfo.setDaemonRun(currentInfo.isDaemonRun());
            completeInfo.setEnabled(currentInfo.isEnabled());
            completeInfo.setOverride(currentInfo.isOverride());
            completeInfo.setOprtIntent(currentInfo.getOprtIntent());
            completeInfo.setNextUI(currentInfo.getNextUI());
            completeInfo.setUIPNavigator(currentInfo.isUIPNavigator());
            completeInfo.setBatchAction(currentInfo.isBatchAction());
            completeInfo.setEntryAction(currentInfo.isEntryAction());
            completeInfo.setBatchMethodName(currentInfo.getBatchMethodName());
            completeInfo.setControlName(currentInfo.getControlName());
            completeInfo.setShortDesc(currentInfo.getShortDesc());
            completeInfo.setLongDesc(currentInfo.getLongDesc());
            completeInfo.setSmallIcon(currentInfo.getSmallIcon());
            Locale[] locales = BOSLocaleUtil.getSupportedOriginLocales();
            if (locales != null) {
                for (Locale locale : locales) {
                    completeInfo.setControlName(currentInfo.getControlName(locale), locale);
                    completeInfo.setShortDesc(currentInfo.getShortDesc(locale), locale);
                    completeInfo.setLongDesc(currentInfo.getLongDesc(locale), locale);
                    completeInfo.setSmallIcon(currentInfo.getSmallIcon(locale), locale);
                }
            }
            completeInfo.setRules(currentInfo.getRules());
        }
    }

    private static void assembleStatuses(StatusCollection completeModel, StatusCollection currentModel) {
        assert (completeModel != null && currentModel != null);
        Iterator iter = currentModel.iterator();
        Iterator itemIter = null;
        StatusInfo currentInfo = null;
        StatusInfo completeInfo = null;
        StatusItemInfo currentItem = null;
        StatusItemInfo completeItem = null;
        StatusItemCollection currentItems = null;
        StatusItemCollection completeItems = null;
        Object localeIter = null;
        while (iter.hasNext()) {
            currentInfo = (StatusInfo)iter.next();
            completeInfo = completeModel.getStatusByName(currentInfo.getName());
            if (completeInfo == null) {
                completeModel.add(currentInfo);
                continue;
            }
            completeInfo.setAlias(currentInfo.getAlias());
            completeInfo.setDescription(currentInfo.getDescription());
            Locale[] locales = BOSLocaleUtil.getSupportedOriginLocales();
            if (locales != null) {
                for (Locale locale : locales) {
                    completeInfo.setAlias(currentInfo.getAlias(locale), locale);
                    completeInfo.setDescription(currentInfo.getDescription(locale), locale);
                }
            }
            currentItems = currentInfo.getStatusItems();
            completeItems = completeInfo.getStatusItems();
            itemIter = currentItems.iterator();
            while (itemIter.hasNext()) {
                currentItem = (StatusItemInfo)itemIter.next();
                completeItem = completeItems.get(currentItem.getName());
                if (completeItem == null) {
                    completeItems.add(currentItem);
                    continue;
                }
                completeItem.setOverride(currentItem.isOverride());
                completeItem.setEnabled(currentItem.getEnabled());
                completeItem.setVisible(currentItem.getVisible());
            }
        }
    }

    private static void setHeritedPropty(UIObjectInfo model, boolean isHerited) {
        ComponentCollection components = model.getComponents();
        Iterator iter = components.iterator();
        Iterator pbIter = null;
        Iterator ebIter = null;
        ComponentInfo component = null;
        EventBindingInfo ebInfo = null;
        while (iter.hasNext()) {
            component = (ComponentInfo)iter.next();
            component.setHerited(isHerited);
            component.setAllHeritedProperties((PropertyCollection)component.getProperties().clone());
            PropertyBindingCollection propBindings = component.getPropertyBindings();
            pbIter = propBindings.iterator();
            while (pbIter.hasNext()) {
                ((PropertyBindingInfo)pbIter.next()).setHerited(isHerited);
            }
            EventBindingCollection eventBindings = component.getEventBindings();
            ebIter = eventBindings.iterator();
            while (ebIter.hasNext()) {
                ebInfo = (EventBindingInfo)ebIter.next();
                ebInfo.setHerited(isHerited);
                ebInfo.setCode("");
            }
        }
        iter = model.getDataObjects().iterator();
        while (iter.hasNext()) {
            ((DataObjectInfo)iter.next()).setHerited(isHerited);
        }
        iter = model.getActions().iterator();
        while (iter.hasNext()) {
            ((ActionInfo)iter.next()).setHerited(isHerited);
        }
        iter = model.getStatuses().iterator();
        StatusInfo status = null;
        while (iter.hasNext()) {
            status = (StatusInfo)iter.next();
            status.setHerited(isHerited);
            pbIter = status.getStatusItems().iterator();
            while (pbIter.hasNext()) {
                ((StatusItemInfo)pbIter.next()).setHerited(isHerited);
            }
        }
    }

    private static void setOverridePropty(UIObjectInfo model, boolean isOverride) {
        ComponentCollection components = model.getComponents();
        Iterator iter = components.iterator();
        Iterator pbIter = null;
        ComponentInfo component = null;
        EventBindingInfo ebInfo = null;
        while (iter.hasNext()) {
            component = (ComponentInfo)iter.next();
            if (component._getConstraint() != null) {
                component.setOverrideConstraint(isOverride);
            }
            if (component.getParent() != null && !StringUtils.isEmpty((String)component.getParent().getName())) {
                component.setOverrideParent(isOverride);
            }
            if (component.getTabIndex() > 0) {
                component.setOverrideTabIndex(isOverride);
            }
            if (component.getLayoutInfo() != null) {
                component.getLayoutInfo().setOverride(isOverride);
            }
            PropertyCollection props = component.getProperties();
            pbIter = props.iterator();
            while (pbIter.hasNext()) {
                ((PropertyInfo)pbIter.next()).setOverride(isOverride);
            }
            PropertyBindingCollection propBindings = component.getPropertyBindings();
            pbIter = propBindings.iterator();
            while (pbIter.hasNext()) {
                ((PropertyBindingInfo)pbIter.next()).setOverride(isOverride);
            }
            EventBindingCollection eventBindings = component.getEventBindings();
            pbIter = eventBindings.iterator();
            while (pbIter.hasNext()) {
                ebInfo = (EventBindingInfo)pbIter.next();
                ebInfo.setOverride(isOverride);
            }
        }
        iter = model.getDataObjects().iterator();
        while (iter.hasNext()) {
            ((DataObjectInfo)iter.next()).setOverride(isOverride);
        }
        iter = model.getActions().iterator();
        while (iter.hasNext()) {
            ((ActionInfo)iter.next()).setOverride(isOverride);
        }
        iter = model.getStatuses().iterator();
        StatusInfo status = null;
        while (iter.hasNext()) {
            status = (StatusInfo)iter.next();
            status.setOverride(isOverride);
            pbIter = status.getStatusItems().iterator();
            while (pbIter.hasNext()) {
                ((StatusItemInfo)pbIter.next()).setOverride(isOverride);
            }
        }
    }

    private static void handleParentChildRelation(UIObjectInfo model) {
        ComponentCollection components = model.getComponents();
        Iterator iter = components.iterator();
        ComponentInfo component = null;
        ComponentInfo parentComponent = null;
        String parentName = null;
        while (iter.hasNext()) {
            component = (ComponentInfo)iter.next();
            if (component.getParent() == null || StringUtils.isEmpty((String)(parentName = component.getParent().getName())) || (parentComponent = components.getComponentInfo(parentName)) == null) continue;
            component.setParent(parentComponent);
            parentComponent.getComponents().add(component);
        }
    }

    private static void initUIInfo(AbstractUIObjectInfo sourceModel, AbstractUIObjectInfo targetModel) {
        targetModel.setPKField(sourceModel.getPKField());
        targetModel.setName(sourceModel.getName());
        targetModel.setPackage(sourceModel.getPackage());
        UIUtils.setParent(targetModel, UIUtils.getParent(sourceModel));
        targetModel.setParentFullName(sourceModel.getParentFullName());
        targetModel.setReleaseClass(sourceModel.getReleaseClass());
        targetModel.setReleasePackage(sourceModel.getReleasePackage());
        targetModel.setDefaultButton(sourceModel.getDefaultButton());
        targetModel.setAlias(sourceModel.getAlias());
        targetModel.setDescription(sourceModel.getDescription());
        targetModel.setTitle(sourceModel.getTitle());
        Locale[] locales = BOSLocaleUtil.getSupportedOriginLocales();
        if (locales != null) {
            for (Locale locale : locales) {
                targetModel.setAlias(sourceModel.getAlias(locale), locale);
                targetModel.setDescription(sourceModel.getDescription(locale), locale);
                targetModel.setTitle(sourceModel.getTitle(locale), locale);
            }
        }
        targetModel.setRuleSet(sourceModel.getRuleSet());
        UIObjectAssembler.copyExtendedProperties(sourceModel, targetModel);
        targetModel.setBizUnitPK(sourceModel.getBizUnitPK());
        targetModel.setUserDefined(sourceModel.isUserDefined());
    }

    private static void copyExtendedProperties(IObjectValue srcObj, IObjectValue desObj) {
        if (srcObj == null || desObj == null) {
            return;
        }
        Map extProps = srcObj.getExtendedProperties();
        for (Object key : extProps.keySet()) {
            desObj.getExtendedProperties().put(key, extProps.get(key));
        }
    }

    private static ComponentCollection parseComposites(ComponentCollection completeModel) {
        assert (completeModel != null);
        ComponentCollection resultModel = new ComponentCollection();
        Iterator iter = completeModel.iterator();
        ComponentInfo tempComponent = null;
        while (iter.hasNext()) {
            tempComponent = UIObjectAssembler.parseComponent((ComponentInfo)iter.next());
            if (tempComponent == null) continue;
            resultModel.add(tempComponent);
        }
        return resultModel;
    }

    private static DataObjectCollection parseDataObjects(DataObjectCollection completeModel) {
        assert (completeModel != null);
        DataObjectCollection resultModel = new DataObjectCollection();
        Iterator iter = completeModel.iterator();
        DataObjectInfo sourceInfo = null;
        while (iter.hasNext()) {
            sourceInfo = (DataObjectInfo)iter.next();
            if (sourceInfo.isHerited() && !sourceInfo.isOverride()) continue;
            resultModel.add(sourceInfo);
        }
        return resultModel;
    }

    private static StatusCollection parseStatuses(StatusCollection completeModel) {
        assert (completeModel != null);
        StatusCollection resultModel = new StatusCollection();
        Iterator iter = completeModel.iterator();
        Object localeIter = null;
        Iterator itemIter = null;
        StatusInfo sourceStatus = null;
        StatusInfo targetStatus = null;
        StatusItemInfo sourceItem = null;
        StatusItemCollection targetStatusItems = null;
        boolean isOverride = false;
        while (iter.hasNext()) {
            sourceStatus = (StatusInfo)iter.next();
            if (!sourceStatus.isHerited()) {
                resultModel.add(sourceStatus);
                continue;
            }
            targetStatus = new StatusInfo();
            targetStatus.setName(sourceStatus.getName());
            targetStatus.setAlias(sourceStatus.getAlias());
            targetStatus.setDescription(sourceStatus.getDescription());
            Locale[] locales = BOSLocaleUtil.getSupportedOriginLocales();
            if (locales != null) {
                for (Locale locale : locales) {
                    targetStatus.setAlias(sourceStatus.getAlias(locale), locale);
                    targetStatus.setDescription(sourceStatus.getDescription(locale), locale);
                }
            }
            itemIter = sourceStatus.getStatusItems().iterator();
            targetStatusItems = new StatusItemCollection();
            while (itemIter.hasNext()) {
                sourceItem = (StatusItemInfo)itemIter.next();
                if (sourceItem.isHerited() && !sourceItem.isOverride()) continue;
                targetStatusItems.add(sourceItem);
                isOverride = true;
            }
            if (!isOverride) continue;
            targetStatus.setStatusItems(targetStatusItems);
            resultModel.add(targetStatus);
        }
        return resultModel;
    }

    private static ActionCollection parseActions(ActionCollection completeModel) {
        assert (completeModel != null);
        ActionCollection resultModel = new ActionCollection();
        Iterator iter = completeModel.iterator();
        ActionInfo sourceInfo = null;
        while (iter.hasNext()) {
            sourceInfo = (ActionInfo)iter.next();
            sourceInfo.setBeforeActionPerformed(sourceInfo.getBeforeAction().getCode());
            sourceInfo.setAfterActionPerformed(sourceInfo.getAfterAction().getCode());
            sourceInfo.setFinallyActionPerformed(sourceInfo.getFinallyAction().getCode());
            if (sourceInfo.isHerited() && !sourceInfo.isOverride()) continue;
            resultModel.add(sourceInfo);
        }
        return resultModel;
    }

    private static void initComponent(ComponentInfo sourceModel, ComponentInfo targetModel) {
        assert (sourceModel != null && targetModel != null);
        targetModel.setName(sourceModel.getName());
        targetModel.setContainer(sourceModel.isContainer());
        targetModel.setClassType(sourceModel.getClassType());
        targetModel.setRules(sourceModel.getRules());
        targetModel.setUserDefined(sourceModel.isUserDefined());
    }

    private static ComponentInfo parseComponent(ComponentInfo completeModel) {
        Object tempConstraint;
        LayoutInfo layoutInfo;
        assert (completeModel != null);
        if (!completeModel.isHerited()) {
            return completeModel;
        }
        ComponentInfo resultModel = new ComponentInfo();
        boolean isOverride = false;
        UIObjectAssembler.initComponent(completeModel, resultModel);
        if (completeModel.isOverrideParent() && completeModel.getParent() != null) {
            resultModel.setParent(completeModel.getParent());
            isOverride = true;
        }
        if ((layoutInfo = completeModel.getLayoutInfo()) != null && layoutInfo.isOverride()) {
            resultModel.setLayoutInfo(layoutInfo);
            isOverride = true;
        }
        if (completeModel.isOverrideConstraint() && (tempConstraint = completeModel.getConstraint()) != null) {
            resultModel.setConstraint(tempConstraint, false);
            isOverride = true;
        }
        if (completeModel.isOverrideTabIndex()) {
            resultModel.setTabIndex(completeModel.getTabIndex());
            isOverride = true;
        }
        Iterator iter = completeModel.getProperties().iterator();
        PropertyInfo sourceProp = null;
        PropertyCollection resultProps = resultModel.getProperties();
        while (iter.hasNext()) {
            sourceProp = (PropertyInfo)iter.next();
            if (!sourceProp.isOverride() && !sourceProp.getName().equalsIgnoreCase("visible") && !sourceProp.getName().equalsIgnoreCase("enabled") && !sourceProp.getName().equalsIgnoreCase("required")) continue;
            resultProps.add(sourceProp);
            isOverride = true;
        }
        iter = completeModel.getPropertyBindings().iterator();
        PropertyBindingInfo sourcePropBinding = null;
        PropertyBindingCollection resultPBs = resultModel.getPropertyBindings();
        while (iter.hasNext()) {
            sourcePropBinding = (PropertyBindingInfo)iter.next();
            if (sourcePropBinding.isHerited() && !sourcePropBinding.isOverride()) continue;
            resultPBs.add(sourcePropBinding);
            isOverride = true;
        }
        iter = completeModel.getEventBindings().iterator();
        EventBindingInfo sourceEB = null;
        EventBindingCollection resultEBs = resultModel.getEventBindings();
        while (iter.hasNext()) {
            sourceEB = (EventBindingInfo)iter.next();
            if (sourceEB.isHerited() && !sourceEB.isOverride()) continue;
            resultEBs.add(sourceEB);
            isOverride = true;
        }
        Map extendMap = completeModel.getExtendedProperties();
        Iterator iterator = extendMap.keySet().iterator();
        while (iterator.hasNext()) {
            String key = iterator.next().toString();
            String value = extendMap.get(key).toString();
            resultModel.setExtendedProperty(key, value);
        }
        if (completeModel.isOverrideRules()) {
            isOverride = true;
        }
        if (isOverride) {
            return resultModel;
        }
        return null;
    }

    private static void handleTolerantDefault(UIObjectInfo completeModel) {
        ComponentInfo tempInfo2 = null;
        String tempStr = null;
        Vector<ComponentInfo> badComps = new Vector<ComponentInfo>();
        Iterator iter = completeModel.getComponents().iterator();
        while (iter.hasNext()) {
            tempInfo2 = (ComponentInfo)iter.next();
            tempStr = tempInfo2.getClassType();
            if (StringUtils.isEmpty((String)tempStr)) {
                badComps.add(tempInfo2);
                continue;
            }
            if (tempInfo2.getParent() != null || "com.kingdee.bos.ctrl.swing.KDPanel".equals(tempStr) || "com.kingdee.bos.ctrl.swing.KDToolBar".equals(tempStr) || "com.kingdee.bos.ctrl.swing.KDMenuBar".equals(tempStr)) continue;
            badComps.add(tempInfo2);
        }
        for (ComponentInfo tempInfo2 : badComps) {
            completeModel.getComponents().remove(tempInfo2);
        }
        badComps.clear();
    }

    private static class UIStatusNameAssemble {
        private UIStatusNameAssemble() {
        }

        private static StatusCollection getAllStatus(Context ctx, UIObjectInfo originalModel) {
            StatusCollection ret = new StatusCollection();
            if (originalModel.isAssembled() || originalModel.getParent() == null) {
                StatusCollection temp = originalModel.getStatuses();
                Iterator iter = temp.iterator();
                while (iter.hasNext()) {
                    ret.add(UIStatusNameAssemble.copySimpleStatusProp((StatusInfo)iter.next()));
                }
                return ret;
            }
            Stack<UIObjectInfo> parentStack = new Stack<UIObjectInfo>();
            UIObjectInfo parent = null;
            UIObjectInfo child = originalModel;
            parentStack.push(child);
            while ((parent = child.getParent()) != null) {
                parentStack.push(parent);
                child = parent;
            }
            while (!parentStack.isEmpty()) {
                UIStatusNameAssemble.assembleStatusesSimpleProp(ret, ((UIObjectInfo)parentStack.pop()).getStatuses());
            }
            return ret;
        }

        private static StatusInfo copySimpleStatusProp(StatusInfo source) {
            Locale[] locales;
            assert (source != null);
            StatusInfo newStatus = new StatusInfo();
            newStatus.setName(source.getName());
            for (Locale locale : locales = BOSLocaleUtil.getSupportedOriginLocales()) {
                newStatus.setAlias(source.getAlias(locale), locale);
                newStatus.setDescription(source.getDescription(locale), locale);
            }
            return newStatus;
        }

        private static void assembleStatusesSimpleProp(StatusCollection target, StatusCollection source) {
            Iterator iter = source.iterator();
            while (iter.hasNext()) {
                Locale[] locales;
                StatusInfo tempSrc = (StatusInfo)iter.next();
                StatusInfo tempTarget = target.getStatusByName(tempSrc.getName());
                if (tempTarget == null) {
                    target.add(UIStatusNameAssemble.copySimpleStatusProp(tempSrc));
                    continue;
                }
                for (Locale locale : locales = BOSLocaleUtil.getSupportedOriginLocales()) {
                    tempTarget.setAlias(tempSrc.getAlias(locale), locale);
                    tempTarget.setDescription(tempSrc.getDescription(locale), locale);
                }
            }
        }
    }
}

