/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.upgrade;

import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.upgrade.LogicalKey;
import com.kingdee.bos.metadata.upgrade.Record;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public class CompareStack {
    private CompareStack parent;
    private final String path;
    private Object ori;
    private Object src;
    private Object dest;
    private List bag;
    private List conflicts;

    public CompareStack(String path) {
        this.path = path;
    }

    public CompareStack(CompareStack parent, String path, boolean resolve) {
        this.parent = parent;
        this.path = path;
        if (resolve) {
            this.resolvePath();
        }
    }

    public CompareStack(CompareStack parent, String path) {
        this(parent, path, false);
    }

    private void resolvePath() {
        if (this.parent != null) {
            if (this.path.matches("\\[.*\\]")) {
                LogicalKey lk = new LogicalKey(this.path);
                IObjectCollection oriColl = (IObjectCollection)this.parent.getOri();
                this.ori = this.findElement(oriColl, lk);
                IObjectCollection srcColl = (IObjectCollection)this.parent.getSrc();
                this.src = this.findElement(srcColl, lk);
                IObjectCollection destColl = (IObjectCollection)this.parent.getDest();
                this.dest = this.findElement(destColl, lk);
            } else {
                this.ori = ((IObjectValue)this.parent.getOri()).get(this.path);
                this.src = ((IObjectValue)this.parent.getSrc()).get(this.path);
                this.dest = ((IObjectValue)this.parent.getDest()).get(this.path);
            }
        }
    }

    private IObjectValue findElement(IObjectCollection coll, LogicalKey lk) {
        int imax = coll.size();
        for (int i = 0; i < imax; ++i) {
            boolean find = true;
            IObjectValue item = coll.getObject(i);
            for (Map.Entry entry : lk.keys.entrySet()) {
                if (entry.getValue().equals(item.get((String)entry.getKey()))) continue;
                find = false;
                break;
            }
            if (!find) continue;
            return item;
        }
        return null;
    }

    private List getBag() {
        if (this.parent == null) {
            if (this.bag == null) {
                this.bag = new ArrayList();
            }
            return this.bag;
        }
        return this.parent.getBag();
    }

    private List getConflictBag() {
        if (this.parent == null) {
            if (this.conflicts == null) {
                this.conflicts = new ArrayList();
            }
            return this.conflicts;
        }
        return this.parent.getConflictBag();
    }

    private CompareStack getTop() {
        return this.isTop() ? this : this.parent.getTop();
    }

    protected Element getElement(Element root) {
        Element pe = root;
        if (this.parent != null) {
            pe = this.parent.getElement(root);
        }
        List childs = pe.getChildren("model");
        int imax = childs.size();
        for (int i = 0; i < imax; ++i) {
            Element child = (Element)childs.get(i);
            if (!child.getAttributeValue("name").equals(this.path)) continue;
            return child;
        }
        Element ele = new Element("model");
        ele.setAttribute("name", this.path);
        pe.addContent(ele);
        return ele;
    }

    public boolean isTop() {
        return this.parent == null;
    }

    public CompareStack getParent() {
        return this.parent;
    }

    public void setModels(Object ori, Object src, Object dest) {
        this.ori = ori;
        this.src = src;
        this.dest = dest;
    }

    public Object getOri() {
        return this.ori;
    }

    public Object getSrc() {
        return this.src;
    }

    public Object getDest() {
        return this.dest;
    }

    public boolean isCollection() {
        return !(this.ori != null && !(this.ori instanceof IObjectCollection) || this.src != null && !(this.src instanceof IObjectCollection) || this.dest != null && !(this.dest instanceof IObjectCollection));
    }

    public boolean isObject() {
        return !(this.ori != null && !(this.ori instanceof IObjectValue) || this.src != null && !(this.src instanceof IObjectValue) || this.dest != null && !(this.dest instanceof IObjectValue));
    }

    public boolean isBasicProperty() {
        return !this.isCollection() && !this.isObject();
    }

    public String getThisPath() {
        return this.path;
    }

    public void recordBasicPropertyAdd(String path) {
        this.getBag().add(new Record(this, 1, path));
    }

    public void recordBasicPropertyAdd(String path, Locale locale) {
        this.getBag().add(new Record(this, 1, path, locale));
    }

    public void recordBasicPropertyModify(String path) {
        this.getBag().add(new Record(this, 2, path));
    }

    public void recordBasicPropertyModify(String path, Locale locale) {
        this.getBag().add(new Record(this, 2, path, locale));
    }

    public void recordBasicPropertyDelete(String path) {
        this.getBag().add(new Record(this, 3, path));
    }

    public void recordBasicPropertyDelete(String path, Locale locale) {
        this.getBag().add(new Record(this, 3, path, locale));
    }

    public void recordObjectAdd(String path) {
        this.getBag().add(new Record(this, 1, path));
    }

    public void recordObjectDelete(String path) {
        this.getBag().add(new Record(this, 3, path));
    }

    public void recordCollectionAdd(String path) {
        this.getBag().add(new Record(this, 7, path));
    }

    public void recordCollectionDelete(String path) {
        this.getBag().add(new Record(this, 9, path));
    }

    public void recordExtendAdd(String extendName) {
        this.getBag().add(new Record(this, 11, 4, extendName));
    }

    public void recordExtendModify(String extendName) {
        this.getBag().add(new Record(this, 11, 5, extendName));
    }

    public void recordExtendDelete(String extendName) {
        this.getBag().add(new Record(this, 11, 6, extendName));
    }

    public boolean hasRecords() {
        return this.getBag().size() != 0;
    }

    public void storeAllRecords(OutputStream os) throws IOException {
        if (this.isTop()) {
            Document doc = new Document();
            Element root = new Element("model");
            doc.setRootElement(root);
            for (Record r : this.getBag()) {
                r.toXML(doc);
            }
            XMLOutputter put = new XMLOutputter("", true);
            put.setIndent("  ");
            put.output(doc, os);
            os.close();
        }
    }

    public boolean hasConflicts() {
        return this.getConflictBag().size() != 0;
    }

    public void storeAllConflicts(OutputStream os) throws IOException {
        if (this.isTop()) {
            Document doc = new Document();
            Element root = new Element("model");
            doc.setRootElement(root);
            for (Record r : this.getConflictBag()) {
                r.toXML(doc);
            }
            XMLOutputter put = new XMLOutputter("", true);
            put.setIndent("  ");
            put.output(doc, os);
            os.close();
        }
    }

    public void conflictBasicPropertyBothAdd(String propName) {
        this.getConflictBag().add(new Record(this, 20, 1, propName));
    }

    public void conflictBasicPropertyBothModify(String propName) {
        this.getConflictBag().add(new Record(this, 20, 2, propName));
    }

    public void conflictBasicPropertyM1Delete(String propName) {
        this.getConflictBag().add(new Record(this, 20, 3, propName));
    }

    public void conflictBasicPropertyBothAdd(String propName, Locale locale) {
        this.getConflictBag().add(new Record(this, 20, 1, propName, locale));
    }

    public void conflictBasicPropertyBothModify(String propName, Locale locale) {
        this.getConflictBag().add(new Record(this, 20, 2, propName, locale));
    }

    public void conflictBasicPropertyM1Delete(String propName, Locale locale) {
        this.getConflictBag().add(new Record(this, 20, 3, propName, locale));
    }

    public void conflictObjectBothAdd(String propName) {
        this.getConflictBag().add(new Record(this, 20, 1, propName));
    }

    public void conflictObjectM1Delete(String propName) {
        this.getConflictBag().add(new Record(this, 20, 3, propName));
    }

    public void conflictObjectBothModify(String propName) {
        this.getConflictBag().add(new Record(this, 20, 2, propName));
    }

    public void conflictObjectM2Delete(String propName) {
        this.getConflictBag().add(new Record(this, 20, 3, propName));
    }

    public void conflictCollectionBothAdd(String path) {
        this.getConflictBag().add(new Record(this, 20, 7, path));
    }

    public void conflictCollectionM2Delete(String path) {
        this.getConflictBag().add(new Record(this, 20, 9, path));
    }

    public void conflictCollectionBothModify(String path) {
        this.getConflictBag().add(new Record(this, 20, 8, path));
    }

    public void conflictCollectionM1Delete(String path) {
        this.getConflictBag().add(new Record(this, 20, 9, path));
    }

    public void conflictExtendBothModify(String key) {
        this.getConflictBag().add(new Record(this, 20, 5, this.path));
    }

    public void conflictExtendBothAdd(String key) {
        this.getConflictBag().add(new Record(this, 20, 4, this.path));
    }

    public void conflictExtendM1Delete(String key) {
        this.getConflictBag().add(new Record(this, 20, 6, this.path));
    }
}

