/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.upgrade;

import com.kingdee.bos.ui.dtp.kdtable.CellInfo;
import com.kingdee.bos.ui.dtp.kdtable.ColumnInfo;
import com.kingdee.bos.ui.dtp.kdtable.HeaderInfo;
import com.kingdee.bos.ui.dtp.kdtable.KDTableDesignerHelper;
import com.kingdee.bos.ui.dtp.kdtable.TableInfo;
import com.kingdee.bos.ui.dtp.kdtable.TableInfoHelper;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class FormatXmlMerger {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.metadata.upgrade.FormatXmlMerger");

    public static String diff2(String xml0, String xmlN) {
        int i;
        TableInfo ti0 = KDTableDesignerHelper.getTableInfoFrom(xml0);
        TableInfo tiN = KDTableDesignerHelper.getTableInfoFrom(xmlN);
        TableInfo result = new TableInfo();
        List colsN = tiN.getColumns();
        for (i = 0; i < tiN.getHeaderCount(); ++i) {
            HeaderInfo hi = new HeaderInfo();
            hi.setParent(result);
            HeaderInfo header = (HeaderInfo)tiN.getHeaders().get(i);
            if (((HeaderInfo)tiN.getHeaders().get(i)).isConfigured()) {
                hi.setConfigured(true);
                hi.setName(header.getName());
                hi.setHeight(header.getHeight());
                hi.setMergeable(header.isMergeable());
                hi.setResizeable(header.isResizeable());
            }
            result.addHeader(hi);
        }
        for (i = 0; i < colsN.size(); ++i) {
            ColumnInfo columnN = (ColumnInfo)colsN.get(i);
            ColumnInfo columnO = FormatXmlMerger.findColumnByName(columnN.getName(), ti0);
            if (columnO == null) {
                if (columnN.getIndex() == -1) {
                    columnN.setIndex(i);
                }
                TableInfoHelper.addColumn(result, tiN, i);
                continue;
            }
            if (!FormatXmlMerger.isChanged(columnO, columnN) && !FormatXmlMerger.isChanged(ti0, tiN, columnN, i)) continue;
            if (columnN.getIndex() == -1) {
                columnN.setIndex(i);
            }
            TableInfoHelper.addColumn(result, tiN, i);
        }
        return KDTableDesignerHelper.getXmlFrom(result);
    }

    private static ColumnInfo findColumnByName(String name, TableInfo table) {
        if (name == null || table == null || table.getColumns() == null) {
            return null;
        }
        ColumnInfo column = null;
        List cols = table.getColumns();
        for (int col = 0; col < cols.size(); ++col) {
            column = (ColumnInfo)cols.get(col);
            if (!name.equals(column.getName())) continue;
            return column;
        }
        return null;
    }

    private static boolean isChanged(ColumnInfo column0, ColumnInfo columnN) {
        if (column0 == null || columnN == null) {
            return false;
        }
        return column0.isHide() != columnN.isHide() || column0.isGroup() != columnN.isGroup() || column0.isLock() != columnN.isLock() || column0.isMergeable() != columnN.isMergeable() || column0.isMoveable() != columnN.isMoveable() || column0.isRequired() != columnN.isRequired() || column0.isResizeable() != columnN.isResizeable() || column0.getWidth() != columnN.getWidth();
    }

    private static boolean isChanged(TableInfo ti0, TableInfo tiN, ColumnInfo columnN, int colNIndex) {
        boolean b = false;
        List head0 = ti0.getHeaders();
        List headN = tiN.getHeaders();
        int col0Index = -1;
        String col0Name = "";
        for (int n = 0; n < ti0.getColumns().size(); ++n) {
            col0Name = ((ColumnInfo)ti0.getColumns().get(n)).getName();
            if (!columnN.getName().equals(col0Name)) continue;
            col0Index = n;
            break;
        }
        if (col0Index >= 0) {
            if (headN.size() != head0.size()) {
                return true;
            }
            for (int i = 0; i < headN.size(); ++i) {
                HeaderInfo h0i = (HeaderInfo)head0.get(i);
                HeaderInfo hNi = (HeaderInfo)headN.get(i);
                ArrayList cells0 = h0i.getCells();
                ArrayList cellsN = hNi.getCells();
                if (cells0 == null || cells0.size() <= col0Index || cellsN == null || cellsN.size() <= colNIndex) continue;
                CellInfo c0 = (CellInfo)cells0.get(col0Index);
                CellInfo cN = (CellInfo)cellsN.get(colNIndex);
                if (c0.getName() != null && c0.getName().equals(cN.getName())) continue;
                b = true;
                break;
            }
        }
        return b;
    }

    public static String merge2(String xml0, String xml1) {
        if (xml0 == null || xml0.length() == 0) {
            return xml1;
        }
        try {
            TableInfo ti0 = KDTableDesignerHelper.getTableInfoFrom(xml0);
            TableInfo ti1 = KDTableDesignerHelper.getTableInfoFrom(xml1);
            List cols1 = ti1.getColumns();
            for (int i = 0; i < cols1.size(); ++i) {
                ColumnInfo column1 = (ColumnInfo)cols1.get(i);
                ColumnInfo column0 = FormatXmlMerger.findColumnByName(column1.getName(), ti0);
                if (column0 == null) {
                    column1.setConfigured(true);
                    TableInfoHelper.addColumn(ti0, ti1, i);
                    continue;
                }
                FormatXmlMerger.copyColumn(column0, column1);
                FormatXmlMerger.copyHeader(ti0, ti1, column0, column1, i);
                logger.warn((Object)("\u884c\u4e1a\u7248\u65b0\u589e\u7684\u4e00\u4e2aKDTable Column\u5728ReBase\u7248\u672c\u4e2d\u4e5f\u65b0\u589e\u540c\u540d\u7684Column. Column=" + column1.getName()));
            }
            if (cols1.size() > 0) {
                ti0.setConfigured(true);
            }
            return KDTableDesignerHelper.getXmlFrom(ti0);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            return xml0;
        }
    }

    private static void copyColumn(ColumnInfo oc, ColumnInfo nc) {
        oc.setHide(nc.isHide());
        oc.setMergeable(nc.isMergeable());
        oc.setMoveable(nc.isMoveable());
        oc.setWidth(nc.getWidth());
        oc.setLock(nc.isLock());
        oc.setGroup(nc.isGroup());
        oc.setRequired(nc.isRequired());
        oc.setResizeable(nc.isResizeable());
        oc.setHorizonAlign(nc.getHorizonAlign());
        oc.setFormatString(nc.getFormatString());
    }

    private static void copyHeader(TableInfo ti0, TableInfo ti1, ColumnInfo column0, ColumnInfo column1, int col1Index) {
        ArrayList head0 = (ArrayList)ti0.getHeaders();
        ArrayList head1 = (ArrayList)ti1.getHeaders();
        int col0Index = -1;
        col0Index = ti0.getColumns().indexOf(column0);
        if (col0Index >= 0) {
            for (int i = 0; i < head1.size(); ++i) {
                HeaderInfo h1i = (HeaderInfo)head1.get(i);
                if (head1.size() > head0.size() && h1i.isConfigured()) {
                    head0.add(i, h1i);
                    continue;
                }
                HeaderInfo h0i = (HeaderInfo)head0.get(i);
                ArrayList cells0 = h0i.getCells();
                ArrayList cells1 = h1i.getCells();
                if (cells0 == null || cells0.size() <= col0Index || cells1 == null || cells1.size() <= col1Index) continue;
                CellInfo c0 = (CellInfo)cells0.get(col0Index);
                CellInfo c1 = (CellInfo)cells1.get(col1Index);
                logger.info((Object)("Header" + i + " " + c0.getName() + " -> " + c1.getName()));
                c0.setName(c1.getName());
            }
        }
    }

    static String merge(Object xml0, Object xml1, Object xmln) throws Exception {
        TableInfo ti0 = KDTableDesignerHelper.getTableInfoFrom((String)xml0);
        TableInfo ti1 = KDTableDesignerHelper.getTableInfoFrom((String)xml1);
        TableInfo tin = KDTableDesignerHelper.getTableInfoFrom((String)xmln);
        List cols0 = ti0.getColumns();
        List cols1 = ti1.getColumns();
        List colsn = tin.getColumns();
        for (int i = 0; i < cols1.size(); ++i) {
            ColumnInfo column1 = (ColumnInfo)cols1.get(i);
            if (FormatXmlMerger.isColumnInList(column1, cols0) || FormatXmlMerger.isColumnInList(column1, colsn)) continue;
            TableInfoHelper.addColumn(tin, ti1, i);
        }
        return KDTableDesignerHelper.getXmlFrom(tin);
    }

    private static boolean isColumnInList(ColumnInfo column, List list) {
        String name = column.getName();
        for (int i = 0; i < list.size(); ++i) {
            ColumnInfo c = (ColumnInfo)list.get(i);
            if (!name.equals(c.getName())) continue;
            return true;
        }
        return false;
    }

    private static boolean isHeaderInList(HeaderInfo header, List list) {
        String name = header.getName();
        for (int i = 0; i < list.size(); ++i) {
            HeaderInfo h = (HeaderInfo)list.get(i);
            if (!name.equals(h.getName())) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) throws Exception {
        String xml0 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> <DocRoot xmlns:c=\"http://www.kingdee.com/Common\" xmlns:f=\"http://www.kingdee.com/Form\" xmlns:t=\"http://www.kingdee.com/Table\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.kingdee.com/KDF KDFSchema.xsd\" version=\"0.0\"><Styles /><Table id=\"KDTable\"><t:Sheet name=\"sheet1\"><t:Table t:selectMode=\"15\" t:mergeMode=\"0\" t:dataRequestMode=\"0\" t:pageRowCount=\"100\"><t:ColumnGroup><t:Column t:key=\"dd\" t:width=\"-1\" t:mergeable=\"true\" t:resizeable=\"true\" t:moveable=\"true\" t:group=\"false\" t:required=\"false\" /><t:Column t:key=\"id\" t:width=\"-1\" t:mergeable=\"true\" t:resizeable=\"true\" t:moveable=\"true\" t:group=\"false\" t:required=\"false\" /></t:ColumnGroup><t:Head><t:Row t:name=\"header\" t:height=\"-1\" t:mergeable=\"true\" t:resizeable=\"true\"><t:Cell>dd</t:Cell><t:Cell>id</t:Cell></t:Row></t:Head></t:Table><t:SheetOptions><t:MergeBlocks><t:Head /></t:MergeBlocks></t:SheetOptions></t:Sheet></Table></DocRoot> ";
        String xml1 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> <DocRoot xmlns:c=\"http://www.kingdee.com/Common\" xmlns:f=\"http://www.kingdee.com/Form\" xmlns:t=\"http://www.kingdee.com/Table\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.kingdee.com/KDF KDFSchema.xsd\" version=\"0.0\"><Styles /><Table id=\"KDTable\"><t:Sheet name=\"sheet1\"><t:Table t:selectMode=\"15\" t:mergeMode=\"0\" t:dataRequestMode=\"0\" t:pageRowCount=\"100\"><t:ColumnGroup><t:Column t:key=\"dd\" t:width=\"-1\" t:mergeable=\"true\" t:resizeable=\"true\" t:moveable=\"true\" t:group=\"false\" t:required=\"false\" /><t:Column t:key=\"id\" t:width=\"-1\" t:mergeable=\"true\" t:resizeable=\"true\" t:moveable=\"true\" t:group=\"false\" t:required=\"false\" /></t:ColumnGroup><t:Head><t:Row t:name=\"header\" t:height=\"-1\" t:mergeable=\"true\" t:resizeable=\"true\"><t:Cell>dd</t:Cell><t:Cell>id</t:Cell></t:Row></t:Head></t:Table><t:SheetOptions><t:MergeBlocks><t:Head /></t:MergeBlocks></t:SheetOptions></t:Sheet></Table></DocRoot> ";
        String xmln = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> <DocRoot xmlns:c=\"http://www.kingdee.com/Common\" xmlns:f=\"http://www.kingdee.com/Form\" xmlns:t=\"http://www.kingdee.com/Table\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.kingdee.com/KDF KDFSchema.xsd\" version=\"0.0\"><Styles /><Table id=\"KDTable\"><t:Sheet name=\"sheet1\"><t:Table t:selectMode=\"15\" t:mergeMode=\"0\" t:dataRequestMode=\"0\" t:pageRowCount=\"100\"><t:ColumnGroup><t:Column t:key=\"dd\" t:width=\"-1\" t:mergeable=\"true\" t:resizeable=\"true\" t:moveable=\"true\" t:group=\"false\" t:required=\"false\" /><t:Column t:key=\"id\" t:width=\"-1\" t:mergeable=\"true\" t:resizeable=\"true\" t:moveable=\"true\" t:group=\"false\" t:required=\"false\" /></t:ColumnGroup><t:Head><t:Row t:name=\"header\" t:height=\"-1\" t:mergeable=\"true\" t:resizeable=\"true\"><t:Cell>dd</t:Cell><t:Cell>id</t:Cell></t:Row></t:Head></t:Table><t:SheetOptions><t:MergeBlocks><t:Head /></t:MergeBlocks></t:SheetOptions></t:Sheet></Table></DocRoot> ";
        String xml = FormatXmlMerger.merge(xml0, xml1, xmln);
        System.out.println("TOXML:\n" + xml);
    }
}

