/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.upgrade;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogicalKey {
    Map keys = new LinkedHashMap(3);

    public LogicalKey(Map keys) {
        this.keys = keys;
    }

    public LogicalKey(String path) {
        Pattern p = Pattern.compile("\\[(.*)\\]");
        Matcher m = p.matcher(path);
        if (m.find()) {
            path = m.group(1);
        }
        String[] nvs = path.split("[,]");
        int imax = nvs.length;
        for (int i = 0; i < imax; ++i) {
            String[] subs = nvs[i].split("[ ]*[=][ ]*");
            assert (subs.length == 2) : "name=value Format error";
            this.keys.put(subs[0], subs[1]);
        }
    }

    public String getPath() {
        StringBuffer buff = new StringBuffer();
        buff.append("[");
        boolean notFirst = false;
        for (Map.Entry entry : this.keys.entrySet()) {
            if (notFirst) {
                buff.append(",");
            } else {
                notFirst = true;
            }
            buff.append(entry.getKey());
            buff.append("=");
            buff.append(entry.getValue());
        }
        buff.append("]");
        return buff.toString();
    }

    public static void main(String[] args) {
        String test = "[name1 =value1,name2= value2]";
        LogicalKey k = new LogicalKey(test);
        System.out.println(k.keys);
        System.out.println("is equals " + Pattern.matches("\\{", "{test}"));
    }
}

