/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.upgrade;

import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.xml.XMLAccessEngine;
import com.kingdee.bos.metadata.upgrade.Solution;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Locale;

public class LogicalKeyUpgrader {
    static Solution slnSrc = null;
    static Context ctxSrc = null;

    private static void usage() {
        System.out.println("-Usage:");
        System.out.println("       meta_dir");
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            LogicalKeyUpgrader.usage();
            return;
        }
        long start = System.currentTimeMillis();
        Locale loc = new Locale("l2");
        ContextUtils.setLocaleToEnv(loc);
        if (args.length == 1) {
            String dir = args[0];
            File srcDir = new File(dir);
            if (!srcDir.isDirectory()) {
                System.out.println("The meta_dir is NOT a directory.");
            }
            ctxSrc = new Context();
            ctxSrc.put((Object)"METADATAPATH", (Object)srcDir.getCanonicalPath());
            slnSrc = new Solution(ctxSrc);
            XMLAccessEngine.getXMLLoader(ctxSrc).getContext().setLocale(loc);
            LogicalKeyUpgrader.upgradeDir();
        }
        System.out.println("Total Time is : " + (System.currentTimeMillis() - start) + " ms");
    }

    private static boolean upgradeDir() throws IOException {
        boolean hasError = false;
        Enumeration e = slnSrc.getEntrys();
        while (e.hasMoreElements()) {
            String entry = (String)e.nextElement();
            if (!entry.endsWith(".query") && !entry.endsWith(".table") && !entry.endsWith(".permission") && !entry.endsWith(".log")) continue;
            try {
                System.out.print("Entry: " + entry + " ... ");
                long oldTimeStamp = slnSrc.getEntryTime(entry);
                IObjectValue model = slnSrc.getObjectValue(entry);
                XMLAccessEngine.store(ctxSrc, model.getBOSType(), model);
                slnSrc.setEntryTime(entry, oldTimeStamp);
                System.out.println("OK!");
            }
            catch (Exception _) {
                System.out.println(">>>>>>>>>>>>>>>>>>>>>>> Error!");
                hasError = true;
            }
        }
        return hasError;
    }
}

