/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.upgrade;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.xml.XMLAccessEngine;
import com.kingdee.bos.metadata.IMetaDataCtrl;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class MetaCtrlFactory {
    protected static final Logger log = Logger.getLogger((String)"com.kingdee.bos.metadata.upgrade.MetaCtrlFactory");
    private Context ctx;
    private Map ctrls = Collections.synchronizedMap(new LimitHashMap(64));
    private static Map ctxMap = Collections.synchronizedMap(new LimitHashMap());

    private MetaCtrlFactory() {
    }

    private MetaCtrlFactory(Context ctx) {
        this();
        this.ctx = ctx;
    }

    public static synchronized MetaCtrlFactory getInstance(Context ctx) {
        MetaCtrlFactory factory = (MetaCtrlFactory)ctxMap.get(ctx);
        if (factory == null) {
            factory = new MetaCtrlFactory(ctx);
            ctxMap.put(ctx, factory);
        }
        return factory;
    }

    public synchronized IMetaDataCtrl getCtrl(BOSObjectType type) {
        if (this.ctx == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"MetaCtrlFactory not inited with Context");
            }
            return null;
        }
        IMetaDataCtrl ctrl = (IMetaDataCtrl)this.ctrls.get(type);
        if (ctrl == null) {
            try {
                ctrl = this.newMetaCtrl(type);
                this.ctrls.put(type, ctrl);
            }
            catch (BOSException e) {
                log.error((Object)"Create MetaDataCtrl error. return null", (Throwable)e);
            }
        }
        return ctrl;
    }

    private IMetaDataCtrl newMetaCtrl(BOSObjectType type) throws BOSException {
        IMetaDataCtrl ctrl = (IMetaDataCtrl)BOSObjectFactory.createBOSObject(this.ctx, type);
        return ctrl;
    }

    public synchronized void clear() {
        this.ctrls.clear();
    }

    public static synchronized void clearCtrls() {
        for (MetaCtrlFactory f : ctxMap.values()) {
            f.clear();
        }
        ctxMap.clear();
    }

    public EntityObjectInfo loadMeta(IObjectValue ov) {
        try {
            return XMLAccessEngine.loadMeta(this.ctx, ov);
        }
        catch (DataAccessException e) {
            log.error((Object)("Load OV[" + ov + "] MetaData error."), (Throwable)((Object)e));
            return null;
        }
    }

    private static class LimitHashMap
    extends LinkedHashMap {
        private static final int DEFALUT_MAX_SIZE = 4;
        private int limit;

        public LimitHashMap() {
            this(4);
        }

        public LimitHashMap(int limit) {
            super(limit, 0.75f, true);
            this.limit = limit;
        }

        protected boolean removeEldestEentry(Map.Entry entry) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("\n\n<<<<<remove Map.Entry[" + entry.getKey() + "]"));
            }
            return this.size() > this.limit;
        }
    }
}

