/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.upgrade;

import com.kingdee.bos.metadata.upgrade.CompareStack;
import com.kingdee.util.LocaleUtils;
import java.util.Locale;
import org.jdom.Document;
import org.jdom.Element;

public class Record {
    public static final int OP_ADD = 1;
    public static final int OP_MODIFY = 2;
    public static final int OP_DELETE = 3;
    public static final int OP_PROP_ADD = 4;
    public static final int OP_PROP_MODIFY = 5;
    public static final int OP_PROP_DELETE = 6;
    public static final int OP_C_ADD = 7;
    public static final int OP_C_MODIFY = 8;
    public static final int OP_C_DELETE = 9;
    public static final int C_EXTEND = 11;
    public static final int C_LOCALE = 12;
    public static final int C_NORMAL = 13;
    public static final int C_CONFLICT = 20;
    int catalog;
    int op;
    CompareStack ctx;
    String target;
    Locale locale;

    protected Record(CompareStack ctx, int c, int op, String ele, Locale locale) {
        this.ctx = ctx;
        this.catalog = c;
        this.op = op;
        this.target = ele;
        this.locale = locale;
    }

    public Record(CompareStack ctx, int op, String ele) {
        this(ctx, 13, op, ele, null);
    }

    public Record(CompareStack ctx, int op, String ele, Locale locale) {
        this(ctx, 12, op, ele, locale);
    }

    public Record(CompareStack ctx, int c, int op, String ele) {
        this(ctx, c, op, ele, null);
    }

    public void toXML(Document doc) {
        this.toXML(doc.getRootElement());
    }

    public void toXML(Element root) {
        Element ele = this.ctx.getElement(root);
        Element ope = new Element(this.opName(this.op));
        ope.setAttribute("name", this.target);
        if (this.catalog == 20) {
            ope.setAttribute("Conflict", "true");
        }
        ele.addContent(ope);
        if (this.locale != null) {
            ope.setAttribute("locale", LocaleUtils.getLocaleString((Locale)this.locale));
        }
    }

    private String opName(int op) {
        switch (op) {
            case 1: {
                return "add";
            }
            case 7: {
                return "add_sub";
            }
            case 3: {
                return "delete";
            }
            case 9: {
                return "delete_sub";
            }
            case 2: {
                return "modify";
            }
            case 8: {
                return "modify_sub";
            }
            case 4: {
                return "add_ext";
            }
            case 5: {
                return "modify_ext";
            }
            case 6: {
                return "delete_ext";
            }
        }
        return "nochange";
    }
}

