/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.upgrade;

import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.xml.Utils;
import com.kingdee.bos.metadata.IMetaDataCtrl;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.InnerMetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.upgrade.EntryFilter;
import com.kingdee.bos.metadata.upgrade.EntryNotFoundException;
import com.kingdee.bos.metadata.upgrade.FileUtil;
import com.kingdee.bos.metadata.upgrade.MetaCtrlFactory;
import com.kingdee.bos.metadata.upgrade.SolutionTravel;
import com.kingdee.bos.metadata.upgrade.Version;
import com.kingdee.bos.util.BOSObjectType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.log4j.Logger;

public class Solution {
    private static final Logger log = Logger.getLogger((String)"com.kingdee.bos.metadata.upgrade.Solution");
    private static final String DEFAULT_SOLUTION_NAME = "eas";
    private final File root;
    private final String name;
    private Context ctx;
    private IMetaDataLoader loader;
    private Locale[] locales;
    private Map ori2nativeIndex;
    private List filters = new ArrayList(3);

    private Solution() {
        this.root = null;
        this.name = null;
        this.ctx = null;
        this.loader = null;
    }

    public Solution(File root) {
        this.root = root;
        this.name = null;
        this.ctx = null;
        this.loader = null;
    }

    public Solution(Context ctx) {
        this.root = new File((String)ctx.get((Object)"METADATAPATH"));
        this.name = ctx.getSolution();
        this.ctx = ctx;
        this.loader = null;
        this.load(false);
    }

    public Solution(String path) {
        this(path, DEFAULT_SOLUTION_NAME);
    }

    public Solution(String path, String name) {
        File file = new File(path);
        if (file.exists()) {
            this.root = file;
            this.name = name;
            this.ctx = new Context(name);
            this.ctx.put((Object)"METADATAPATH", (Object)this.root.getAbsolutePath());
        } else {
            this.root = null;
            this.name = null;
            this.ctx = null;
        }
        this.loader = null;
    }

    public Solution(String path, boolean heavy) {
        this(path, DEFAULT_SOLUTION_NAME, heavy);
    }

    public Solution(String path, String name, boolean heavy) {
        this(path, name);
        this.load(heavy);
    }

    public synchronized IMetaDataLoader getLoader(boolean heavy) {
        if (this.loader == null) {
            this.load(heavy);
        }
        return this.loader;
    }

    public Context getContext() {
        return this.ctx;
    }

    public IMetaDataCtrl getMetaCtrl(String entry) {
        BOSObjectType type = SolutionTravel.getMetaBOSObjectType(entry);
        MetaCtrlFactory factory = MetaCtrlFactory.getInstance(this.ctx);
        return factory.getCtrl(type);
    }

    public Locale getLocale(String oriLocale) {
        return BOSLocaleUtil.getLocale(oriLocale);
    }

    public Locale getLocale(Locale oriLocale) {
        if (this.ori2nativeIndex == null) {
            this.ori2nativeIndex = new HashMap(3);
            LanguageCollection lc = this.getSolutionInfo().getLanguages();
            int imax = lc.size();
            for (int i = 0; i < imax; ++i) {
                this.ori2nativeIndex.put(lc.get(i).getOriginalLocale(), lc.get(i).getLocale());
            }
        }
        return (Locale)this.ori2nativeIndex.get(oriLocale);
    }

    public SolutionInfo getSolutionInfo() {
        return (SolutionInfo)this.getObjectValue(this.getSolutionModelEntry());
    }

    public Version getSolutionVersion() {
        return new Version(this.getSolutionInfo().getVersion());
    }

    protected String getSolutionModelEntry() {
        BOSObjectType solution = MetaDataTypeList.SOLUTION;
        return this.name + Utils.getMetaDataSuffix(solution);
    }

    public IObjectValue getObjectValue(String entry) {
        IMetaDataPK pk = FileUtil.entry2PK(entry);
        IMetaDataCtrl ctrl = this.getMetaCtrl(entry);
        try {
            Method method = ctrl.getClass().getMethod("getValue", IMetaDataPK.class);
            return (IObjectValue)method.invoke((Object)ctrl, pk);
        }
        catch (InvocationTargetException e) {
            log.error((Object)("Get ValueObject for [pk=" + pk + "] invocation error."), e.getTargetException());
            return null;
        }
        catch (Exception e) {
            log.error((Object)("Get ValueObject for [pk=" + pk + "] error."), (Throwable)e);
            return null;
        }
    }

    public EntityObjectInfo loadMeta(IObjectValue ov) {
        MetaCtrlFactory factory = MetaCtrlFactory.getInstance(this.ctx);
        return factory.loadMeta(ov);
    }

    private void load(boolean heavy) {
        this.loader = InnerMetaDataLoaderFactory.getInstance(this.ctx);
    }

    public final File getRoot() {
        return this.root;
    }

    public final boolean isRootInDir() {
        return this.root.isDirectory();
    }

    public final boolean isRootInJar() {
        return this.root.isFile();
    }

    public final boolean canRead() {
        return this.root.canRead();
    }

    public final boolean canWrite() {
        return this.isRootInDir() && this.root.canWrite();
    }

    public InputStream getEntryInputStream(String entry) throws IOException {
        if (this.isRootInJar()) {
            JarFile jar = new JarFile(this.root);
            ZipEntry e = jar.getEntry(entry);
            if (null == e) {
                throw new IOException();
            }
            return jar.getInputStream(e);
        }
        File file = new File(this.root, entry);
        return new FileInputStream(file);
    }

    public OutputStream getEntryOutputStream(String entry) throws IOException {
        if (this.isRootInJar()) {
            throw new IOException();
        }
        File file = new File(this.root, entry);
        FileUtil.createFile(file);
        return new FileOutputStream(file);
    }

    public long getEntryTime(String entry) throws IOException {
        if (this.isRootInJar()) {
            JarFile jar = new JarFile(this.root);
            ZipEntry e = jar.getEntry(entry);
            if (null != e) {
                return e.getTime();
            }
        } else {
            File file = new File(this.root, entry);
            return file.lastModified();
        }
        return -1L;
    }

    public void setEntryTime(String entry, long st) throws IOException {
        if (!this.isRootInJar()) {
            File file = new File(this.root, entry);
            file.setLastModified(st);
        }
    }

    public long getEntrySize(String entry) throws IOException {
        if (this.isRootInJar()) {
            JarFile jar = new JarFile(this.root);
            ZipEntry e = jar.getEntry(entry);
            if (null != e) {
                return e.getSize();
            }
        } else {
            File file = new File(this.root, entry);
            return file.length();
        }
        return -1L;
    }

    public boolean isEntryFile(String entry) throws EntryNotFoundException {
        return !this.isEntryDir(entry);
    }

    public boolean isEntryDir(String entry) throws EntryNotFoundException {
        try {
            if (this.isRootInDir()) {
                File file = new File(this.root, entry);
                return file.isDirectory();
            }
            JarFile jar = new JarFile(this.root);
            ZipEntry e = jar.getEntry(entry);
            if (null == e) {
                throw new EntryNotFoundException();
            }
            return e.isDirectory();
        }
        catch (IOException e) {
            throw new EntryNotFoundException();
        }
    }

    public boolean isEntryExist(String entry) {
        try {
            if (this.isRootInDir()) {
                File file = new File(this.root, entry);
                return file.exists();
            }
            JarFile jar = new JarFile(this.root);
            ZipEntry e = jar.getEntry(entry);
            return null != e;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean isNullSolution() {
        String[] subs;
        return this.isRootInDir() && ((subs = this.root.list()) == null || subs.length == 0);
    }

    public Enumeration getEntrys(final String tree) throws IOException {
        if (this.isRootInJar()) {
            JarFile jar = new JarFile(this.root);
            final Enumeration<JarEntry> zipEntrys = jar.entries();
            return new Enumeration(){
                private String next = null;

                @Override
                public boolean hasMoreElements() {
                    while (zipEntrys.hasMoreElements()) {
                        this.next = ((ZipEntry)zipEntrys.nextElement()).getName();
                        if (this.next.indexOf(tree) == -1 && Solution.this.isIngnoreEntry(this.next)) continue;
                        return true;
                    }
                    return false;
                }

                public Object nextElement() {
                    return this.next;
                }
            };
        }
        return this.getFileTree(this.root, tree);
    }

    public Enumeration getEntrys() throws IOException {
        return this.getEntrys("");
    }

    public int getEntryCounts() throws IOException {
        return this.getEntryCounts("");
    }

    public int getEntryCounts(String tree) throws IOException {
        Enumeration e = this.getEntrys(tree);
        int num = 0;
        while (e.hasMoreElements()) {
            ++num;
            e.nextElement();
        }
        return num;
    }

    private Enumeration getFileTree(File base, String tree) throws IOException {
        Vector l = new Vector(1024, 1024);
        this.getSubFiles(base, tree, l);
        return l.elements();
    }

    private void getSubFiles(File base, String fn, List l) throws IOException {
        File file = new File(base, fn);
        if (file.isDirectory()) {
            File[] childs = file.listFiles();
            int len = childs.length;
            for (int i = 0; i < len; ++i) {
                String en = this.getEntryName(base, childs[i]);
                if (null != en && en.length() > 0) {
                    if (this.isIngnoreEntry(en)) {
                        return;
                    }
                    l.add(en);
                }
                this.getSubFiles(base, en, l);
            }
        }
    }

    protected boolean isIngnoreEntry(String entry) {
        return false;
    }

    public void addEntryFilter(EntryFilter filter) {
        this.filters.add(filter);
    }

    public void removeEntryFilter(EntryFilter filter) {
        this.filters.remove(filter);
    }

    public void clearEntryFilter() {
        this.filters.clear();
    }

    private String getEntryName(File base, File file) throws IOException {
        if (base.equals(file)) {
            return null;
        }
        String baseName = base.getAbsolutePath();
        String fileName = file.getAbsolutePath();
        String name = fileName.substring(baseName.length() + 1);
        if (file.isDirectory()) {
            name = name + File.separator;
        }
        if ('/' != File.separatorChar) {
            name = name.replace(File.separatorChar, '/');
        }
        return name;
    }
}

