/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.upgrade;

import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.xml.Utils;
import com.kingdee.bos.dao.xml.impl.AbstractMDElement;
import com.kingdee.bos.engine.MDSaveException;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.query.JoinCollection;
import com.kingdee.bos.metadata.query.JoinInfo;
import com.kingdee.bos.metadata.query.JoinItemCollection;
import com.kingdee.bos.metadata.query.JoinItemInfo;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.PropertyRefCollection;
import com.kingdee.bos.metadata.query.PropertyRefInfo;
import com.kingdee.bos.metadata.query.PropertyUnitCollection;
import com.kingdee.bos.metadata.query.PropertyUnitInfo;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.EventBindingInfo;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.metadata.upgrade.CompareStack;
import com.kingdee.bos.metadata.upgrade.FormatXmlMerger;
import com.kingdee.bos.metadata.upgrade.LogicalKey;
import com.kingdee.bos.metadata.upgrade.LogicalKeyException;
import com.kingdee.bos.metadata.upgrade.MergeException;
import com.kingdee.bos.metadata.upgrade.WorkSpace;
import com.kingdee.bos.metadata.upgrade.loader.Loader3;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jdom.Element;
import org.jdom.input.DefaultJDOMFactory;
import org.jdom.input.JDOMFactory;

public class SolutionTravel {
    private static final Logger log = Logger.getLogger((String)"com.kingdee.bos.metadata.upgrade.SolutionTravel");
    private Loader3 m0;
    private Loader3 m1;
    private Loader3 m2;
    private Loader3 mn;
    private WorkSpace ws;
    private static final LanguageInfo[] hardcodeLocales;
    private JDOMFactory jdfactory = new DefaultJDOMFactory();
    private Set filter = new HashSet();
    private LanguageInfo[] cls;
    private LanguageInfo[] als;
    private LanguageInfo[] mls;

    public SolutionTravel(WorkSpace ws) {
        this.ws = ws;
        this.m0 = ws.getM0();
        this.m1 = ws.getM1();
        this.m2 = ws.getM2();
        this.mn = ws.getMn();
    }

    public void process(Set needDiff2) throws MergeException {
        try {
            for (String entry : needDiff2) {
                if (entry.endsWith(".mdbview")) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("start ### " + entry));
                }
                if ((this.ws.getMode() & 1) == 1) {
                    try {
                        this.diffEntry(entry);
                    }
                    catch (Throwable t) {
                        log.fatal((Object)("  *****  Diff Entry[" + entry + "] Error!"), t);
                        this.ws.mrWriter.println("fatal," + entry + ",\"" + StringUtils.stackToString((Throwable)t) + "\"");
                    }
                }
                if (SolutionTravel.needReleaseMemory()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"[[MT]] Workspace ready to clear Engine ...");
                    }
                    this.m0.clear();
                    this.m1.clear();
                    this.m2.clear();
                    this.mn.clear();
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("end ### " + entry));
            }
        }
        catch (Exception e) {
            log.error((Object)"[[ERROR]]  Travel Model1 error", (Throwable)e);
        }
    }

    private void addMetaFilter(AbstractMetaDataValue meta) {
        if (null == meta) {
            return;
        }
        String name = meta.getFullName();
        String suffix = Utils.getMetaDataSuffix(meta.getBOSType());
        this.filter.add(name.replaceAll("\\.", "/") + "." + suffix);
    }

    private void addMetaFilter(String pk, BOSObjectType type) {
        if (null == pk || pk.length() == 0) {
            return;
        }
        String suffix = Utils.getMetaDataSuffix(type);
        this.filter.add(pk.replaceAll("\\.", "/") + "." + suffix);
    }

    public void saveSolution(SolutionInfo sin) throws MDSaveException {
        if ((this.ws.getMode() & 2) == 2) {
            this.mn.saveMetadata(sin.getFullName() + Utils.getMetaDataSuffix(MetaDataTypeList.SOLUTION), sin);
        }
    }

    protected void diffEntry(String entry) throws Exception {
        boolean merged = false;
        IObjectValue ele0 = this.wrapThrowable(this.m0, entry, "\u57fa\u7ebf\u5143\u6570\u636e");
        IObjectValue ele1 = this.wrapThrowable(this.m1, entry, "\u5ba2\u6237\u5316\u5143\u6570\u636e");
        IObjectValue elen = this.wrapThrowable(this.m2, entry, "\u65b0\u7248\u672c\u5143\u6570\u636e");
        if (log.isDebugEnabled()) {
            if (ele1 == null || ele0 == null || elen == null) {
                log.debug((Object)"  ERROR  Element in Models can't get.");
                return;
            }
            log.debug((Object)("{{Merge Enrty}}[" + entry + "]"));
        }
        try {
            if (elen instanceof JoinQueryInfo) {
                this.fixJoinQuery((JoinQueryInfo)ele0);
                this.fixJoinQuery((JoinQueryInfo)ele1);
                this.fixJoinQuery((JoinQueryInfo)elen);
            }
        }
        catch (Exception _) {
            // empty catch block
        }
        CompareStack stack = new CompareStack(entry);
        merged = this.diffModelByMeta(entry, ele0, ele1, elen, stack);
        if (merged) {
            if ((this.ws.getMode() & 2) == 2) {
                if ("com.kingdee.bos.metadata.query.JoinQueryInfo".equals(elen.getClass().getName())) {
                    this.locationQueryParent((JoinQueryInfo)elen);
                }
                this.saveModel(entry, elen);
            }
            Element ele = this.jdfactory.element("mergedMetadata");
            ele.setAttribute("pk", entry);
            ele.setAttribute("remark", "mergeM0M1M2");
            this.ws.mergedDoc.getRootElement().getChild("mergedMetadatas").addContent(ele);
        } else {
            this.mn.tag(entry, this.m2);
        }
    }

    private IObjectValue wrapThrowable(Loader3 loader, String entry, String msg) throws Exception {
        AbstractMetaDataValue ele0;
        block3: {
            ele0 = null;
            try {
                ele0 = loader.loadMetadata(entry);
            }
            catch (Throwable t) {
                if (t instanceof Exception) {
                    Exception e = new Exception(msg, t);
                    throw e;
                }
                if (!(t instanceof Error)) break block3;
                Error e = new Error(msg, t);
                throw e;
            }
        }
        return ele0;
    }

    private void locationQueryParent(JoinQueryInfo query) {
        PropertyUnitCollection props = query.getUnits();
        for (int i = 0; i < props.size(); ++i) {
            PropertyUnitInfo prop = props.get(i);
            PropertyRefCollection refs = prop.getPropertyRefs();
            for (int j = 0; j < refs.size(); ++j) {
                PropertyRefInfo ref = refs.get(j);
                ref.setUnit(prop);
            }
        }
    }

    private void fixJoinQuery(JoinQueryInfo query) {
        int i;
        PropertyUnitCollection props = query.getUnits();
        JoinCollection joins = query.getJoins();
        ArrayList<Integer> needRemove = new ArrayList<Integer>(props.size());
        for (i = 0; i < props.size(); ++i) {
            PropertyUnitInfo prop = props.get(i);
            if (prop instanceof QueryFieldInfo || this.refByJoin(prop, joins)) continue;
            needRemove.add(i);
        }
        for (i = needRemove.size() - 1; i >= 0; --i) {
            Integer index = (Integer)needRemove.get(i);
            props.removeObject(index);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Remove PropertyUnit from Query: " + query.getFullName()));
        }
    }

    private boolean refByJoin(PropertyUnitInfo prop, JoinCollection joins) {
        String name = prop.getName();
        for (int i = 0; i < joins.size(); ++i) {
            JoinInfo join = joins.get(i);
            JoinItemCollection items = join.getJoinItems();
            if (items == null) continue;
            for (int j = 0; j < items.size(); ++j) {
                JoinItemInfo item = items.get(j);
                PropertyUnitInfo left = item.getLeftField();
                if (name.equals(left.getName())) {
                    return true;
                }
                PropertyUnitInfo rgh = item.getRightField();
                if (!name.equals(rgh.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private void saveModel(String entry, IObjectValue elen) throws Exception {
        this.mn.saveMetadata(entry, (AbstractMetaDataValue)elen);
    }

    private boolean diffModelByMeta(String entry, IObjectValue ov0, IObjectValue ov1, IObjectValue ovn, CompareStack stack) throws Exception {
        boolean merged = false;
        EntityObjectInfo meta1 = this.m1.getMetametaLoader().loadMeta(ov1.getBOSType());
        PropertyCollection pc1 = meta1.getInheritedNoDuplicatedPropertiesRuntime();
        Iterator it1 = pc1.iterator();
        while (it1.hasNext()) {
            String name;
            com.kingdee.bos.metadata.entity.PropertyInfo pi1 = (com.kingdee.bos.metadata.entity.PropertyInfo)it1.next();
            String propName = pi1.getName();
            assert (propName != null && propName.length() > 0) : "Metametadata[" + meta1 + "] error - Prop's Name is null.";
            if (pi1 instanceof OwnPropertyInfo) {
                Object obj1;
                boolean hasProp1 = ov1.containsKey(propName);
                boolean hasProp0 = ov0.containsKey(propName);
                if (hasProp0) {
                    if (hasProp1) {
                        if (((OwnPropertyInfo)pi1).isMultilingual()) {
                            LanguageInfo[] als = this.getAddedLocales();
                            int len = als.length;
                            for (int i = 0; i < len; ++i) {
                                log.info((Object)("OwnProperty[" + propName + "] Locale[" + als[i] + "] add to " + ov1.get(propName, als[i])));
                                stack.recordBasicPropertyAdd(propName, als[i].getOriginalLocale());
                                ovn.put(propName, ov1.get(propName, als[i].getOriginalLocale()), als[i].getOriginalLocale());
                                merged = true;
                            }
                            LanguageInfo[] cls = this.getCommonLocales();
                            int len2 = cls.length;
                            for (int i = 0; i < len2; ++i) {
                                Locale locale = cls[i].getOriginalLocale();
                                Object obj12 = ov1.get(propName, locale);
                                Object obj0 = ov0.get(propName, locale);
                                if (obj12 == null && obj0 == null || obj12 != null && obj12.equals(obj0)) continue;
                                log.info((Object)("OwnProperty[" + propName + "] Locale[" + locale + "] modify to " + obj12));
                                Object objn = ovn.get(propName, locale);
                                if (!(objn == null && obj12 == null || objn != null && objn.equals(obj12))) {
                                    PropertyInfo pinfo;
                                    stack.conflictBasicPropertyBothModify(propName, cls[i].getOriginalLocale());
                                    if ("value".equals(propName) && ov1 instanceof PropertyInfo && "formatXml".equals((pinfo = (PropertyInfo)ov1).getName())) {
                                        try {
                                            obj12 = FormatXmlMerger.merge(obj0, obj12, objn);
                                        }
                                        catch (Exception _) {
                                            // empty catch block
                                        }
                                    }
                                }
                                stack.recordBasicPropertyModify(propName, cls[i].getOriginalLocale());
                                ovn.put(propName, obj12, locale);
                                merged = true;
                            }
                            continue;
                        }
                        obj1 = ov1.get(propName);
                        Object obj0 = ov0.get(propName);
                        if (obj1 == null && obj0 == null || obj1 != null && obj1.equals(obj0)) continue;
                        log.info((Object)("OwnProperty[" + propName + "] modify to " + obj1));
                        Object objn = ovn.get(propName);
                        if (!(objn == null && obj1 == null || objn != null && objn.equals(obj1))) {
                            stack.conflictBasicPropertyBothModify(propName);
                        }
                        stack.recordBasicPropertyModify(propName);
                        String cname = ovn.getClass().getName();
                        if ("name".equals(propName) && ("com.kingdee.bos.metadata.query.PropertyUnitInfo".equals(cname) || "com.kingdee.bos.metadata.query.JoinInfo".equals(cname))) {
                            String sname = (String)obj1;
                            if (sname.length() > 37 && sname.indexOf("-") != -1) {
                                ovn.put(propName, obj1);
                            } else {
                                sname = sname + "-" + Uuid.create().toString();
                                ovn.put(propName, sname);
                                ov1.put(propName, sname);
                            }
                        } else if (!"version".equals(propName) || !"com.kingdee.bos.metadata.management.SolutionInfo".equals(cname)) {
                            ovn.put(propName, obj1);
                        }
                        merged = true;
                        continue;
                    }
                    stack.conflictBasicPropertyM1Delete(propName);
                    log.warn((Object)("<<<M1 Delete-Ignore>>> OwnProperty" + SolutionTravel.getPath(stack) + "." + propName + " deleted"));
                    this.ws.mrWriter.println("warn," + entry + ",\"M1\u5220\u9664\u4e86\u81ea\u6709\u5c5e\u6027" + SolutionTravel.getPath(stack) + "." + propName + ", \u5ffd\u7565\u5220\u9664\"");
                    continue;
                }
                if (!hasProp1) continue;
                obj1 = ov1.get(propName);
                boolean hasPropn = ovn.containsKey(propName);
                if (hasPropn) {
                    stack.conflictBasicPropertyBothAdd(propName);
                    log.warn((Object)("<<<Conflict-AutoChoose>>> OwnProperty" + SolutionTravel.getPath(stack) + "." + propName + " M2 M1 all added,choose M1"));
                    this.ws.mrWriter.println("warn," + entry + ",\"M2 M1 \u90fd\u589e\u52a0\u4e86\u81ea\u6709\u5c5e\u6027" + SolutionTravel.getPath(stack) + "." + propName + " ,\u9009\u62e9 M1\"");
                }
                if (((OwnPropertyInfo)pi1).isMultilingual()) {
                    LanguageCollection ls = this.m1.getSolution().getLanguages();
                    int len = ls.size();
                    for (int i = 0; i < len; ++i) {
                        log.info((Object)("OwnProperty[" + propName + "] Locale[" + ls.get(i).getOriginalLocale() + "] add to " + ov1.get(propName, ls.get(i).getOriginalLocale())));
                        stack.recordBasicPropertyAdd(propName, ls.get(i).getOriginalLocale());
                        ovn.put(propName, ov1.get(propName, ls.get(i).getOriginalLocale()), ls.get(i).getOriginalLocale());
                    }
                } else {
                    log.info((Object)("OwnProperty[" + propName + "] add to " + obj1));
                    stack.recordBasicPropertyAdd(propName);
                    ovn.put(propName, obj1);
                }
                merged = true;
                continue;
            }
            if (!(pi1 instanceof LinkPropertyInfo)) continue;
            LinkPropertyInfo lpi1 = (LinkPropertyInfo)pi1;
            RelationshipInfo r1 = lpi1.getRelationship();
            CardinalityType ct1 = r1.getSupplierCardinality();
            if (ct1.equals((Object)CardinalityType.ZERO_TO_ONE) || ct1.equals((Object)CardinalityType.ONE)) {
                IObjectValue obj1 = ov1.getObjectValue(propName);
                IObjectValue obj0 = ov0.getObjectValue(propName);
                IObjectValue objn = ovn.getObjectValue(propName);
                if (obj0 == null) {
                    if (obj1 == null) continue;
                    log.info((Object)("M1 Added LinkProperty(0..1)[" + propName + "] obj1 = " + obj1));
                    if (objn != null) {
                        stack.conflictObjectBothAdd(propName);
                        log.warn((Object)("<<<Conflict-AutoChoose>>> M1 M2 added the same LinkProperty(0..1),choose M1. " + SolutionTravel.getPath(stack) + "." + propName));
                        this.ws.mrWriter.println("warn," + entry + ",\"M1 M2 \u589e\u52a0\u4e86\u76f8\u540c\u7684\u8fde\u63a5\u5c5e\u6027(0..1), " + SolutionTravel.getPath(stack) + "." + propName + ", \u9009\u62e9 M1.\"");
                    }
                    stack.recordObjectAdd(propName);
                    ovn.put(propName, obj1);
                    merged = true;
                    continue;
                }
                if (obj1 == null) {
                    stack.conflictObjectM1Delete(propName);
                    log.warn((Object)("<<<M1 Delete-Ignore>>> LinkProperty(0..1)" + SolutionTravel.getPath(stack) + "." + propName));
                    this.ws.mrWriter.println("warn," + entry + ",\"M1 \u5220\u9664\u4e86\u8fde\u63a5\u5c5e\u6027(0..1), " + SolutionTravel.getPath(stack) + "." + propName + ", \u5ffd\u7565\u5220\u9664\"");
                    continue;
                }
                try {
                    if (objn != null) {
                        if (r1.getType().equals((Object)RelationshipType.COMPOSITION)) {
                            merged |= this.diffModelByMeta(entry, obj0, obj1, objn, new CompareStack(stack, propName));
                            continue;
                        }
                        if (this.equalsByLK(obj0, obj1)) continue;
                        if (this.equalsByLK(obj0, objn)) {
                            stack.recordObjectAdd(propName);
                            if (ovn instanceof JoinItemInfo) {
                                JoinQueryInfo elen = (JoinQueryInfo)this.wrapThrowable(this.mn, entry, "\u65b0\u7248\u672c\u5143\u6570\u636e");
                                PropertyUnitInfo pui = (PropertyUnitInfo)this.findInCollection((IObjectCollection)elen.getUnits(), obj1);
                                ovn.put(propName, pui);
                            } else {
                                ovn.put(propName, obj1);
                            }
                            merged = true;
                            continue;
                        }
                        stack.conflictObjectBothModify(propName);
                        continue;
                    }
                    if (objn == null) {
                        stack.conflictObjectM2Delete(propName);
                        log.warn((Object)"<<M2 Delete>>");
                        this.ws.mrWriter.println("warn," + entry + ",\"M2\u5220\u9664\u4e86\u8fde\u63a5\u5c5e\u6027" + SolutionTravel.getPath(stack) + "." + propName + "\"");
                        continue;
                    }
                    log.error((Object)"[[LogicalKey Changed]] M1 or M2 changed logicalkey value,Ignored");
                }
                catch (Exception e) {
                    log.error((Object)("[[LogicalKey Error]] Exception while Compare: " + entry), (Throwable)e);
                    this.ws.mrWriter.println("error," + entry + ",\"[[LogicalKey Error]] \u6bd4\u8f83\u65f6\u53d1\u751f\u4e86\u5f02\u5e38: " + StringUtils.stackToString((Exception)e) + "\"");
                }
                continue;
            }
            IObjectCollection oc1 = (IObjectCollection)ov1.get(propName);
            IObjectCollection oc0 = (IObjectCollection)ov0.get(propName);
            IObjectCollection ocn = (IObjectCollection)ovn.get(propName);
            CompareStack collStack = new CompareStack(stack, propName);
            if (oc0 == null || oc0.size() == 0) {
                if (oc1 == null || oc1.size() == 0) continue;
                if (ocn == null || ocn.size() == 0) {
                    log.info((Object)("LinkProp(0..*) add from M1 Prop[" + propName + "]"));
                    ovn.put(propName, oc1);
                } else {
                    try {
                        for (int i = 0; i < oc1.size(); ++i) {
                            IObjectValue added = oc1.getObject(i);
                            if (!this.existInCollection(ocn, added)) {
                                log.info((Object)("LinkProp(0..*) add Element by M1 Prop[" + propName + "]"));
                                ocn.addObject(added);
                                if (!"com.kingdee.bos.metadata.query.PropertyUnitInfo".equals(added.getClass().getName()) && !"com.kingdee.bos.metadata.query.JoinInfo".equals(added.getClass().getName())) continue;
                                name = added.getString("name");
                                name = name + "-" + Uuid.create().toString();
                                added.setString("name", name);
                                continue;
                            }
                            LogicalKey lk = this.getLogicalKey(added);
                            collStack.conflictCollectionBothAdd(lk.getPath());
                            if (!(added instanceof EventBindingInfo)) continue;
                            EventBindingInfo ebi = (EventBindingInfo)added;
                            String code1 = ebi.getCode();
                            IObjectValue finded = this.findInCollection(ocn, added);
                            String coden = ((EventBindingInfo)finded).getCode();
                            if (!StringUtils.isEmpty((String)coden) || StringUtils.isEmpty((String)code1)) continue;
                            ((EventBindingInfo)finded).setCode(code1);
                        }
                    }
                    catch (Exception _) {
                        // empty catch block
                    }
                }
                stack.recordObjectAdd(propName);
                merged = true;
                continue;
            }
            if (oc1 == null || oc1.size() == 0) {
                stack.conflictObjectM1Delete(propName);
                log.warn((Object)("<<<M1 Delete-Ignore>>> LinkProps[" + propName + "]"));
                this.ws.mrWriter.println("warn," + entry + ",\"M1\u5220\u9664\u4e86\u8fde\u63a5\u5c5e\u6027" + SolutionTravel.getPath(stack) + "." + propName + "\"");
                continue;
            }
            if (ocn == null || ocn.size() == 0) {
                stack.conflictObjectM2Delete(propName);
                log.warn((Object)("<<<M2 Delete>>> LinkProps[" + propName + "]"));
                this.ws.mrWriter.println("warn," + entry + ",\"M2\u5220\u9664\u4e86\u8fde\u63a5\u5c5e\u6027" + SolutionTravel.getPath(stack) + "." + propName + "\"");
                continue;
            }
            try {
                LogicalKey logicalKey;
                for (IObjectValue mov1 : this.bothCollection(oc1, oc0)) {
                    LogicalKey logicalKey2;
                    IObjectValue mov0 = this.findInCollection(oc0, mov1);
                    IObjectValue movn = this.findInCollection(ocn, mov1);
                    if (movn == null) {
                        logicalKey2 = this.getLogicalKey(mov1);
                        collStack.conflictCollectionM2Delete(logicalKey2.getPath());
                        continue;
                    }
                    if (r1.getType().equals((Object)RelationshipType.COMPOSITION)) {
                        merged |= this.diffModelByMeta(entry, mov0, mov1, movn, new CompareStack(collStack, this.getLogicalKey(mov1).getPath()));
                        continue;
                    }
                    if (this.equalsByLK(mov0, mov1)) continue;
                    if (this.equalsByLK(mov0, movn)) {
                        ocn.addObject(mov1);
                    } else {
                        logicalKey2 = this.getLogicalKey(mov1);
                        collStack.conflictCollectionBothModify(logicalKey2.getPath());
                    }
                    logicalKey2 = this.getLogicalKey(mov1);
                    collStack.recordCollectionAdd(logicalKey2.getPath());
                    merged = true;
                }
                for (IObjectValue addedOv : this.diffCollection(oc1, oc0)) {
                    if (this.existInCollection(ocn, addedOv)) {
                        logicalKey = this.getLogicalKey(addedOv);
                        collStack.conflictCollectionBothAdd(logicalKey.getPath());
                        String temp = addedOv instanceof MethodInfo ? ((MethodInfo)addedOv).toString() : addedOv.getString("name");
                        log.warn((Object)("<<<Conflict Both Added Auto Choose>>> LinkProps(0..*) Props[" + propName + "]" + temp));
                        IObjectValue finded = this.findInCollection(ocn, addedOv);
                        boolean circle = false;
                        if (finded instanceof ComponentInfo) {
                            circle = this.processComponent(ocn, (ComponentInfo)finded, (ComponentInfo)addedOv);
                        }
                        if (!circle) {
                            this.ws.mrWriter.println("warn," + entry + ",\"M1 M2\u90fd\u589e\u52a0\u4e86\u8fde\u63a5\u5c5e\u6027(0..*) Props[" + propName + "]" + temp + ", \u9009\u62e9M2\"");
                        } else {
                            this.ws.mrWriter.println("warn," + entry + ",\"M1 M2\u90fd\u589e\u52a0\u4e86\u8fde\u63a5\u5c5e\u6027(0..*) Props[" + propName + "]" + temp + ", \u9009\u62e9M1\"");
                        }
                        addedOv.setString("name", finded.getString("name"));
                        if (addedOv instanceof EventBindingInfo) {
                            EventBindingInfo ebi = (EventBindingInfo)addedOv;
                            String code1 = ebi.getCode();
                            String coden = ((EventBindingInfo)finded).getCode();
                            if (StringUtils.isEmpty((String)coden) && !StringUtils.isEmpty((String)code1)) {
                                ((EventBindingInfo)finded).setCode(code1);
                            }
                        }
                    } else {
                        log.info((Object)("LinkProps M1 add subElement[" + addedOv.get("name") + "]"));
                        ocn.addObject(addedOv);
                        if ("com.kingdee.bos.metadata.query.PropertyUnitInfo".equals(addedOv.getClass().getName()) || "com.kingdee.bos.metadata.query.JoinInfo".equals(addedOv.getClass().getName())) {
                            name = addedOv.getString("name");
                            name = name + "-" + Uuid.create().toString();
                            addedOv.setString("name", name);
                        }
                    }
                    logicalKey = this.getLogicalKey(addedOv);
                    collStack.recordCollectionAdd(logicalKey.getPath());
                    merged = true;
                }
                for (IObjectValue deledOv : this.diffCollection(oc0, oc1)) {
                    logicalKey = this.getLogicalKey(deledOv);
                    collStack.conflictCollectionM1Delete(logicalKey.getPath());
                    log.warn((Object)("<<<M1 Delete-Ignore>>> LinpProp[" + propName + "] elements"));
                }
            }
            catch (Exception e) {
            }
        }
        if (ov1 != null || ovn != null) {
            merged |= this.processExtend(entry, ov0, ov1, ovn, stack);
        }
        return merged;
    }

    private boolean existInCollection(IObjectCollection set, IObjectValue ele) throws LogicalKeyException {
        return this.findInCollection(set, ele) != null;
    }

    private IObjectValue findInCollection(IObjectCollection set, IObjectValue ele) throws LogicalKeyException {
        if (set == null || ele == null) {
            return null;
        }
        int len = set.size();
        for (int i = 0; i < len; ++i) {
            IObjectValue ov = set.getObject(i);
            if (!this.equalsByLK(ov, ele)) continue;
            return ov;
        }
        return null;
    }

    private IObjectValue findInCollection(IObjectCollection set, LogicalKey key) {
        if (set == null || key == null) {
            return null;
        }
        int len = set.size();
        for (int i = 0; i < len; ++i) {
            IObjectValue ov = set.getObject(i);
            try {
                if (!key.equals(this.getLogicalKey(ov))) continue;
                return ov;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    private List bothCollection(IObjectCollection s1, IObjectCollection s2) throws LogicalKeyException {
        ArrayList<IObjectValue> rtv = new ArrayList<IObjectValue>();
        int l1 = s1.size();
        for (int i = 0; i < l1; ++i) {
            IObjectValue ov = s1.getObject(i);
            if (!this.existInCollection(s2, ov)) continue;
            rtv.add(ov);
        }
        return rtv;
    }

    private List diffCollection(IObjectCollection s1, IObjectCollection s2) throws LogicalKeyException {
        ArrayList<IObjectValue> rtv = new ArrayList<IObjectValue>();
        int l1 = s1.size();
        for (int i = 0; i < l1; ++i) {
            IObjectValue ov = s1.getObject(i);
            if (this.existInCollection(s2, ov)) continue;
            rtv.add(ov);
        }
        return rtv;
    }

    private boolean processExtend(String entry, IObjectValue ov0, IObjectValue ov1, IObjectValue ovn, CompareStack stack) {
        boolean merged = false;
        if (ov0 == null && ov1.getExtendedProperties().size() > 0) {
            ovn.getExtendedProperties().putAll(ov1.getExtendedProperties());
            return true;
        }
        Map map1 = ov1.getExtendedProperties();
        for (Map.Entry kv1 : map1.entrySet()) {
            String vn;
            String key = (String)kv1.getKey();
            String v1 = (String)kv1.getValue();
            String v0 = ov0.getExtendedProperty(key);
            if (ov0.containsExtendedPropertyKey(key)) {
                if (v1 != null) {
                    if (v1.equals(v0)) continue;
                    if (ovn.containsExtendedPropertyKey(key)) {
                        vn = ovn.getExtendedProperty(key);
                        if (v1.equals(vn)) continue;
                        stack.conflictExtendBothModify(key);
                        ovn.setExtendedProperty(key, v1);
                        merged = true;
                        continue;
                    }
                    ovn.setExtendedProperty(key, v1);
                    merged = true;
                    continue;
                }
                if (ov0.getExtendedProperty(key) == null) continue;
                ovn.setExtendedProperty(key, null);
                merged = true;
                continue;
            }
            if (ovn.containsExtendedPropertyKey(key)) {
                vn = ovn.getExtendedProperty(key);
                if (v1.equals(vn)) continue;
                stack.conflictExtendBothAdd(key);
                ovn.setExtendedProperty(key, v1);
                merged = true;
                continue;
            }
            ovn.setExtendedProperty(key, v1);
            merged = true;
        }
        Map map0 = ov0.getExtendedProperties();
        for (Map.Entry kv0 : map0.entrySet()) {
            String key = (String)kv0.getKey();
            if (ov1.containsExtendedPropertyKey(key) || !ovn.containsExtendedPropertyKey(key)) continue;
            stack.conflictExtendM1Delete(key);
            ovn.removeExtendedProperty(key);
            merged = true;
        }
        return merged;
    }

    private boolean equalsByJoin(JoinInfo ov0, JoinInfo ov1) {
        return ov0.getLeftObject().getName().equals(ov1.getLeftObject().getName()) && ov0.getRightObject().getName().equals(ov1.getRightObject().getName());
    }

    private boolean equalsByPropertyUnit(PropertyUnitInfo ov0, PropertyUnitInfo ov1) {
        AbstractMDElement refPropertyOrRefUnit1;
        AbstractMDElement refPropertyOrRefUnit0;
        SubObjectInfo sub1;
        PropertyRefInfo ref0 = ov0.getPropertyRefs().get(0);
        PropertyRefInfo ref1 = ov1.getPropertyRefs().get(0);
        SubObjectInfo sub0 = ref0.getSubEntity();
        if (sub0 == null) {
            sub0 = ref0.getSubQuery();
        }
        if ((sub1 = ref1.getSubEntity()) == null) {
            sub1 = ref1.getSubQuery();
        }
        if ((refPropertyOrRefUnit0 = ref0.getRefProperty()) == null) {
            refPropertyOrRefUnit0 = ref0.getRefUnit();
        }
        if ((refPropertyOrRefUnit1 = ref1.getRefProperty()) == null) {
            refPropertyOrRefUnit1 = ref1.getRefUnit();
        }
        return refPropertyOrRefUnit0.getString("name").equals(refPropertyOrRefUnit1.getString("name")) && sub0.getName().equals(sub1.getName());
    }

    private boolean equalsByPropertyRef(PropertyRefInfo ref0, PropertyRefInfo ref1) {
        SubObjectInfo sub1;
        SubObjectInfo sub0 = ref0.getSubEntity();
        if (sub0 == null) {
            sub0 = ref0.getSubQuery();
        }
        if ((sub1 = ref1.getSubEntity()) == null) {
            sub1 = ref1.getSubQuery();
        }
        return ref0.getRefProperty().getName().equals(ref1.getRefProperty().getName()) && sub0.getName().equals(sub1.getName());
    }

    private boolean equalsByLK(IObjectValue ov0, IObjectValue ov1) throws LogicalKeyException {
        try {
            if (ov0 instanceof JoinInfo && ov1 instanceof JoinInfo) {
                return this.equalsByJoin((JoinInfo)ov0, (JoinInfo)ov1);
            }
            if (ov0 instanceof PropertyUnitInfo && !(ov0 instanceof QueryFieldInfo) && ov1 instanceof PropertyUnitInfo && !(ov1 instanceof QueryFieldInfo)) {
                return this.equalsByPropertyUnit((PropertyUnitInfo)ov0, (PropertyUnitInfo)ov1);
            }
            if (ov0 instanceof PropertyRefInfo && ov1 instanceof PropertyRefInfo) {
                return this.equalsByPropertyRef((PropertyRefInfo)ov0, (PropertyRefInfo)ov1);
            }
            if (ov0 instanceof ColumnInfo && ov1 instanceof ColumnInfo) {
                return this.equalsIgnoreCaseByName(ov0, ov1);
            }
            EntityObjectInfo eoi1 = this.m1.getMetametaLoader().loadMeta(ov1.getBOSType());
            PropertyCollection pc1 = eoi1.getLogicalKey().getKeyPropertys();
            if (pc1.size() == 0) {
                log.error((Object)"[[MetaMetaData Error]] No Logical Key Defined");
                throw new LogicalKeyException("No LogicalKey Can find.");
            }
            int len = pc1.size();
            for (int i = 0; i < len; ++i) {
                String lkName = pc1.get(i).getName();
                Object lkValue1 = ov1.get(lkName);
                Object lkValue0 = ov0.get(lkName);
                if ((lkValue1 == null || lkValue1.equals("")) && (lkValue0 == null || lkValue0.equals(""))) continue;
                if (lkValue1 == null || lkValue1.equals("") || lkValue0 == null || lkValue0.equals("")) {
                    log.error((Object)"[[MetaData Error]] LogicalKey Value Null");
                    throw new LogicalKeyException("LogicalKey Value Null.");
                }
                if (lkValue1.equals(lkValue0)) continue;
                return false;
            }
        }
        catch (Exception e) {
            throw new LogicalKeyException("LogicalKey Compare Error", e);
        }
        return true;
    }

    private boolean equalsIgnoreCaseByName(IObjectValue ov0, IObjectValue ov1) {
        String name0 = ov0.getString("name");
        String name1 = ov1.getString("name");
        return StringUtils.equalsIgnoreCase((String)name0, (String)name1);
    }

    private LogicalKey getLogicalKey(IObjectValue ov) {
        try {
            EntityObjectInfo eoi1 = this.m1.getMetametaLoader().loadMeta(ov.getBOSType());
            PropertyCollection pc1 = eoi1.getLogicalKey().getKeyPropertys();
            if (pc1.size() == 0) {
                return null;
            }
            LinkedHashMap<String, Object> keys = new LinkedHashMap<String, Object>(3);
            int len = pc1.size();
            for (int i = 0; i < len; ++i) {
                String lkName = pc1.get(i).getName();
                Object lkValue = ov.get(lkName);
                keys.put(lkName, lkValue);
            }
            return new LogicalKey(keys);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static BOSObjectType getMetaBOSObjectType(String entry) {
        return BOSObjectType.create((String)SolutionTravel.getMetaBOSObjectTypeName(entry));
    }

    protected static String getMetaBOSObjectTypeName(String entry) {
        int idx = entry.lastIndexOf(46);
        String sf = "";
        if (idx != -1) {
            sf = entry.substring(idx, entry.length());
        }
        return Utils.getBOSTypeBySuffix(sf);
    }

    public final LanguageInfo[] getCommonLocales() {
        if (this.cls == null) {
            this.cls = hardcodeLocales;
        }
        return this.cls;
    }

    public final LanguageInfo[] getAddedLocales() {
        if (this.als == null) {
            this.als = new LanguageInfo[0];
        }
        return this.als;
    }

    public final LanguageInfo[] getSubedLocales() {
        if (this.mls == null) {
            this.mls = new LanguageInfo[0];
        }
        return this.mls;
    }

    private static boolean needReleaseMemory() {
        long warn;
        Runtime rt = Runtime.getRuntime();
        long free = rt.freeMemory();
        if (free < (warn = 0x800000L)) {
            long total = rt.totalMemory();
            long max = rt.maxMemory();
            if (max - (total - free) < warn) {
                return true;
            }
        }
        return false;
    }

    private static String getPath(CompareStack cs) {
        String path = cs.getThisPath();
        if (!path.startsWith("[")) {
            path = "[" + path + "]";
        }
        return path;
    }

    private boolean processComponent(IObjectCollection ocn, ComponentInfo finded, ComponentInfo addedOv) {
        ArrayList<String> ps = new ArrayList<String>();
        ps.add(finded.getName());
        boolean circle = false;
        ComponentInfo parent = null;
        for (parent = finded.getParent(); parent != null; parent = parent.getParent()) {
            if (ps.contains(parent.getName())) {
                circle = true;
                break;
            }
            ps.add(parent.getName());
        }
        if (circle) {
            ocn.removeObject(finded);
            ocn.addObject(addedOv);
        }
        return circle;
    }

    static {
        LanguageInfo lang = null;
        hardcodeLocales = new LanguageInfo[3];
        lang = new LanguageInfo();
        lang.setName("\u82f1\u6587");
        lang.setAlias("\u82f1\u6587");
        lang.setLocaleString("en_US");
        lang.setPostfix("L1");
        SolutionTravel.hardcodeLocales[0] = lang;
        lang = new LanguageInfo();
        lang.setName("\u4e2d\u6587 (\u7b80\u4f53)");
        lang.setAlias("\u4e2d\u6587 (\u7b80\u4f53)");
        lang.setLocaleString("zh_CN");
        lang.setPostfix("L2");
        SolutionTravel.hardcodeLocales[1] = lang;
        lang = new LanguageInfo();
        lang.setName("\u4e2d\u6587 (\u7e41\u4f53)");
        lang.setAlias("\u4e2d\u6587 (\u7e41\u4f53)");
        lang.setLocaleString("zh_TW");
        lang.setPostfix("L3");
        SolutionTravel.hardcodeLocales[2] = lang;
    }

    private static class FilterBizEnumeration
    implements Enumeration {
        private Enumeration d;
        private String next = null;

        public FilterBizEnumeration(Enumeration d) {
            this.d = d;
        }

        @Override
        public boolean hasMoreElements() {
            while (this.d.hasMoreElements()) {
                this.next = (String)this.d.nextElement();
                if (this.isIngnoreEntry(this.next)) continue;
                return true;
            }
            return false;
        }

        public Object nextElement() {
            return this.next;
        }

        protected boolean isIngnoreEntry(String entry) {
            if (entry.endsWith("/")) {
                return true;
            }
            String type = SolutionTravel.getMetaBOSObjectTypeName(entry);
            if (type == null) {
                return true;
            }
            return !"bzut".equals(type);
        }
    }

    private static class FilterEnumeration
    implements Enumeration {
        private Enumeration d;
        private Set ingnores;
        private String next = null;

        public FilterEnumeration(Enumeration d, Set exceptes) {
            this.d = d;
            this.ingnores = exceptes;
        }

        @Override
        public boolean hasMoreElements() {
            while (this.d.hasMoreElements()) {
                this.next = (String)this.d.nextElement();
                if (this.isIngnoreEntry(this.next)) continue;
                return true;
            }
            return false;
        }

        public Object nextElement() {
            return this.next;
        }

        protected boolean isIngnoreEntry(String entry) {
            if (this.ingnores.contains(entry)) {
                return true;
            }
            if (entry.endsWith("/")) {
                return true;
            }
            String type = SolutionTravel.getMetaBOSObjectTypeName(entry);
            if (type == null) {
                return true;
            }
            return "solu".equals(type) || "bzut".equals(type);
        }
    }
}

