/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.upgrade;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.xml.Utils;
import com.kingdee.bos.dao.xml.XMLLoader;
import com.kingdee.bos.dao.xml.impl.MetadataIndexer;
import com.kingdee.bos.engine.difftool.PathsHelper;
import com.kingdee.bos.engine.impl.BOSTypeHelper;
import com.kingdee.bos.engine.impl.MetadataXMLAssembler;
import com.kingdee.bos.engine.impl.ResEntry;
import com.kingdee.bos.metadata.upgrade.FileUtil;
import com.kingdee.bos.metadata.upgrade.MergeException;
import com.kingdee.bos.metadata.upgrade.MergeModelEnum;
import com.kingdee.bos.metadata.upgrade.MergeResult;
import com.kingdee.bos.metadata.upgrade.MergeResultItem;
import com.kingdee.bos.metadata.upgrade.Request;
import com.kingdee.bos.metadata.upgrade.Solution;
import com.kingdee.bos.metadata.upgrade.SolutionTravel;
import com.kingdee.bos.metadata.upgrade.WorkSpaceLockedException;
import com.kingdee.bos.metadata.upgrade.WorkspaceException;
import com.kingdee.bos.metadata.upgrade.WorkspaceNotOpenedException;
import com.kingdee.bos.metadata.upgrade.loader.Loader3;
import com.kingdee.bos.metadata.util.XmlUtils;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.XMLParser;
import com.kingdee.bos.util.md5;
import com.kingdee.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.DefaultJDOMFactory;
import org.jdom.input.JDOMFactory;

public class WorkSpace {
    private static final Logger log = Logger.getLogger((String)"com.kingdee.bos.metadata.upgrade.WorkSpace");
    private Loader3 m0;
    private Loader3 m1;
    private Loader3 m2;
    private Loader3 mn;
    private Solution delta;
    private Solution conflict;
    private boolean isOpened = false;
    private int mode = 3;
    public static final int MODE_DIFF = 1;
    public static final int MODE_MERGE = 2;
    public static final int MODE_NORMAL = 3;
    public static final int PS_WS_INIT = 1;
    public static final int PS_MODEL_INPUT = 2;
    public static final int PS_MODEL_LOAD = 4;
    public static final int PS_MODEL_INIT = 8;
    public static final int PS_MODEL_DIFF1 = 16;
    public static final int PS_MODEL_DIFF2 = 32;
    public static final int PS_MODEL_MERGE1 = 64;
    public static final int PS_MODEL_MERGE2 = 128;
    public static final int PS_MODEL_MERGE3 = 256;
    public static final int PS_MODEL_VERIFY = 512;
    public static final int PS_MODEL_DEPLOY = 1024;
    public static final int PS_DB_DIFF = 65536;
    public static final int PS_DB_MERGE = 131072;
    private static final String KEY_INTERNAL_PREFIX = "ws.";
    private static final String KEY_CREATE_TIME = "ws.create_time";
    private static final String KEY_MODIFY_TIME = "ws.modify_time";
    private static final String KEY_SAVE_TIME = "ws.save_time";
    public static final String KEY_M0_PATH = "ws.m0_path";
    public static final String KEY_M1_PATH = "ws.m1_path";
    public static final String KEY_M2_PATH = "ws.m2_path";
    public static final String KEY_Mn_PATH = "ws.mn_path";
    public static final String KEY_DELTA_PATH = "ws.delta_path";
    public static final String KEY_M0_PATH_EXT = "ws.m0_path_ext";
    public static final String KEY_M1_PATH_EXT = "ws.m1_path_ext";
    public static final String KEY_M2_PATH_EXT = "ws.m2_path_ext";
    public static final String KEY_Mn_PATH_EXT = "ws.mn_path_ext";
    private static final String KEY_PROCESS_STATUS = "ws.ps_status";
    private File home;
    private static final String LOCK_FILE_NAME = ".lock";
    private static final String PROP_FILE_NAME = "workspace.properties";
    private Properties prop;
    private MetadataXMLAssembler assembler;
    private XMLLoader metametaLoader;
    private JDOMFactory jdfactory = new DefaultJDOMFactory();
    Document mergedDoc;
    public static final String MERGED_METADATAS = "mergedMetadatas";
    public static final String MERGED_METADATA = "mergedMetadata";
    public static final String MERGED_FILE__NAME = "merged.xml";
    public static final String MERGED_RESULT = "merged_result.csv";
    PrintWriter mrWriter = null;
    Set needDiff2 = new TreeSet();
    private MergeModelEnum mergeModel = MergeModelEnum.WHOLE;
    private Set pkgs = new HashSet();
    private Set mds = new HashSet();

    protected WorkSpace() {
    }

    public WorkSpace(File home) throws IOException {
        XMLLoader xmlLoader;
        if (null == home) {
            log.error((Object)"Workspace Home is null");
            throw new IllegalArgumentException("Workspace Home is null");
        }
        if (!home.exists()) {
            try {
                home.mkdirs();
            }
            catch (Exception e) {
                log.error((Object)("Create Workspace [" + home.getPath() + "] error!"), (Throwable)e);
                throw new IOException("Create Workspace [" + home.getPath() + "] error!");
            }
        }
        if (!home.isDirectory()) {
            log.error((Object)("Workspace home [" + home + "] must be a Directiry!"));
            throw new IOException("Workspace home [" + home + "] must be a Directiry!");
        }
        if (!home.canWrite()) {
            log.error((Object)("Workspace Home [" + home + "] can not write!"));
            throw new IOException("Workspace Home [" + home + "] can not write!");
        }
        this.home = home;
        this.createDirs();
        Context ctx = new Context();
        ctx.put((Object)"METADATAPATH", (Object)"");
        this.metametaLoader = xmlLoader = new XMLLoader(ctx, new String[0]);
        new BOSTypeHelper(xmlLoader);
        this.assembler = new MetadataXMLAssembler(xmlLoader);
        this.assembler.setPlugin(false);
    }

    public WorkSpace(File home, int mode) throws IOException {
        this(home);
        this.mode = mode;
    }

    public File getHome() {
        return this.home;
    }

    public final boolean isOpened() {
        return this.isOpened;
    }

    public final boolean isClosed() {
        return !this.isOpened;
    }

    public Loader3 getM0() {
        return this.m0;
    }

    public Loader3 getM1() {
        return this.m1;
    }

    public Loader3 getM2() {
        return this.m2;
    }

    public Loader3 getMn() {
        return this.mn;
    }

    public Solution getDelta() {
        if (this.delta == null) {
            try {
                this.delta = new Solution(new File(this.home, "delta").getCanonicalPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.delta;
    }

    public Solution getConflict() {
        if (this.conflict == null) {
            try {
                this.conflict = new Solution(new File(this.home, "conflict").getCanonicalPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.conflict;
    }

    protected final void checkOpen() throws WorkspaceException {
        this.checkOpen(false);
    }

    protected final void checkOpen(boolean open) throws WorkspaceException {
        if (open && this.isClosed()) {
            this.open();
        }
        if (this.isClosed()) {
            throw new WorkspaceNotOpenedException();
        }
    }

    protected final void checkOpenStatus(int ps) throws WorkspaceException {
        this.checkOpen();
        int status = this.getPSStatus();
        if (status != ps) {
            throw new WorkspaceException("ws status error");
        }
    }

    protected final void checkOpenStatus(int[] pss) throws WorkspaceException {
        this.checkOpen();
        int status = this.getPSStatus();
        int len = pss.length;
        for (int i = 0; i < len; ++i) {
            if (status != pss[i]) continue;
            return;
        }
        throw new WorkspaceException("ws status error");
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    private void createDirs() {
        new File(this.home, "mn").mkdirs();
        new File(this.home, "delta").mkdirs();
        new File(this.home, "conflict").mkdirs();
        new File(this.home, "temp").mkdirs();
    }

    public synchronized void open() throws WorkSpaceLockedException {
        if (this.isOpened) {
            return;
        }
        this.isOpened = true;
        File lock = new File(this.home, LOCK_FILE_NAME);
        if (lock.exists()) {
            log.warn((Object)"Workspace has been Locked by other process!");
            throw new WorkSpaceLockedException("Workspace has been Locked by other process!");
        }
        try {
            boolean cs = lock.createNewFile();
            if (log.isDebugEnabled()) {
                log.debug((Object)"Create Lock File OK!");
            }
            lock.deleteOnExit();
        }
        catch (IOException e) {
            log.error((Object)"Create Lock File error!", (Throwable)e);
            throw new WorkSpaceLockedException("Can NOT lock the workspace.");
        }
        log.info((Object)"Lock the workspace OK!");
        File propFile = new File(this.home, PROP_FILE_NAME);
        this.prop = new Properties();
        try {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(propFile));
            this.prop.load(is);
            ((InputStream)is).close();
        }
        catch (FileNotFoundException e) {
            try {
                propFile.createNewFile();
            }
            catch (Exception fe) {
                // empty catch block
            }
            this.setDateProperty(KEY_CREATE_TIME, new Date());
            log.info((Object)"Workspace .properties file has not create.");
        }
        catch (IOException e) {
            log.warn((Object)"get workspace .properties error.", (Throwable)e);
        }
    }

    public synchronized void close() {
        this.saveProperties();
        this.releaseModels();
        File lock = new File(this.home, LOCK_FILE_NAME);
        try {
            boolean ds = lock.delete();
            if (log.isDebugEnabled()) {
                log.debug((Object)"Delete Lock File OK!");
            }
        }
        catch (Exception e) {
            log.warn((Object)"Release Workspace Lock error!", (Throwable)e);
        }
        log.info((Object)"Unlock the workspace OK!");
        this.isOpened = false;
    }

    public synchronized void clean() {
        this.setIntProperty(KEY_PROCESS_STATUS, 1);
    }

    public synchronized void reset() {
        String[] tempDirs = new String[]{"temp", "delta", "mn"};
        for (int i = 0; i < tempDirs.length; ++i) {
            try {
                File dir = new File(this.home, tempDirs[i]);
                FileUtil.clearDir(dir);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setIntProperty(KEY_PROCESS_STATUS, 2);
    }

    protected void releaseModels() {
        this.m0 = null;
        this.m1 = null;
        this.mn = null;
    }

    protected final synchronized void saveProperties() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
        String str = df.format(new Date());
        this.prop.setProperty(KEY_SAVE_TIME, str);
        File propFile = new File(this.home, PROP_FILE_NAME);
        try {
            FileOutputStream os = new FileOutputStream(propFile);
            this.prop.store(os, "");
            ((OutputStream)os).close();
        }
        catch (Exception e) {
            log.warn((Object)"Save Properties error!", (Throwable)e);
        }
    }

    protected final Date getDateProperty(String key) {
        String str = this.getStringProperty(key);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
        Date date = null;
        try {
            date = df.parse(str);
        }
        catch (Exception e) {
            log.error((Object)("getDate[key=" + key + "] from properties error!"), (Throwable)e);
        }
        return date;
    }

    protected final void setDateProperty(String key, Date value) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
        String str = df.format(value);
        this.setStringProperty(key, str);
    }

    protected final String getStringProperty(String key) {
        return this.prop.getProperty(key);
    }

    protected final void setStringProperty(String key, String value) {
        if (value == null) {
            return;
        }
        this.prop.setProperty(key, value);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
        String str = df.format(new Date());
        this.prop.setProperty(KEY_MODIFY_TIME, str);
        this.saveProperties();
        this.processNeedMergeMetas(key, value);
    }

    private void processNeedMergeMetas(String key, String value) {
        String[] paths;
        if (KEY_M1_PATH.equals(key) && (paths = value.split(PathsHelper.SPLIT_D)) != null && paths.length > 1) {
            int i;
            boolean processed = false;
            for (i = 1; i < paths.length; ++i) {
                if (paths[i].toLowerCase().indexOf("sp-bim-metas.jar") <= 0) continue;
                try {
                    JarFile jf = new JarFile(paths[i]);
                    Enumeration<JarEntry> enume = jf.entries();
                    while (enume.hasMoreElements()) {
                        ZipEntry ze = enume.nextElement();
                        if (ze.isDirectory()) continue;
                        String name = ze.getName();
                        int index = name.lastIndexOf(46);
                        if (index > 0) {
                            name = name.substring(0, index);
                        }
                        this.addMergedMetadata(name);
                    }
                    this.setMergeModel(MergeModelEnum.PART);
                    processed = true;
                    break;
                }
                catch (IOException e) {
                    log.error((Object)e, (Throwable)e);
                }
            }
            if (!processed) {
                for (i = 1; i < paths.length; ++i) {
                    File f = new File(paths[i]);
                    if (!f.isDirectory()) continue;
                    this.processDir(f, new Stack());
                    processed = true;
                }
                if (processed) {
                    this.setMergeModel(MergeModelEnum.PART);
                }
            }
        }
    }

    private void processDir(File dir, Stack paths) {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            String name;
            File file = files[i];
            if (file.isDirectory()) {
                paths.push(file.getName());
                this.processDir(file, paths);
                paths.pop();
                continue;
            }
            if (!file.isFile() || !Utils.acceptSuffix(name = file.getName())) continue;
            int pos = name.lastIndexOf(".");
            if (pos != -1) {
                name = name.substring(0, pos);
            }
            String fullname = this.joinPath(paths, name);
            this.addMergedMetadata(fullname);
        }
    }

    private String joinPath(Stack paths, String name) {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < paths.size(); ++i) {
            String path = (String)paths.get(i);
            if (StringUtils.isEmpty((String)path)) continue;
            buff.append(path);
            buff.append("/");
        }
        buff.append(name);
        return buff.toString();
    }

    protected final int getIntProperty(String key) {
        String str = this.getStringProperty(key);
        try {
            return Integer.parseInt(str);
        }
        catch (Throwable e) {
            log.warn((Object)("getInt[key=" + key + "] from properties error!"));
            return -1;
        }
    }

    protected final void setIntProperty(String key, int value) {
        String str = String.valueOf(value);
        this.setStringProperty(key, str);
    }

    public Date getCreateTime() {
        return this.getDateProperty(KEY_CREATE_TIME);
    }

    public Date getModifyTime() {
        return this.getDateProperty(KEY_MODIFY_TIME);
    }

    public Date getSaveTime() {
        return this.getDateProperty(KEY_SAVE_TIME);
    }

    public int getPSStatus() {
        int status = this.getIntProperty(KEY_PROCESS_STATUS);
        if (status == -1) {
            return 1;
        }
        return status;
    }

    public void input(Request req) throws WorkspaceException {
        log.info((Object)"[Process] begin Input");
        this.checkOpenStatus(1);
        if (null == req) {
            log.error((Object)"null Request for ws");
            throw new IllegalArgumentException("null Request for ws");
        }
        log.info((Object)("M0 : " + req.getNameM0()));
        try {
            req.setNameM1(new File(this.home, "m1m").getCanonicalPath() + File.pathSeparator + req.getNameM1());
        }
        catch (IOException ioe) {
            log.error((Object)ioe, (Throwable)ioe);
        }
        log.info((Object)("M1 : " + req.getNameM1()));
        log.info((Object)("M2 : " + req.getNameM2()));
        req.copy2ws(this);
        this.setIntProperty(KEY_PROCESS_STATUS, 2);
    }

    public void load() throws WorkspaceException {
        log.info((Object)"[Process] begin Load");
        this.checkOpenStatus(2);
        try {
            Context ctx = new Context();
            ctx.put((Object)"METADATAPATH", (Object)"");
            XMLLoader xmlLoader = new XMLLoader(ctx, new String[0]);
            BOSTypeHelper helper = new BOSTypeHelper(xmlLoader);
            String path_ext = this.getStringProperty(KEY_M0_PATH_EXT);
            String path = this.getStringProperty(KEY_M0_PATH);
            this.m0 = new Loader3(path_ext, path, xmlLoader, helper);
            this.m0.setWriter(this.mrWriter);
            path_ext = this.getStringProperty(KEY_M1_PATH_EXT);
            path = this.getStringProperty(KEY_M1_PATH);
            this.m1 = new Loader3(path_ext, path, xmlLoader, helper);
            this.m1.setWriter(this.mrWriter);
            path_ext = this.getStringProperty(KEY_M2_PATH_EXT);
            path = this.getStringProperty(KEY_M2_PATH);
            this.m2 = new Loader3(path_ext, path, xmlLoader, helper);
            this.m2.setWriter(this.mrWriter);
            this.mn = new Loader3(new File(this.home, "mn").getPath(), path, xmlLoader, helper);
            this.mn.setMergeModel(this.mergeModel);
            this.mn.setWriter(this.mrWriter);
            this.delta = new Solution(new File(this.home, "delta").getCanonicalPath());
            this.conflict = new Solution(new File(this.home, "conflict").getCanonicalPath());
        }
        catch (Exception e) {
            log.error((Object)"Load m0 m1 m2 mn error.", (Throwable)e);
            throw new WorkspaceException("Load m0 m1 m2 mn error.", e);
        }
        this.setIntProperty(KEY_PROCESS_STATUS, 4);
    }

    public void diff1() throws WorkspaceException {
        log.info((Object)"[Process] begin Diff1");
        this.checkOpenStatus(4);
        try {
            TreeSet<String> needDiff2 = new TreeSet<String>();
            TreeSet all = new TreeSet();
            Set keysM0 = this.m0.getEntrys();
            Set keysM1 = this.m1.getEntrys();
            Set keysM2 = this.m2.getEntrys();
            all.addAll(keysM0);
            all.addAll(keysM1);
            all.addAll(keysM2);
            for (String entry : all) {
                if (!this.needMerge(entry)) continue;
                if (keysM0.contains(entry)) {
                    if (keysM1.contains(entry)) {
                        if (keysM2.contains(entry)) {
                            if (!Loader3.modified(entry, this.m1, this.m0)) {
                                this.mn.tag(entry, this.m2);
                                continue;
                            }
                            if (!Loader3.modified(entry, this.m2, this.m0)) {
                                needDiff2.add(entry);
                                continue;
                            }
                            needDiff2.add(entry);
                            continue;
                        }
                        if (!Loader3.modified(entry, this.m1, this.m0)) {
                            this.mrWriter.println("warn," + entry + ",\"M2\u5220\u9664\"");
                            continue;
                        }
                        Loader3.copyFromLoader(entry, this.m1, this.mn);
                        this.mrWriter.println("warn," + entry + ",\"M1\u4fee\u6539 M2\u5220\u9664\"");
                        continue;
                    }
                    if (!keysM2.contains(entry)) continue;
                    this.mn.tag(entry, this.m2);
                    if (!Loader3.modified(entry, this.m2, this.m0)) {
                        this.mrWriter.println("warn," + entry + ",\"M1\u5220\u9664\"");
                        continue;
                    }
                    this.mrWriter.println("warn," + entry + ",\"M1\u5220\u9664 M2\u4fee\u6539\"");
                    continue;
                }
                if (keysM1.contains(entry)) {
                    if (keysM2.contains(entry)) {
                        Loader3.copyFromLoader(entry, this.m2, this.mn);
                        this.mrWriter.println("info," + entry + ",\"M1\u589e\u52a0 M2\u589e\u52a0 \u81ea\u52a8\u505a\u5408\u5e76\"");
                        this.mergeM1M2(entry);
                        continue;
                    }
                    Loader3.copyFromLoader(entry, this.m1, this.mn);
                    continue;
                }
                if (!keysM2.contains(entry)) continue;
                this.mn.tag(entry, this.m2);
                this.mrWriter.println("info," + entry + ",\"M2\u589e\u52a0\"");
            }
            this.needDiff2 = needDiff2;
        }
        catch (Exception e) {
            log.error((Object)"Diff and Merge m1 to mn", (Throwable)e);
            throw new MergeException("Diff and Merge m1 to mn", e);
        }
        this.setIntProperty(KEY_PROCESS_STATUS, 16);
    }

    private void mergeM1M2(String entry) {
        if (entry.endsWith(".mdbview")) {
            return;
        }
        try {
            ResEntry r1 = this.m1.ensure(entry);
            ResEntry r2 = this.m2.ensure(entry);
            InputStream is1 = null;
            InputStream is2 = null;
            if (r1.f != null && r2.f != null) {
                is1 = r1.f.getInputStream(entry);
                is2 = r2.f.getInputStream(entry);
            } else if (r1.f == null && r2.f == null) {
                is1 = r1.b.getInputStream(entry);
                is2 = r2.b.getInputStream(entry);
            } else {
                is1 = r1.b.getInputStream(entry);
                is2 = r2.f.getInputStream(entry);
            }
            Document doc1 = XMLParser.parseXML((InputStream)is1);
            Document doc2 = XMLParser.parseXML((InputStream)is2);
            is1.close();
            is2.close();
            BOSObjectType type = Loader3.entryName2BOSType(entry);
            Document doc3 = this.assembler.merge(this.metametaLoader.loadMeta(type), doc2, doc1);
            ResEntry rn = this.mn.ensure(entry);
            OutputStream os = rn.f.getOutputStream(entry);
            XmlUtils.output(doc3, os);
            os.flush();
            os.close();
            this.addMergedElement(entry, "mergeM1M2");
        }
        catch (Exception e) {
            log.error((Object)("\u76f4\u63a5\u5408\u5e76M1M2\u9519\u8bef\uff0centry = " + entry), (Throwable)e);
            this.mrWriter.println("error," + entry + ",\"\u76f4\u63a5\u5408\u5e76M1M2\u9519\u8bef" + StringUtils.stackToString((Exception)e) + "\"");
        }
    }

    public void diff2(Set needDiff2) throws WorkspaceException {
        log.info((Object)"[Process] begin Diff2");
        log.info((Object)("needDiff2 size: " + needDiff2.size()));
        this.checkOpenStatus(16);
        SolutionTravel travel = new SolutionTravel(this);
        travel.process(needDiff2);
        this.setIntProperty(KEY_PROCESS_STATUS, 32);
    }

    public void merge1() throws WorkspaceException {
        log.info((Object)"[Process] begin Merge1");
        this.checkOpenStatus(32);
        this.setIntProperty(KEY_PROCESS_STATUS, 64);
    }

    public void merge2() throws WorkspaceException {
        log.info((Object)"[Process] begin Merge2");
        this.checkOpenStatus(64);
        this.setIntProperty(KEY_PROCESS_STATUS, 128);
    }

    public void merge3() throws WorkspaceException {
        log.info((Object)"[Process] begin Merge3");
        this.checkOpenStatus(128);
        this.setIntProperty(KEY_PROCESS_STATUS, 256);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() throws WorkspaceException {
        long start = System.currentTimeMillis();
        this.open();
        Element root = this.jdfactory.element("metadatas");
        this.mergedDoc = this.jdfactory.document(root);
        root.addContent(this.jdfactory.element(MERGED_METADATAS));
        try {
            File file = new File(this.home, MERGED_RESULT);
            this.mrWriter = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            this.mrWriter.println("\u65e5\u5fd7\u7ea7\u522b(error\u548cfatal\u5fc5\u987b\u4fee\u590d),\u5143\u6570\u636e,\u63cf\u8ff0(M0\u8868\u793a\u57fa\u7ebf\u5143\u6570\u636e;M1\u8868\u793a\u5ba2\u6237\u5316\u5143\u6570\u636e;M2\u8868\u793a\u65b0\u7248\u672c\u5143\u6570\u636e)");
        }
        catch (IOException e1) {
            log.error((Object)e1, (Throwable)e1);
        }
        int status = this.getPSStatus();
        switch (status) {
            case 1: {
                break;
            }
            case 2: {
                this.load();
            }
            case 4: {
                this.diff1();
            }
            case 16: {
                this.diff2(this.needDiff2);
            }
            case 32: {
                this.merge1();
            }
            case 64: {
                this.merge2();
            }
            case 128: {
                break;
            }
        }
        File file = new File(this.home, MERGED_FILE__NAME);
        try {
            XmlUtils.output(this.mergedDoc, new BufferedOutputStream(new FileOutputStream(file)));
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        this.mrWriter.close();
        File mn = new File(this.home, "mn");
        try {
            MetadataIndexer.processBOIndex(mn, mn.getPath());
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        if (MergeModelEnum.PART.equals((Object)this.mergeModel)) {
            FileOutputStream fos = null;
            try {
                Properties prop = new Properties();
                this.genMD5(mn, mn, prop);
                fos = new FileOutputStream(new File(mn, "md5.properties"));
                prop.store(fos, "");
            }
            catch (Throwable t) {
                log.warn((Object)t, t);
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        log.info((Object)("\u6d88\u8017\u65f6\u95f4 " + (System.currentTimeMillis() - start) / 1000L + " \u79d2"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void genMD5(File dir, File root, Properties prop) {
        File[] children = dir.listFiles();
        if (children != null && children.length > 0) {
            for (int i = 0; i < children.length; ++i) {
                File child = children[i];
                if (child.isDirectory()) {
                    this.genMD5(child, root, prop);
                    continue;
                }
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(child);
                    md5 m5 = new md5((InputStream)fis);
                    m5.getDigest();
                    String value = m5.getStringDigest();
                    String key = child.getAbsolutePath().substring(root.getAbsolutePath().length());
                    key = key.replace('\\', '/');
                    if (key.startsWith("/")) {
                        key = key.substring(1);
                    }
                    prop.put(key, value);
                    continue;
                }
                catch (Exception e) {
                    log.warn((Object)e, (Throwable)e);
                    continue;
                }
                finally {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        }
    }

    void addMergedElement(String entry, String remark) {
        Element ele = this.jdfactory.element(MERGED_METADATA);
        ele.setAttribute("pk", entry);
        ele.setAttribute("remark", remark);
        this.mergedDoc.getRootElement().getChild(MERGED_METADATAS).addContent(ele);
    }

    public MergeModelEnum getMergeModel() {
        return this.mergeModel;
    }

    public void setMergeModel(MergeModelEnum mergeModel) {
        this.mergeModel = mergeModel;
    }

    public void addMergedPackage(String pkgName) {
        this.pkgs.add(pkgName.replace('.', '/'));
    }

    public void addMergedMetadata(String pk) {
        this.mds.add(pk.replace('.', '/'));
    }

    public boolean needMerge(String entry) {
        if (MergeModelEnum.WHOLE.equals((Object)this.mergeModel) || MergeModelEnum.PLUGIN.equals((Object)this.mergeModel)) {
            return true;
        }
        for (String pkg : this.pkgs) {
            if (!entry.startsWith(pkg)) continue;
            return true;
        }
        int i = entry.lastIndexOf(46);
        if (i > 0) {
            entry = entry.substring(0, i);
        }
        for (String md : this.mds) {
            if (!entry.equals(md)) continue;
            return true;
        }
        return false;
    }

    public MergeResult getMergeResult() throws Exception {
        File file = new File(this.home, MERGED_RESULT);
        return WorkSpace.getMergeResult(file.getAbsolutePath());
    }

    public static MergeResult getMergeResult(String mrcsv) throws Exception {
        String[] sa;
        if (!new File(mrcsv).exists()) {
            return null;
        }
        MergeResult mr = new MergeResult();
        BufferedReader br = new BufferedReader(new FileReader(mrcsv));
        String s = br.readLine();
        if (s != null && (sa = s.split(",")).length >= 3) {
            MergeResultItem head = new MergeResultItem(sa[0], sa[1], sa[2]);
            mr.setHead(head);
        }
        while ((s = br.readLine()) != null) {
            sa = s.split(",");
            if (sa.length < 3) continue;
            MergeResultItem item = new MergeResultItem(sa[0], sa[1], sa[2]);
            mr.addItem(item);
        }
        return mr;
    }
}

