/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bizrule.RuleSetInfo;
import com.kingdee.bos.metadata.bizunit.BizUnitCollection;
import com.kingdee.bos.metadata.bizunit.BizUnitCtrl;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.bo.MethodCollection;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.data.ColumnCollection;
import com.kingdee.bos.metadata.data.DataTableCollection;
import com.kingdee.bos.metadata.data.DataTableCtrl;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.data.ForeignKeyCollection;
import com.kingdee.bos.metadata.data.IndexCollection;
import com.kingdee.bos.metadata.entity.EntityObjectCollection;
import com.kingdee.bos.metadata.entity.EntityObjectCtrl;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.event.EventCollection;
import com.kingdee.bos.metadata.event.EventInfo;
import com.kingdee.bos.metadata.event.FormalParameterInfo;
import com.kingdee.bos.metadata.function.FunctionObjectCollection;
import com.kingdee.bos.metadata.function.FunctionObjectCtrl;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationCollection;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.metadata.function.UIActionRefInfo;
import com.kingdee.bos.metadata.management.PackageCollection;
import com.kingdee.bos.metadata.management.PackageCtrl;
import com.kingdee.bos.metadata.management.PackageInfo;
import com.kingdee.bos.metadata.query.JoinQueryCtrl;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.PropertyUnitCollection;
import com.kingdee.bos.metadata.query.QueryCollection;
import com.kingdee.bos.metadata.query.QueryCtrl;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.QuerySorterItemCollection;
import com.kingdee.bos.metadata.query.SubObjectCollection;
import com.kingdee.bos.metadata.ui.ActionCollection;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.DataObjectCollection;
import com.kingdee.bos.metadata.ui.StatusCollection;
import com.kingdee.bos.metadata.ui.StatusInfo;
import com.kingdee.bos.metadata.ui.UIObjectCollection;
import com.kingdee.bos.metadata.ui.UIObjectCtrl;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

public class MetadataUDFUpdater {
    private static final Logger log = Logger.getLogger((String)"com.kingdee.bos.metadata.util.MetadataUDFUpdater");
    private String metadataRootPathName = null;
    private DataTableCtrl tableCtrl = null;
    private EntityObjectCtrl entityCtrl = null;
    private QueryCtrl queryCtrl = null;
    private JoinQueryCtrl joinQueryCtrl = null;
    private UIObjectCtrl uiCtrl = null;
    private PackageCtrl packageCtrl = null;
    private FunctionObjectCtrl functionCtrl = null;
    private BizUnitCtrl bizUnitCtrl = null;
    private static final boolean USERDEFINED = true;

    public static void main(String[] args) throws IOException {
        if (args == null || args.length == 0) {
            log.debug((Object)"\u8bf7\u8f93\u5165\u53c2\u6570\uff1a\u5143\u6570\u636e\u6839\u76ee\u5f55\u548c\u5305\u540d\uff0cMetadataUDFUpdater C:\\metadata com.kingdee.eas.basedata");
            return;
        }
        if (args.length == 1) {
            new MetadataUDFUpdater().update(args[0], null);
        } else {
            new MetadataUDFUpdater().update(args[0], args[1]);
        }
    }

    public void update(String metadataRootPathName, String packageName) throws IOException {
        File metadataRootPath = new File(metadataRootPathName);
        if (!metadataRootPath.exists()) {
            log.debug((Object)("\u5143\u6570\u636e\u6839\u76ee\u5f55" + metadataRootPathName + "\u4e0d\u5b58\u5728\uff01"));
            return;
        }
        this.metadataRootPathName = metadataRootPath.getAbsolutePath();
        try {
            this.packageCtrl = new PackageCtrl(this.getContext());
            this.entityCtrl = new EntityObjectCtrl(this.getContext());
            this.tableCtrl = new DataTableCtrl(this.getContext());
            this.queryCtrl = new QueryCtrl(this.getContext());
            this.joinQueryCtrl = new JoinQueryCtrl(this.getContext());
            this.uiCtrl = new UIObjectCtrl(this.getContext());
            this.functionCtrl = new FunctionObjectCtrl(this.getContext());
            this.bizUnitCtrl = new BizUnitCtrl(this.getContext());
        }
        catch (Exception e) {
            log.debug((Object)("\u5143\u5143\u6570\u636e\u88c5\u8f7d\u5931\u8d25\uff01\u53ef\u80fd\u5f15\u7528\u7684\u7c7b\u8def\u5f84\u4e2d\u6ca1\u6709metametas.jar\u5305\u3002\n" + e.toString()));
            return;
        }
        log.debug((Object)"\u5f00\u59cb\u904d\u5386\u5143\u6570\u636e\u76ee\u5f55...");
        try {
            this.updatePackage(packageName);
            this.updateTable(packageName);
            this.updateEntity(packageName);
            this.updateQuery(packageName);
            this.updateFunction(packageName);
            this.updateUIObject(packageName);
            this.updateBizUnit(packageName);
        }
        catch (BOSException e) {
            log.debug((Object)("\u5143\u6570\u636e\u66f4\u65b0\u5931\u8d25\uff01\n" + e.toString()));
            return;
        }
        log.debug((Object)"\u5143\u6570\u636e\u66f4\u65b0\u5b8c\u6bd5!");
    }

    public void setUserDefined(RuleSetInfo ruleSet, boolean userDefined) {
        ruleSet.setUserDefined(userDefined);
    }

    public void setUserDefined(RelationshipInfo rlation, boolean userDefined) {
        rlation.setUserDefined(userDefined);
    }

    public void setUserDefined(DataTableInfo table, boolean userDefined) {
        table.setUserDefined(userDefined);
        ColumnCollection columnCol = table.getColumns();
        int n = columnCol.size();
        for (int i = 0; i < n; ++i) {
            columnCol.get(i).setUserDefined(userDefined);
        }
        if (table.getPrimaryKey() != null) {
            table.getPrimaryKey().setUserDefined(userDefined);
        }
        IndexCollection indexCol = table.getIndexes();
        int n2 = indexCol.size();
        for (int i = 0; i < n2; ++i) {
            indexCol.get(i).setUserDefined(userDefined);
        }
        ForeignKeyCollection fkCol = table.getForeignKeys();
        int n3 = fkCol.size();
        for (int i = 0; i < n3; ++i) {
            fkCol.get(i).setUserDefined(userDefined);
        }
    }

    public void setUserDefined(EntityObjectInfo entity, boolean userDefined) {
        entity.setUserDefined(userDefined);
        PropertyCollection propCol = entity.getProperties();
        int n = propCol.size();
        for (int i = 0; i < n; ++i) {
            propCol.get(i).setUserDefined(userDefined);
            if (!(propCol.get(i) instanceof LinkPropertyInfo)) continue;
            ((LinkPropertyInfo)propCol.get(i)).getRelationship().setUserDefined(userDefined);
        }
        MethodCollection methodCol = entity.getMethods();
        int n2 = methodCol.size();
        for (int i = 0; i < n2; ++i) {
            MethodInfo method = methodCol.get(i);
            method.setUserDefined(userDefined);
            int m = method.getParameters().size();
            for (int j = 0; j < m; ++j) {
                method.getParameters().get(j).setUserDefined(userDefined);
            }
        }
        if (entity.getLogicalKey() != null) {
            entity.getLogicalKey().setUserDefined(userDefined);
        }
        EventCollection eventCol = entity.getEvents();
        int n3 = eventCol.size();
        for (int i = 0; i < n3; ++i) {
            EventInfo event = eventCol.get(i);
            event.setUserDefined(userDefined);
            int m = event.getFormalParameters().size();
            for (int j = 0; j < m; ++j) {
                FormalParameterInfo parameter = event.getFormalParameters().get(j);
                parameter.setUserDefined(userDefined);
                if (parameter.getParameter() == null) continue;
                parameter.getParameter().setUserDefined(userDefined);
            }
        }
    }

    public void setUserDefined(QueryInfo query, boolean userDefined) {
        query.setUserDefined(userDefined);
        PropertyUnitCollection propUnitCol = query.getUnits();
        int n = propUnitCol.size();
        for (int i = 0; i < n; ++i) {
            propUnitCol.get(i).setUserDefined(userDefined);
        }
        SubObjectCollection subObjectCol = query.getSubObjects();
        int n2 = subObjectCol.size();
        for (int i = 0; i < n2; ++i) {
            subObjectCol.get(i).setUserDefined(userDefined);
        }
        QuerySorterItemCollection sorterItemCol = query.getDefaultSorters();
        int n3 = sorterItemCol.size();
        for (int i = 0; i < n3; ++i) {
            sorterItemCol.get(i).setUserDefined(userDefined);
        }
    }

    public void setUserDefined(UIObjectInfo uiObject, boolean userDefined) {
        uiObject.setUserDefined(userDefined);
        ComponentCollection componentCol = uiObject.getComponents();
        int n = componentCol.size();
        for (int i = 0; i < n; ++i) {
            int j;
            ComponentInfo component = componentCol.get(i);
            component.setUserDefined(userDefined);
            int m = component.getProperties().size();
            for (j = 0; j < m; ++j) {
                component.getProperties().get(j).setUserDefined(userDefined);
            }
            m = component.getPropertyBindings().size();
            for (j = 0; j < m; ++j) {
                component.getPropertyBindings().get(j).setUserDefined(userDefined);
            }
            m = component.getEventBindings().size();
            for (j = 0; j < m; ++j) {
                component.getEventBindings().get(j).setUserDefined(userDefined);
            }
        }
        ActionCollection actionCol = uiObject.getActions();
        int n2 = actionCol.size();
        for (int i = 0; i < n2; ++i) {
            actionCol.get(i).setUserDefined(userDefined);
        }
        DataObjectCollection dataObjCol = uiObject.getDataObjects();
        int n3 = dataObjCol.size();
        for (int i = 0; i < n3; ++i) {
            dataObjCol.get(i).setUserDefined(userDefined);
        }
        StatusCollection statusCol = uiObject.getStatuses();
        int n4 = statusCol.size();
        for (int i = 0; i < n4; ++i) {
            StatusInfo status = statusCol.get(i);
            status.setUserDefined(userDefined);
            int m = status.getStatusItems().size();
            for (int j = 0; j < m; ++j) {
                status.getStatusItems().get(j).setUserDefined(userDefined);
            }
        }
    }

    public void setUserDefined(PackageInfo pack, boolean userDefined) {
        pack.setUserDefined(userDefined);
    }

    public void setUserDefined(BizUnitInfo bizUnit, boolean userDefined) {
        bizUnit.setUserDefined(userDefined);
    }

    public void setUserDefined(FunctionObjectInfo function, boolean userDefined) {
        function.setUserDefined(userDefined);
        OperationCollection operationCol = function.getOperation();
        int n = operationCol.size();
        for (int i = 0; i < n; ++i) {
            OperationInfo operation = operationCol.get(i);
            operation.setUserDefined(userDefined);
            operation.getExtendedProperties().put("userDefined", String.valueOf(userDefined));
            UIActionRefInfo uiActionRef = operation.getUiActionRef();
            if (uiActionRef == null) continue;
            uiActionRef.setUserDefined(userDefined);
            int m = uiActionRef.getParameters().size();
            for (int j = 0; j < m; ++j) {
                uiActionRef.getParameters().get(j).setUserDefined(userDefined);
            }
        }
    }

    private void updateEntity(String packageName) throws BOSException {
        log.debug((Object)"\u5f00\u59cb\u66f4\u65b0\u5b9e\u4f53\u5143\u6570\u636e...");
        EntityObjectCollection entityCol = StringUtils.isEmpty((String)packageName) ? this.entityCtrl.getCollection() : this.entityCtrl.getCollection(packageName);
        int n = entityCol.size();
        for (int i = 0; i < n; ++i) {
            EntityObjectInfo entity = entityCol.get(i);
            this.setUserDefined(entity, true);
            this.entityCtrl.update(MetaDataPK.create(entity.getFullName()), entity);
        }
        log.debug((Object)"\u66f4\u65b0\u5b9e\u4f53\u5143\u6570\u636e\u5b8c\u6bd5!");
    }

    private void updateTable(String packageName) throws BOSException {
        log.debug((Object)"\u5f00\u59cb\u66f4\u65b0\u6570\u636e\u8868\u5143\u6570\u636e...");
        DataTableCollection tableCol = StringUtils.isEmpty((String)packageName) ? this.tableCtrl.getCollection() : this.tableCtrl.getCollection(packageName);
        int n = tableCol.size();
        for (int i = 0; i < n; ++i) {
            DataTableInfo table = tableCol.get(i);
            this.setUserDefined(table, true);
            this.tableCtrl.update(MetaDataPK.create(table.getFullName()), table);
        }
        log.debug((Object)"\u66f4\u65b0\u6570\u636e\u8868\u5143\u6570\u636e\u5b8c\u6bd5!");
    }

    private void updateQuery(String packageName) throws BOSException {
        log.debug((Object)"\u5f00\u59cb\u66f4\u65b0\u67e5\u8be2\u5143\u6570\u636e...");
        QueryCollection queryCol = StringUtils.isEmpty((String)packageName) ? this.queryCtrl.getCollection() : this.queryCtrl.getCollection(packageName);
        int n = queryCol.size();
        for (int i = 0; i < n; ++i) {
            QueryInfo query = queryCol.get(i);
            if (!(query instanceof JoinQueryInfo)) continue;
            this.setUserDefined(query, true);
            this.joinQueryCtrl.update(MetaDataPK.create(query.getFullName()), (JoinQueryInfo)query);
        }
        log.debug((Object)"\u66f4\u65b0\u67e5\u8be2\u5143\u6570\u636e\u5b8c\u6bd5!");
    }

    private void updateUIObject(String packageName) throws BOSException {
        log.debug((Object)"\u5f00\u59cb\u66f4\u65b0\u754c\u9762\u5143\u6570\u636e...");
        UIObjectCollection uiCol = StringUtils.isEmpty((String)packageName) ? this.uiCtrl.getRawCollection() : this.uiCtrl.getRawCollection(packageName);
        int n = uiCol.size();
        for (int i = 0; i < n; ++i) {
            UIObjectInfo uiObject = uiCol.get(i);
            this.setUserDefined(uiObject, true);
            this.uiCtrl.rawUpdate(MetaDataPK.create(uiObject.getFullName()), uiObject);
        }
        log.debug((Object)"\u66f4\u65b0\u754c\u9762\u5143\u6570\u636e\u5b8c\u6bd5!");
    }

    private void updatePackage(String packageName) throws BOSException {
        log.debug((Object)"\u5f00\u59cb\u66f4\u65b0\u5305\u5143\u6570\u636e...");
        PackageCollection packageCol = StringUtils.isEmpty((String)packageName) ? this.packageCtrl.getCollection() : this.packageCtrl.getCollection(packageName);
        int n = packageCol.size();
        for (int i = 0; i < n; ++i) {
            PackageInfo pack = packageCol.get(i);
            this.setUserDefined(pack, true);
            this.packageCtrl.update(MetaDataPK.create(pack.getFullName()), pack);
        }
        log.debug((Object)"\u66f4\u65b0\u5305\u5143\u6570\u636e\u5b8c\u6bd5!");
    }

    private void updateFunction(String packageName) throws BOSException {
        log.debug((Object)"\u5f00\u59cb\u66f4\u65b0\u529f\u80fd\u5143\u6570\u636e...");
        FunctionObjectCollection functionCol = StringUtils.isEmpty((String)packageName) ? this.functionCtrl.getCollection() : this.functionCtrl.getCollection(packageName);
        int n = functionCol.size();
        for (int i = 0; i < n; ++i) {
            FunctionObjectInfo function = functionCol.get(i);
            this.setUserDefined(function, true);
            this.functionCtrl.update(MetaDataPK.create(function.getFullName()), function);
        }
        log.debug((Object)"\u66f4\u65b0\u529f\u80fd\u5143\u6570\u636e\u5b8c\u6bd5!");
    }

    private void updateBizUnit(String packageName) throws BOSException {
        log.debug((Object)"\u5f00\u59cb\u66f4\u65b0\u4e1a\u52a1\u5355\u5143\u5143\u6570\u636e...");
        BizUnitCollection bizUnitCol = StringUtils.isEmpty((String)packageName) ? this.bizUnitCtrl.getCollection() : this.bizUnitCtrl.getCollection(packageName);
        int n = bizUnitCol.size();
        for (int i = 0; i < n; ++i) {
            BizUnitInfo bizUnit = bizUnitCol.get(i);
            this.setUserDefined(bizUnit, true);
            this.bizUnitCtrl.update(MetaDataPK.create(bizUnit.getFullName()), bizUnit);
        }
        log.debug((Object)"\u66f4\u65b0\u4e1a\u52a1\u5355\u5143\u5143\u6570\u636e\u5b8c\u6bd5!");
    }

    private Context getContext() {
        Context ctx = new Context();
        ctx.put((Object)"current_mode", (Object)"DEBUG");
        ctx.put((Object)"METADATAPATH", (Object)this.metadataRootPathName);
        return ctx;
    }
}

