/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.util;

import com.kingdee.bos.metadata.ui.AbstractUIObjectInfo;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.metadata.webcomponent.WebComponentObjectInfo;
import com.kingdee.bos.metadata.webcontrol.WebControlObjectInfo;
import com.kingdee.bos.metadata.webpage.WebPageObjectInfo;
import com.kingdee.bos.metadata.webui.WebUIObjectInfo;
import org.apache.log4j.Logger;

public class UIUtils {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.metadata.util.UIUtils");

    public static AbstractUIObjectInfo getParent(AbstractUIObjectInfo aui) {
        if (aui instanceof UIObjectInfo) {
            UIObjectInfo ui = (UIObjectInfo)aui;
            return ui.getParent();
        }
        if (aui instanceof WebUIObjectInfo) {
            WebUIObjectInfo wui = (WebUIObjectInfo)aui;
            return wui.getParent();
        }
        if (aui instanceof WebPageObjectInfo) {
            WebPageObjectInfo ui = (WebPageObjectInfo)aui;
            return ui.getParent();
        }
        if (aui instanceof WebComponentObjectInfo) {
            WebComponentObjectInfo wui = (WebComponentObjectInfo)aui;
            return wui.getParent();
        }
        if (aui instanceof WebControlObjectInfo) {
            WebControlObjectInfo wui = (WebControlObjectInfo)aui;
            return wui.getParent();
        }
        return aui;
    }

    public static void setParent(AbstractUIObjectInfo aui, AbstractUIObjectInfo parent) {
        if (aui instanceof UIObjectInfo && parent instanceof UIObjectInfo) {
            UIObjectInfo ui = (UIObjectInfo)aui;
            ui.setParent((UIObjectInfo)parent);
        } else if (aui instanceof WebUIObjectInfo && parent instanceof WebUIObjectInfo) {
            WebUIObjectInfo wui = (WebUIObjectInfo)aui;
            wui.setParent((WebUIObjectInfo)parent);
        } else if (aui instanceof WebPageObjectInfo && parent instanceof WebPageObjectInfo) {
            WebPageObjectInfo ui = (WebPageObjectInfo)aui;
            ui.setParent((WebPageObjectInfo)parent);
        } else if (aui instanceof WebComponentObjectInfo && parent instanceof WebComponentObjectInfo) {
            WebComponentObjectInfo wui = (WebComponentObjectInfo)aui;
            wui.setParent((WebComponentObjectInfo)parent);
        } else if (aui instanceof WebComponentObjectInfo && parent instanceof WebControlObjectInfo) {
            WebControlObjectInfo wui = (WebControlObjectInfo)aui;
            wui.setParent((WebControlObjectInfo)parent);
        }
    }

    public static int[] getSideAnchor(int anchor) {
        int right;
        int left;
        int bottom;
        int top = anchor & 1;
        if (top == 0) {
            top = (anchor >> 5 & 1) << 5;
        }
        if ((bottom = (anchor >> 1 & 1) << 1) == 0) {
            bottom = (anchor >> 6 & 1) << 6;
        }
        if ((left = (anchor >> 2 & 1) << 2) == 0) {
            left = (anchor >> 7 & 1) << 7;
        }
        if ((right = (anchor >> 3 & 1) << 3) == 0) {
            right = (anchor >> 8 & 1) << 8;
        }
        int center = anchor >> 4 & 1;
        int[] ret = new int[]{top, bottom, left, right, center};
        return ret;
    }

    public static void printComponentDOM(ComponentInfo cInfo, int deep) {
        String len = "    ";
        String tap = "";
        for (int i = 0; i < deep; ++i) {
            tap = tap + len;
        }
        if (cInfo != null) {
            logger.info((Object)(tap + cInfo.getName() + " - " + cInfo.getClassType() + "-" + (cInfo.getParent() == null ? "null" : cInfo.getParent().getName())));
            ComponentCollection cols = cInfo.getComponents();
            int size = cols.size();
            for (int i = 0; i < size; ++i) {
                UIUtils.printComponentDOM(cols.get(i), deep + 1);
            }
        }
    }
}

