/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.validate.impl;

import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueCollection;
import com.kingdee.bos.metadata.validate.VerifyReport;
import com.kingdee.bos.metadata.validate.VerifyUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CheckEnumItem
extends VerifyUnit {
    private static final String ENUM_ITEM_REGEX = "\\p{Upper}{1}[A-Z0-9]*";

    @Override
    public boolean check(VerifyReport report) {
        assert (this.getTarget() instanceof BizEnumInfo);
        BizEnumInfo bizenum = (BizEnumInfo)this.getTarget();
        BizEnumValueCollection items = bizenum.getEnumValue();
        Pattern pattern = Pattern.compile(ENUM_ITEM_REGEX);
        int size = items.size();
        for (int i = 0; i < size; ++i) {
            String n = items.get(i).getName();
            String[] words = n.split("_");
            int length = words.length;
            for (int j = 0; j < length; ++j) {
                Matcher m = pattern.matcher(words[j]);
                if (m.matches()) continue;
                report.addWarning("Invalid eas name of Enum's item :" + words[j]);
                return false;
            }
        }
        return true;
    }
}

