/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.view;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.xml.Utils;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.InnerMetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.metadata.view.IMetaDataBriefViewBuilder;
import com.kingdee.bos.metadata.view.IMetaDataBriefViewCtrl;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.metadata.view.MetaDataBriefViewInfo;
import com.kingdee.bos.metadata.view.StoreTask;
import com.kingdee.bos.metadata.view.SubSystemUtils;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class BusinessObjectBriefViewGenerator {
    private final IMetaDataLoader loader;
    private final IMetaDataBriefViewCtrl viewCtrl;
    private static final Logger logger = Logger.getLogger(BusinessObjectBriefViewGenerator.class);
    public static ExecutorService pool = Executors.newCachedThreadPool();
    private static Map<String, BusinessObjectBriefViewGenerator> generators = new HashMap<String, BusinessObjectBriefViewGenerator>(2);

    private BusinessObjectBriefViewGenerator(String metaDataPath) throws BOSException {
        Context ctx = new Context();
        ctx.put((Object)"METADATAPATH", (Object)metaDataPath);
        this.loader = InnerMetaDataLoaderFactory.getInstance(ctx, true);
        this.viewCtrl = (IMetaDataBriefViewCtrl)BOSObjectFactory.createBOSObject(ctx, MetaDataTypeList.METADATABRIEFVIEW);
    }

    static synchronized BusinessObjectBriefViewGenerator getInstance(String metaDataPath) throws BOSException {
        BusinessObjectBriefViewGenerator g = generators.get(metaDataPath);
        if (g != null) {
            return g;
        }
        g = new BusinessObjectBriefViewGenerator(metaDataPath);
        generators.put(metaDataPath, g);
        return g;
    }

    void generate(IMetaDataBriefViewBuilder ... builders) throws BOSException {
        this.generate((String)null, builders);
    }

    void generate(String updatePkg, IMetaDataBriefViewBuilder ... builders) throws BOSException {
        MetaDataBriefViewInfo view = null;
        IBriefViewTreeNode root = null;
        for (IMetaDataBriefViewBuilder builder : builders) {
            builder.setMetaDataLoader(this.loader);
            root = builder.build(updatePkg);
            view = this.constructView(MetaDataPK.create(builder.getPackage(), builder.getName()), root);
            MetaDataPK pk = MetaDataPK.create(view.getPackage(), view.getName());
            boolean async = "true".equals(SubSystemUtils.getProperty("async", "true"));
            logger.info((Object)("BusinessObjectBriefViewGenerator.generate async:" + async));
            StoreTask task = null;
            if (StringUtils.isEmpty((String)updatePkg)) {
                if (async) {
                    task = new StoreTask(this.viewCtrl, pk, view, true);
                } else {
                    this.viewCtrl.store(pk, view);
                }
            } else {
                String[] paths = Utils.getMetadataPath(this.loader.getContext());
                if (new File(paths[0], ((Object)pk).toString() + "." + "mdbview").exists()) {
                    this.viewCtrl.update(pk, view);
                } else if (async) {
                    task = new StoreTask(this.viewCtrl, pk, view, true);
                } else {
                    this.viewCtrl.store(pk, view);
                }
            }
            if (task == null) continue;
            pool.submit(task);
        }
    }

    protected MetaDataBriefViewInfo constructView(IMetaDataPK pk, IBriefViewTreeNode root) {
        assert (root != null) : "Root cannot be null!";
        MetaDataBriefViewInfo view = null;
        IBriefViewTreeNode node = null;
        MetaDataBriefInfo meta = null;
        view = new MetaDataBriefViewInfo();
        view.setPackage(pk.getPackage());
        view.setName(pk.getName());
        Enumeration<TreeNode> e = ((DefaultMutableTreeNode)((Object)root)).breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            node = (IBriefViewTreeNode)e.nextElement();
            meta = node.getMetaDataObjectBriefInfo();
            if (node.getParent() != null) {
                meta.setParent(((IBriefViewTreeNode)node.getParent()).getFullName());
            }
            view.getMetaDataBriefs().add(meta);
        }
        return view;
    }
}

