/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.view;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.xml.XMLAccessEngine;
import com.kingdee.bos.dao.xml.XMLDAO;
import com.kingdee.bos.metadata.AbstractMetaDataCtrl;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataNotFoundException;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.view.BriefViewTreeNode;
import com.kingdee.bos.metadata.view.BusinessObjectBriefView;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.metadata.view.IMetaDataBriefViewCtrl;
import com.kingdee.bos.metadata.view.MetaDataBriefCollection;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.metadata.view.MetaDataBriefViewInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.log4j.Logger;

public class MetaDataBriefViewCtrl
extends AbstractMetaDataCtrl
implements IMetaDataBriefViewCtrl {
    private static Logger logger = Logger.getLogger(MetaDataBriefViewCtrl.class);

    public MetaDataBriefViewCtrl() {
        super.registerInterface(IMetaDataBriefViewCtrl.class, (Object)this);
        this.loadSelfMetametaData(MetaDataPK.create("metametadata.view", "metaDataBriefView"));
        this.loadSelfMetametaData(MetaDataPK.create("metametadata.facade", "facade"));
        this.loadSelfMetametaData(MetaDataPK.create("metametadata.function", "functionObject"));
        this.loadSelfMetametaData(MetaDataPK.create("metametadata.ui", "uiObject"));
        this.loadSelfMetametaData(MetaDataPK.create("metametadata.management", "package"));
    }

    public MetaDataBriefViewCtrl(Context ctx) {
        super(ctx);
        super.registerInterface(IMetaDataBriefViewCtrl.class, (Object)this);
        this.loadSelfMetametaData(MetaDataPK.create("metametadata.view", "metaDataBriefView"));
        this.loadSelfMetametaData(MetaDataPK.create("metametadata.facade", "facade"));
        this.loadSelfMetametaData(MetaDataPK.create("metametadata.function", "functionObject"));
        this.loadSelfMetametaData(MetaDataPK.create("metametadata.ui", "uiObject"));
        this.loadSelfMetametaData(MetaDataPK.create("metametadata.management", "package"));
    }

    @Override
    public BOSObjectType getType() {
        return MetaDataTypeList.METADATABRIEFVIEW;
    }

    @Override
    public MetaDataBriefViewInfo getValue(IMetaDataPK metaType) throws BOSException {
        assert (metaType != null) : "metaType cannot be null!";
        MetaDataBriefViewInfo view = (MetaDataBriefViewInfo)this.getDAO().getValue(metaType);
        if (view == null) {
            throw new MetaDataNotFoundException("Cannot found metadataview!");
        }
        return view;
    }

    @Override
    public BusinessObjectBriefView getValueAPI(IMetaDataPK metaType) throws BOSException {
        assert (metaType != null) : "metaType cannot be null!";
        MetaDataBriefViewInfo view = (MetaDataBriefViewInfo)this.getDAO().getValue(metaType);
        if (view == null) {
            throw new MetaDataNotFoundException("Cannot found metadataview!");
        }
        return new BusinessObjectBriefView(this.getRoot(view), this.createMetaDataResource());
    }

    private Map createMetaDataResource() {
        HashMap<BOSObjectType, MetaDataBriefInfo> resource = new HashMap<BOSObjectType, MetaDataBriefInfo>();
        resource.put(MetaDataTypeList.ENTITY, this.createMetaDataResource(MetaDataTypeList.ENTITY));
        resource.put(MetaDataTypeList.FACADE, this.createMetaDataResource(MetaDataTypeList.FACADE));
        resource.put(MetaDataTypeList.FUNCTION, this.createMetaDataResource(MetaDataTypeList.FUNCTION));
        resource.put(MetaDataTypeList.UIOBJECT, this.createMetaDataResource(MetaDataTypeList.UIOBJECT));
        resource.put(MetaDataTypeList.PACKAGE, this.createMetaDataResource(MetaDataTypeList.PACKAGE));
        return resource;
    }

    private MetaDataBriefInfo createMetaDataResource(BOSObjectType bosType) {
        try {
            MetaDataBriefInfo meta = new MetaDataBriefInfo();
            meta.setMetaDataType(MetaDataTypeList.PACKAGE);
            EntityObjectInfo entity = XMLAccessEngine.getXMLLoader(this.getContext()).loadMeta(bosType);
            Locale[] locales = XMLAccessEngine.getXMLLoader(this.getContext()).getSupportedLocales();
            meta.setName(entity.getName());
            int len = locales.length;
            for (int i = 0; i < len; ++i) {
                meta.setAlias(entity.getAlias(locales[i]), locales[i]);
                meta.setDescription(entity.getDescription(locales[i]), locales[i]);
            }
            return meta;
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            assert (false);
            return null;
        }
    }

    private IBriefViewTreeNode getRoot(MetaDataBriefViewInfo view) {
        HashMap<String, BriefViewTreeNode> tree = new HashMap<String, BriefViewTreeNode>();
        MetaDataBriefInfo info = null;
        MetaDataBriefCollection metas = view.getMetaDataBriefs();
        BriefViewTreeNode node = null;
        BriefViewTreeNode root = null;
        IBriefViewTreeNode parent = null;
        int size = metas.size();
        for (int i = 0; i < size; ++i) {
            info = metas.get(i);
            node = new BriefViewTreeNode(info);
            if (root == null && StringUtils.isEmpty((String)info.getParent())) {
                root = node;
            }
            if (info.getMetaDataType().equals((Object)MetaDataTypeList.PACKAGE)) {
                tree.put(info.getFullName(), node);
            }
            if ((parent = (IBriefViewTreeNode)tree.get(info.getParent())) == null) continue;
            ((DefaultMutableTreeNode)((Object)parent)).add(node);
        }
        return root;
    }

    @Override
    public void store(IMetaDataPK pk, MetaDataBriefViewInfo view) throws BOSException {
        this.getDAO().update(pk, view);
    }

    @Override
    public void update(IMetaDataPK pk, MetaDataBriefViewInfo view) throws BOSException {
        ((XMLDAO)this.getDAO()).update4Mdbview(view);
    }
}

