/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.view;

import com.kingdee.bos.BOSException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

class SubSystemHideFilter {
    private final List<Pattern> items = new ArrayList<Pattern>();
    private static final Map<String, SubSystemHideFilter> filters = new HashMap<String, SubSystemHideFilter>(2);

    private SubSystemHideFilter(String xmlPath) throws BOSException {
        if (xmlPath != null) {
            String[] xmls;
            for (String xml : xmls = xmlPath.split(";")) {
                this.initHideItem(new File(xml), this.items);
            }
        }
    }

    static SubSystemHideFilter getInstance(String xmlPath) throws BOSException {
        SubSystemHideFilter b = filters.get(xmlPath);
        if (b == null) {
            b = new SubSystemHideFilter(xmlPath);
            filters.put(xmlPath, b);
        }
        return b;
    }

    boolean hidden(String fullName) {
        if (fullName == null) {
            return false;
        }
        for (Pattern p : this.items) {
            if (!p.matcher(fullName).matches()) continue;
            return true;
        }
        return false;
    }

    private void initHideItem(File file, List<Pattern> items) throws BOSException {
        Document doc;
        try {
            doc = new SAXBuilder().build(file);
        }
        catch (Exception e) {
            throw new BOSException("HideFilter config error.", (Throwable)e);
        }
        Element root = doc.getRootElement();
        List itemElements = root.getChild("hide").getChildren("item");
        for (Element ele : itemElements) {
            items.add(Pattern.compile(ele.getText()));
        }
        List xmls = root.getChild("include").getChildren("name");
        for (Element ele : xmls) {
            String xml = ele.getText();
            File sub = new File(file.getParent(), xml);
            if (!sub.exists()) continue;
            this.initHideItem(sub, items);
        }
    }

    private void output() throws Exception {
        String fileName = "w:/SubSystemHide.xml";
        Document doc = new Document();
        Element root = new Element("subSystemHide");
        doc.setRootElement(root);
        Element include = new Element("include");
        root.addContent(include);
        include.addContent(new Element("name").setText("testxml.xml"));
        include.addContent(new Element("name").setText("testxml.xml"));
        Element hide = new Element("hide");
        root.addContent(hide);
        hide.addContent(new Element("item").setText("com.kingdee1.*"));
        hide.addContent(new Element("item").setText("com.kingdee1.eas.*"));
        XMLOutputter out = new XMLOutputter();
        File file = new File(fileName);
        if (!file.exists()) {
            file.createNewFile();
        }
        out.output(doc, (OutputStream)new FileOutputStream(fileName));
    }
}

