/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.view.listeners;

import com.kingdee.bos.dao.xml.impl.MDLoader;
import com.kingdee.bos.dao.xml.impl.MetaDataPK2;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.management.PackageInfo;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.view.ISubSystemFilter;
import com.kingdee.bos.metadata.view.MetaDataBriefCollection;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.metadata.view.MetaDataBriefViewInfo;
import com.kingdee.bos.metadata.view.listeners.MdbviewListener;
import com.kingdee.bos.util.BOSObjectType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import org.apache.log4j.Logger;

public abstract class AbstractMdbviewListener
implements MdbviewListener,
ISubSystemFilter {
    private static String ROOT = "com.kingdee.eas";
    private static String ROOT_FULLNAME = "com.kingdee.eas.eas";
    private static Logger logger = Logger.getLogger(AbstractMdbviewListener.class);

    @Override
    public void addNew(IMetaDataPK pk, MetaDataBriefViewInfo mdbv, MetaDataPK2[] pks, Project.Projects depends) {
        if (pks == null) {
            return;
        }
        if (this.getBriefViewFilter().getViewName().equals(pk.getFullName())) {
            logger.debug((Object)(this.getBriefViewFilter().getViewName() + "---addNew   begin"));
            IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader(ConfigMDUtil.getContext());
            SolutionInfo slnInfo = loader.getSolution();
            Locale[] supportedLocales = slnInfo.getSupportedLocales();
            Locale current = slnInfo.getSolutionDefaultLocale();
            for (int i = 0; i < pks.length; ++i) {
                boolean isTypeMatched = this.typeMatched(pks[i]);
                boolean isExists = this.exist(mdbv.getMetaDataBriefs(), pks[i].getFullName());
                boolean isAccept = false;
                String parent = null;
                if (isTypeMatched && !isExists) {
                    AbstractMetaDataValue meta = (AbstractMetaDataValue)loader.get(BOSObjectType.create((String)pks[i].getType()), MetaDataPK.create(pks[i].getFullName()), depends);
                    if (meta != null) {
                        isAccept = this.getBriefViewFilter().isAccept(meta);
                    }
                    if (isAccept) {
                        MetaDataBriefInfo mdbi = new MetaDataBriefInfo(current, supportedLocales, meta, true);
                        parent = this.findParent(mdbv.getMetaDataBriefs(), pks[i], depends);
                        mdbi.setParent(parent);
                        mdbi.setMetaDataType(BOSObjectType.create((String)pks[i].getType()));
                        if (meta instanceof BusinessObjectInfo) {
                            mdbi.setBOType(((BusinessObjectInfo)meta).getType());
                        }
                        mdbv.getMetaDataBriefs().add(mdbi);
                    }
                }
                logger.debug((Object)(this.getBriefViewFilter().getViewName() + "----addNew  " + pks[i].getFullName() + "  isTypeMatched:" + isTypeMatched + "  isExists:" + isExists + "  isAccept:" + isAccept + "  parent:" + parent));
            }
            logger.debug((Object)(this.getBriefViewFilter().getViewName() + "---addNew   end"));
        }
    }

    private boolean exist(MetaDataBriefCollection mdbc, String fullName) {
        for (int i = 0; i < mdbc.size(); ++i) {
            if (!fullName.equals(mdbc.get(i).getFullName())) continue;
            return true;
        }
        return false;
    }

    private String findParent(MetaDataBriefCollection mdbc, MetaDataPK2 pk2, Project.Projects depends) {
        String pn;
        String strParent;
        String parent = null;
        HashMap<String, MetaDataBriefInfo> map = new HashMap<String, MetaDataBriefInfo>();
        for (int i = 0; i < mdbc.size(); ++i) {
            MetaDataBriefInfo mdbi = mdbc.get(i);
            if (!MetaDataTypeList.PACKAGE.equals((Object)mdbi.getMetaDataType())) continue;
            String packageName = mdbi.getPackgeName();
            map.put(packageName, mdbi);
        }
        ArrayList<String> l = new ArrayList<String>();
        parent = pk2.getFullName();
        String pk2FullName = pk2.getFullName();
        while (parent.lastIndexOf(46) > 0 && !ROOT.equals(parent = parent.substring(0, parent.lastIndexOf(46)))) {
            if (!this.packageIsExist(parent, depends)) continue;
            l.add(parent);
        }
        if (l.size() > 1 && ((String)l.get(0)).endsWith(".app")) {
            l.remove(0);
        }
        parent = ROOT_FULLNAME;
        for (int i = l.size() - 1; i >= 0 && !pk2FullName.equals(strParent = this.getFullName(pn = (String)l.get(i))); --i) {
            if (!map.containsKey(pn)) {
                IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader(ConfigMDUtil.getContext());
                SolutionInfo slnInfo = loader.getSolution();
                Locale[] supportedLocales = slnInfo.getSupportedLocales();
                Locale current = slnInfo.getSolutionDefaultLocale();
                PackageInfo meta = (PackageInfo)loader.get(MetaDataTypeList.PACKAGE, MetaDataPK.create(strParent), depends);
                MetaDataBriefInfo mdbi = new MetaDataBriefInfo(current, supportedLocales, meta, true);
                mdbi.setParent(parent);
                mdbi.setMetaDataType(MetaDataTypeList.PACKAGE);
                mdbc.add(mdbi);
                map.put(pn, mdbi);
                parent = strParent;
                continue;
            }
            parent = strParent;
        }
        map.clear();
        l.clear();
        map = null;
        l = null;
        return parent;
    }

    private boolean packageIsExist(String packageName, Project.Projects depends) {
        String fullName = this.getFullName(packageName);
        return MDLoader.getInstance().cl.getMDContext().pkIndexs.isExist(MetaDataTypeList.PACKAGE, MetaDataPK.create(fullName), depends);
    }

    private String getFullName(String packageName) {
        int i = packageName.lastIndexOf(46);
        String name = i > 0 ? packageName.substring(i + 1) : packageName;
        String fullName = packageName + "." + name;
        return fullName;
    }

    @Override
    public void modify(IMetaDataPK pk, MetaDataBriefViewInfo mdbv, MetaDataPK2[] pks, Project.Projects depends) {
        if (pks == null) {
            return;
        }
        if (this.getBriefViewFilter().getViewName().equals(pk.getFullName())) {
            logger.debug((Object)(this.getBriefViewFilter().getViewName() + "---modify   begin"));
            IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader(ConfigMDUtil.getContext());
            SolutionInfo slnInfo = loader.getSolution();
            Locale[] supportedLocales = slnInfo.getSupportedLocales();
            Locale current = slnInfo.getSolutionDefaultLocale();
            HashMap<String, String> parents = new HashMap<String, String>();
            for (int i = 0; i < pks.length; ++i) {
                boolean isTypeMatched = this.typeMatched(pks[i]);
                boolean isAccept = false;
                String parent = null;
                if (isTypeMatched) {
                    AbstractMetaDataValue meta = (AbstractMetaDataValue)loader.get(BOSObjectType.create((String)pks[i].getType()), MetaDataPK.create(pks[i].getFullName()), depends);
                    MetaDataBriefCollection mdbc = mdbv.getMetaDataBriefs();
                    Iterator iterator = mdbc.iterator();
                    while (iterator.hasNext()) {
                        MetaDataBriefInfo mdbi = (MetaDataBriefInfo)iterator.next();
                        if (!mdbi.getFullName().equals(pks[i].getFullName())) continue;
                        parents.put(mdbi.getFullName(), mdbi.getParent());
                        iterator.remove();
                    }
                    if (meta != null) {
                        isAccept = this.getBriefViewFilter().isAccept(meta);
                    }
                    if (isAccept) {
                        MetaDataBriefInfo mdbi = new MetaDataBriefInfo(current, supportedLocales, meta, true);
                        parent = (String)parents.get(mdbi.getFullName());
                        if (parent == null) {
                            parent = this.findParent(mdbv.getMetaDataBriefs(), pks[i], depends);
                        }
                        mdbi.setParent(parent);
                        mdbi.setMetaDataType(BOSObjectType.create((String)pks[i].getType()));
                        if (meta instanceof BusinessObjectInfo) {
                            mdbi.setBOType(((BusinessObjectInfo)meta).getType());
                        }
                        mdbv.getMetaDataBriefs().add(mdbi);
                    }
                }
                logger.debug((Object)(this.getBriefViewFilter().getViewName() + "----modify  " + pks[i].getFullName() + "  isTypeMatched:" + isTypeMatched + "  isAccept:" + isAccept + "   parent:" + parent));
            }
            logger.debug((Object)(this.getBriefViewFilter().getViewName() + "---modify   end"));
        }
    }

    private boolean typeMatched(MetaDataPK2 pk) {
        String type = pk.getType();
        BOSObjectType[] types = this.getBriefViewFilter().getMetaDataTypeFilters();
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].toString().equals(type)) continue;
            return true;
        }
        return false;
    }
}

