/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.webcontrol;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.metadata.management.SolutionCtrl;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.ui.ActionCollection;
import com.kingdee.bos.metadata.ui.ActionInfo;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.DataObjectCollection;
import com.kingdee.bos.metadata.ui.DataObjectInfo;
import com.kingdee.bos.metadata.ui.EventBindingCollection;
import com.kingdee.bos.metadata.ui.EventBindingInfo;
import com.kingdee.bos.metadata.ui.LayoutInfo;
import com.kingdee.bos.metadata.ui.PropertyBindingCollection;
import com.kingdee.bos.metadata.ui.PropertyBindingInfo;
import com.kingdee.bos.metadata.ui.PropertyCollection;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.metadata.ui.StatusCollection;
import com.kingdee.bos.metadata.ui.StatusInfo;
import com.kingdee.bos.metadata.ui.StatusItemCollection;
import com.kingdee.bos.metadata.ui.StatusItemInfo;
import com.kingdee.bos.metadata.ui.UIControlOrderHelper;
import com.kingdee.bos.metadata.webcontrol.WebControlObjectInfo;
import com.kingdee.bos.metadata.webpage.ScriptCollection;
import com.kingdee.bos.metadata.webpage.ScriptInfo;
import com.kingdee.bos.metadata.webpage.StyleSheetCollection;
import com.kingdee.bos.metadata.webpage.StyleSheetInfo;
import com.kingdee.bos.metadata.webpage.WebActionCollection;
import com.kingdee.bos.metadata.webpage.WebActionInfo;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import org.apache.log4j.Logger;

public class WebControlObjectAssembler {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.metadata.ui.UIControlObjectAssembler");

    public static WebControlObjectInfo parseWebControl(Context ctx, WebControlObjectInfo completeModel) {
        WebControlObjectAssembler.compatibleHandleComponentTree(completeModel);
        if (completeModel.getParent() == null) {
            return completeModel;
        }
        long startTime = System.currentTimeMillis();
        WebControlObjectInfo resultModel = new WebControlObjectInfo();
        List locales = WebControlObjectAssembler.initSolutionLocales(ctx);
        WebControlObjectAssembler.initUIInfo(completeModel, resultModel, locales);
        resultModel.setComponents(WebControlObjectAssembler.parseComposites(completeModel.getComponents(), locales));
        resultModel.setDataObjects(WebControlObjectAssembler.parseDataObjects(completeModel.getDataObjects()));
        resultModel.setScripts(WebControlObjectAssembler.parseScripts(completeModel.getScripts()));
        resultModel.setStyleSheets(WebControlObjectAssembler.parseStyleSheets(completeModel.getStyleSheets()));
        resultModel.setStatuses(WebControlObjectAssembler.parseStatuses(completeModel.getStatuses(), locales));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u89e3\u6790UI\u5171\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startTime)));
        }
        resultModel.put("Resource_Last_Modified", completeModel.get("Resource_Last_Modified"));
        return resultModel;
    }

    private static void assembleWebActions(WebActionCollection completeModel, WebActionCollection currentModel, List locales) {
        assert (completeModel != null && currentModel != null);
        Iterator iter = currentModel.iterator();
        WebActionInfo currentInfo = null;
        WebActionInfo completeInfo = null;
        while (iter.hasNext()) {
            currentInfo = (WebActionInfo)iter.next();
            completeInfo = completeModel.getActionByName(currentInfo.getActionName());
            if (completeInfo == null) {
                completeModel.add(currentInfo);
                continue;
            }
            completeInfo.setHerited(true);
        }
    }

    private static WebActionCollection parseWebActions(WebActionCollection completeModel) {
        assert (completeModel != null);
        WebActionCollection resultModel = new WebActionCollection();
        Iterator iter = completeModel.iterator();
        WebActionInfo sourceInfo = null;
        while (iter.hasNext()) {
            sourceInfo = (WebActionInfo)iter.next();
            resultModel.add(sourceInfo);
        }
        return resultModel;
    }

    private static void compatibleHandleComponentTree(WebControlObjectInfo completeModel) {
        ComponentCollection collections = completeModel.getComponents();
        if (collections == null || collections.size() == 0) {
            return;
        }
        Iterator iter = collections.iterator();
        ComponentInfo info = null;
        LinkedList<ComponentInfo> list = new LinkedList<ComponentInfo>();
        while (iter.hasNext()) {
            info = (ComponentInfo)iter.next();
            list.add(info);
        }
        if (list.isEmpty()) {
            return;
        }
        iter = list.iterator();
        while (iter.hasNext()) {
            WebControlObjectAssembler.compatibleHandleComponentTree(completeModel, (ComponentInfo)iter.next());
        }
    }

    private static void compatibleHandleComponentTree(WebControlObjectInfo completeModel, ComponentInfo parentInfo) {
        if (parentInfo == null) {
            return;
        }
        ComponentCollection collections = parentInfo.getComponents();
        if (collections == null || collections.size() == 0) {
            return;
        }
        Iterator iter = collections.iterator();
        ComponentInfo info = null;
        while (iter.hasNext()) {
            info = (ComponentInfo)iter.next();
            if (completeModel.containsComponentInfo(info)) continue;
            completeModel.getComponents().add(info);
            WebControlObjectAssembler.compatibleHandleComponentTree(completeModel, info);
        }
    }

    public static StatusCollection getAllStatus(Context ctx, WebControlObjectInfo originalModel) {
        return UIStatusNameAssemble.getAllStatus(ctx, originalModel);
    }

    public static WebControlObjectInfo assembleWebControl(Context ctx, WebControlObjectInfo originalModel) {
        return WebControlObjectAssembler.assembleWebControl(ctx, originalModel, false);
    }

    public static WebControlObjectInfo assembleWebControl(Context ctx, WebControlObjectInfo originalModel, boolean needCompositePropBinding) {
        if (originalModel == null) {
            logger.warn((Object)"The second argument originalModel is null");
            return null;
        }
        if (originalModel.isAssembled()) {
            return originalModel;
        }
        if (originalModel.getParent() == null) {
            WebControlObjectAssembler.handleParentChildRelation(originalModel);
            UIControlOrderHelper.getInstance().orderUIControl(originalModel);
            originalModel.setAssembled(true);
            return originalModel;
        }
        WebControlObjectInfo originalModelClone = (WebControlObjectInfo)originalModel.clone();
        long startTime = System.currentTimeMillis();
        Stack<WebControlObjectInfo> parentStack = new Stack<WebControlObjectInfo>();
        WebControlObjectInfo parent = null;
        WebControlObjectInfo child = originalModelClone;
        WebControlObjectInfo completeModel = new WebControlObjectInfo();
        List locales = WebControlObjectAssembler.initSolutionLocales(ctx);
        WebControlObjectAssembler.initUIInfo(originalModelClone, completeModel, locales);
        while ((parent = child.getParent()) != null) {
            parentStack.push(parent);
            child = parent;
        }
        while (!parentStack.isEmpty()) {
            WebControlObjectAssembler.assembleParentUI(completeModel, (WebControlObjectInfo)parentStack.pop(), locales, needCompositePropBinding);
        }
        WebControlObjectAssembler.setHeritedPropty(completeModel, true);
        WebControlObjectAssembler.setOverridePropty(originalModelClone, true);
        WebControlObjectAssembler.assembleParentUI(completeModel, originalModelClone, locales, needCompositePropBinding);
        WebControlObjectAssembler.handleParentChildRelation(completeModel);
        UIControlOrderHelper.getInstance().orderUIControl(completeModel);
        WebControlObjectAssembler.handleTolerantDefault(completeModel);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u88c5\u914dUI\u5171\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startTime)));
        }
        completeModel.setAssembled(true);
        completeModel.put("Resource_Last_Modified", originalModel.get("Resource_Last_Modified"));
        return completeModel;
    }

    private static void assembleParentUI(WebControlObjectInfo completeModel, WebControlObjectInfo parentModel, List locales, boolean needCompositePropBinding) {
        WebControlObjectAssembler.assembleComposite(completeModel.getComponents(), parentModel.getComponents(), locales, needCompositePropBinding);
        WebControlObjectAssembler.assembleDataObjects(completeModel.getDataObjects(), parentModel.getDataObjects(), locales);
        WebControlObjectAssembler.assembleScripts(completeModel.getScripts(), parentModel.getScripts(), locales);
        WebControlObjectAssembler.assembleStyleSheets(completeModel.getStyleSheets(), parentModel.getStyleSheets(), locales);
        WebControlObjectAssembler.assembleStatuses(completeModel.getStatuses(), parentModel.getStatuses(), locales);
    }

    private static void assembleComposite(ComponentCollection completeModel, ComponentCollection currentModel, List locales, boolean needCompositePropBinding) {
        assert (currentModel != null && completeModel != null);
        Iterator iter = currentModel.iterator();
        ComponentInfo currentComponent = null;
        ComponentInfo completeComponent = null;
        ComponentInfo tempComponent = null;
        ComponentInfo tempParent = null;
        while (iter.hasNext()) {
            String alias;
            LayoutInfo layoutInfo;
            int tabIndex;
            Object constraint;
            currentComponent = (ComponentInfo)iter.next();
            completeComponent = completeModel.getComponentInfo(currentComponent.getName());
            if (completeComponent == null) {
                completeModel.add(currentComponent);
                continue;
            }
            completeModel.insertObject(completeModel.size() - 1, (IObjectValue)completeComponent);
            tempComponent = currentComponent.getParent();
            if (tempComponent != null) {
                tempParent = completeModel.getComponentInfo(tempComponent.getName());
                if (tempParent == null) {
                    tempParent = currentModel.getComponentInfo(tempComponent.getName());
                }
                completeComponent.setParent(tempParent);
                completeComponent.setOverrideParent(currentComponent.isOverrideParent());
            }
            if (!((constraint = currentComponent._getConstraint()) == null || constraint instanceof String && StringUtils.isEmpty((String)((String)constraint)))) {
                completeComponent.setConstraint(constraint, false);
                completeComponent.setOverrideConstraint(currentComponent.isOverrideConstraint());
            }
            if ((tabIndex = currentComponent.getTabIndex()) > 0) {
                completeComponent.setTabIndex(tabIndex);
                completeComponent.setOverrideTabIndex(currentComponent.isOverrideTabIndex());
            }
            if ((layoutInfo = currentComponent.getLayoutInfo()) != null) {
                completeComponent.setLayoutInfo(layoutInfo);
            }
            if (!StringUtils.isEmpty((String)(alias = currentComponent.getAlias()))) {
                completeComponent.setAlias(alias);
            }
            if (locales != null) {
                Iterator localIter = locales.iterator();
                Locale locale = null;
                while (localIter.hasNext()) {
                    locale = (Locale)localIter.next();
                    alias = currentComponent.getAlias(locale);
                    if (StringUtils.isEmpty((String)alias)) continue;
                    completeComponent.setAlias(alias, locale);
                }
            }
            PropertyCollection childComponentProperties = currentComponent.getProperties();
            for (int j = 0; j < childComponentProperties.size(); ++j) {
                PropertyInfo currentComponentProp = childComponentProperties.get(j);
                PropertyInfo completeComponentProp = completeComponent.getProperties().get(currentComponentProp.getName());
                if (completeComponentProp == null) {
                    completeComponent.getProperties().add(currentComponentProp);
                    continue;
                }
                completeComponentProp.setOverride(currentComponentProp.isOverride());
                completeComponentProp.setValue(currentComponentProp.getValue());
                if (!currentComponentProp.isMultiLanguage() || locales == null) continue;
                Iterator localIter = locales.iterator();
                Locale locale = null;
                while (localIter.hasNext()) {
                    locale = (Locale)localIter.next();
                    completeComponentProp.setValue(currentComponentProp.getValue(locale), locale);
                }
            }
            PropertyBindingCollection currentComponentPropertyBindings = currentComponent.getPropertyBindings();
            for (int j = 0; j < currentComponentPropertyBindings.size(); ++j) {
                PropertyBindingInfo currentPBInfo = currentComponentPropertyBindings.get(j);
                PropertyBindingInfo completePBInfo = (PropertyBindingInfo)completeComponent.getPropertyBindings().getObject(currentPBInfo.getPropertyName());
                if (completePBInfo == null) {
                    completeComponent.getPropertyBindings().add(currentPBInfo);
                    continue;
                }
                completePBInfo.setOverride(currentPBInfo.isOverride());
                completePBInfo.setBindingObject(currentPBInfo.getBindingObject());
                completePBInfo.setBingdingField(currentPBInfo.getBingdingField());
            }
            EventBindingCollection currentEventBindings = currentComponent.getEventBindings();
            for (int j = 0; j < currentEventBindings.size(); ++j) {
                EventBindingInfo currentEBInfo = currentEventBindings.get(j);
                EventBindingInfo completeEBInfo = (EventBindingInfo)completeComponent.getEventBindings().getObject(currentEBInfo.getEventName());
                if (completeEBInfo == null) {
                    completeComponent.getEventBindings().add(currentEBInfo);
                    continue;
                }
                completeEBInfo.setCode(currentEBInfo.getCode());
                completeEBInfo.setOverride(currentEBInfo.isOverride());
            }
            completeComponent.setRules(currentComponent.getRules());
            Map extendMap = currentComponent.getExtendedProperties();
            Iterator iterator = extendMap.keySet().iterator();
            while (iterator.hasNext()) {
                String key = iterator.next().toString();
                String value = extendMap.get(key).toString();
                completeComponent.setExtendedProperty(key, value);
            }
        }
    }

    private static void assembleStyleSheets(StyleSheetCollection completeModel, StyleSheetCollection currentModel, List locales) {
        assert (completeModel != null && currentModel != null);
        Iterator iter = currentModel.iterator();
        StyleSheetInfo currentInfo = null;
        StyleSheetInfo completeInfo = null;
        while (iter.hasNext()) {
            currentInfo = (StyleSheetInfo)iter.next();
            completeInfo = completeModel.getStyleSheetByName(currentInfo.getName());
            if (completeInfo == null) {
                completeModel.add(currentInfo);
                continue;
            }
            completeInfo.setOverride(currentInfo.isOverride());
            completeInfo.setReference(currentInfo.getReference());
        }
    }

    private static void assembleScripts(ScriptCollection completeModel, ScriptCollection currentModel, List locales) {
        assert (completeModel != null && currentModel != null);
        Iterator iter = currentModel.iterator();
        ScriptInfo currentScriptInfo = null;
        ScriptInfo completeScriptInfo = null;
        while (iter.hasNext()) {
            currentScriptInfo = (ScriptInfo)iter.next();
            completeScriptInfo = completeModel.getScriptByName(currentScriptInfo.getName());
            if (completeScriptInfo == null) {
                completeModel.add(currentScriptInfo);
                continue;
            }
            completeScriptInfo.setOverride(currentScriptInfo.isOverride());
            completeScriptInfo.setType(currentScriptInfo.getType());
            completeScriptInfo.setReference(currentScriptInfo.getReference());
            completeScriptInfo.setScript(currentScriptInfo.getScript());
        }
    }

    private static void assembleDataObjects(DataObjectCollection completeModel, DataObjectCollection currentModel, List locales) {
        assert (completeModel != null && currentModel != null);
        Iterator iter = currentModel.iterator();
        DataObjectInfo currentDataObjInfo = null;
        DataObjectInfo completeDataObjInfo = null;
        while (iter.hasNext()) {
            currentDataObjInfo = (DataObjectInfo)iter.next();
            completeDataObjInfo = completeModel.getDataObject(currentDataObjInfo.getName());
            if (completeDataObjInfo == null) {
                completeModel.add(currentDataObjInfo);
                continue;
            }
            completeDataObjInfo.setOverride(currentDataObjInfo.isOverride());
            completeDataObjInfo.setType(currentDataObjInfo.getType());
            completeDataObjInfo.setDescription(currentDataObjInfo.getDescription());
            if (locales == null) continue;
            Iterator localeIter = locales.iterator();
            Locale locale = null;
            while (localeIter.hasNext()) {
                locale = (Locale)localeIter.next();
                completeDataObjInfo.setDescription(currentDataObjInfo.getDescription());
            }
        }
    }

    private static void assembleActions(ActionCollection completeModel, ActionCollection currentModel, List locales) {
        assert (completeModel != null && currentModel != null);
        Iterator iter = currentModel.iterator();
        ActionInfo currentInfo = null;
        ActionInfo completeInfo = null;
        while (iter.hasNext()) {
            currentInfo = (ActionInfo)iter.next();
            completeInfo = completeModel.getActionByName(currentInfo.getName());
            if (completeInfo == null) {
                completeModel.add(currentInfo);
                continue;
            }
            completeInfo.setAcceleratorKey(currentInfo.getAcceleratorKey());
            completeInfo.setActionCommandKey(currentInfo.getActionCommandKey());
            completeInfo.setActionExtendProperty(currentInfo.getActionExtendProperty());
            completeInfo.setActionPerformed(currentInfo.getActionPerformed());
            completeInfo.setBeforeActionPerformed(currentInfo.getBeforeActionPerformed());
            completeInfo.setAfterActionPerformed(currentInfo.getAfterActionPerformed());
            completeInfo.setFinallyActionPerformed(currentInfo.getFinallyActionPerformed());
            completeInfo.setMnemonicKey(currentInfo.getMnemonicKey());
            completeInfo.setServices(currentInfo.getServices());
            completeInfo.setBindWorkFlow(currentInfo.isBindWorkFlow());
            completeInfo.setDaemonRun(currentInfo.isDaemonRun());
            completeInfo.setEnabled(currentInfo.isEnabled());
            completeInfo.setOverride(currentInfo.isOverride());
            completeInfo.setOprtIntent(currentInfo.getOprtIntent());
            completeInfo.setNextUI(currentInfo.getNextUI());
            completeInfo.setUIPNavigator(currentInfo.isUIPNavigator());
            completeInfo.setActionBinding(currentInfo.getActionBinding());
            completeInfo.setControlName(currentInfo.getControlName());
            completeInfo.setShortDesc(currentInfo.getShortDesc());
            completeInfo.setLongDesc(currentInfo.getLongDesc());
            completeInfo.setSmallIcon(currentInfo.getSmallIcon());
            if (locales != null) {
                Iterator localeIter = locales.iterator();
                Locale locale = null;
                while (localeIter.hasNext()) {
                    locale = (Locale)localeIter.next();
                    completeInfo.setControlName(currentInfo.getControlName(locale), locale);
                    completeInfo.setShortDesc(currentInfo.getShortDesc(locale), locale);
                    completeInfo.setLongDesc(currentInfo.getLongDesc(locale), locale);
                    completeInfo.setSmallIcon(currentInfo.getSmallIcon(locale), locale);
                }
            }
            completeInfo.setRules(currentInfo.getRules());
        }
    }

    private static void assembleStatuses(StatusCollection completeModel, StatusCollection currentModel, List locales) {
        assert (completeModel != null && currentModel != null);
        Iterator iter = currentModel.iterator();
        Iterator itemIter = null;
        StatusInfo currentInfo = null;
        StatusInfo completeInfo = null;
        StatusItemInfo currentItem = null;
        StatusItemInfo completeItem = null;
        StatusItemCollection currentItems = null;
        StatusItemCollection completeItems = null;
        Locale locale2 = null;
        Iterator localeIter = null;
        while (iter.hasNext()) {
            currentInfo = (StatusInfo)iter.next();
            completeInfo = completeModel.getStatusByName(currentInfo.getName());
            if (completeInfo == null) {
                completeModel.add(currentInfo);
                continue;
            }
            completeInfo.setAlias(currentInfo.getAlias());
            completeInfo.setDescription(currentInfo.getDescription());
            if (locales != null) {
                for (Locale locale2 : locales) {
                    completeInfo.setAlias(currentInfo.getAlias(locale2), locale2);
                    completeInfo.setDescription(currentInfo.getDescription(locale2), locale2);
                }
            }
            currentItems = currentInfo.getStatusItems();
            completeItems = completeInfo.getStatusItems();
            itemIter = currentItems.iterator();
            while (itemIter.hasNext()) {
                currentItem = (StatusItemInfo)itemIter.next();
                completeItem = completeItems.get(currentItem.getName());
                if (completeItem == null) {
                    completeItems.add(currentItem);
                    continue;
                }
                completeItem.setOverride(currentItem.isOverride());
                completeItem.setEnabled(currentItem.getEnabled());
                completeItem.setVisible(currentItem.getVisible());
            }
        }
    }

    private static void setHeritedPropty(WebControlObjectInfo model, boolean isHerited) {
        ComponentCollection components = model.getComponents();
        Iterator iter = components.iterator();
        Iterator pbIter = null;
        Iterator ebIter = null;
        ComponentInfo component = null;
        EventBindingInfo ebInfo = null;
        while (iter.hasNext()) {
            component = (ComponentInfo)iter.next();
            component.setHerited(isHerited);
            component.setAllHeritedProperties((PropertyCollection)component.getProperties().clone());
            PropertyBindingCollection propBindings = component.getPropertyBindings();
            pbIter = propBindings.iterator();
            while (pbIter.hasNext()) {
                ((PropertyBindingInfo)pbIter.next()).setHerited(isHerited);
            }
            EventBindingCollection eventBindings = component.getEventBindings();
            ebIter = eventBindings.iterator();
            while (ebIter.hasNext()) {
                ebInfo = (EventBindingInfo)ebIter.next();
                ebInfo.setHerited(isHerited);
                ebInfo.setCode("");
            }
        }
        iter = model.getDataObjects().iterator();
        while (iter.hasNext()) {
            ((DataObjectInfo)iter.next()).setHerited(isHerited);
        }
        iter = model.getStatuses().iterator();
        StatusInfo status = null;
        while (iter.hasNext()) {
            status = (StatusInfo)iter.next();
            status.setHerited(isHerited);
            pbIter = status.getStatusItems().iterator();
            while (pbIter.hasNext()) {
                ((StatusItemInfo)pbIter.next()).setHerited(isHerited);
            }
        }
        iter = model.getStyleSheets().iterator();
        while (iter.hasNext()) {
            ((StyleSheetInfo)iter.next()).setHerited(isHerited);
        }
        iter = model.getScripts().iterator();
        while (iter.hasNext()) {
            ((ScriptInfo)iter.next()).setHerited(isHerited);
        }
    }

    private static void setOverridePropty(WebControlObjectInfo model, boolean isOverride) {
        ComponentCollection components = model.getComponents();
        Iterator iter = components.iterator();
        Iterator pbIter = null;
        ComponentInfo component = null;
        EventBindingInfo ebInfo = null;
        while (iter.hasNext()) {
            component = (ComponentInfo)iter.next();
            if (component._getConstraint() != null) {
                component.setOverrideConstraint(isOverride);
            }
            if (component.getParent() != null && !StringUtils.isEmpty((String)component.getParent().getName())) {
                component.setOverrideParent(isOverride);
            }
            if (component.getTabIndex() > 0) {
                component.setOverrideTabIndex(isOverride);
            }
            if (component.getLayoutInfo() != null) {
                component.getLayoutInfo().setOverride(isOverride);
            }
            PropertyCollection props = component.getProperties();
            pbIter = props.iterator();
            while (pbIter.hasNext()) {
                ((PropertyInfo)pbIter.next()).setOverride(isOverride);
            }
            PropertyBindingCollection propBindings = component.getPropertyBindings();
            pbIter = propBindings.iterator();
            while (pbIter.hasNext()) {
                ((PropertyBindingInfo)pbIter.next()).setOverride(isOverride);
            }
            EventBindingCollection eventBindings = component.getEventBindings();
            pbIter = eventBindings.iterator();
            while (pbIter.hasNext()) {
                ebInfo = (EventBindingInfo)pbIter.next();
                ebInfo.setOverride(isOverride);
            }
        }
        iter = model.getDataObjects().iterator();
        while (iter.hasNext()) {
            ((DataObjectInfo)iter.next()).setOverride(isOverride);
        }
        iter = model.getActions().iterator();
        while (iter.hasNext()) {
            ((ActionInfo)iter.next()).setOverride(isOverride);
        }
        iter = model.getStatuses().iterator();
        StatusInfo status = null;
        while (iter.hasNext()) {
            status = (StatusInfo)iter.next();
            status.setOverride(isOverride);
            pbIter = status.getStatusItems().iterator();
            while (pbIter.hasNext()) {
                ((StatusItemInfo)pbIter.next()).setOverride(isOverride);
            }
        }
        iter = model.getStyleSheets().iterator();
        while (iter.hasNext()) {
            ((StyleSheetInfo)iter.next()).setOverride(isOverride);
        }
        iter = model.getScripts().iterator();
        while (iter.hasNext()) {
            ((ScriptInfo)iter.next()).setOverride(isOverride);
        }
    }

    private static void handleParentChildRelation(WebControlObjectInfo model) {
        ComponentCollection components = model.getComponents();
        Iterator iter = components.iterator();
        ComponentInfo component = null;
        ComponentInfo parentComponent = null;
        String parentName = null;
        while (iter.hasNext()) {
            component = (ComponentInfo)iter.next();
            if (component.getParent() == null || StringUtils.isEmpty((String)(parentName = component.getParent().getName())) || (parentComponent = components.getComponentInfo(parentName)) == null) continue;
            component.setParent(parentComponent);
            parentComponent.getComponents().add(component);
        }
    }

    private static List initSolutionLocales(Context ctx) {
        ArrayList<Locale> locales = new ArrayList<Locale>();
        try {
            SolutionInfo solution = new SolutionCtrl(ctx).getValue();
            LanguageCollection langs = solution.getLanguages();
            Iterator iter = langs.iterator();
            while (iter.hasNext()) {
                locales.add(((LanguageInfo)iter.next()).getLocale());
            }
        }
        catch (BOSException e) {
            logger.warn((Object)"Load Solution Error", (Throwable)e);
        }
        return locales;
    }

    private static void initUIInfo(WebControlObjectInfo sourceModel, WebControlObjectInfo targetModel, List locales) {
        targetModel.setPKField(sourceModel.getPKField());
        targetModel.setName(sourceModel.getName());
        targetModel.setPackage(sourceModel.getPackage());
        targetModel.setParent(sourceModel.getParent());
        targetModel.setParentFullName(sourceModel.getParentFullName());
        targetModel.setReleaseClass(sourceModel.getReleaseClass());
        targetModel.setReleasePackage(sourceModel.getReleasePackage());
        targetModel.setDefaultButton(sourceModel.getDefaultButton());
        targetModel.setAlias(sourceModel.getAlias());
        targetModel.setDescription(sourceModel.getDescription());
        targetModel.setTitle(sourceModel.getTitle());
        if (locales != null) {
            Iterator iter = locales.iterator();
            Locale locale = null;
            while (iter.hasNext()) {
                locale = (Locale)iter.next();
                targetModel.setAlias(sourceModel.getAlias(locale), locale);
                targetModel.setDescription(sourceModel.getDescription(locale), locale);
                targetModel.setTitle(sourceModel.getTitle(locale), locale);
            }
        }
        targetModel.setRuleSet(sourceModel.getRuleSet());
        WebControlObjectAssembler.copyExtendedProperties(sourceModel, targetModel);
        targetModel.setBizUnitPK(sourceModel.getBizUnitPK());
        targetModel.setUserDefined(sourceModel.isUserDefined());
    }

    private static void copyExtendedProperties(IObjectValue srcObj, IObjectValue desObj) {
        if (srcObj == null || desObj == null) {
            return;
        }
        Map extProps = srcObj.getExtendedProperties();
        for (Object key : extProps.keySet()) {
            desObj.getExtendedProperties().put(key, extProps.get(key));
        }
    }

    private static ComponentCollection parseComposites(ComponentCollection completeModel, List locales) {
        assert (completeModel != null);
        ComponentCollection resultModel = new ComponentCollection();
        Iterator iter = completeModel.iterator();
        ComponentInfo tempComponent = null;
        while (iter.hasNext()) {
            tempComponent = WebControlObjectAssembler.parseComponent((ComponentInfo)iter.next(), locales);
            if (tempComponent == null) continue;
            resultModel.add(tempComponent);
        }
        return resultModel;
    }

    private static DataObjectCollection parseDataObjects(DataObjectCollection completeModel) {
        assert (completeModel != null);
        DataObjectCollection resultModel = new DataObjectCollection();
        Iterator iter = completeModel.iterator();
        DataObjectInfo sourceInfo = null;
        while (iter.hasNext()) {
            sourceInfo = (DataObjectInfo)iter.next();
            if (sourceInfo.isHerited() && !sourceInfo.isOverride()) continue;
            resultModel.add(sourceInfo);
        }
        return resultModel;
    }

    private static StyleSheetCollection parseStyleSheets(StyleSheetCollection completeModel) {
        assert (completeModel != null);
        StyleSheetCollection resultModel = new StyleSheetCollection();
        Iterator iter = completeModel.iterator();
        StyleSheetInfo info = null;
        while (iter.hasNext()) {
            info = (StyleSheetInfo)iter.next();
            if (info.isHerited() && !info.isOverride()) continue;
            resultModel.add(info);
        }
        return resultModel;
    }

    private static ScriptCollection parseScripts(ScriptCollection completeModel) {
        assert (completeModel != null);
        ScriptCollection resultModel = new ScriptCollection();
        Iterator iter = completeModel.iterator();
        ScriptInfo info = null;
        while (iter.hasNext()) {
            info = (ScriptInfo)iter.next();
            if (info.isHerited() && !info.isOverride()) continue;
            resultModel.add(info);
        }
        return resultModel;
    }

    private static StatusCollection parseStatuses(StatusCollection completeModel, List locales) {
        assert (completeModel != null);
        StatusCollection resultModel = new StatusCollection();
        Iterator iter = completeModel.iterator();
        Iterator localeIter = null;
        Iterator itemIter = null;
        StatusInfo sourceStatus = null;
        StatusInfo targetStatus = null;
        StatusItemInfo sourceItem = null;
        Locale locale2 = null;
        StatusItemCollection targetStatusItems = null;
        boolean isOverride = false;
        while (iter.hasNext()) {
            sourceStatus = (StatusInfo)iter.next();
            if (!sourceStatus.isHerited()) {
                resultModel.add(sourceStatus);
                continue;
            }
            targetStatus = new StatusInfo();
            targetStatus.setName(sourceStatus.getName());
            targetStatus.setAlias(sourceStatus.getAlias());
            targetStatus.setDescription(sourceStatus.getDescription());
            if (locales != null) {
                for (Locale locale2 : locales) {
                    targetStatus.setAlias(sourceStatus.getAlias(locale2), locale2);
                    targetStatus.setDescription(sourceStatus.getDescription(locale2), locale2);
                }
            }
            itemIter = sourceStatus.getStatusItems().iterator();
            targetStatusItems = new StatusItemCollection();
            while (itemIter.hasNext()) {
                sourceItem = (StatusItemInfo)itemIter.next();
                if (sourceItem.isHerited() && !sourceItem.isOverride()) continue;
                targetStatusItems.add(sourceItem);
                isOverride = true;
            }
            if (!isOverride) continue;
            targetStatus.setStatusItems(targetStatusItems);
            resultModel.add(targetStatus);
        }
        return resultModel;
    }

    private static ActionCollection parseActions(ActionCollection completeModel) {
        assert (completeModel != null);
        ActionCollection resultModel = new ActionCollection();
        Iterator iter = completeModel.iterator();
        ActionInfo sourceInfo = null;
        while (iter.hasNext()) {
            sourceInfo = (ActionInfo)iter.next();
            sourceInfo.setBeforeActionPerformed(sourceInfo.getBeforeAction().getCode());
            sourceInfo.setAfterActionPerformed(sourceInfo.getAfterAction().getCode());
            sourceInfo.setFinallyActionPerformed(sourceInfo.getFinallyAction().getCode());
            if (sourceInfo.isHerited() && !sourceInfo.isOverride()) continue;
            resultModel.add(sourceInfo);
        }
        return resultModel;
    }

    private static void initComponent(ComponentInfo sourceModel, ComponentInfo targetModel, List locales) {
        assert (sourceModel != null && targetModel != null);
        targetModel.setName(sourceModel.getName());
        targetModel.setContainer(sourceModel.isContainer());
        targetModel.setClassType(sourceModel.getClassType());
        targetModel.setRules(sourceModel.getRules());
        targetModel.setUserDefined(sourceModel.isUserDefined());
    }

    private static ComponentInfo parseComponent(ComponentInfo completeModel, List locales) {
        Object tempConstraint;
        LayoutInfo layoutInfo;
        assert (completeModel != null);
        if (!completeModel.isHerited()) {
            return completeModel;
        }
        ComponentInfo resultModel = new ComponentInfo();
        boolean isOverride = false;
        WebControlObjectAssembler.initComponent(completeModel, resultModel, locales);
        if (completeModel.isOverrideParent() && completeModel.getParent() != null) {
            resultModel.setParent(completeModel.getParent());
            isOverride = true;
        }
        if ((layoutInfo = completeModel.getLayoutInfo()) != null && layoutInfo.isOverride()) {
            resultModel.setLayoutInfo(layoutInfo);
            isOverride = true;
        }
        if (completeModel.isOverrideConstraint() && (tempConstraint = completeModel.getConstraint()) != null) {
            resultModel.setConstraint(tempConstraint, false);
            isOverride = true;
        }
        if (completeModel.isOverrideTabIndex()) {
            resultModel.setTabIndex(completeModel.getTabIndex());
            isOverride = true;
        }
        Iterator iter = completeModel.getProperties().iterator();
        PropertyInfo sourceProp = null;
        PropertyCollection resultProps = resultModel.getProperties();
        while (iter.hasNext()) {
            sourceProp = (PropertyInfo)iter.next();
            if (!sourceProp.isOverride()) continue;
            resultProps.add(sourceProp);
            isOverride = true;
        }
        iter = completeModel.getPropertyBindings().iterator();
        PropertyBindingInfo sourcePropBinding = null;
        PropertyBindingCollection resultPBs = resultModel.getPropertyBindings();
        while (iter.hasNext()) {
            sourcePropBinding = (PropertyBindingInfo)iter.next();
            if (sourcePropBinding.isHerited() && !sourcePropBinding.isOverride()) continue;
            resultPBs.add(sourcePropBinding);
            isOverride = true;
        }
        iter = completeModel.getEventBindings().iterator();
        EventBindingInfo sourceEB = null;
        EventBindingCollection resultEBs = resultModel.getEventBindings();
        while (iter.hasNext()) {
            sourceEB = (EventBindingInfo)iter.next();
            if (sourceEB.isHerited() && !sourceEB.isOverride()) continue;
            resultEBs.add(sourceEB);
            isOverride = true;
        }
        if (completeModel.isOverrideRules()) {
            isOverride = true;
        }
        if (isOverride) {
            return resultModel;
        }
        return null;
    }

    private static void handleTolerantDefault(WebControlObjectInfo completeModel) {
        ComponentInfo tempInfo2 = null;
        String tempStr = null;
        Vector<ComponentInfo> badComps = new Vector<ComponentInfo>();
        Iterator iter = completeModel.getComponents().iterator();
        while (iter.hasNext()) {
            tempInfo2 = (ComponentInfo)iter.next();
            tempStr = tempInfo2.getClassType();
            if (StringUtils.isEmpty((String)tempStr)) {
                badComps.add(tempInfo2);
                continue;
            }
            if (tempInfo2.getParent() != null || "com.kingdee.bos.ctrl.web.RootPane".equals(tempStr)) continue;
            badComps.add(tempInfo2);
        }
        for (ComponentInfo tempInfo2 : badComps) {
            completeModel.getComponents().remove(tempInfo2);
        }
        badComps.clear();
    }

    private static class UIStatusNameAssemble {
        private UIStatusNameAssemble() {
        }

        private static StatusCollection getAllStatus(Context ctx, WebControlObjectInfo originalModel) {
            List locales = WebControlObjectAssembler.initSolutionLocales(ctx);
            StatusCollection ret = new StatusCollection();
            if (originalModel.isAssembled() || originalModel.getParent() == null) {
                StatusCollection temp = originalModel.getStatuses();
                Iterator iter = temp.iterator();
                while (iter.hasNext()) {
                    ret.add(UIStatusNameAssemble.copySimpleStatusProp((StatusInfo)iter.next(), locales));
                }
                return ret;
            }
            Stack<WebControlObjectInfo> parentStack = new Stack<WebControlObjectInfo>();
            WebControlObjectInfo parent = null;
            WebControlObjectInfo child = originalModel;
            parentStack.push(child);
            while ((parent = child.getParent()) != null) {
                parentStack.push(parent);
                child = parent;
            }
            while (!parentStack.isEmpty()) {
                UIStatusNameAssemble.assembleStatusesSimpleProp(ret, ((WebControlObjectInfo)parentStack.pop()).getStatuses(), locales);
            }
            return ret;
        }

        private static StatusInfo copySimpleStatusProp(StatusInfo source, List locales) {
            assert (locales != null && source != null);
            StatusInfo newStatus = new StatusInfo();
            newStatus.setName(source.getName());
            for (Locale locale : locales) {
                newStatus.setAlias(source.getAlias(locale), locale);
                newStatus.setDescription(source.getDescription(locale), locale);
            }
            return newStatus;
        }

        private static void assembleStatusesSimpleProp(StatusCollection target, StatusCollection source, List locales) {
            Iterator iter = source.iterator();
            while (iter.hasNext()) {
                StatusInfo tempSrc = (StatusInfo)iter.next();
                StatusInfo tempTarget = target.getStatusByName(tempSrc.getName());
                if (tempTarget == null) {
                    target.add(UIStatusNameAssemble.copySimpleStatusProp(tempSrc, locales));
                    continue;
                }
                for (Locale locale : locales) {
                    tempTarget.setAlias(tempSrc.getAlias(locale), locale);
                    tempTarget.setDescription(tempSrc.getDescription(locale), locale);
                }
            }
        }
    }
}

