/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.webui;

import com.kingdee.bos.ui.dtp.weblayout.WebLayoutData;
import com.kingdee.util.StringUtils;

public class WebLayoutDataConverter {
    private WebLayoutData data;
    private int rows;
    private int columns;

    public WebLayoutDataConverter(WebLayoutData data, int rows, int columns) {
        this.data = data;
        this.rows = rows;
        this.columns = columns;
    }

    public WebLayoutData getWebLayoutData() {
        return this.data;
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.columns;
    }

    public static WebLayoutDataConverter parse(String constraint) {
        int columns;
        int rows;
        if (StringUtils.isEmpty((String)constraint)) {
            throw new IllegalArgumentException("format error!");
        }
        if (constraint.lastIndexOf("#") == -1) {
            throw new IllegalArgumentException("format error!");
        }
        String con = constraint.substring(constraint.lastIndexOf("#") + 1);
        String[] info = con.split(",");
        if (info.length != 2) {
            throw new IllegalArgumentException("format error!");
        }
        String wld = constraint.substring(0, constraint.lastIndexOf("#"));
        WebLayoutData data = WebLayoutData.parse(wld);
        try {
            rows = Integer.parseInt(info[0].substring(info[0].lastIndexOf("=") + 1));
            columns = Integer.parseInt(info[1].substring(info[1].lastIndexOf("=") + 1));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("format error!");
        }
        return new WebLayoutDataConverter(data, rows, columns);
    }

    public static String parse(WebLayoutData data, int rows, int columns) {
        if (data != null) {
            return data.toString() + "#row=" + rows + ",column=" + columns;
        }
        return null;
    }
}

