/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.webui.transfer;

import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.DataObjectInfo;
import com.kingdee.bos.metadata.ui.EventBindingCollection;
import com.kingdee.bos.metadata.ui.EventBindingInfo;
import com.kingdee.bos.metadata.ui.PropertyBindingCollection;
import com.kingdee.bos.metadata.ui.PropertyBindingInfo;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.metadata.util.UIUtils;
import com.kingdee.bos.metadata.webui.WebUIObjectInfo;
import com.kingdee.bos.metadata.webui.transfer.WebUIModelMapper;
import com.kingdee.bos.metadata.webui.transfer.tablemodel.Table;
import com.kingdee.bos.metadata.webui.transfer.tablemodel.TableCell;
import com.kingdee.bos.metadata.webui.transfer.tablemodel.TableColumn;
import com.kingdee.bos.metadata.webui.transfer.tablemodel.TableRow;
import com.kingdee.bos.metadata.webui.xhtml.WebTag;
import com.kingdee.bos.metadata.webui.xhtml.WebTags;
import com.kingdee.bos.ui.bizunitproxy.EditUIProxyHelper;
import com.kingdee.bos.ui.dtp.StringConverter;
import com.kingdee.bos.ui.dtp.kdtable.CellInfo;
import com.kingdee.bos.ui.dtp.kdtable.ColumnInfo;
import com.kingdee.bos.ui.dtp.model.layout.Layout;
import com.kingdee.bos.ui.dtp.model.layout.LayoutConverter;
import com.kingdee.bos.ui.dtp.model.layout.SmartLayout;
import com.kingdee.bos.ui.dtp.model.layout.WebLayout;
import com.kingdee.bos.ui.dtp.smartlayout.SmartLayoutData;
import com.kingdee.bos.ui.dtp.webborderlayout.WebBorderLayoutData;
import com.kingdee.bos.ui.dtp.webevent.AjaxAction;
import com.kingdee.bos.ui.dtp.weblayout.WebLayoutData;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class Component2XmlHelper {
    private WebUIObjectInfo model;
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static Namespace NS_TABLE = Namespace.getNamespace((String)"t", (String)"com.kingdee.bos.ui.tablelayout");
    private static int ROW = 0;
    private static int COLUMN = 1;
    private String rootJsVar;

    public Component2XmlHelper(WebUIObjectInfo model) {
        this.model = model;
    }

    private static String saveConvert(String theString, boolean escapeSpace, boolean escapeUnicode) {
        int len = theString.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuffer outBuffer = new StringBuffer(bufLen);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue;
                }
                outBuffer.append(aChar);
                continue;
            }
            switch (aChar) {
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    outBuffer.append('\\');
                    outBuffer.append(aChar);
                    continue block8;
                }
                default: {
                    if ((aChar < ' ' || aChar > '~') & escapeUnicode) {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(Component2XmlHelper.toHex(aChar >> 12 & 0xF));
                        outBuffer.append(Component2XmlHelper.toHex(aChar >> 8 & 0xF));
                        outBuffer.append(Component2XmlHelper.toHex(aChar >> 4 & 0xF));
                        outBuffer.append(Component2XmlHelper.toHex(aChar & 0xF));
                        continue block8;
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    private static String loadConvert(char[] in, int off, int len, char[] convtBuf) {
        if (convtBuf.length < len) {
            int newLen = len * 2;
            if (newLen < 0) {
                newLen = Integer.MAX_VALUE;
            }
            convtBuf = new char[newLen];
        }
        char[] out = convtBuf;
        int outLen = 0;
        int end = off + len;
        while (off < end) {
            int aChar;
            if ((aChar = in[off++]) == 92) {
                if ((aChar = in[off++]) == 117) {
                    int value = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        aChar = in[off++];
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                    }
                    out[outLen++] = (char)value;
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                out[outLen++] = aChar;
                continue;
            }
            out[outLen++] = aChar;
        }
        return new String(out, 0, outLen);
    }

    private static void load(LineReader lr, List list, Properties properties) throws IOException {
        int limit;
        char[] convtBuf = new char[1024];
        while ((limit = lr.readLine()) >= 0) {
            int keyLen;
            char c = '\u0000';
            int valueStart = limit;
            boolean hasSep = false;
            boolean precedingBackslash = false;
            for (keyLen = 0; keyLen < limit; ++keyLen) {
                c = lr.lineBuf[keyLen];
                if (!(c != '=' && c != ':' || precedingBackslash)) {
                    valueStart = keyLen + 1;
                    hasSep = true;
                    break;
                }
                if (!(c != ' ' && c != '\t' && c != '\f' || precedingBackslash)) {
                    valueStart = keyLen + 1;
                    break;
                }
                precedingBackslash = c == '\\' ? !precedingBackslash : false;
            }
            while (valueStart < limit) {
                c = lr.lineBuf[valueStart];
                if (c != ' ' && c != '\t' && c != '\f') {
                    if (hasSep || c != '=' && c != ':') break;
                    hasSep = true;
                }
                ++valueStart;
            }
            String key = Component2XmlHelper.loadConvert(lr.lineBuf, 0, keyLen, convtBuf);
            String value = Component2XmlHelper.loadConvert(lr.lineBuf, valueStart, limit - valueStart, convtBuf);
            list.add(key);
            properties.setProperty(key, value);
        }
    }

    public static String keyPairs2String(List list, Properties properties) {
        StringBuffer sb = new StringBuffer();
        for (String s : list) {
            sb.append(Component2XmlHelper.saveConvert(s, true, true) + "=" + Component2XmlHelper.saveConvert(properties.getProperty(s), true, true) + " ");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static void string2KeyPairs(String s, List list, Properties properties) {
        ByteArrayInputStream bis = new ByteArrayInputStream(s.replace(' ', '\n').getBytes());
        LineReader lr = new LineReader(bis);
        try {
            Component2XmlHelper.load(lr, list, properties);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public static Element createElementWithID(WebTag webTag, String id) {
        Element element = new Element(webTag.getTagName(), webTag.getNs());
        element.setAttribute("id", id);
        return element;
    }

    private WebLayoutData getWebLayoutData(String constaint) {
        if (constaint.indexOf("#") >= 0) {
            constaint = constaint.substring(0, constaint.indexOf("#"));
            return WebLayoutData.parse(constaint);
        }
        return null;
    }

    private void mergeStyleSheet(Element element, String styleAttr, String css) {
        String old = element.getAttributeValue(styleAttr);
        if (old != null) {
            if (old.trim().endsWith(";")) {
                element.setAttribute(styleAttr, old + css);
            } else {
                element.setAttribute(styleAttr, old + ";" + css);
            }
        } else {
            element.setAttribute(styleAttr, css);
        }
    }

    private void setElementBoundsForBorderLayout(Element element, ComponentInfo component) {
        WebBorderLayoutData bounds = (WebBorderLayoutData)component.getConstraint();
        if ("west".equals(bounds.region) || "east".equals(bounds.region)) {
            element.setAttribute("width", String.valueOf(bounds.widthHint));
        } else if ("north".equals(bounds.region) || "south".equals(bounds.region)) {
            element.setAttribute("height", String.valueOf(bounds.heightHint));
        }
    }

    private void setElementBoundsForSmartLayout(Element element, ComponentInfo component) {
        SmartLayoutData bounds = (SmartLayoutData)component.getConstraint();
        if ("com.kingdee.bos.ctrl.web.DataGrid".equals(component.getClassType()) || "com.kingdee.bos.ctrl.web.EditDataGrid".equals(component.getClassType())) {
            this.mergeStyleSheet(element, "style", "overflow-x:auto;overflow-y:hidden;");
            if ("true".equals(component.getExtendedProperty("createbutton4editdatagrid"))) {
                element.setAttribute("height", String.valueOf(bounds.height - 18 > 0 ? bounds.height - 18 : 1));
            } else {
                element.setAttribute("height", String.valueOf(bounds.height));
            }
        } else if ("com.kingdee.bos.ctrl.web.TabbedPane".equals(component.getClassType()) || "com.kingdee.bos.ctrl.web.AccordionPane".equals(component.getClassType()) || "com.kingdee.bos.ctrl.web.Splitcontainer".equals(component.getClassType()) || "com.kingdee.bos.ctrl.web.BorderLayout".equals(component.getClassType())) {
            element.setAttribute("fit", "true");
            this.mergeStyleSheet(element, "style", "width:100%;height:100%;");
        } else if ("com.kingdee.bos.ctrl.web.Label".equals(component.getClassType()) || "com.kingdee.bos.ctrl.web.ListBox".equals(component.getClassType()) || "com.kingdee.bos.ctrl.web.CommandLink".equals(component.getClassType())) {
            this.mergeStyleSheet(element, "style", "width:100%; height:100%");
        } else if (!("com.kingdee.bos.ctrl.web.ToolBar".equals(component.getClassType()) || "com.kingdee.bos.ctrl.web.Line".equals(component.getClassType()) || "com.kingdee.bos.ctrl.web.TitleSection".equals(component.getClassType()))) {
            if ("com.kingdee.bos.ctrl.web.Container".equals(component.getClassType()) || "com.kingdee.bos.ctrl.web.Composite".equals(component.getClassType())) {
                this.mergeStyleSheet(element, "style", "width:100%;");
                element.setAttribute("height", String.valueOf(bounds.height));
            } else if ("com.kingdee.bos.ctrl.web.TabbedPane".equals(component.getClassType()) || "com.kingdee.bos.ctrl.web.AccordionPane".equals(component.getClassType()) || "com.kingdee.bos.ctrl.web.Tree".equals(component.getClassType())) {
                this.mergeStyleSheet(element, "style", "width:100%;height:100%;");
            } else if ("com.kingdee.bos.ctrl.web.MenuBar".equals(component.getClassType())) {
                this.mergeStyleSheet(element, "style", "width:100%;height:100%;");
            } else if ("com.kingdee.bos.ctrl.web.Menu".equals(component.getClassType()) || "com.kingdee.bos.ctrl.web.CheckMenuItem".equals(component.getClassType()) || "com.kingdee.bos.ctrl.web.CommandMenuItem".equals(component.getClassType()) || "com.kingdee.bos.ctrl.web.LinkMenuItem".equals(component.getClassType()) || "com.kingdee.bos.ctrl.web.RadioMenuItem".equals(component.getClassType()) || "com.kingdee.bos.ctrl.web.Fileupload".equals(component.getClassType())) {
                this.mergeStyleSheet(element, "style", "width:" + bounds.width + "px");
            } else if (!"com.kingdee.bos.ctrl.web.Form".equals(component.getClassType())) {
                if ("com.kingdee.bos.ctrl.web.MsgArea".equals(component.getClassType()) || "com.kingdee.bos.ctrl.web.Attachment".equals(component.getClassType())) {
                    this.mergeStyleSheet(element, "style", "width:100%;height:" + bounds.height);
                } else if (component.getClassType() != null && component.getClassType().startsWith("com.kingdee.bos.ctrl.ExtControl")) {
                    this.mergeStyleSheet(element, "style", "width:" + bounds.width + ";height:" + bounds.height);
                } else {
                    element.setAttribute("width", String.valueOf(bounds.width));
                    element.setAttribute("height", String.valueOf(bounds.height));
                }
            }
        }
    }

    private void setElementBounds(Element element, ComponentInfo component) {
        Object constraint;
        if (this.notNeedBounds(component)) {
            return;
        }
        if (component.getConstraint() instanceof SmartLayoutData) {
            this.setElementBoundsForSmartLayout(element, component);
            return;
        }
        if (component.getConstraint() instanceof WebBorderLayoutData) {
            this.setElementBoundsForBorderLayout(element, component);
            return;
        }
        if (component.getParent() != null && "com.kingdee.bos.ctrl.web.EditableColumn".equals(component.getParent().getClassType())) {
            return;
        }
        if (component.getParent() != null && "com.kingdee.bos.ctrl.web.TextArea".equals(component.getClassType()) && "com.kingdee.bos.ctrl.web.LabelContainer".equals(component.getParent().getClassType())) {
            constraint = component.getParent().getConstraint();
            int height = -1;
            if (constraint instanceof WebLayoutData) {
                height = ((WebLayoutData)constraint).height;
            } else if (constraint instanceof SmartLayoutData) {
                height = ((SmartLayoutData)constraint).height;
            }
            if (height > 0) {
                this.mergeStyleSheet(element, "style", "height:" + (height - 4) + "px;margin-top:1px");
            }
        }
        constraint = component.getConstraint();
        WebLayoutData ld = null;
        if (constraint instanceof WebLayoutData) {
            ld = (WebLayoutData)constraint;
        } else if (constraint instanceof String) {
            ld = this.getWebLayoutData((String)constraint);
        }
        if (ld == null) {
            return;
        }
        if ("com.kingdee.bos.ctrl.web.DataGrid".equals(component.getClassType()) || "com.kingdee.bos.ctrl.web.EditDataGrid".equals(component.getClassType()) || "com.kingdee.bos.ctrl.web.Panel".equals(component.getClassType()) || "com.kingdee.bos.ctrl.web.Composite".equals(component.getClassType())) {
            if (ld.width.isPercentage) {
                element.setAttribute("height", String.valueOf(ld.height));
            } else {
                if ("com.kingdee.bos.ctrl.web.EditDataGrid".equals(component.getClassType()) && "true".equals(component.getExtendedProperty("createbutton4editdatagrid"))) {
                    element.setAttribute("height", String.valueOf(ld.height - 18 > 0 ? ld.height - 18 : 1));
                } else {
                    element.setAttribute("height", String.valueOf(ld.height));
                }
                element.setAttribute("width", ld.width.toString());
            }
            this.mergeStyleSheet(element, "style", "overflow-x:auto;overflow-y:hidden;");
        } else if ("com.kingdee.bos.ctrl.web.Splitcontainer".equals(component.getClassType()) || "com.kingdee.bos.ctrl.web.BorderLayout".equals(component.getClassType())) {
            if (ld.width.isPercentage) {
                element.setAttribute("fit", "true");
            } else {
                element.setAttribute("fit", "false");
                element.setAttribute("height", String.valueOf(ld.height));
                element.setAttribute("width", ld.width.toString());
            }
        } else if ("com.kingdee.bos.ctrl.web.TabbedPane".equals(component.getClassType()) || "com.kingdee.bos.ctrl.web.AccordionPane".equals(component.getClassType()) || "com.kingdee.bos.ctrl.web.Tree".equals(component.getClassType())) {
            if (!ld.width.isPercentage) {
                element.setAttribute("height", String.valueOf(ld.height));
                element.setAttribute("width", ld.width.toString());
            }
        } else if ("com.kingdee.bos.ctrl.web.Label".equals(component.getClassType()) || "com.kingdee.bos.ctrl.web.ListBox".equals(component.getClassType()) || "com.kingdee.bos.ctrl.web.CommandLink".equals(component.getClassType())) {
            this.mergeStyleSheet(element, "style", ld.toCSSString());
        } else if ("com.kingdee.bos.ctrl.web.ToolBar".equals(component.getClassType())) {
            this.mergeStyleSheet(element, "style", "width:" + ld.width.toString());
        } else if ("com.kingdee.bos.ctrl.web.Container".equals(component.getClassType())) {
            this.mergeStyleSheet(element, "style", "width:" + ld.width.toString());
            element.setAttribute("height", "" + ld.height);
        } else if ("com.kingdee.bos.ctrl.web.MsgArea".equals(component.getClassType()) || "com.kingdee.bos.ctrl.web.Attachment".equals(component.getClassType())) {
            this.mergeStyleSheet(element, "style", "width:" + ld.width.toString() + ";height:" + ld.height);
        } else if (component.getClassType() != null && component.getClassType().startsWith("com.kingdee.bos.ctrl.ExtControl")) {
            this.mergeStyleSheet(element, "style", "width:" + ld.width.toString() + ";height:" + ld.height);
        } else if ("com.kingdee.bos.ctrl.web.MenuBar".equals(component.getClassType()) || "com.kingdee.bos.ctrl.web.Menu".equals(component.getClassType()) || "com.kingdee.bos.ctrl.web.CheckMenuItem".equals(component.getClassType()) || "com.kingdee.bos.ctrl.web.CommandMenuItem".equals(component.getClassType()) || "com.kingdee.bos.ctrl.web.LinkMenuItem".equals(component.getClassType()) || "com.kingdee.bos.ctrl.web.RadioMenuItem".equals(component.getClassType()) || "com.kingdee.bos.ctrl.web.Fileupload".equals(component.getClassType())) {
            this.mergeStyleSheet(element, "style", "width:" + ld.width.toString());
        } else {
            element.setAttribute("width", ld.width.toString());
            element.setAttribute("height", "" + ld.height);
        }
    }

    private Element createUserTag(ComponentInfo component) {
        PropertyInfo propertyInfo = component.getPropertyByName("tag");
        if (propertyInfo == null) {
            return null;
        }
        if (StringUtils.isEmpty((String)propertyInfo.getValue())) {
            return null;
        }
        String tag = propertyInfo.getValue();
        propertyInfo = component.getPropertyByName("namespace");
        Namespace ns = null;
        if (propertyInfo == null) {
            ns = WebTags.DEFAULTNS;
        } else {
            String nsStr = propertyInfo.getValue();
            int index = nsStr.indexOf(59);
            String prefix = nsStr.substring(0, index);
            String uri = nsStr.substring(index + 1);
            ns = Namespace.getNamespace((String)prefix, (String)uri);
        }
        ArrayList list = new ArrayList();
        Properties properties = new Properties();
        propertyInfo = component.getPropertyByName("attributes");
        if (propertyInfo != null) {
            Component2XmlHelper.string2KeyPairs(propertyInfo.getValue(), list, properties);
        }
        Element element = new Element(tag, ns);
        for (String key : list) {
            String value = properties.getProperty(key);
            element.setAttribute(key, value);
        }
        if (component.getComponents().size() > 0) {
            this.buildComponentChildren(component, element);
        }
        return element;
    }

    private Element createExtTag(ComponentInfo component) {
        String tag = component.getClassType();
        String prefix = "";
        if (tag.lastIndexOf(".") >= 0) {
            if ((tag = tag.substring(tag.lastIndexOf(".") + 1)).indexOf("_") >= 0) {
                prefix = tag.substring(0, tag.indexOf("_"));
                tag = tag.substring(tag.indexOf("_") + 1);
            }
        } else {
            return null;
        }
        Element element = new Element(tag, Component2XmlHelper.getNamespaceByPrefix(prefix));
        element.setAttribute("id", component.getName());
        this.processElement(element, component);
        return element;
    }

    private static Namespace getNamespaceByPrefix(String prefix) {
        if (StringUtils.isEmpty((String)prefix)) {
            return WebTags.DEFAULTNS;
        }
        if (WebTags.FNS.getPrefix().equalsIgnoreCase(prefix.trim())) {
            return WebTags.FNS;
        }
        if (WebTags.WNS.getPrefix().equalsIgnoreCase(prefix.trim())) {
            return WebTags.WNS;
        }
        if (WebTags.LAYOUTNS.getPrefix().equalsIgnoreCase(prefix.trim())) {
            return WebTags.LAYOUTNS;
        }
        if (WebTags.AJAXNS.getPrefix().equalsIgnoreCase(prefix.trim())) {
            return WebTags.AJAXNS;
        }
        if (WebTags.UINS.getPrefix().equalsIgnoreCase(prefix.trim())) {
            return WebTags.UINS;
        }
        if (WebTags.HNS.getPrefix().equalsIgnoreCase(prefix.trim())) {
            return WebTags.HNS;
        }
        if (WebTags.KDNS.getPrefix().equalsIgnoreCase(prefix.trim())) {
            return WebTags.KDNS;
        }
        if (WebTags.BIZNS.getPrefix().equalsIgnoreCase(prefix.trim())) {
            return WebTags.BIZNS;
        }
        if (WebTags.OMNS.getPrefix().equalsIgnoreCase(prefix.trim())) {
            return WebTags.OMNS;
        }
        return WebTags.DEFAULTNS;
    }

    private void buildClientValidator(Element element, ComponentInfo component) {
        PropertyInfo p = component.getPropertyByName("clientValidator");
        if (p == null) {
            return;
        }
        String text = p.getValue();
        if (StringUtils.isEmpty((String)text)) {
            return;
        }
        PropertyInfo message = component.getPropertyByName("clientValidatorMessage");
        String msg = "";
        if (message != null) {
            msg = Component2XmlHelper.translate2Resource(component, message);
        }
        if (msg == null) {
            msg = "";
        }
        Element sub = new Element("clientValidator", WebTags.AJAXNS);
        sub.setAttribute("message", msg);
        sub.addContent(text);
        element.addContent(sub);
    }

    private Attribute createAjaxLoggerStyleAttribute(ComponentInfo component) {
        HashMap<String, String> map = new HashMap<String, String>();
        String[] strs = StringUtils.split((String)((String)component.getConstraint()), (String)";");
        int size = strs.length;
        for (int i = 0; i < size; ++i) {
            int pos = strs[i].indexOf("=");
            map.put(strs[i].substring(0, pos), strs[i].substring(pos + 1));
        }
        StringBuffer sbStyle = new StringBuffer();
        sbStyle.append("overflow:scroll;font-size:9pt;");
        String width = (String)map.get("width");
        sbStyle.append("width:").append(width).append("px;");
        String height = (String)map.get("height");
        sbStyle.append("height:").append(height).append("px;");
        Attribute attribute = new Attribute("style", sbStyle.toString());
        return attribute;
    }

    private Attribute createAjaxScripterAttribute(ComponentInfo component) {
        HashMap<String, String> map = new HashMap<String, String>();
        String[] strs = StringUtils.split((String)((String)component.getConstraint()), (String)";");
        int size = strs.length;
        for (int i = 0; i < size; ++i) {
            int pos = strs[i].indexOf("=");
            map.put(strs[i].substring(0, pos), strs[i].substring(pos + 1));
        }
        StringBuffer sbStyle = new StringBuffer();
        sbStyle.append("overflow:scroll;font-size:9pt;");
        String width = (String)map.get("width");
        sbStyle.append("width:").append(width).append("px;");
        String height = (String)map.get("height");
        sbStyle.append("height:").append(height).append("px;");
        Attribute attribute = new Attribute("style", sbStyle.toString());
        return attribute;
    }

    private Dimension getBorderLayoutPanelDesignSize(ComponentInfo component, Dimension parent) {
        int height_offset = 0;
        PropertyInfo title = component.getPropertyByName("title");
        if (title != null && !StringUtils.isEmpty((String)title.getValue())) {
            height_offset = 25;
        }
        ComponentCollection children = component.getParent().getComponents();
        WebBorderLayoutData[] grid = new WebBorderLayoutData[5];
        for (int i = 0; i < children.size(); ++i) {
            ComponentInfo child = children.get(i);
            WebBorderLayoutData data = (WebBorderLayoutData)child.getConstraint();
            if (data == null) continue;
            if ("center".equals(data.region)) {
                grid[0] = data;
                continue;
            }
            if ("north".equals(data.region)) {
                grid[1] = data;
                continue;
            }
            if ("south".equals(data.region)) {
                grid[2] = data;
                continue;
            }
            if ("east".equals(data.region)) {
                grid[3] = data;
                continue;
            }
            if (!"west".equals(data.region)) continue;
            grid[4] = data;
        }
        WebBorderLayoutData curData = (WebBorderLayoutData)component.getConstraint();
        if ("center".equals(curData.region)) {
            int hSub = 0;
            if (grid[1] != null && grid[1].visible) {
                hSub += grid[1].heightHint;
            }
            if (grid[2] != null && grid[2].visible) {
                hSub += grid[2].heightHint;
            }
            int wSub = 0;
            if (grid[3] != null && grid[3].visible) {
                wSub += grid[3].widthHint;
            }
            if (grid[4] != null && grid[4].visible) {
                wSub += grid[4].widthHint;
            }
            return new Dimension(parent.width - wSub, parent.height - hSub - height_offset);
        }
        if ("north".equals(curData.region) || "south".equals(curData.region)) {
            return new Dimension(parent.width, curData.heightHint - height_offset);
        }
        if ("east".equals(curData.region) || "west".equals(curData.region)) {
            int hSub = 0;
            if (grid[1] != null && grid[1].visible) {
                hSub += grid[1].heightHint;
            }
            if (grid[2] != null && grid[2].visible) {
                hSub += grid[2].heightHint;
            }
            return new Dimension(curData.widthHint, parent.height - hSub - height_offset);
        }
        return new Dimension(curData.widthHint, curData.heightHint - height_offset);
    }

    private Dimension getComponentDesignSize(ComponentInfo component) {
        Object constraint = component.getConstraint();
        if (constraint instanceof Rectangle) {
            Rectangle rect = (Rectangle)constraint;
            return new Dimension(rect.width, rect.height);
        }
        if (constraint instanceof WebLayoutData) {
            WebLayoutData data = (WebLayoutData)constraint;
            if (data.width.isPercentage) {
                Dimension dim = this.getComponentDesignSize(component.getParent());
                return new Dimension((int)((float)dim.width * data.width.number), data.height);
            }
            return new Dimension((int)data.width.number, data.height);
        }
        if (constraint instanceof SmartLayoutData) {
            SmartLayoutData data = (SmartLayoutData)constraint;
            if ("com.kingdee.bos.ctrl.web.Container".equals(component.getClassType())) {
                return new Dimension(data.width - 2, data.height - 27);
            }
            if ("com.kingdee.bos.ctrl.web.Composite".equals(component.getClassType())) {
                return new Dimension(data.width, data.height - 21);
            }
            return new Dimension(data.width, data.height);
        }
        if (constraint instanceof WebBorderLayoutData) {
            return this.getBorderLayoutPanelDesignSize(component, this.getComponentDesignSize(component.getParent()));
        }
        if (constraint instanceof String && "com.kingdee.bos.ctrl.web.TablePanel".equals(component.getParent().getClassType())) {
            String s = (String)constraint;
            int index = s.indexOf("#");
            String webLayoutData = s.substring(0, index);
            String point = s.substring(index + 1);
            WebLayoutData data = WebLayoutData.parse(webLayoutData);
            if (data.width.isPercentage) {
                Point p = Component2XmlHelper.getCellLocation(point);
                Dimension size = this.getCellSize(component, p.y, p.x);
                return new Dimension((int)((float)size.width * data.width.number), data.height);
            }
            return new Dimension((int)data.width.number, data.height);
        }
        if ("com.kingdee.bos.ctrl.web.TabbedPane".equals(component.getParent().getClassType())) {
            Dimension dim = this.getComponentDesignSize(component.getParent());
            return new Dimension(dim.width, dim.height - 30);
        }
        if ("com.kingdee.bos.ctrl.web.AccordionPane".equals(component.getParent().getClassType())) {
            Dimension dim = this.getComponentDesignSize(component.getParent());
            int n = this.getAccordionChildCount(component.getParent());
            return new Dimension(dim.width, dim.height - n * 23);
        }
        if ("com.kingdee.bos.ctrl.web.Splitcontainer".equals(component.getParent().getClassType())) {
            Dimension dim = this.getComponentDesignSize(component.getParent());
            PropertyInfo dividerLocationProp = component.getParent().getPropertyByName("dividerLocation");
            int dividerLocation = 100;
            if (dividerLocationProp != null) {
                dividerLocation = Integer.parseInt(dividerLocationProp.getValue());
            }
            PropertyInfo orientationProp = component.getParent().getPropertyByName("orientation");
            int orientation = 1;
            if (orientationProp != null) {
                orientation = Integer.parseInt(orientationProp.getValue());
            }
            if (orientation == 1) {
                if ("left".equals(component.getConstraint())) {
                    return new Dimension(dividerLocation, dim.height);
                }
                return new Dimension(dim.width - dividerLocation - 5, dim.height);
            }
            if ("top".equals(component.getConstraint())) {
                return new Dimension(dim.width, dividerLocation);
            }
            return new Dimension(dim.width, dim.height - dividerLocation - 5);
        }
        throw new IllegalArgumentException("unsupported layout");
    }

    private String freeTableVerAlign(int align) {
        if (align == 0) {
            return "top";
        }
        if (align == 1) {
            return "bottom";
        }
        if (align == 2) {
            return "middle";
        }
        return "N/A";
    }

    private SmartLayoutData offset(SmartLayoutData data, Point offset) {
        return new SmartLayoutData(data.x - offset.x, data.y - offset.y, data.width, data.height, data.autoSize);
    }

    private Element createFreeTable(ComponentInfo component) {
        Dimension size = this.getComponentDesignSize(component);
        ComponentCollection cc = component.getComponents();
        int len = cc.size();
        ArrayList<ComponentInfo> list = new ArrayList<ComponentInfo>(len);
        for (int i = 0; i < len; ++i) {
            list.add(cc.get(i));
        }
        Element elem = this.createFreeTable(list, size, new Point(0, 21));
        return elem;
    }

    private Element createFreeTable(List components, Dimension size, Point offset) {
        int cur;
        int i;
        if (components.size() == 0) {
            return null;
        }
        TreeSet<Integer> rowLines = new TreeSet<Integer>();
        TreeSet<Integer> columnLines = new TreeSet<Integer>();
        HashMap<Point, ComponentInfo> componentMap = new HashMap<Point, ComponentInfo>();
        LinkedList<ComponentInfo> nonVisualComponents = new LinkedList<ComponentInfo>();
        Element element = new Element(WebTags.TABLE.getTagName(), WebTags.TABLE.getNs());
        element.setAttribute("border", "0");
        element.setAttribute("cellspacing", "0");
        element.setAttribute("cellpadding", "0");
        element.setAttribute("width", String.valueOf(size.width));
        element.setAttribute("height", String.valueOf(size.height));
        rowLines.add(0);
        rowLines.add(size.height);
        columnLines.add(0);
        columnLines.add(size.width);
        for (int i2 = 0; i2 < components.size(); ++i2) {
            ComponentInfo child = (ComponentInfo)components.get(i2);
            if (!this.isVisualComponent(child)) {
                nonVisualComponents.addFirst(child);
                continue;
            }
            SmartLayoutData rect = (SmartLayoutData)child.getConstraint();
            rect = this.offset(rect, offset);
            componentMap.put(new Point(rect.x, rect.y), child);
            rowLines.add(new Integer(rect.y));
            rowLines.add(new Integer(rect.y + rect.height));
            columnLines.add(new Integer(rect.x));
            columnLines.add(new Integer(rect.x + rect.width));
        }
        for (ComponentInfo child : nonVisualComponents) {
            Element childElement = this.createElement(child);
            if (childElement == null) continue;
            element.addContent(childElement);
        }
        Integer[] rowArray = new Integer[rowLines.size()];
        Integer[] columnArray = new Integer[columnLines.size()];
        rowLines.toArray(rowArray);
        columnLines.toArray(columnArray);
        Element rowElement = new Element("tr", WebTags.DEFAULTNS);
        rowElement.setAttribute("height", "0");
        element.addContent(rowElement);
        for (int j = 0; j < columnArray.length - 1; ++j) {
            int from = columnArray[j];
            int to = columnArray[j + 1];
            int width = to - from;
            Element cellElement = new Element("td", WebTags.DEFAULTNS);
            rowElement.addContent(cellElement);
            cellElement.setAttribute("width", String.valueOf(width));
        }
        Table tableModel = new Table();
        for (i = cur = tableModel.getRowCount(); i < rowArray.length - 1; ++i) {
            TableRow row = tableModel.addRow();
            row.setHeight(rowArray[i + 1] - rowArray[i]);
        }
        for (i = cur = tableModel.getColumnCount(); i < columnArray.length - 1; ++i) {
            TableColumn column = tableModel.addColumn();
            column.setWidth(columnArray[i + 1] - columnArray[i]);
        }
        for (i = 0; i < components.size(); ++i) {
            ComponentInfo child = (ComponentInfo)components.get(i);
            if (!this.isVisualComponent(child)) {
                nonVisualComponents.addFirst(child);
                continue;
            }
            SmartLayoutData bounds = (SmartLayoutData)child.getConstraint();
            bounds = this.offset(bounds, offset);
            int x1 = bounds.x;
            int x2 = bounds.x + bounds.width;
            int x1_index = 0;
            int x2_index = 0;
            int y1 = bounds.y;
            int y2 = bounds.y + bounds.height;
            int y1_index = 0;
            int y2_index = 0;
            for (int r = 0; r < rowArray.length; ++r) {
                if (y1 == rowArray[r]) {
                    y1_index = r;
                }
                if (y2 != rowArray[r]) continue;
                y2_index = r;
            }
            for (int c = 0; c < columnArray.length; ++c) {
                if (x1 == columnArray[c]) {
                    x1_index = c;
                }
                if (x2 != columnArray[c]) continue;
                x2_index = c;
            }
            int colspan = x2_index - x1_index;
            int rowspan = y2_index - y1_index;
            TableCell cell = tableModel.getCell(y1_index, x1_index);
            if (cell == null) continue;
            cell.setData(child);
            if (colspan <= 1 && rowspan <= 1) continue;
            tableModel.mergeCell(y1_index, x1_index, y2_index - 1, x2_index - 1);
        }
        for (i = cur; i < rowArray.length - 1; ++i) {
            TableRow row = tableModel.getRow(i);
            if (row == null) continue;
            rowElement = new Element("tr", WebTags.DEFAULTNS);
            rowElement.setAttribute("height", String.valueOf(row.getHeight()));
            element.addContent(rowElement);
            for (int j = cur; j < columnArray.length - 1; ++j) {
                Element componentElement;
                Object obj;
                TableCell cell = tableModel.getCell(i, j);
                if (cell == null || cell.isMerged() && cell != cell.getMergedCell()) continue;
                Element cellElement = new Element("td", WebTags.DEFAULTNS);
                rowElement.addContent(cellElement);
                if (cell.isMerged()) {
                    int colspan;
                    int rowspan = cell.getRowSpan();
                    if (rowspan > 1) {
                        cellElement.setAttribute("rowspan", String.valueOf(rowspan));
                    }
                    if ((colspan = cell.getColumnSpan()) > 1) {
                        cellElement.setAttribute("colspan", String.valueOf(colspan));
                    }
                }
                if (!((obj = cell.getData()) instanceof ComponentInfo) || (componentElement = this.createElement((ComponentInfo)obj)) == null) continue;
                cellElement.addContent(componentElement);
            }
        }
        return element;
    }

    private int getAccordionChildCount(ComponentInfo cInfo) {
        int n = 0;
        if (cInfo != null && "com.kingdee.bos.ctrl.web.AccordionPane".equals(cInfo.getClassType())) {
            ComponentCollection col = cInfo.getComponents();
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                ComponentInfo child = col.get(i);
                if (!"com.kingdee.bos.ctrl.web.Panel".equals(child.getClassType()) && !"com.kingdee.bos.ctrl.web.FreePanel".equals(child.getClassType())) continue;
                ++n;
            }
        }
        return n;
    }

    private Element createPanelElement4FreePanel(ComponentInfo freepanel) {
        Element panel = new Element(WebTags.PANEL.getTagName(), WebTags.PANEL.getNs());
        String s = (String)freepanel.getConstraint();
        PropertyInfo title = new PropertyInfo();
        title.setName("title");
        title.setValue(s);
        title.setMultiLanguage(true);
        freepanel.getProperties().add(title);
        if (freepanel.getParent() != null && !"com.kingdee.bos.ctrl.web.Splitcontainer".equals(freepanel.getParent().getClassType())) {
            panel.setAttribute(Component2XmlHelper.createAttribute(freepanel, title));
        }
        panel.setAttribute("align", "left");
        panel.addContent(this.createSmartLayout(freepanel));
        return panel;
    }

    private Element createSmartLayout(ComponentInfo component) {
        if (component != null && "com.kingdee.bos.ctrl.web.Container".equals(component.getClassType())) {
            return this.createFreeTable(component);
        }
        Dimension size = this.getComponentDesignSize(component);
        ComponentInfo parent = component.getParent();
        LinkedList<ComponentInfo> nonVisualComponents = new LinkedList<ComponentInfo>();
        ComponentCollection components = component.getComponents();
        Element element = null;
        if (parent != null && "com.kingdee.bos.ctrl.web.RootPane".equals(parent.getClassType())) {
            element = new Element(WebTags.KDROOTLAYOUT.getTagName(), WebTags.KDROOTLAYOUT.getNs());
            if ("true".equals(this.model.getExtendedProperty("height_self_adaption"))) {
                element.setAttribute("heightAdaptive", "true");
            }
        } else {
            element = new Element(WebTags.KDLAYOUT.getTagName(), WebTags.KDLAYOUT.getNs());
        }
        this.mergeStyleSheet(element, "style", "width:100%;");
        element.setAttribute("height", String.valueOf(size.height));
        element.setAttribute("originalWidth", String.valueOf(size.width));
        element.setAttribute("originalHeight", String.valueOf(size.height));
        PropertyInfo border = component.getPropertyByName("border");
        if (border == null || "0".equals(border.getValue())) {
            element.setAttribute("border", "0");
        }
        if (parent != null && "com.kingdee.bos.ctrl.web.RootPane".equals(parent.getClassType())) {
            this.rootJsVar = Component2XmlHelper.getJsVar(component);
            element.setAttribute("jsvar", this.rootJsVar);
        }
        if ("com.kingdee.bos.ctrl.web.FreePanel".equals(component.getClassType())) {
            element.setAttribute("id", component.getName());
        }
        List coms = this.reorderComponents(components);
        coms = this.getComponentList(coms);
        for (int i = 0; i < coms.size(); ++i) {
            ComponentInfo child = (ComponentInfo)coms.get(i);
            if (!this.isVisualComponent(child)) {
                nonVisualComponents.addFirst(child);
                Element childElement = this.createElement(child);
                if (childElement == null) continue;
                element.addContent(childElement);
                continue;
            }
            Element componentElement = this.createElement(child);
            if (componentElement == null) continue;
            Object constraint = child.getConstraint();
            Element layoutPanel = new Element(WebTags.KDLAYOUTPANEL.getTagName(), WebTags.KDLAYOUTPANEL.getNs());
            if (constraint instanceof SmartLayoutData) {
                SmartLayoutData data = (SmartLayoutData)constraint;
                int y = this.getCorrectY(component, child, data.y);
                layoutPanel.setAttribute("x", String.valueOf(data.x));
                layoutPanel.setAttribute("y", String.valueOf(y));
                layoutPanel.setAttribute("width", String.valueOf(data.width));
                layoutPanel.setAttribute("originalX", String.valueOf(data.x));
                layoutPanel.setAttribute("originalY", String.valueOf(y));
                layoutPanel.setAttribute("originalWidth", String.valueOf(data.width));
                int height = this.getCorrectHeight(child, data.height);
                if (height >= 0) {
                    layoutPanel.setAttribute("height", String.valueOf(height));
                    layoutPanel.setAttribute("originalHeight", String.valueOf(height));
                }
                layoutPanel.setAttribute("classType", child.getClassType());
                layoutPanel.setAttribute("kdAnchor", String.valueOf(data.autoSize));
                if (WebUIModelMapper.isCtrlNeedResize(child.getClassType())) {
                    String child_jsvar = Component2XmlHelper.getJsVar(child);
                    componentElement.setAttribute("jsvar", child_jsvar);
                    layoutPanel.setAttribute("childItem", child_jsvar);
                }
            }
            this.smartLayoutChileProcess(child, componentElement);
            layoutPanel.setAttribute("border", "0");
            layoutPanel.addContent(componentElement);
            element.addContent(layoutPanel);
        }
        return element;
    }

    private List reorderComponents(ComponentCollection components) {
        ArrayList<ComponentInfo> list = new ArrayList<ComponentInfo>();
        if (components != null) {
            int i;
            LinkedList<ComponentInfo> last = new LinkedList<ComponentInfo>();
            for (i = 0; i < components.size(); ++i) {
                ComponentInfo child = components.get(i);
                if ("com.kingdee.bos.ctrl.web.MsgArea".equals(child.getClassType())) {
                    last.add(child);
                    continue;
                }
                list.add(child);
            }
            for (i = 0; i < last.size(); ++i) {
                list.add((ComponentInfo)last.get(i));
            }
        }
        return list;
    }

    private int getCorrectY(ComponentInfo cInfo, ComponentInfo child, int y) {
        PropertyInfo title;
        if (cInfo != null && "com.kingdee.bos.ctrl.web.Container".equals(cInfo.getClassType())) {
            return this.getCorrectYBySelf(child, y - 21);
        }
        if (cInfo != null && "com.kingdee.bos.ctrl.web.Composite".equals(cInfo.getClassType())) {
            return this.getCorrectYBySelf(child, y - 21);
        }
        if (cInfo != null && "com.kingdee.bos.ctrl.web.BorderLayoutPanel".equals(cInfo.getClassType()) && (title = cInfo.getPropertyByName("title")) != null && !StringUtils.isEmpty((String)title.getValue())) {
            return this.getCorrectYBySelf(child, y - 25);
        }
        return this.getCorrectYBySelf(child, y);
    }

    private int getCorrectYBySelf(ComponentInfo child, int y) {
        if (("com.kingdee.bos.ctrl.web.DataGrid".equals(child.getClassType()) || "com.kingdee.bos.ctrl.web.EditDataGrid".equals(child.getClassType())) && "true".equals(child.getExtendedProperty("createbutton4editdatagrid"))) {
            return y + 18;
        }
        return y;
    }

    private int getCorrectHeight(ComponentInfo cInfo, int height) {
        if (cInfo != null) {
            if ("com.kingdee.bos.ctrl.web.TextArea".equals(cInfo.getClassType())) {
                return height + 1;
            }
            if ("com.kingdee.bos.ctrl.web.LabelContainer".equals(cInfo.getClassType())) {
                if (height < 22) {
                    return 22;
                }
            } else if ("com.kingdee.bos.ctrl.web.DataGrid".equals(cInfo.getClassType()) || "com.kingdee.bos.ctrl.web.EditDataGrid".equals(cInfo.getClassType())) {
                if ("true".equals(cInfo.getExtendedProperty("createbutton4editdatagrid"))) {
                    return height - 18 > 0 ? height - 18 : 1;
                }
            } else if ("com.kingdee.bos.ctrl.web.MsgArea".equals(cInfo.getClassType())) {
                return -1;
            }
        }
        return height;
    }

    private void smartLayoutChileProcess(ComponentInfo cInfo, Element element) {
        if (cInfo != null && element != null && "com.kingdee.bos.ctrl.web.TextArea".equals(cInfo.getClassType())) {
            this.mergeStyleSheet(element, "style", "margin-top:1px");
        }
    }

    private Element getRootFormElement(Element element) {
        if (element == null) {
            return null;
        }
        WebTag formTag = WebUIModelMapper.getElementWebTag("com.kingdee.bos.ctrl.web.Form");
        if (formTag.getTagName().equals(element.getName()) && formTag.getNs().equals((Object)element.getNamespace())) {
            return element;
        }
        List children = element.getChildren();
        for (Element child : children) {
            Element form = this.getRootFormElement(child);
            if (form == null) continue;
            return form;
        }
        return null;
    }

    private boolean notNeedBounds(ComponentInfo component) {
        if ("com.kingdee.bos.ctrl.web.CheckBox".equals(component.getClassType())) {
            return true;
        }
        if ("com.kingdee.bos.ctrl.web.FileUploadDialog".equals(component.getClassType())) {
            return false;
        }
        return !this.isVisualComponent(component);
    }

    private boolean isVisualComponent(ComponentInfo component) {
        return !"com.kingdee.bos.ctrl.web.UseBean".equals(component.getClassType()) && !"com.kingdee.bos.ctrl.web.AjaxTimer".equals(component.getClassType()) && !"com.kingdee.bos.ctrl.web.AjaxScripter".equals(component.getClassType()) && !"com.kingdee.bos.ctrl.web.AjaxStatus".equals(component.getClassType()) && !"com.kingdee.bos.ctrl.web.EditableColumn".equals(component.getClassType()) && !"com.kingdee.bos.ctrl.web.Column".equals(component.getClassType()) && !"com.kingdee.bos.ctrl.web.TreeNode".equals(component.getClassType()) && !"com.kingdee.bos.ctrl.web.ContextMenu".equals(component.getClassType()) && !"com.kingdee.bos.ctrl.web.AjaxProgress".equals(component.getClassType()) && !"com.kingdee.bos.ctrl.web.FileUploadDialog".equals(component.getClassType());
    }

    public Element buildElementTree(ComponentInfo component) {
        Element element = this.createElement(component);
        Element form = this.getRootFormElement(element);
        if (form != null && form.getParent() != null) {
            Element parent = form.getParent();
            List children = form.getChildren();
            ArrayList<Element> bak = new ArrayList<Element>(children.size());
            for (Element child : children) {
                bak.add(child);
            }
            form.removeChildren();
            for (Element child : bak) {
                parent.addContent(child);
            }
            parent.removeContent(form);
            children = element.getChildren();
            bak = new ArrayList(children.size());
            for (Element child : children) {
                bak.add(child);
            }
            element.removeChildren();
            for (Element child : bak) {
                form.addContent(child);
            }
            element.addContent(form);
        }
        return element;
    }

    public Element createElement(ComponentInfo component) {
        if ("com.kingdee.bos.ctrl.web.UserTag".equals(component.getClassType()) || "com.kingdee.bos.ctrl.web.VisualUserTag".equals(component.getClassType())) {
            return this.createUserTag(component);
        }
        if ("com.kingdee.bos.ctrl.web.FreePanel".equals(component.getClassType())) {
            if ("com.kingdee.bos.ctrl.web.TabbedPane".equals(component.getParent().getClassType()) || "com.kingdee.bos.ctrl.web.Splitcontainer".equals(component.getParent().getClassType()) || "com.kingdee.bos.ctrl.web.AccordionPane".equals(component.getParent().getClassType())) {
                return this.createPanelElement4FreePanel(component);
            }
            return this.createSmartLayout(component);
        }
        if (component.getClassType() != null && component.getClassType().startsWith("com.kingdee.bos.ctrl.ExtControl")) {
            return this.createExtTag(component);
        }
        WebTag webTag = WebUIModelMapper.getElementWebTag(component);
        if (webTag == null) {
            return null;
        }
        if ("com.kingdee.bos.ctrl.web.TablePanel".equals(component.getClassType())) {
            Element element = this.createTableElement(component);
            this.setElementBounds(element, component);
            return element;
        }
        Element element = null;
        if ("com.kingdee.bos.ctrl.web.EditableColumn".equals(component.getClassType())) {
            PropertyInfo idColumn = component.getPropertyByName("idColumn");
            boolean isId = false;
            if (idColumn != null) {
                isId = Boolean.valueOf(idColumn.getValue());
                if (isId) {
                    element = new Element(WebTags.IDCOLUMN.getTagName(), WebTags.IDCOLUMN.getNs());
                    element.setAttribute("id", component.getName());
                } else {
                    element = Component2XmlHelper.createElementWithID(webTag, component.getName());
                }
            } else {
                element = Component2XmlHelper.createElementWithID(webTag, component.getName());
            }
        } else if ("com.kingdee.bos.ctrl.web.BorderLayoutPanel".equals(component.getClassType())) {
            WebBorderLayoutData constraint = (WebBorderLayoutData)component.getConstraint();
            if (!constraint.visible) {
                return null;
            }
            element = Component2XmlHelper.createElementWithID(webTag, component.getName());
        } else {
            element = Component2XmlHelper.createElementWithID(webTag, component.getName());
        }
        this.processElement(element, component);
        return element;
    }

    private void processElement(Element element, ComponentInfo component) {
        Layout layout;
        Object constraint;
        ComponentCollection col;
        Attribute attribute;
        this.specialProcess(element, component);
        this.buildClientValidator(element, component);
        this.setElementBounds(element, component);
        com.kingdee.bos.metadata.ui.PropertyCollection properties = component.getProperties();
        boolean buildFont = false;
        int n = properties.size();
        for (int i = 0; i < n; ++i) {
            Element subElement;
            if ("font".equals(properties.get(i).getName())) {
                this.buildFontStyle(element, component, properties.get(i).getValue());
                buildFont = true;
                continue;
            }
            if ("binding".equals(properties.get(i).getName())) {
                if (Component2XmlHelper.isEL(properties.get(i).getValue())) {
                    element.setAttribute("binding", properties.get(i).getValue());
                    continue;
                }
                element.setAttribute("binding", "#{" + this.getBeanName(this.model) + "." + properties.get(i).getValue() + "}");
                continue;
            }
            if ("actionBinding".equals(properties.get(i).getName())) {
                String action = properties.get(i).getValue();
                if (StringUtils.isEmpty((String)action)) continue;
                if (Component2XmlHelper.isEL(action)) {
                    element.setAttribute("actionBinding", action);
                    continue;
                }
                element.setAttribute("actionBinding", "#{" + this.getBeanName(this.model) + "." + action + "}");
                continue;
            }
            if ("foreground".equals(properties.get(i).getName())) {
                this.buildForegroundColorStyle(element, component, properties.get(i).getValue());
                continue;
            }
            if ("background".equals(properties.get(i).getName())) {
                this.buildBackgroundColorStyle(element, component, properties.get(i).getValue());
                continue;
            }
            if ("style".equals(properties.get(i).getName())) {
                this.mergeStyleSheet(element, "style", properties.get(i).getValue());
                continue;
            }
            if ("items".equals(properties.get(i).getName()) && ("com.kingdee.bos.ctrl.web.ComboBox".equals(component.getClassType()) || "com.kingdee.bos.ctrl.web.CheckBoxGroup".equals(component.getClassType()) || "com.kingdee.bos.ctrl.web.RadioGroup".equals(component.getClassType()) || "com.kingdee.bos.ctrl.web.ListBox".equals(component.getClassType()) || "com.kingdee.bos.ctrl.web.RadioMenuItem".equals(component.getClassType()))) {
                ArrayList list = new ArrayList();
                Properties props = new Properties();
                Component2XmlHelper.string2KeyPairs(properties.get(i).getValue(), list, props);
                for (String key : list) {
                    String value = props.getProperty(key);
                    subElement = new Element("selectItem", WebTags.FNS);
                    subElement.setAttribute("itemLabel", "#{extraMsgs['" + component.getName() + ".items." + key + "']}");
                    subElement.setAttribute("itemValue", key);
                    element.addContent(subElement);
                }
                continue;
            }
            if ("selectItems".equals(properties.get(i).getName()) && ("com.kingdee.bos.ctrl.web.ComboBox".equals(component.getClassType()) || "com.kingdee.bos.ctrl.web.CheckBoxGroup".equals(component.getClassType()) || "com.kingdee.bos.ctrl.web.RadioGroup".equals(component.getClassType()) || "com.kingdee.bos.ctrl.web.ListBox".equals(component.getClassType()))) {
                subElement = new Element("selectItems", WebTags.FNS);
                subElement.setAttribute("id", component.getName() + "_selectItems_");
                subElement.setAttribute("value", properties.get(i).getValue());
                element.addContent(subElement);
                continue;
            }
            if ("direction".equals(properties.get(i).getName()) && ("com.kingdee.bos.ctrl.web.CheckBoxGroup".equals(component.getClassType()) || "com.kingdee.bos.ctrl.web.RadioGroup".equals(component.getClassType()))) {
                if ("1".equals(properties.get(i).getValue())) {
                    element.setAttribute("direction", "v");
                    continue;
                }
                element.setAttribute("direction", "h");
                continue;
            }
            if ("value".equals(properties.get(i).getName()) && "com.kingdee.bos.ctrl.web.DataGrid".equals(component.getClassType())) {
                if (Component2XmlHelper.isEL(properties.get(i).getValue())) {
                    element.setAttribute("value", properties.get(i).getValue());
                    continue;
                }
                String attributeValue = this.getBeanName(this.model);
                if (StringUtils.isEmpty((String)attributeValue)) continue;
                attributeValue = "#{" + attributeValue + "." + properties.get(i).getValue() + "}";
                element.setAttribute("value", attributeValue);
                continue;
            }
            if ("clientValidator".equals(properties.get(i).getName()) || "clientValidatorMessage".equals(properties.get(i).getName())) continue;
            if ("com.kingdee.bos.ctrl.web.Splitcontainer".equals(component.getClassType())) {
                if ("orientation".equals(properties.get(i).getName()) || !"dividerLocation".equals(properties.get(i).getName())) continue;
                continue;
            }
            if ("castType".equals(properties.get(i).getName())) {
                String pattern = "yyyy-MM-dd";
                if ("com.kingdee.bos.ctrl.web.DateField".equals(component.getClassType())) {
                    pattern = "yyyy-MM-dd";
                } else if ("com.kingdee.bos.ctrl.web.DateTimeField".equals(component.getClassType())) {
                    pattern = "yyyy-MM-dd HH:mm";
                } else if ("com.kingdee.bos.ctrl.web.TimeField".equals(component.getClassType())) {
                    pattern = "HH:mm:ss";
                    element.setAttribute("format", "G:i:s");
                }
                subElement = new Element("convertAllDate", WebTags.KDNS);
                subElement.setAttribute("pattern", pattern);
                subElement.setAttribute(Component2XmlHelper.createAttribute(component, properties.get(i)));
                element.addContent(subElement);
                continue;
            }
            if ("com.kingdee.bos.ctrl.web.Splitcontainer".equals(component.getClassType())) {
                if ("orientation".equals(properties.get(i).getName()) || !"dividerLocation".equals(properties.get(i).getName())) continue;
                continue;
            }
            if ("uploadListener".equals(properties.get(i).getName())) {
                if (Component2XmlHelper.isEL(properties.get(i).getValue())) {
                    element.setAttribute("uploadListener", properties.get(i).getValue());
                    continue;
                }
                element.setAttribute("uploadListener", "#{" + this.getBeanName(this.model) + "." + properties.get(i).getValue() + "}");
                continue;
            }
            if ("image".equals(properties.get(i).getName()) && "com.kingdee.bos.ctrl.web.CommandLink".equals(component.getClassType())) {
                Element img = new Element("img", WebTags.DEFAULTNS);
                img.setAttribute("src", properties.get(i).getValue());
                element.addContent(img);
                continue;
            }
            if ("jsvar".equals(properties.get(i).getName())) {
                element.setAttribute("jsvar", Component2XmlHelper.getJsVar(component));
                continue;
            }
            attribute = Component2XmlHelper.createAttribute(component, properties.get(i));
            if (attribute == null) continue;
            element.setAttribute(attribute);
        }
        if (!buildFont && ("com.kingdee.bos.ctrl.web.Label".equals(component.getClassType()) || "com.kingdee.bos.ctrl.web.ListBox".equals(component.getClassType()))) {
            this.buildFontStyle(element, component, "family=Dialog;name=Dialog;style=0;size=12");
        }
        if ("com.kingdee.bos.ctrl.web.LabelContainer".equals(component.getClassType()) && (col = component.getComponents()) != null && col.size() > 0) {
            ComponentInfo field = col.get(0);
            element.setAttribute("childItem", Component2XmlHelper.getJsVar(field));
        }
        if (component.getParent() != null && "com.kingdee.bos.ctrl.web.LabelContainer".equals(component.getParent().getClassType())) {
            element.setAttribute("jsvar", Component2XmlHelper.getJsVar(component));
        }
        if (!"com.kingdee.bos.ctrl.web.DataGrid".equals(component.getClassType()) && !"com.kingdee.bos.ctrl.web.EditDataGrid".equals(component.getClassType())) {
            PropertyBindingCollection pbCol = component.getPropertyBindings();
            int n2 = pbCol.size();
            for (int i = 0; i < n2; ++i) {
                attribute = this.createAttribute(element, component, pbCol.get(i), "");
                if (attribute == null) continue;
                element.setAttribute(attribute);
            }
        }
        if ("com.kingdee.bos.ctrl.web.AjaxLogger".equals(component.getClassType())) {
            Attribute attrStyle = this.createAjaxLoggerStyleAttribute(component);
            element.setAttribute(attrStyle);
        }
        if ("com.kingdee.bos.ctrl.web.Composite".equals(component.getClassType())) {
            element.setAttribute("bodyStyle", "border:1px solid #c8c8c8;border-top:0px;");
            Attribute title = element.getAttribute("title");
            if (title == null) {
                element.setAttribute("title", "");
            }
        }
        if ("com.kingdee.bos.ctrl.web.BorderLayoutPanel".equals(component.getClassType()) && (constraint = component.getConstraint()) instanceof WebBorderLayoutData) {
            element.setAttribute("region", ((WebBorderLayoutData)constraint).region);
        }
        EventBindingCollection ebc = component.getEventBindings();
        boolean isListGrid = this.isListUIGrid(component);
        boolean selectionChange = false;
        for (int i = 0; i < ebc.size(); ++i) {
            EventBindingInfo eb = ebc.get(i);
            String methodName = eb.getMethodName();
            AjaxAction action = this.parseAjaxAction(methodName);
            if (action == null) {
                element.setAttribute(eb.getEventName(), "#{" + this.getBeanName(this.model) + "." + methodName + "}");
                continue;
            }
            if (!StringUtils.isEmpty((String)action.getEventHandler())) {
                element.setAttribute(eb.getEventName(), action.getEventHandler());
            }
            if (StringUtils.isEmpty((String)action.getAction()) && StringUtils.isEmpty((String)action.getActionListener())) continue;
            Element actionElement = new Element("action", WebTags.AJAXNS);
            element.addContent(actionElement);
            if (!StringUtils.isEmpty((String)action.getAction())) {
                actionElement.setAttribute("action", "#{" + this.getBeanName(this.model) + "." + action.getAction() + "}");
            }
            if (!StringUtils.isEmpty((String)action.getActionListener())) {
                actionElement.setAttribute("actionListener", "#{" + this.getBeanName(this.model) + "." + action.getActionListener() + "}");
            }
            actionElement.setAttribute("rendered", String.valueOf(action.isRendered()));
            actionElement.setAttribute("immediate", String.valueOf(action.isImmediate()));
            actionElement.setAttribute("event", eb.getEventName());
            if (!isListGrid || !"onselectionchange".equals(eb.getEventName())) continue;
            selectionChange = true;
        }
        if (isListGrid && !selectionChange) {
            Element selectionChangeAction = new Element("action", WebTags.AJAXNS);
            selectionChangeAction.setAttribute("actionListener", "#{" + this.getBeanName(this.model) + ".grid_onselectionchange_actionPerformed}");
            selectionChangeAction.setAttribute("rendered", "true");
            selectionChangeAction.setAttribute("immediate", "false");
            selectionChangeAction.setAttribute("event", "onselectionchange");
            element.addContent(selectionChangeAction);
        }
        if (component.isContainer() && (layout = LayoutConverter.convertToLayoutObj(component.getLayoutInfo())) instanceof WebLayout) {
            WebLayout webLayout = (WebLayout)layout;
            String align = null;
            align = webLayout.getHorizontalAlign() == WebLayout.H_ALIGN_LEFT ? "left" : (webLayout.getHorizontalAlign() == WebLayout.H_ALIGN_RIGHT ? "right" : "center");
            if ("com.kingdee.bos.ctrl.web.Panel".equals(component.getClassType())) {
                if ("com.kingdee.bos.ctrl.web.TabbedPane".equals(component.getParent().getClassType()) || "com.kingdee.bos.ctrl.web.AccordionPane".equals(component.getParent().getClassType())) {
                    PropertyInfo title = component.getPropertyByName("title");
                    String s = Component2XmlHelper.translate2Resource(component, title);
                    if (StringUtils.isEmpty((String)s)) {
                        s = (String)component.getConstraint();
                    }
                    element.setAttribute("title", s);
                }
                element.setAttribute("align", align);
            }
            if (!"com.kingdee.bos.ctrl.web.EditDataGrid".equals(component.getClassType())) {
                element.setAttribute("align", align);
            }
        }
        if (component.isContainer()) {
            layout = LayoutConverter.convertToLayoutObj(component.getLayoutInfo());
            if (layout instanceof SmartLayout) {
                Element freeTableElem = this.createSmartLayout(component);
                element.addContent(freeTableElem);
            } else {
                this.buildComponentChildren(component, element);
            }
        }
    }

    private void specialProcess(Element element, ComponentInfo component) {
        if (element != null && component != null && "com.kingdee.bos.ctrl.web.Panel".equals(component.getClassType())) {
            int count = 0;
            ComponentCollection components = component.getComponents();
            for (int i = 0; i < components.size(); ++i) {
                ComponentInfo child = components.get(i);
                if (!"com.kingdee.bos.ctrl.web.Panel".equals(child.getClassType()) && !"com.kingdee.bos.ctrl.web.Composite".equals(child.getClassType())) continue;
                ++count;
            }
            if (count > 1) {
                Element hidden = new Element(WebTags.PANEL.getTagName(), WebTags.PANEL.getNs());
                hidden.setAttribute("height", "0");
                hidden.setAttribute("collapsed", "true");
                element.addContent(hidden);
            }
        }
    }

    private void buildComponentChildren(ComponentInfo component, Element element) {
        if ("com.kingdee.bos.ctrl.web.Splitcontainer".equals(component.getClassType())) {
            PropertyInfo dividerLocation = component.getPropertyByName("dividerLocation");
            int width = dividerLocation == null ? -1 : Integer.parseInt(dividerLocation.getValue());
            ComponentCollection col = component.getComponents();
            int n = col.size();
            for (int i = 0; i < n; ++i) {
                Element subElement = this.createElement(col.get(i));
                if (subElement == null) continue;
                subElement.setAttribute("split", "true");
                ComponentInfo child = col.get(i);
                if ("left".equals(child.getConstraint())) {
                    subElement.setAttribute("region", "west");
                    if (width > 0) {
                        subElement.setAttribute("width", String.valueOf(width));
                    }
                } else if ("right".equals(child.getConstraint())) {
                    subElement.setAttribute("region", "center");
                } else if ("top".equals(child.getConstraint())) {
                    subElement.setAttribute("region", "north");
                    if (width > 0) {
                        subElement.setAttribute("height", String.valueOf(width));
                    }
                } else if ("bottom".equals(child.getConstraint())) {
                    subElement.setAttribute("region", "center");
                }
                element.addContent(subElement);
            }
        } else {
            List col = this.getComponentList(component);
            int n = col.size();
            for (int i = 0; i < n; ++i) {
                ComponentInfo child = (ComponentInfo)col.get(i);
                Element subElement = this.createElement(child);
                if (subElement == null) continue;
                element.addContent(subElement);
            }
        }
    }

    private List getComponentList(ComponentInfo cInfo) {
        if (cInfo != null) {
            ComponentCollection col = cInfo.getComponents();
            ArrayList<ComponentInfo> list = new ArrayList<ComponentInfo>(col.size());
            int n = col.size();
            for (int i = 0; i < n; ++i) {
                ComponentInfo child = col.get(i);
                if ("com.kingdee.bos.ctrl.web.EditDataGrid".equals(child.getClassType())) {
                    this.createButton4EditdataGrid(child, list);
                }
                list.add(child);
            }
            return list;
        }
        return new ArrayList(0);
    }

    private List getComponentList(List col) {
        if (col != null) {
            ArrayList<ComponentInfo> list = new ArrayList<ComponentInfo>(col.size());
            int n = col.size();
            for (int i = 0; i < n; ++i) {
                ComponentInfo child = (ComponentInfo)col.get(i);
                if ("com.kingdee.bos.ctrl.web.EditDataGrid".equals(child.getClassType())) {
                    this.createButton4EditdataGrid(child, list);
                }
                list.add(child);
            }
            return list;
        }
        return new ArrayList(0);
    }

    private void createButton4EditdataGrid(ComponentInfo datagrid, List col) {
        PropertyInfo value;
        if (col != null && "true".equals(datagrid.getExtendedProperty("createbutton4editdatagrid")) && (value = datagrid.getPropertyByName("value")) != null) {
            EntityObjectInfo entity = this.getEditDataGridBindEntity(datagrid);
            if (entity == null) {
                return;
            }
            ComponentInfo addRow = new ComponentInfo("com.kingdee.bos.ctrl.web.CommandLink");
            addRow.setName("_" + datagrid.getName() + "_addRow");
            addRow.setParent(datagrid.getParent());
            PropertyInfo pInfo = new PropertyInfo();
            pInfo.setName("image");
            pInfo.setValue("#{skin.getSkinReourceURL('/widget/images/table1_button_add.gif')}");
            addRow.getProperties().add(pInfo);
            pInfo = new PropertyInfo();
            pInfo.setName("action");
            pInfo.setValue("#{" + this.getBeanName(this.model) + "." + StringUtils.headCharLowerCase((String)entity.getName()) + "Bean_apendRow}");
            addRow.getProperties().add(pInfo);
            ComponentInfo removeRow = new ComponentInfo("com.kingdee.bos.ctrl.web.CommandLink");
            removeRow.setName("_" + datagrid.getName() + "_removeRow");
            removeRow.setParent(datagrid.getParent());
            pInfo = new PropertyInfo();
            pInfo.setName("image");
            pInfo.setValue("#{skin.getSkinReourceURL('/widget/images/table1_button_delete.gif')}");
            removeRow.getProperties().add(pInfo);
            pInfo = new PropertyInfo();
            pInfo.setName("action");
            pInfo.setValue("#{" + this.getBeanName(this.model) + "." + StringUtils.headCharLowerCase((String)entity.getName()) + "Bean_removeRow}");
            removeRow.getProperties().add(pInfo);
            Object constraint = datagrid.getConstraint();
            if (constraint instanceof WebLayoutData) {
                WebLayoutData addCon = new WebLayoutData(WebLayoutData.Unit.absolute(30), 15);
                addRow.setConstraint(addCon);
                WebLayoutData delCon = new WebLayoutData(WebLayoutData.Unit.absolute(30), 15);
                removeRow.setConstraint(delCon);
            } else if (constraint instanceof SmartLayoutData) {
                SmartLayoutData con = (SmartLayoutData)constraint;
                int x = con.x;
                int y = con.y;
                int width = con.width;
                x = x + width - 60;
                int anchor = 0;
                int[] sideAnchor = UIUtils.getSideAnchor(con.autoSize);
                anchor = sideAnchor[4] == 1 ? 16 : sideAnchor[0] + sideAnchor[3];
                SmartLayoutData addCon = new SmartLayoutData(x, y, 25, 15, anchor);
                addRow.setConstraint(addCon);
                SmartLayoutData delCon = new SmartLayoutData(x + 30, y, 25, 15, anchor);
                removeRow.setConstraint(delCon);
            } else {
                return;
            }
            col.add(addRow);
            col.add(removeRow);
        }
    }

    public EntityObjectInfo getEditDataGridBindEntity(ComponentInfo datagrid) {
        ComponentInfo column;
        EntityObjectInfo entity = this.getBindedEntity();
        if (entity == null) {
            return null;
        }
        PropertyBindingInfo pbInfo = null;
        ComponentCollection columns = datagrid.getComponents();
        int size = columns.size();
        for (int i = 0; i < size && ((pbInfo = (column = columns.get(i)).getPropertyBindings().get("value")) == null || StringUtils.isEmpty((String)pbInfo.getBingdingField())); ++i) {
            pbInfo = null;
        }
        if (pbInfo == null) {
            return null;
        }
        String bindField = pbInfo.getBingdingField();
        return Component2XmlHelper.getEntityByPropertyName(entity, bindField);
    }

    public static EntityObjectInfo getEntityByPropertyName(EntityObjectInfo entity, String propertyName) {
        if (entity == null || StringUtils.isEmpty((String)propertyName)) {
            return null;
        }
        if (propertyName.indexOf(".") != propertyName.lastIndexOf(".")) {
            return null;
        }
        if (propertyName.indexOf(".") > 0) {
            propertyName = propertyName.substring(0, propertyName.indexOf(".")).trim();
        }
        PropertyCollection col = entity.getInheritedProperties();
        for (int i = 0; i < col.size(); ++i) {
            LinkPropertyInfo link;
            com.kingdee.bos.metadata.entity.PropertyInfo p = col.get(i);
            if (!(p instanceof LinkPropertyInfo) || !(link = (LinkPropertyInfo)p).getRelationship().getSupplierCardinality().equals((Object)CardinalityType.ZERO_TO_UNBOUNDED) && !link.getRelationship().getSupplierCardinality().equals((Object)CardinalityType.ONE_TO_UNBOUNDED) || !propertyName.equals(link.getName())) continue;
            return link.getRelationship().getSupplierObject();
        }
        return null;
    }

    private static boolean isEL(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return false;
        }
        return str.startsWith("#{") && str.endsWith("}");
    }

    private AjaxAction parseAjaxAction(String methodName) {
        if (StringUtils.isJavaIdentifier((String)methodName)) {
            return null;
        }
        AjaxAction action = new AjaxAction();
        action.parse(methodName);
        return action;
    }

    private String getBeanName(WebUIObjectInfo ui) {
        String packageName = Component2XmlHelper.getWebUIShortPackage(ui.getReleasePackage());
        String fullName = StringUtils.isEmpty((String)packageName) ? ui.getReleaseClass() + "Bean" : packageName + "." + ui.getReleaseClass() + "Bean";
        return fullName;
    }

    public static String getEntryBeanName(WebUIObjectInfo ui, EntityObjectInfo entity) {
        assert (ui != null && entity != null);
        String packageName = Component2XmlHelper.getWebUIShortPackage(ui.getPackage());
        if (packageName.indexOf(".app") >= 0) {
            packageName = StringUtils.replace((String)packageName, (String)".app.", (String)".");
        }
        String fullName = StringUtils.isEmpty((String)packageName) ? entity.getRealName() + "Bean" : packageName + "." + entity.getRealName() + "Bean";
        return fullName;
    }

    private void buildBackgroundColorStyle(Element element, ComponentInfo component, String value) {
        String styleAttr = null;
        styleAttr = "com.kingdee.bos.ctrl.web.LabelContainer".equals(component.getClassType()) ? "labelStyle" : "style";
        PropertyInfo p = component.getPropertyByName("opaque");
        boolean opaque = false;
        if (p != null) {
            opaque = Boolean.valueOf(p.getValue());
        }
        String style = null;
        if (!opaque) {
            style = "transparent";
        } else {
            Color color = StringConverter.convertToColor(value);
            if (color == null) {
                return;
            }
            style = "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
        }
        String old = element.getAttributeValue(styleAttr);
        if (old != null) {
            if (!old.trim().endsWith(";")) {
                element.setAttribute(styleAttr, old + "background-color:" + style);
            } else {
                element.setAttribute(styleAttr, old + ";" + "background-color:" + style);
            }
        } else {
            element.setAttribute(styleAttr, "background-color:" + style);
        }
    }

    private void buildForegroundColorStyle(Element element, ComponentInfo component, String value) {
        String styleAttr = null;
        styleAttr = "com.kingdee.bos.ctrl.web.LabelContainer".equals(component.getClassType()) ? "labelStyle" : "style";
        StringBuffer sb = new StringBuffer();
        Color color = StringConverter.convertToColor(value);
        if (color == null) {
            return;
        }
        sb.append("color:rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")");
        this.mergeStyleSheet(element, styleAttr, sb.toString());
    }

    private void buildFontStyle(Element element, ComponentInfo component, String value) {
        StringBuffer sb = new StringBuffer();
        Font font = StringConverter.convertToFont(value);
        sb.append("font-family:" + font.getFamily());
        sb.append("; font-size:" + font.getSize() + "px");
        if ((font.getStyle() & 1) > 0) {
            sb.append(";font-weigth:bold");
        }
        if ((font.getStyle() & 2) > 0) {
            sb.append(";font-style:italic");
        }
        if ("com.kingdee.bos.ctrl.web.Label".equals(component.getClassType()) || "com.kingdee.bos.ctrl.web.LabelContainer".equals(component.getClassType())) {
            WebLayoutData data;
            sb.append(";overflow:hidden");
            Object constraint = component.getConstraint();
            if (constraint instanceof WebLayoutData) {
                sb.append(";" + ((WebLayoutData)constraint).toCSSString());
            } else if (constraint instanceof String && (data = this.getWebLayoutData((String)component.getConstraint())) != null) {
                sb.append(";" + data.toCSSString());
            }
        }
        String styleAttr = null;
        styleAttr = "com.kingdee.bos.ctrl.web.LabelContainer".equals(component.getClassType()) ? "labelStyle" : "style";
        this.mergeStyleSheet(element, styleAttr, sb.toString());
    }

    public Element createTableElement(ComponentInfo component) {
        WebTag webTag = WebUIModelMapper.getElementWebTag(component);
        if (webTag == null) {
            return null;
        }
        Element element = new Element(webTag.getTagName(), webTag.getNs());
        this.translateTable(component, element);
        return element;
    }

    private EntityObjectInfo getBindedEntity() {
        if (this.model.getDataObjects().size() > 0) {
            DataObjectInfo dataObj = this.model.getDataObjects().get(0);
            if (MetaDataTypeList.ENTITY.toString().equals(dataObj.getObjectType())) {
                return (EntityObjectInfo)dataObj.getInstance();
            }
        }
        return null;
    }

    private QueryInfo getBindedQuery() {
        if (this.model.getDataObjects().size() > 0) {
            DataObjectInfo dataObj = this.model.getDataObjects().get(0);
            if (MetaDataTypeList.JOINQUERY.toString().equals(dataObj.getObjectType())) {
                return (QueryInfo)dataObj.getInstanceOfQueryForBim();
            }
        }
        return null;
    }

    private QueryFieldInfo getBindedQueryField(ComponentInfo component, String columnName) {
        return null;
    }

    private com.kingdee.bos.metadata.entity.PropertyInfo getBindedProperty(ComponentInfo component, String columnName) {
        if (component == null || StringUtils.isEmpty((String)columnName)) {
            return null;
        }
        EntityObjectInfo entity = this.getBindedEntity();
        if (entity == null) {
            return null;
        }
        String tableColumnName = "";
        int n = component.getPropertyBindings().size();
        for (int j = 0; j < n; ++j) {
            PropertyBindingInfo pbInfo = component.getPropertyBindings().get(j);
            if (pbInfo.getPropertyName().indexOf(".text") < 0 || !(tableColumnName = StringUtils.replace((String)pbInfo.getPropertyName(), (String)".text", (String)"")).equalsIgnoreCase(columnName)) continue;
            String sbindField = pbInfo.getBingdingField();
            return EditUIProxyHelper.getPropertyByName(entity, sbindField);
        }
        return null;
    }

    public Element createIDColumnElement(ComponentInfo component, ColumnInfo column, CellInfo cell, com.kingdee.bos.metadata.entity.PropertyInfo prop) {
        Element element = Component2XmlHelper.createElementWithID(WebTags.IDCOLUMN, "id");
        element.setAttribute("header", "id");
        element.setAttribute("hidden", "true");
        return element;
    }

    public static Attribute createAttribute(ComponentInfo component, PropertyInfo property) {
        return new Attribute(property.getName(), Component2XmlHelper.translate2Resource(component, property));
    }

    private String normalizePropertyName(String propertyName) {
        if (StringUtils.isEmpty((String)propertyName)) {
            return propertyName;
        }
        if (propertyName.length() >= 2 && Character.isUpperCase(propertyName.charAt(1))) {
            return StringUtils.headCharUpperCase((String)propertyName);
        }
        return propertyName.substring(0, 1).toLowerCase() + propertyName.substring(1);
    }

    private static String verifyEntityPropertyName(String propName) {
        if (StringUtils.isEmpty((String)propName) || propName.length() < 2) {
            return propName;
        }
        if (Character.isUpperCase(propName.charAt(0)) && Character.isLowerCase(propName.charAt(1))) {
            return StringUtils.headCharLowerCase((String)propName);
        }
        return propName;
    }

    public Attribute createAttribute(Element element, ComponentInfo component, PropertyBindingInfo pbInfo, String var) {
        EntityObjectInfo entity = this.getBindedEntity();
        String attributeName = pbInfo.getPropertyName();
        String propertyName = pbInfo.getBingdingField();
        if (entity != null) {
            if ("com.kingdee.bos.ctrl.web.DataGrid".equals(component.getClassType())) {
                com.kingdee.bos.metadata.entity.PropertyInfo prop = EditUIProxyHelper.getBindingProperty(this.model, component, "userObject");
                if (prop != null && prop instanceof LinkPropertyInfo) {
                    EntityObjectInfo subEntity = ((LinkPropertyInfo)prop).getRelationship().getSupplierObject();
                    if ("userObject".equals(attributeName)) {
                        attributeName = "value";
                        String attributeValue = Component2XmlHelper.getEntryBeanName(this.model, subEntity);
                        attributeValue = "#{" + attributeValue + ".listModel}";
                        Attribute attribute = new Attribute(attributeName, attributeValue);
                        return attribute;
                    }
                    attributeName = "value";
                    if (propertyName.indexOf(".") >= 0) {
                        propertyName = propertyName.substring(propertyName.indexOf(".") + 1);
                    }
                    String attributeValue = "#{" + var + "." + propertyName + "}";
                    Attribute attribute = new Attribute(attributeName, attributeValue);
                    return attribute;
                }
            } else {
                com.kingdee.bos.metadata.entity.PropertyInfo prop = EditUIProxyHelper.getPropertyByName(entity, pbInfo.getBingdingField());
                if (prop != null) {
                    if ("text".equals(attributeName)) {
                        attributeName = "value";
                    }
                    if (component.getParent() != null && "com.kingdee.bos.ctrl.web.EditDataGrid".equals(component.getParent().getClassType())) {
                        PropertyInfo varProp = component.getParent().getPropertyByName("var");
                        var = varProp != null ? varProp.getValue() : "data";
                        String verifiedPropertyName = propertyName.substring(propertyName.indexOf(".") + 1);
                        verifiedPropertyName = Component2XmlHelper.verifyEntityPropertyName(verifiedPropertyName);
                        String attributeValue = "#{" + var + "." + verifiedPropertyName + "}";
                        Attribute attribute = new Attribute(attributeName, attributeValue);
                        if ("com.kingdee.bos.ctrl.web.EditableColumn".equals(component.getClassType())) {
                            element.setAttribute("id", verifiedPropertyName);
                        }
                        return attribute;
                    }
                    String attributeValue = this.getBeanName(this.model);
                    attributeValue = "#{" + attributeValue + ".model" + "." + this.normalizePropertyName(propertyName) + "}";
                    Attribute attribute = new Attribute(attributeName, attributeValue);
                    return attribute;
                }
            }
        } else {
            QueryInfo query = this.getBindedQuery();
            if (query != null) {
                attributeName = "value";
                String attributeValue = "#{data['" + propertyName + "']}";
                Attribute attribute = new Attribute(attributeName, attributeValue);
                return attribute;
            }
        }
        return new Attribute(pbInfo.getPropertyName(), pbInfo.getBingdingField());
    }

    private Dimension getCellSize(ComponentInfo tableComp, int rowIndex, int columnIndex) {
        List trs;
        Element table;
        PropertyInfo property = Component2XmlHelper.getTablePanelXml(tableComp);
        if (property == null) {
            throw new IllegalArgumentException("could not found 'com.kingdee.bos.ctrl.web.TablePanel''s formatXML ");
        }
        String xml = property.getValue();
        SAXBuilder sb = new SAXBuilder();
        try {
            Document doc = sb.build((Reader)new StringReader(xml));
            table = doc.getRootElement().getChild("table", NS_TABLE);
            trs = table.getChildren("tr", NS_TABLE);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("error xml format");
        }
        int rowCount = Integer.parseInt(table.getAttributeValue("rows"));
        int columnCount = Integer.parseInt(table.getAttributeValue("columns"));
        boolean[][] cellParsed = new boolean[rowCount][columnCount];
        int[] cellWidths = new int[columnCount];
        int[] rowHeights = new int[rowCount];
        int colspan = 1;
        int rowspan = 1;
        for (int i = 0; i < rowCount; ++i) {
            Element rowElement = (Element)trs.get(i);
            rowHeights[i] = Integer.parseInt(rowElement.getAttributeValue("height"));
            List tds = rowElement.getChildren();
            int tdIndex = 0;
            for (int j = 0; j < columnCount; ++j) {
                if (cellParsed[i][j]) continue;
                Element cellElement = (Element)tds.get(tdIndex);
                int cspan = 1;
                int rspan = 1;
                if (cellElement.getAttributeValue("colspan") == null) {
                    cspan = Integer.parseInt(cellElement.getAttributeValue("colspan"));
                }
                if (cellElement.getAttributeValue("rowspan") == null) {
                    rspan = Integer.parseInt(cellElement.getAttributeValue("rowspan"));
                }
                if (j == columnIndex && i == rowIndex) {
                    colspan = cspan;
                    rowspan = rspan;
                }
                if (cellElement.getAttributeValue("widthHint") != null) {
                    cellWidths[j] = Integer.parseInt(cellElement.getAttributeValue("widthHint"));
                }
                for (int m = 0; m < rspan; ++m) {
                    for (int n = 0; n < cspan; ++n) {
                        cellParsed[i + m][j + n] = true;
                    }
                }
                ++tdIndex;
            }
        }
        int width = 0;
        for (int i = 0; i < colspan; ++i) {
            width += cellWidths[i + columnIndex];
        }
        int height = 0;
        for (int i = 0; i < rowspan; ++i) {
            width += rowHeights[i + rowIndex];
        }
        return new Dimension(width, height);
    }

    public void translateTable(ComponentInfo tableComp, Element htmlTable) {
        List trs;
        Element table;
        ComponentCollection children = tableComp.getComponents();
        PropertyInfo property = Component2XmlHelper.getTablePanelXml(tableComp);
        if (property == null) {
            throw new IllegalArgumentException("could not found 'com.kingdee.bos.ctrl.web.TablePanel''s formatXML ");
        }
        String xml = property.getValue();
        SAXBuilder sb = new SAXBuilder();
        try {
            Document doc = sb.build((Reader)new StringReader(xml));
            table = doc.getRootElement().getChild("table", NS_TABLE);
            trs = table.getChildren("tr", NS_TABLE);
        }
        catch (Exception e) {
            return;
        }
        Table tableModel = new Table();
        int columns = 0;
        String attVal = table.getAttributeValue("columns");
        if (attVal != null && !attVal.equals("")) {
            columns = Integer.parseInt(attVal);
            Component2XmlHelper.recoverCoR(tableModel, columns, COLUMN);
        }
        int rows = 0;
        attVal = table.getAttributeValue("rows");
        if (attVal != null && !attVal.equals("")) {
            rows = Integer.parseInt(attVal);
            Component2XmlHelper.recoverCoR(tableModel, rows, ROW);
        }
        if ((attVal = table.getAttributeValue("cellspacing")) != null && !attVal.equals("")) {
            htmlTable.setAttribute("cellspacing", attVal);
        }
        if ((attVal = table.getAttributeValue("width")) != null && !attVal.equals("")) {
            htmlTable.setAttribute("width", attVal);
        }
        if ((attVal = table.getAttributeValue("height")) != null && !attVal.equals("")) {
            htmlTable.setAttribute("height", attVal);
        }
        int trSize = trs.size();
        for (int i = 0; i < rows; ++i) {
            if (i >= trSize) {
                throw new IllegalArgumentException("\u8868\u683c\u5e03\u5c40\u7684\u884c\u6570\u53c2\u6570\u4e0d\u6b63\u786e");
            }
            Element tr = (Element)trs.get(i);
            attVal = tr.getAttributeValue("height");
            Element htmlTr = new Element("tr", WebTags.DEFAULTNS);
            htmlTable.addContent(htmlTr);
            htmlTr.setAttribute("height", attVal);
            List tds = tr.getChildren("td", NS_TABLE);
            int col = 0;
            int tdSize = tds.size();
            for (int j = 0; j < columns; ++j) {
                TableCell cell = tableModel.getCell(i, j);
                if (cell.isMerged() && cell != cell.getMergedCell()) continue;
                if (col >= tdSize) {
                    throw new IllegalArgumentException("\u8868\u683c\u5e03\u5c40\u7684\u5217\u6570\u53c2\u6570\u4e0d\u6b63\u786e");
                }
                Element td = (Element)tds.get(col);
                Element htmlTd = new Element("td", WebTags.DEFAULTNS);
                htmlTd.setAttribute("style", "overflow:hidden");
                htmlTr.addContent(htmlTd);
                attVal = td.getAttributeValue("width");
                if (attVal != null && !attVal.equals("")) {
                    htmlTd.setAttribute("width", attVal);
                }
                int rowspan = 1;
                attVal = td.getAttributeValue("rowspan");
                if (attVal != null && !attVal.equals("")) {
                    rowspan = Integer.parseInt(attVal);
                    htmlTd.setAttribute("rowspan", attVal);
                }
                int columnspan = 1;
                attVal = td.getAttributeValue("colspan");
                if (attVal != null && !attVal.equals("")) {
                    columnspan = Integer.parseInt(attVal);
                    htmlTd.setAttribute("colspan", attVal);
                }
                if ((attVal = td.getAttributeValue("align")) != null && !attVal.equals("")) {
                    htmlTd.setAttribute("align", attVal);
                }
                if ((attVal = td.getAttributeValue("valign")) != null && !attVal.equals("")) {
                    htmlTd.setAttribute("valign", attVal);
                }
                tableModel.mergeCell(i, j, i + rowspan - 1, j + columnspan - 1);
                cell.setData(htmlTd);
                List cellChildren = Component2XmlHelper.getCellChildren(children, i, j);
                int size = cellChildren.size();
                for (int k = 0; k < size; ++k) {
                    ComponentInfo cInfo = (ComponentInfo)cellChildren.get(k);
                    Element e = this.createElement(cInfo);
                    if (e == null) continue;
                    htmlTd.addContent(e);
                }
                ++col;
            }
        }
    }

    private static PropertyInfo getTablePanelXml(ComponentInfo tableCom) {
        if (tableCom != null) {
            com.kingdee.bos.metadata.ui.PropertyCollection pcol = tableCom.getProperties();
            int size = pcol.size();
            for (int i = 0; i < size; ++i) {
                PropertyInfo pInfo = pcol.get(i);
                if (!"formatXML".equals(pInfo.getName())) continue;
                return pInfo;
            }
        }
        return null;
    }

    private static Point getCellLocation(String s) {
        String[] info = s.split(",");
        int r = Integer.parseInt(info[0].substring(info[0].lastIndexOf("=") + 1));
        int c = Integer.parseInt(info[1].substring(info[1].lastIndexOf("=") + 1));
        return new Point(c, r);
    }

    private static List getCellChildren(ComponentCollection children, int row, int column) {
        ArrayList<ComponentInfo> list = new ArrayList<ComponentInfo>();
        if (children != null) {
            int size = children.size();
            for (int i = 0; i < size; ++i) {
                ComponentInfo child = children.get(i);
                String constraint = (String)child.getConstraint();
                String con = constraint.substring(constraint.lastIndexOf("#") + 1);
                Point p = Component2XmlHelper.getCellLocation(con);
                int r = p.y;
                int c = p.x;
                if (r != row || c != column) continue;
                list.add(child);
            }
        }
        return list;
    }

    private boolean isListUIGrid(ComponentInfo cInfo) {
        if (cInfo != null && this.isInheritListUI() && "com.kingdee.bos.ctrl.web.DataGrid".equals(cInfo.getClassType())) {
            com.kingdee.bos.metadata.ui.PropertyCollection properties = cInfo.getProperties();
            int n = properties.size();
            for (int i = 0; i < n; ++i) {
                String value;
                if (!"binding".equals(properties.get(i).getName())) continue;
                if (!Component2XmlHelper.isEL(properties.get(i).getValue()) || !(value = properties.get(i).getValue()).trim().endsWith(".grid}")) break;
                return true;
            }
        }
        return false;
    }

    private boolean isInheritListUI() {
        if (this.model != null) {
            WebUIObjectInfo root = this.model;
            while (root.getParent() != null) {
                root = root.getParent();
            }
            if ("com.kingdee.eas.framework.web.ListUI".equals(root.getFullName())) {
                return true;
            }
        }
        return false;
    }

    private static void recoverCoR(Table table, int num, int type) {
        block8: {
            block9: {
                int cur;
                block10: {
                    if (table == null) break block8;
                    if (type != ROW) break block9;
                    cur = table.getRowCount();
                    if (num <= cur) break block10;
                    for (int i = cur; i < num; ++i) {
                        table.addRow();
                    }
                    break block8;
                }
                if (num >= cur) break block8;
                for (int i = num; i < cur; ++i) {
                    table.removeRow(table.getRowCount() - 1);
                }
                break block8;
            }
            if (type == COLUMN) {
                int cur = table.getColumnCount();
                if (num > cur) {
                    for (int i = cur; i < num; ++i) {
                        table.addColumn();
                    }
                } else if (num < cur) {
                    for (int i = num; i < cur; ++i) {
                        table.removeColumn(table.getColumnCount() - 1);
                    }
                }
            }
        }
    }

    private static String translate2Resource(ComponentInfo cInfo, PropertyInfo pInfo) {
        if (pInfo != null) {
            if (cInfo != null && pInfo.isMultiLanguage() && !Component2XmlHelper.isEL(pInfo.getValue())) {
                String cName = cInfo.getName();
                String pName = pInfo.getName();
                return "#{extraMsgs['" + cName + "." + pName + "']}";
            }
            return pInfo.getValue();
        }
        return "";
    }

    public static Element getInnerWindowElement(WebUIObjectInfo uiModel) {
        if (uiModel != null) {
            ComponentCollection col = uiModel.getComponents();
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                String tag;
                PropertyInfo propertyInfo;
                ComponentInfo component = col.get(i);
                if (!"com.kingdee.bos.ctrl.web.UserTag".equals(component.getClassType()) || (propertyInfo = component.getPropertyByName("tag")) == null || StringUtils.isEmpty((String)propertyInfo.getValue()) || !"innerWindow".equals(tag = propertyInfo.getValue())) continue;
                propertyInfo = component.getPropertyByName("namespace");
                Namespace ns = null;
                if (propertyInfo == null) {
                    ns = WebTags.DEFAULTNS;
                } else {
                    String nsStr = propertyInfo.getValue();
                    int index = nsStr.indexOf(59);
                    String prefix = nsStr.substring(0, index);
                    String uri = nsStr.substring(index + 1);
                    ns = Namespace.getNamespace((String)prefix, (String)uri);
                }
                ArrayList list = new ArrayList();
                Properties properties = new Properties();
                propertyInfo = component.getPropertyByName("attributes");
                if (propertyInfo != null) {
                    Component2XmlHelper.string2KeyPairs(propertyInfo.getValue(), list, properties);
                }
                Element element = new Element(tag, ns);
                for (String key : list) {
                    String value = properties.getProperty(key);
                    element.setAttribute(key, value);
                }
                return element;
            }
        }
        return null;
    }

    private static String getWebUIShortPackage(String packageName) {
        if (StringUtils.isEmpty((String)packageName)) {
            return packageName;
        }
        String shortName = packageName;
        if (shortName.startsWith("com.kingdee.eas.")) {
            shortName = shortName.substring("com.kingdee.eas.".length());
        }
        if (shortName.endsWith(".web")) {
            shortName = shortName.substring(0, shortName.length() - ".web".length());
        }
        return shortName;
    }

    private static String getParentReleaseClass(WebUIObjectInfo model) {
        if (model != null && model.getParent() != null) {
            WebUIObjectInfo parent = model.getParent();
            if (!StringUtils.isEmpty((String)parent.getReleasePackage())) {
                return parent.getReleasePackage() + "." + parent.getReleaseClass() + "Bean";
            }
            return parent.getReleaseClass() + "Bean";
        }
        return null;
    }

    private static String getJsVar(ComponentInfo component) {
        PropertyInfo jsvar_pro = component.getPropertyByName("jsvar");
        String jsvar = component.getName();
        if (jsvar_pro != null && !StringUtils.isEmpty((String)jsvar_pro.getValue())) {
            jsvar = jsvar_pro.getValue();
        }
        if (!WebUIModelMapper.isJsIdentifier(jsvar)) {
            jsvar = jsvar + "$JS";
        }
        return jsvar;
    }

    public void clearSmartLayoutScript() {
        this.rootJsVar = null;
    }

    public Element getSmartLayoutScript() {
        Element script = new Element("script", WebTags.DEFAULTNS);
        script.setAttribute("type", "text/javascript");
        StringBuffer sb = new StringBuffer();
        String start = "\n\tExt.onReady(function(){\n";
        sb.append(start);
        sb.append("\t\tvar win_Width,win_Height;\n");
        sb.append("\t\tif(" + this.rootJsVar + ".heightAdaptive) {\n");
        sb.append("\t\t\twin_Width = document.body.clientWidth;\n");
        sb.append("\t\t\twin_Height = document.body.clientHeight;\n");
        sb.append("\t\t}else{\n");
        sb.append("\t\t\twin_Width = document.body.clientWidth;\n");
        sb.append("\t\t\twin_Height = " + this.rootJsVar + ".getSize().height;\n");
        sb.append("\t\t}\n");
        sb.append("\t\t" + this.rootJsVar + ".onResize(win_Width, win_Height);\n");
        String end = "\t});\n";
        sb.append(end);
        script.addContent(sb.toString());
        return script;
    }

    static class LineReader {
        byte[] inByteBuf;
        char[] inCharBuf;
        char[] lineBuf = new char[1024];
        int inLimit = 0;
        int inOff = 0;
        InputStream inStream;
        Reader reader;

        public LineReader(InputStream inStream) {
            this.inStream = inStream;
            this.inByteBuf = new byte[8192];
        }

        public LineReader(Reader reader) {
            this.reader = reader;
            this.inCharBuf = new char[8192];
        }

        int readLine() throws IOException {
            int len = 0;
            char c = '\u0000';
            boolean skipWhiteSpace = true;
            boolean isCommentLine = false;
            boolean isNewLine = true;
            boolean appendedLineBegin = false;
            boolean precedingBackslash = false;
            boolean skipLF = false;
            while (true) {
                if (this.inOff >= this.inLimit) {
                    this.inLimit = this.inStream == null ? this.reader.read(this.inCharBuf) : this.inStream.read(this.inByteBuf);
                    this.inOff = 0;
                    if (this.inLimit <= 0) {
                        if (len == 0 || isCommentLine) {
                            return -1;
                        }
                        return len;
                    }
                }
                c = this.inStream != null ? (char)(0xFF & this.inByteBuf[this.inOff++]) : this.inCharBuf[this.inOff++];
                if (skipLF) {
                    skipLF = false;
                    if (c == '\n') continue;
                }
                if (skipWhiteSpace) {
                    if (c == ' ' || c == '\t' || c == '\f' || !appendedLineBegin && (c == '\r' || c == '\n')) continue;
                    skipWhiteSpace = false;
                    appendedLineBegin = false;
                }
                if (isNewLine) {
                    isNewLine = false;
                    if (c == '#' || c == '!') {
                        isCommentLine = true;
                        continue;
                    }
                }
                if (c != '\n' && c != '\r') {
                    this.lineBuf[len++] = c;
                    if (len == this.lineBuf.length) {
                        int newLength = this.lineBuf.length * 2;
                        if (newLength < 0) {
                            newLength = Integer.MAX_VALUE;
                        }
                        char[] buf = new char[newLength];
                        System.arraycopy(this.lineBuf, 0, buf, 0, this.lineBuf.length);
                        this.lineBuf = buf;
                    }
                    if (c == '\\') {
                        precedingBackslash = !precedingBackslash;
                        continue;
                    }
                    precedingBackslash = false;
                    continue;
                }
                if (isCommentLine || len == 0) {
                    isCommentLine = false;
                    isNewLine = true;
                    skipWhiteSpace = true;
                    len = 0;
                    continue;
                }
                if (this.inOff >= this.inLimit) {
                    this.inLimit = this.inStream == null ? this.reader.read(this.inCharBuf) : this.inStream.read(this.inByteBuf);
                    this.inOff = 0;
                    if (this.inLimit <= 0) {
                        return len;
                    }
                }
                if (!precedingBackslash) break;
                --len;
                skipWhiteSpace = true;
                appendedLineBegin = true;
                precedingBackslash = false;
                if (c != '\r') continue;
                skipLF = true;
            }
            return len;
        }
    }
}

