/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.webui.transfer;

import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.DataObjectInfo;
import com.kingdee.bos.metadata.ui.EventBindingInfo;
import com.kingdee.bos.metadata.ui.LayoutInfo;
import com.kingdee.bos.metadata.ui.PropertyBindingCollection;
import com.kingdee.bos.metadata.ui.PropertyBindingInfo;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.metadata.webui.WebUIObjectInfo;
import com.kingdee.bos.metadata.webui.transfer.ResourceBundleList;
import com.kingdee.bos.metadata.webui.transfer.WebUIModelMapper;
import com.kingdee.bos.metadata.webui.xhtml.WebTag;
import com.kingdee.bos.metadata.webui.xhtml.WebTagHelper;
import com.kingdee.bos.metadata.webui.xhtml.WebTags;
import com.kingdee.bos.ui.bizunitproxy.EditUIProxyHelper;
import com.kingdee.bos.ui.bizunitproxy.UIProxyHelper;
import com.kingdee.bos.ui.dtp.ControlDefaultSizeManager;
import com.kingdee.bos.ui.dtp.kdtable.CellInfo;
import com.kingdee.bos.ui.dtp.kdtable.ColumnInfo;
import com.kingdee.bos.ui.dtp.kdtable.HeaderInfo;
import com.kingdee.bos.ui.dtp.kdtable.KDTableDesignerHelper;
import com.kingdee.bos.ui.dtp.kdtable.TableInfo;
import com.kingdee.util.StringUtils;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.Element;

public class Xml2ComponentHelper {
    private WebUIObjectInfo model;
    private ResourceBundleList bundleMap = null;
    private static final Logger logger = Logger.getLogger(Xml2ComponentHelper.class);

    public Xml2ComponentHelper(WebUIObjectInfo model, ResourceBundleList bundleMap) {
        this.model = model;
        this.bundleMap = bundleMap;
    }

    public PropertyInfo parseProperty(ComponentInfo component, Attribute attribute) {
        if ("lineWidth".equals(attribute.getName())) {
            return this.createLineWidthProperty(attribute.getValue());
        }
        if ("visible".equals(attribute.getName())) {
            return this.createVisibleProperty(attribute.getValue());
        }
        if ("enabled".equals(attribute.getName())) {
            return this.createEnableProperty(attribute.getValue());
        }
        if ("caption".equals(attribute.getName())) {
            return this.createCaptionProperty(this.getAttributeValue(attribute));
        }
        if ("value".equals(attribute.getName())) {
            return this.createCommonProperty(attribute.getName(), String.class.getName(), this.getAttributeValue(attribute));
        }
        if ("rendered".equals(attribute.getName())) {
            return this.createRenderedProperty(attribute.getValue());
        }
        if ("queryInfo".equals(attribute.getName())) {
            return this.createCommonProperty(attribute.getName(), String.class.getName(), attribute.getValue());
        }
        if ("align".equals(attribute.getName())) {
            return this.createCommonProperty(attribute.getName(), String.class.getName(), attribute.getValue());
        }
        if ("orgType".equals(attribute.getName())) {
            return this.createCommonProperty(attribute.getName(), "int", attribute.getValue());
        }
        if ("required".equals(attribute.getName())) {
            return this.createCommonProperty(attribute.getName(), "boolean", attribute.getValue());
        }
        if ("disabled".equals(attribute.getName())) {
            return this.createCommonProperty(attribute.getName(), "boolean", attribute.getValue());
        }
        if ("idColumn".equals(attribute.getName())) {
            return this.createCommonProperty(attribute.getName(), "boolean", attribute.getValue());
        }
        if ("width".equals(attribute.getName())) {
            return this.createCommonProperty(attribute.getName(), "int", attribute.getValue());
        }
        if ("header".equals(attribute.getName())) {
            return this.createCommonProperty(attribute.getName(), String.class.getName(), this.getAttributeValue(attribute));
        }
        if ("hidden".equals(attribute.getName())) {
            return this.createCommonProperty(attribute.getName(), "boolean", attribute.getValue());
        }
        if ("requiredMessage".equals(attribute.getName())) {
            return this.createCommonProperty(attribute.getName(), String.class.getName(), attribute.getValue());
        }
        if ("allowBlank".equals(attribute.getName())) {
            return this.createCommonProperty(attribute.getName(), "boolean", attribute.getValue());
        }
        if ("boxLabel".equals(attribute.getName())) {
            return this.createCommonProperty(attribute.getName(), String.class.getName(), this.getAttributeValue(attribute));
        }
        if ("label".equals(attribute.getName())) {
            return this.createCommonProperty(attribute.getName(), String.class.getName(), this.getAttributeValue(attribute));
        }
        if ("text".equals(attribute.getName())) {
            return this.createCommonProperty(attribute.getName(), String.class.getName(), this.getAttributeValue(attribute));
        }
        if ("actionBinding".equals(attribute.getName())) {
            return this.createCommonProperty(attribute.getName(), String.class.getName(), this.getAttributeValue(attribute));
        }
        if ("checked".equals(attribute.getName())) {
            return this.createCommonProperty(attribute.getName(), "boolean", attribute.getValue());
        }
        if ("immediate".equals(attribute.getName())) {
            return this.createCommonProperty(attribute.getName(), "boolean", attribute.getValue());
        }
        if ("showRowNumber".equals(attribute.getName())) {
            return this.createCommonProperty(attribute.getName(), "boolean", attribute.getValue());
        }
        if ("autoScroll".equals(attribute.getName())) {
            return this.createCommonProperty(attribute.getName(), "boolean", attribute.getValue());
        }
        if ("binding".equals(attribute.getName())) {
            return this.createCommonProperty(attribute.getName(), String.class.getName(), attribute.getValue());
        }
        if ("alt".equals(attribute.getName())) {
            return this.createCommonProperty(attribute.getName(), String.class.getName(), attribute.getValue());
        }
        if ("accesskey".equals(attribute.getName())) {
            return this.createCommonProperty(attribute.getName(), String.class.getName(), attribute.getValue());
        }
        if ("allowReEnter".equals(attribute.getName())) {
            return this.createCommonProperty(attribute.getName(), "boolean", attribute.getValue());
        }
        if ("alwaysSubmit".equals(attribute.getName())) {
            return this.createCommonProperty(attribute.getName(), "boolean", attribute.getValue());
        }
        if ("title".equals(attribute.getName())) {
            return this.createCommonProperty(attribute.getName(), String.class.getName(), this.getAttributeValue(attribute));
        }
        if ("tooltip".equals(attribute.getName())) {
            return this.createCommonProperty(attribute.getName(), String.class.getName(), this.getAttributeValue(attribute));
        }
        if ("minWidth".equals(attribute.getName())) {
            return this.createCommonProperty(attribute.getName(), "int", attribute.getValue());
        }
        if ("minHeight".equals(attribute.getName())) {
            return this.createCommonProperty(attribute.getName(), "int", attribute.getValue());
        }
        if ("maxWidth".equals(attribute.getName())) {
            return this.createCommonProperty(attribute.getName(), "int", attribute.getValue());
        }
        if ("maxHeight".equals(attribute.getName())) {
            return this.createCommonProperty(attribute.getName(), "int", attribute.getValue());
        }
        return null;
    }

    private PropertyInfo createCommonProperty(String name, String dataType, String value) {
        PropertyInfo prop = new PropertyInfo();
        prop.setName(name);
        prop.setType(dataType);
        prop.setMultiLanguage(false);
        prop.setValue(value);
        prop.setOverride(true);
        return prop;
    }

    private PropertyInfo createRenderedProperty(String value) {
        PropertyInfo prop = new PropertyInfo();
        prop.setName("rendered");
        prop.setType(String.class.getName());
        prop.setMultiLanguage(true);
        prop.setValue(value);
        prop.setOverride(true);
        return prop;
    }

    private PropertyInfo createLabelProperty(String value) {
        PropertyInfo prop = new PropertyInfo();
        prop.setName("label");
        prop.setType(String.class.getName());
        prop.setMultiLanguage(true);
        prop.setValue(value);
        prop.setOverride(true);
        return prop;
    }

    private PropertyInfo createCaptionProperty(String caption) {
        PropertyInfo prop = new PropertyInfo();
        prop.setName("caption");
        prop.setType(String.class.getName());
        prop.setMultiLanguage(true);
        prop.setValue(caption);
        prop.setOverride(true);
        return prop;
    }

    private PropertyInfo createVisibleProperty(String visible) {
        PropertyInfo prop = new PropertyInfo();
        prop.setName("visible");
        prop.setType("boolean");
        prop.setValue(visible);
        prop.setOverride(true);
        return prop;
    }

    private PropertyInfo createEnableProperty(String enabled) {
        PropertyInfo prop = new PropertyInfo();
        prop.setName("enabled");
        prop.setType("boolean");
        prop.setValue(enabled);
        prop.setOverride(true);
        return prop;
    }

    private PropertyInfo createLineWidthProperty(String width) {
        PropertyInfo prop = new PropertyInfo();
        prop.setName("lineWidth");
        prop.setType("int");
        prop.setValue(width);
        prop.setOverride(true);
        return prop;
    }

    public void parseProperty(Element element, ComponentInfo component) {
        List list = element.getAttributes();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Attribute attribute = (Attribute)list.get(i);
            PropertyInfo property = this.parseProperty(component, attribute);
            if (property == null) continue;
            component.getProperties().add(property);
        }
    }

    public ComponentInfo parseComponent(Element element) {
        WebTag webTag = WebTag.create(element);
        if (WebTagHelper.isSupportedWebTag(webTag)) {
            if (WebUIModelMapper.isComponent(webTag)) {
                if (WebTags.DIV.equals(webTag)) {
                    return null;
                }
                String componentType = WebUIModelMapper.getComponentType(webTag);
                if (!StringUtils.isEmpty((String)componentType)) {
                    ComponentInfo component = this.createCommonControl(element, componentType);
                    component = this.parseComponent(element, component);
                    return component;
                }
            }
        } else {
            logger.debug((Object)("un supported web tag:" + element.getName()));
        }
        return null;
    }

    private ComponentInfo createCommonControl(Element element, String componentType) {
        ComponentInfo component = new ComponentInfo();
        component.setClassType(componentType);
        component.setName(element.getAttributeValue("id"));
        component.setContainer(false);
        return component;
    }

    public ComponentInfo parseComponent(Element element, ComponentInfo component) {
        String componentType = component.getClassType();
        component.setConstraint(this.createConstraint(element, componentType));
        component.setUserDefined(true);
        this.parseProperties(element, component);
        this.parsePropertyBindings(element, component);
        this.parseEventBindings(element, component);
        if ("com.kingdee.bos.ctrl.web.LabelContainer".equals(componentType)) {
            component = this.parseLabelContainer(element, component);
        } else if ("com.kingdee.bos.ctrl.web.Form".equals(componentType)) {
            component = this.parseForm(element, component);
        } else if ("com.kingdee.bos.ctrl.web.DataGrid".equals(componentType)) {
            component = this.parseDataGrid(element, component);
        } else if ("com.kingdee.bos.ctrl.web.EditDataGrid".equals(componentType)) {
            component = this.parseEditDataGrid(element, component);
        } else if ("com.kingdee.bos.ctrl.web.EditableColumn".equals(componentType)) {
            component = this.parseEditableColumn(element, component);
        } else if ("com.kingdee.bos.ctrl.web.ToolBar".equals(componentType)) {
            component = this.parseToolBar(element, component);
        } else if ("com.kingdee.bos.ctrl.web.Tree".equals(componentType) || "com.kingdee.bos.ctrl.web.TreeNode".equals(componentType)) {
            component = this.parseTree(element, component);
        }
        return component;
    }

    private Object createConstraint(Element element, String classType) {
        Dimension dim = ControlDefaultSizeManager.getDefaultSize(classType);
        int width = 0;
        int height = 0;
        if (dim != null) {
            width = dim.width;
            height = dim.height;
        }
        String widthValue = element.getAttributeValue("width");
        String heightValue = element.getAttributeValue("height");
        if (!StringUtils.isEmpty((String)widthValue)) {
            try {
                int width1;
                width = width1 = Integer.parseInt(widthValue);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (!StringUtils.isEmpty((String)heightValue)) {
            try {
                int height1 = Integer.parseInt(heightValue);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return new Rectangle(0, 0, width, height);
    }

    public ComponentInfo parseTree(Element element, ComponentInfo component) {
        component.setContainer(true);
        component.setLayoutInfo(this.createTreeLayout(component.getName()));
        return component;
    }

    public ComponentInfo parseForm(Element element, ComponentInfo component) {
        component.setContainer(true);
        return component;
    }

    public ComponentInfo parseLabelContainer(Element element, ComponentInfo component) {
        component.setLayoutInfo(this.createLabelContainerLayout(component.getName()));
        component.setContainer(true);
        return component;
    }

    private LayoutInfo createLabelContainerLayout(String componentName) {
        LayoutInfo layout = new LayoutInfo();
        if (StringUtils.isEmpty((String)componentName)) {
            layout.setName(componentName + "lcl");
        } else {
            layout.setName("layout");
        }
        layout.setType("LabelContainerLayout");
        return layout;
    }

    private LayoutInfo createTreeLayout(String componentName) {
        LayoutInfo layout = new LayoutInfo();
        if (StringUtils.isEmpty((String)componentName)) {
            layout.setName(componentName + "lcl");
        } else {
            layout.setName("layout");
        }
        layout.setType("WebLayout");
        layout.setValue("0,1,false");
        return layout;
    }

    public ComponentInfo parseToolBar(Element element, ComponentInfo component) {
        ComponentInfo toolBar = component;
        toolBar.setContainer(true);
        return toolBar;
    }

    private int getIntegerValue(String value, int defaultValue) {
        if (!StringUtils.isEmpty((String)value)) {
            try {
                int value1 = Integer.parseInt(value);
                return value1;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public ComponentInfo parseEditableColumn(Element element, ComponentInfo component) {
        component.setContainer(true);
        component.setLayoutInfo(this.createTreeLayout(component.getName()));
        return component;
    }

    public ComponentInfo parseEditDataGrid(Element element, ComponentInfo component) {
        component.setContainer(true);
        component.setLayoutInfo(this.createTreeLayout(component.getName()));
        return component;
    }

    public ComponentInfo parseDataGrid(Element element, ComponentInfo component) {
        List list = element.getChildren();
        TableInfo tableInfo = new TableInfo();
        HeaderInfo headerInfo = new HeaderInfo();
        headerInfo.setName("header");
        tableInfo.addHeader(headerInfo);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Element subElement = (Element)list.get(i);
            WebTag webTag = WebTag.create(subElement);
            if (!WebTagHelper.isSupportedWebTag(webTag) || !WebTags.IDCOLUMN.equals(webTag) && !WebTags.OUTPUTCOLUMN.equals(webTag)) continue;
            ColumnInfo column = new ColumnInfo();
            column.setName(subElement.getAttributeValue("id"));
            if (WebTags.IDCOLUMN.equals(webTag)) {
                column.setHide(true);
            } else {
                column.setHide(true);
            }
            column.setWidth(this.getIntegerValue(subElement.getAttributeValue("width"), 150));
            column.setLock(false);
            column.setFormatString("");
            tableInfo.addColumn(column);
            Attribute attribute = subElement.getAttribute("header");
            CellInfo cell = new CellInfo();
            if (attribute != null) {
                cell.setName(this.getAttributeValue(attribute));
            } else {
                cell.setName(column.getName());
            }
            cell.setColSpan(0);
            cell.setRowSpan(0);
            headerInfo.addCell(cell);
        }
        PropertyInfo propInfo = new PropertyInfo();
        propInfo.setName("formatXml");
        propInfo.setType(String.class.getName());
        propInfo.setMultiLanguage(true);
        propInfo.setValue(KDTableDesignerHelper.getXmlFrom(tableInfo));
        component.getProperties().add(propInfo);
        return component;
    }

    private void parsePropertyBindings(Element element, ComponentInfo component) {
        List list = element.getAttributes();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            PropertyBindingInfo pbInfo;
            Attribute attribute = (Attribute)list.get(i);
            if (!this.isPropertyBinding(component, attribute) || (pbInfo = this.parsePropertyBinding(component, attribute)) == null) continue;
            component.getPropertyBindings().add(pbInfo);
        }
    }

    private void parseProperties(Element element, ComponentInfo component) {
        List list = element.getAttributes();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            PropertyInfo pInfo;
            Attribute attribute = (Attribute)list.get(i);
            if (!this.isProperty(component, attribute) || (pInfo = this.parseProperty(component, attribute)) == null) continue;
            component.getProperties().add(pInfo);
        }
    }

    private EntityObjectInfo getBindedEntity() {
        if (this.model.getDataObjects().size() > 0) {
            DataObjectInfo dataObj = this.model.getDataObjects().get(0);
            if (MetaDataTypeList.ENTITY.toString().equals(dataObj.getObjectType())) {
                return (EntityObjectInfo)dataObj.getInstance();
            }
        }
        return null;
    }

    private PropertyBindingInfo parsePropertyBinding(ComponentInfo component, Attribute attribute, String columnName) {
        return null;
    }

    private static LinkPropertyInfo getEntryProperty(EntityObjectInfo entity, String subEntityBeanName) {
        PropertyCollection col = entity.getInheritedNoDuplicatedProperties();
        int n = col.size();
        for (int i = 0; i < n; ++i) {
            RelationshipInfo relation;
            com.kingdee.bos.metadata.entity.PropertyInfo prop = col.get(i);
            if (!(prop instanceof LinkPropertyInfo) || !CardinalityType.ZERO_TO_UNBOUNDED.equals((Object)(relation = ((LinkPropertyInfo)prop).getRelationship()).getSupplierCardinality()) && !CardinalityType.ONE_TO_UNBOUNDED.equals((Object)relation.getSupplierCardinality())) continue;
            String beanName = relation.getSupplierObject().getFullName();
            if (beanName.startsWith("com.kingdee.eas.")) {
                beanName = beanName.substring("com.kingdee.eas.".length());
            }
            if (beanName.indexOf(".app") >= 0) {
                beanName = StringUtils.replace((String)beanName, (String)".app.", (String)".");
            }
            if (!subEntityBeanName.equals(beanName = beanName + "Bean")) continue;
            return (LinkPropertyInfo)prop;
        }
        return null;
    }

    private PropertyBindingInfo parsePropertyBinding(ComponentInfo component, Attribute attribute) {
        String value = attribute.getValue();
        if (!StringUtils.isEmpty((String)value) && value.startsWith("#{") && value.endsWith("}")) {
            String propName = value.substring("#{".length(), value.indexOf("}"));
            if ("com.kingdee.bos.ctrl.web.DataGrid".equals(component.getClassType()) || "com.kingdee.bos.ctrl.web.EditDataGrid".equals(component.getClassType())) {
                LinkPropertyInfo lnkProp;
                EntityObjectInfo entity;
                if (propName.endsWith(".listModel") && (entity = this.getBindedEntity()) != null && (lnkProp = Xml2ComponentHelper.getEntryProperty(entity, propName.substring(0, propName.indexOf(".listModel")))) != null) {
                    PropertyBindingInfo pb = new PropertyBindingInfo();
                    pb.setPropertyName("userObject");
                    pb.setPropertyType(Object.class.getName());
                    pb.setBindingObject("editData");
                    pb.setBingdingField(lnkProp.getName());
                    pb.setFieldType(lnkProp.getRelationship().getSupplierObject().getBusinessImplName() + "Collection");
                    pb.setAccessType(2);
                    pb.setAutoMode(false);
                    pb.setOverride(true);
                    return pb;
                }
            } else {
                ComponentInfo temp;
                String id;
                ComponentInfo table = null;
                if (attribute.getParent() != null && attribute.getParent().getParent() != null && !StringUtils.isEmpty((String)(id = attribute.getParent().getParent().getAttributeValue("id"))) && (temp = UIProxyHelper.findControlByName(this.model.getMainPanelComponent(), id)) != null && "com.kingdee.bos.ctrl.web.EditDataGrid".equals(temp.getClassType())) {
                    table = temp;
                }
                if (table != null) {
                    com.kingdee.bos.metadata.entity.PropertyInfo prop;
                    LinkPropertyInfo lnkProp;
                    if (propName.startsWith("data.") && (lnkProp = this.getEntryProperty(table)) != null && (prop = lnkProp.getRelationship().getSupplierObject().getPropertyByName(propName.substring("data.".length()))) != null) {
                        if (prop instanceof OwnPropertyInfo) {
                            PropertyBindingInfo pb = new PropertyBindingInfo();
                            pb.setPropertyName("value");
                            pb.setPropertyType(Object.class.getName());
                            pb.setBindingObject("editData");
                            pb.setBingdingField(propName);
                            pb.setFieldType(((OwnPropertyInfo)prop).getJavaType());
                            pb.setAccessType(2);
                            pb.setAutoMode(false);
                            pb.setOverride(true);
                            return pb;
                        }
                        if (prop instanceof LinkPropertyInfo) {
                            PropertyBindingInfo pb = new PropertyBindingInfo();
                            pb.setPropertyName("value");
                            pb.setPropertyType(Object.class.getName());
                            pb.setBindingObject("editData");
                            pb.setBingdingField(propName);
                            pb.setFieldType(((LinkPropertyInfo)prop).getRelationship().getSupplierObject().getObjectValueClass());
                            pb.setAccessType(2);
                            pb.setAutoMode(false);
                            pb.setOverride(true);
                            return pb;
                        }
                    }
                } else {
                    com.kingdee.bos.metadata.entity.PropertyInfo propInfo;
                    EntityObjectInfo entity = this.getBindedEntity();
                    if (propName.indexOf(".model.") > 0 && entity != null && (propInfo = EditUIProxyHelper.getPropertyByName(entity, propName = propName.substring(propName.indexOf(".model.") + ".model.".length()))) != null) {
                        PropertyBindingInfo pb = new PropertyBindingInfo();
                        pb.setPropertyName("value");
                        pb.setPropertyType(Xml2ComponentHelper.getBindPropertyType(component));
                        pb.setBindingObject("editData");
                        pb.setBingdingField(propName);
                        if (propInfo instanceof OwnPropertyInfo) {
                            pb.setFieldType(((OwnPropertyInfo)propInfo).getJavaType());
                        } else {
                            pb.setFieldType(((LinkPropertyInfo)propInfo).getRelationship().getSupplierObject().getBusinessImplName() + "Info");
                        }
                        pb.setAccessType(2);
                        pb.setAutoMode(false);
                        pb.setOverride(true);
                        return pb;
                    }
                }
            }
        }
        return null;
    }

    private LinkPropertyInfo getEntryProperty(ComponentInfo table) {
        EntityObjectInfo entity = this.getBindedEntity();
        if (entity == null) {
            return null;
        }
        PropertyInfo prop = table.getPropertyByName("value");
        if (prop != null) {
            String propName;
            String value = prop.getValue();
            if (!StringUtils.isEmpty((String)value) && value.startsWith("#{") && value.endsWith("}") && (propName = value.substring("#{".length(), value.indexOf("}"))).endsWith(".listModel")) {
                return Xml2ComponentHelper.getEntryProperty(entity, value.substring(0, value.indexOf(".listModel")));
            }
        } else {
            PropertyBindingCollection pbCol = table.getPropertyBindings();
            int n = pbCol.size();
            for (int i = 0; i < n; ++i) {
                com.kingdee.bos.metadata.entity.PropertyInfo property;
                String propName;
                PropertyBindingInfo pbInfo = pbCol.get(i);
                if (!"userObject".equals(pbInfo.getPropertyName()) || StringUtils.isEmpty((String)(propName = pbInfo.getBingdingField())) || (property = entity.getPropertyByName(propName, true)) == null || !(property instanceof LinkPropertyInfo)) continue;
                return (LinkPropertyInfo)property;
            }
        }
        return null;
    }

    private static String getBindPropertyType(ComponentInfo component) {
        if ("com.kingdee.bos.ctrl.web.TextField".equals(component.getClassType())) {
            return String.class.getName();
        }
        if ("com.kingdee.bos.ctrl.web.CheckBox".equals(component.getClassType())) {
            return "boolean";
        }
        return Object.class.getName();
    }

    private EventBindingInfo parseEventBinding(Element element) {
        if ("action".equals(element.getName())) {
            EventBindingInfo eventBinding = new EventBindingInfo();
            eventBinding.setEventName(element.getAttributeValue("event"));
            eventBinding.setMethodName(element.getAttributeValue("action"));
            return eventBinding;
        }
        return null;
    }

    private void parseEventBindings(Element element, ComponentInfo component) {
        List list = element.getChildren();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            EventBindingInfo ebInfo;
            Element subElement = (Element)list.get(i);
            WebTag webTag = WebTag.create(subElement);
            if (!this.isEventBinding(webTag) || (ebInfo = this.parseEventBinding(subElement)) == null) continue;
            component.getEventBindings().add(ebInfo);
        }
    }

    public boolean isProperty(ComponentInfo component, Attribute attribute) {
        return !this.isPropertyBinding(component, attribute);
    }

    public boolean isPropertyBinding(ComponentInfo component, Attribute attribute) {
        if ("com.kingdee.bos.ctrl.web.Button".equals(component.getClassType())) {
            return false;
        }
        return ("checked".equals(attribute.getName()) || "value".equals(attribute.getName())) && attribute.getValue().startsWith("#{");
    }

    public boolean isEventBinding(WebTag webTag) {
        return WebTags.ACTION.equals(webTag);
    }

    private String getAttributeValue(Attribute attribute) {
        String value = attribute.getValue();
        if (Xml2ComponentHelper.isELExpression(value)) {
            ResourceBundle bundle;
            String key = Xml2ComponentHelper.getELExpressionKey(value);
            String resKey = Xml2ComponentHelper.getELExpressionValue(value);
            if (!StringUtils.isEmpty((String)key) && !StringUtils.isEmpty((String)resKey) && (bundle = this.bundleMap.getBundle(key)) != null) {
                value = Xml2ComponentHelper.getResourceValue(bundle, resKey, value);
            }
        }
        return value;
    }

    private static String getResourceValue(ResourceBundle bundle, String key, String defaultValue) {
        try {
            String value = bundle.getString(key);
            return value;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private static boolean isELExpression(String value) {
        return value.startsWith("#{") && value.indexOf("['") > 0 && value.indexOf("']") > 0;
    }

    private static String getELExpressionKey(String el) {
        if (el.startsWith("#{") && el.indexOf("['") > 0) {
            return el.substring("#{".length(), el.indexOf("['"));
        }
        return null;
    }

    private static String getELExpressionValue(String el) {
        if (el.startsWith("#{") && el.indexOf("['") > 0 && el.indexOf("']") > 0) {
            return el.substring(el.indexOf("['") + 2, el.indexOf("']"));
        }
        return null;
    }
}

