/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.webui.transfer.strategy;

import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.LayoutInfo;
import com.kingdee.bos.metadata.webui.WebUIObjectInfo;
import com.kingdee.bos.metadata.webui.transfer.IWebUILayoutStrategy;
import com.kingdee.bos.metadata.webui.transfer.strategy.TablePanelManager;
import com.kingdee.bos.ui.bizunitproxy.UIProxyHelper;
import com.kingdee.util.StringUtils;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class AbstractWebUILayoutStrategy
implements IWebUILayoutStrategy {
    protected int width = 860;
    protected int height = 668;
    protected WebUIObjectInfo model;
    protected Map defineNameMap = new HashMap();
    protected Map tablePanelManagers = new HashMap();

    public AbstractWebUILayoutStrategy(WebUIObjectInfo model) {
        this.model = model;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    public LayoutInfo getLayoutInfo(ComponentInfo component) {
        return null;
    }

    public Object getConstraint(ComponentInfo component) {
        return null;
    }

    @Override
    public Rectangle getContentArea() {
        return null;
    }

    @Override
    public int getHorizontalSpace() {
        return 0;
    }

    @Override
    public int getVerticalSpace() {
        return 0;
    }

    @Override
    public void initMainPanel(WebUIObjectInfo model) {
        if (model.getMainPanelComponent() == null) {
            model.getComponents().add(this.createMainPanel());
        }
    }

    private ComponentInfo createMainPanel() {
        ComponentInfo mainPanel = new ComponentInfo();
        mainPanel.setName("coreUI");
        mainPanel.setClassType("com.kingdee.bos.ctrl.web.RootPane");
        mainPanel.setConstraint(new Rectangle(0, 0, this.getWidth(), this.getHeight()));
        mainPanel.setContainer(true);
        LayoutInfo layout = new LayoutInfo();
        layout.setName("kdLayout1");
        layout.setValue("3,3");
        mainPanel.setLayoutInfo(layout);
        return mainPanel;
    }

    @Override
    public ComponentInfo addComponent(ComponentInfo container, ComponentInfo component, Dimension dim) {
        if ("com.kingdee.bos.ctrl.web.LabelContainer".equals(container.getClassType())) {
            component.setConstraint("7");
            container.addChild(this.model, component);
        } else if ("com.kingdee.bos.ctrl.web.Tree".equals(container.getClassType()) || "com.kingdee.bos.ctrl.web.TreeNode".equals(container.getClassType())) {
            component.setConstraint("width=170;height=19;newLine=false");
            container.addChild(this.model, component);
        } else if ("com.kingdee.bos.ctrl.web.EditDataGrid".equals(container.getClassType()) || "com.kingdee.bos.ctrl.web.DataGrid".equals(container.getClassType()) || "com.kingdee.bos.ctrl.web.EditableColumn".equals(container.getClassType())) {
            component.setConstraint("width=170;height=19;newLine=false");
            container.addChild(this.model, component);
        } else if ("com.kingdee.bos.ctrl.web.ToolBar".equals(container.getClassType())) {
            if ("com.kingdee.bos.ctrl.web.ToolBar".equals(component.getClassType())) {
                int n = component.getComponents().size();
                for (int i = 0; i < n; ++i) {
                    component.getComponents().get(i).setConstraint(String.valueOf(container.getComponents().size()));
                    container.addChild(this.model, component.getComponents().get(i));
                }
                return container;
            }
            component.setConstraint(String.valueOf(container.getComponents().size()));
            container.addChild(this.model, component);
        } else {
            ComponentInfo tablePanel = null;
            tablePanel = "com.kingdee.bos.ctrl.web.TablePanel".equals(container.getClassType()) ? container : this.getDefaultTablePanel();
            if (tablePanel != null) {
                if ("com.kingdee.bos.ctrl.web.ToolBar".equals(component.getClassType())) {
                    this.getTablePanelManager(tablePanel).addComponent(component, dim, true);
                } else {
                    this.getTablePanelManager(tablePanel).addComponent(component, dim, false);
                }
            }
        }
        return component;
    }

    protected TablePanelManager getTablePanelManager(ComponentInfo component) {
        if (component == null || StringUtils.isEmpty((String)component.getName())) {
            return null;
        }
        if (this.tablePanelManagers.containsKey(component.getName())) {
            return (TablePanelManager)this.tablePanelManagers.get(component.getName());
        }
        TablePanelManager manager = new TablePanelManager(this.model, component, 2);
        this.tablePanelManagers.put(component.getName(), manager);
        return manager;
    }

    @Override
    public ComponentInfo getDefinedComponent(String defineName) {
        String componentName = (String)this.defineNameMap.get(defineName);
        if (!StringUtils.isEmpty((String)componentName)) {
            return UIProxyHelper.findControlByName(this.model.getMainPanelComponent(), componentName);
        }
        return null;
    }

    @Override
    public ComponentInfo getMainPanel() {
        return this.model.getMainPanelComponent();
    }

    @Override
    public ComponentInfo getDefaultTablePanel() {
        List list = UIProxyHelper.findControlsByClassType(this.getMainPanel(), "com.kingdee.bos.ctrl.web.TablePanel");
        if (list.size() > 0) {
            return (ComponentInfo)list.get(0);
        }
        return null;
    }

    @Override
    public void updateModel() {
        Iterator iter = this.tablePanelManagers.values().iterator();
        while (iter.hasNext()) {
            ((TablePanelManager)iter.next()).updateFormatXml();
        }
    }
}

