/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.webui.transfer.tablemodel;

import com.kingdee.bos.metadata.webui.transfer.tablemodel.TableCell;
import com.kingdee.bos.metadata.webui.transfer.tablemodel.TableColumn;
import com.kingdee.bos.metadata.webui.transfer.tablemodel.TableRow;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Table {
    private List rows = new ArrayList();
    private List columns = new ArrayList();
    private List rowCells = new ArrayList();
    private List columnCells = new ArrayList();
    private Map mergedCells = new HashMap();

    public int getRowCount() {
        return this.rows.size();
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public int getCellHSpace() {
        return 0;
    }

    public int getCellVSpace() {
        return 0;
    }

    public Collection getRows() {
        return this.rows;
    }

    public Collection getColumns() {
        return this.columns;
    }

    public TableRow getRow(int row) {
        if (row >= 0 && row < this.rows.size()) {
            return (TableRow)this.rows.get(row);
        }
        return null;
    }

    public TableColumn getColumn(int column) {
        if (column >= 0 && column < this.columns.size()) {
            return (TableColumn)this.columns.get(column);
        }
        return null;
    }

    public TableCell getCell(int row, int column) {
        if (row >= 0 && row < this.rows.size() && column >= 0 && column < this.columns.size()) {
            return (TableCell)((List)this.rowCells.get(row)).get(column);
        }
        return null;
    }

    public TableRow addRow() {
        ArrayList newRowCells = new ArrayList();
        TableRow row = this.createRow(newRowCells);
        this.rows.add(row);
        this.rowCells.add(newRowCells);
        int n = this.columns.size();
        for (int i = 0; i < n; ++i) {
            ((List)this.columnCells.get(i)).add(row.getCell(i));
        }
        return row;
    }

    public TableColumn addColumn() {
        ArrayList newColumnCells = new ArrayList();
        TableColumn column = this.createColumn(newColumnCells);
        this.columns.add(column);
        this.columnCells.add(newColumnCells);
        int n = this.rows.size();
        for (int i = 0; i < n; ++i) {
            ((List)this.rowCells.get(i)).add(column.getCell(i));
        }
        return column;
    }

    public TableRow insertRow(int index) {
        ArrayList newRowCells = new ArrayList();
        TableRow row = this.createRow(newRowCells);
        this.rows.add(index, row);
        this.rowCells.add(index, newRowCells);
        int n = this.columns.size();
        for (int i = 0; i < n; ++i) {
            ((List)this.columnCells.get(i)).add(index, row.getCell(i));
        }
        return row;
    }

    public TableColumn insertColumn(int index) {
        ArrayList newColumnCells = new ArrayList();
        TableColumn column = this.createColumn(newColumnCells);
        this.columns.add(index, column);
        this.columnCells.add(index, newColumnCells);
        int n = this.rows.size();
        for (int i = 0; i < n; ++i) {
            ((List)this.rowCells.get(i)).add(index, column.getCell(i));
        }
        return column;
    }

    private TableRow createRow(List newRowCells) {
        int n = this.columns.size();
        for (int i = 0; i < n; ++i) {
            newRowCells.add(new TableCell(newRowCells, (List)this.columnCells.get(i), this.mergedCells));
        }
        TableRow row = new TableRow(this.rows, newRowCells);
        return row;
    }

    private TableColumn createColumn(List newColumnCells) {
        int n = this.rows.size();
        for (int i = 0; i < n; ++i) {
            newColumnCells.add(new TableCell((List)this.rowCells.get(i), newColumnCells, this.mergedCells));
        }
        TableColumn column = new TableColumn(this.columns, newColumnCells);
        return column;
    }

    public void removeRow(int index) {
        int j;
        int n = this.getColumnCount();
        for (j = 0; j < n; ++j) {
            TableCell cell = this.getCell(index, j);
            this.unMergeCell(cell);
            this.mergedCells.remove(cell);
        }
        n = this.getColumnCount();
        for (j = 0; j < n; ++j) {
            ((List)this.columnCells.get(j)).remove(index);
        }
        this.rows.remove(index);
        this.rowCells.remove(index);
    }

    public void clearRows() {
        int n = this.columns.size();
        for (int i = 0; i < n; ++i) {
            ((List)this.columnCells.get(i)).clear();
        }
        this.rows.clear();
        this.rowCells.clear();
        this.mergedCells.clear();
    }

    public void removeColumn(int index) {
        int i;
        int n = this.getRowCount();
        for (i = 0; i < n; ++i) {
            TableCell cell = this.getCell(i, index);
            this.unMergeCell(cell);
            this.mergedCells.remove(cell);
        }
        n = this.getRowCount();
        for (i = 0; i < n; ++i) {
            ((List)this.rowCells.get(i)).remove(index);
        }
        this.columns.remove(index);
        this.columnCells.remove(index);
    }

    public void clearColumns() {
        int n = this.rows.size();
        for (int i = 0; i < n; ++i) {
            ((List)this.rowCells.get(i)).clear();
        }
        this.columns.clear();
        this.columnCells.clear();
        this.mergedCells.clear();
    }

    public boolean mergeCell(int row1, int column1, int row2, int column2) {
        int rowCount = this.getRowCount();
        int columnCount = this.getColumnCount();
        if (row1 < 0 || column1 < 0 || row2 < 0 || column2 < 0 || row1 > rowCount - 1 || row2 > rowCount - 1 || column1 > columnCount - 1 || column2 > columnCount - 1 || row1 > row2 || column1 > column2) {
            return false;
        }
        TableCell mergedCell = this.getCell(row1, column1);
        for (int i = row1; i <= row2; ++i) {
            for (int j = column1; j <= column2; ++j) {
                TableCell cell = this.getCell(i, j);
                this.mergedCells.put(cell, mergedCell);
            }
        }
        return true;
    }

    public boolean unMergeCell(TableCell cell) {
        if (cell == null || !cell.isMerged() || cell != cell.getMergedCell()) {
            return false;
        }
        int row1 = cell.getRowIndex();
        int column1 = cell.getColumnIndex();
        int row2 = cell.getRowIndex() + cell.getRowSpan() - 1;
        int column2 = cell.getColumnIndex() + cell.getColumnSpan() - 1;
        return this.unMergeCell(row1, column1, row2, column2);
    }

    public boolean unMergeCell(int row1, int column1, int row2, int column2) {
        int rowCount = this.getRowCount();
        int columnCount = this.getColumnCount();
        if (row1 < 0 || column1 < 0 || row2 < 0 || column2 < 0 || row1 > rowCount - 1 || row2 > rowCount - 1 || column1 > columnCount - 1 || column2 > columnCount - 1 || row1 > row2 || column1 > column2) {
            return false;
        }
        for (int i = row1; i <= row2; ++i) {
            for (int j = column1; j <= column2; ++j) {
                TableCell cell = this.getCell(i, j);
                this.mergedCells.remove(cell);
            }
        }
        return true;
    }

    public TableRow splitRow(int index, int seperator) {
        TableRow row = this.getRow(index);
        if (row != null && row.getTop() < seperator && row.getTop() + row.getHeight() > seperator) {
            ArrayList newRowCells = new ArrayList();
            TableRow newRow = this.createRow(newRowCells);
            this.rows.add(index + 1, newRow);
            this.rowCells.add(index + 1, newRowCells);
            int n = this.columns.size();
            for (int i = 0; i < n; ++i) {
                ((List)this.columnCells.get(i)).add(index + 1, newRow.getCell(i));
            }
            newRow.setTop(seperator);
            newRow.setHeight(row.getTop() + row.getHeight() - seperator);
            row.setHeight(seperator - row.getTop());
            int n2 = this.getColumnCount();
            for (int i = 0; i < n2; ++i) {
                TableCell cell = row.getCell(i);
                if (!cell.isMerged() || cell != cell.getMergedCell() || cell.getRowSpan() <= 1) continue;
                for (int j = 0; j < cell.getColumnSpan(); ++j) {
                    this.mergedCells.put(newRow.getCell(i + j), cell);
                }
            }
            return newRow;
        }
        return null;
    }

    public TableColumn splitColumn(int index, int seperator) {
        TableColumn column = this.getColumn(index);
        if (column != null && column.getLeft() < seperator && column.getLeft() + column.getWidth() > seperator) {
            ArrayList newColumnCells = new ArrayList();
            TableColumn newColumn = this.createColumn(newColumnCells);
            this.columns.add(index + 1, newColumn);
            this.columnCells.add(index + 1, newColumnCells);
            int n = this.rows.size();
            for (int i = 0; i < n; ++i) {
                ((List)this.rowCells.get(i)).add(index + 1, newColumn.getCell(i));
            }
            newColumn.setLeft(seperator);
            newColumn.setWidth(column.getLeft() + column.getWidth() - seperator);
            column.setWidth(seperator - column.getLeft());
            int n2 = this.getRowCount();
            for (int i = 0; i < n2; ++i) {
                TableCell cell = column.getCell(i);
                if (!cell.isMerged() || cell != cell.getMergedCell() || cell.getColumnSpan() <= 1) continue;
                for (int j = 0; j < cell.getRowSpan(); ++j) {
                    this.mergedCells.put(newColumn.getCell(i + j), cell);
                }
            }
            return column;
        }
        return null;
    }

    public Map getMergedCells() {
        return this.mergedCells;
    }
}

