/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.orm.trace.compatible;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.LoginUtils;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.orm.trace.XMLHelper;
import com.kingdee.bos.orm.trace.compatible.CompatibleHelper;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.util.Base64Encoder;
import com.kingdee.util.SAXBuilderFactory;
import com.kingdee.util.Uuid;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Iterator;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.DefaultJDOMFactory;
import org.jdom.input.JDOMFactory;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class DataXMLRepairer {
    public static final String OBJECTVALUE = "objectValue";
    public static final String OBJECTCOLLECTION = "objectCollection";
    public static final String USEROBJECT = "userObject";
    public static final String CLASSNAME = "className";
    public static final String HASHCODE = "hashCode";
    public static final String ID = "id";
    public static final String NAME = "name";
    public static final String TYPE = "type";
    public static final String VALUE = "value";
    public static final String REFOBJECT = "refObj";
    public static final String ENTITY = "entity";
    public static final String COLLECTION = "collection";
    public static final String OWNPROPERTY = "ownProperty";
    public static final String ROOT = "root";
    public static final String NULL = "_~^NULL";
    public static final String COM_KINGDEE_BOS_UTIL_BOSOBJECTTYPE = "com.kingdee.bos.util.BOSObjectType";
    public static final String COM_KINGDEE_BOS_UTIL_BOSUUID = "com.kingdee.bos.util.BOSUuid";
    public static final String COM_KINGDEE_BOS_DAO_ORMAPPING_OBJECTUUIDPK = "com.kingdee.bos.dao.ormapping.ObjectUuidPK";
    public static final String COM_KINGDEE_BOS_METADATA_METADATAPK = "com.kingdee.bos.metadata.MetaDataPK";
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.orm.trace.compatible.DataXMLRepairer");
    private String ais;
    private String file;
    private String username;
    private String password = "";
    private String solution = "eas";
    private String locale = "L2";
    private String server = "tcp://localhost:11034";
    private boolean deleteSerializError = true;
    private boolean xmlDirty = false;
    private String metasdir;

    private Document repairXML(InputStream is) throws IOException, JDOMException, Exception {
        SAXBuilder builder = SAXBuilderFactory.create();
        Document doc = builder.build(is);
        Element root = doc.getRootElement();
        Iterator it = root.getChildren().iterator();
        Element elem = null;
        while (it.hasNext()) {
            elem = (Element)it.next();
            if (elem.getName().equals(OBJECTVALUE)) {
                this.repairObjectValueXML(root, elem);
                continue;
            }
            if (elem.getName().equals(OBJECTCOLLECTION)) {
                this.repairObjectCollectionXML(elem);
                continue;
            }
            if (!elem.getName().equals(USEROBJECT)) continue;
            this.repairUserObject(elem);
        }
        return doc;
    }

    private void repairUserObject(Element elem) {
    }

    private void repairObjectCollectionXML(Element elem) throws Exception {
        Object mainObject = Class.forName(elem.getAttributeValue(CLASSNAME)).newInstance();
        if (mainObject.getClass().isAssignableFrom(Class.forName("com.kingdee.bos.framework.agent.IObjectCollectionAgent"))) {
            return;
        }
    }

    private void repairObjectValueXML(Element root, Element el) throws Exception {
        IObjectValue tmpOV = null;
        String className = el.getAttributeValue(CLASSNAME);
        String key = el.getAttributeValue(ID);
        String mainHashCode = el.getAttributeValue(HASHCODE);
        Class<?> _class = Class.forName(className);
        Class<?> agentInterface = Class.forName("com.kingdee.bos.framework.agent.IObjectValueAgent");
        if (agentInterface.isAssignableFrom(_class)) {
            logger.info((Object)("ignore agent class for object[ID = " + key + ", CLASS=" + className + "]!"));
            return;
        }
        Object mainObject = _class.newInstance();
        Element entityEl2 = null;
        for (Element entityEl2 : el.getChildren()) {
            if (!entityEl2.getName().equals(ENTITY) || !mainHashCode.equals(entityEl2.getAttributeValue(HASHCODE))) continue;
            boolean haseDeserailizedError = false;
            tmpOV = (IObjectValue)mainObject;
            Iterator entityIt = entityEl2.getChildren().iterator();
            Element propElem = null;
            while (entityIt.hasNext()) {
                propElem = (Element)entityIt.next();
                if (propElem.getName().equals(OWNPROPERTY)) {
                    if (!this.repairObjectProperty(tmpOV, propElem)) continue;
                    haseDeserailizedError = true;
                    continue;
                }
                if (!propElem.getName().equals(REFOBJECT)) continue;
            }
            if (haseDeserailizedError || this.needRefreashRecord(tmpOV, entityEl2)) {
                try {
                    tmpOV = CompatibleHelper.refreshRecored(tmpOV);
                    Element newEl = this.rebuildObjectValueXML(tmpOV, entityEl2, key);
                    root.removeContent(el);
                    root.addContent(newEl);
                    logger.info((Object)("repair object [ID = " + key + ", CLASS=" + className + "]!"));
                    this.xmlDirty = true;
                }
                catch (BOSException e) {
                    logger.error((Object)"\u8bd5\u56fe\u5237\u65b0\u8bb0\u5f55\u65f6\u51fa\u9519", (Throwable)e);
                }
            }
            logger.info((Object)("no incompatibility for object[ID = " + key + ", CLASS=" + className + "]!"));
            break;
        }
    }

    Element rebuildObjectValueXML(IObjectValue tmpOV, Element el, String key) {
        return XMLHelper.getInstance().obj2Xml(key, tmpOV);
    }

    private boolean repairObjectProperty(IObjectValue parent, Element propElem) {
        block33: {
            String name = propElem.getAttributeValue(NAME);
            String type = propElem.getAttributeValue(TYPE);
            String strValue = propElem.getAttributeValue(VALUE);
            if (type.equals(DataType.BOOLEAN.getName())) {
                parent.put(name, Boolean.valueOf(strValue));
            } else if (type.equals(DataType.BYTE.getName())) {
                parent.put(name, new Byte(strValue));
            } else if (type.equals(DataType.CHAR.getName())) {
                parent.put(name, new Character(strValue.charAt(0)));
            } else if (type.equals(DataType.SHORT.getName())) {
                parent.put(name, new Short(strValue));
            } else if (type.equals(DataType.INTEGER.getName())) {
                parent.put(name, new Integer(strValue));
            } else if (type.equals(DataType.LONG.getName())) {
                parent.put(name, new Long(strValue));
            } else if (type.equals(DataType.FLOAT.getName())) {
                parent.put(name, new Float(strValue));
            } else if (type.equals(DataType.DOUBLE.getName())) {
                parent.put(name, new Double(strValue));
            } else if (type.equals(DataType.DECIMAL.getName())) {
                parent.put(name, new BigDecimal(strValue));
            } else if (type.equals(DataType.TIME.getName())) {
                parent.put(name, new Time(Long.valueOf(strValue)));
            } else if (type.equals(DataType.DATE.getName())) {
                parent.put(name, new Date(Long.valueOf(strValue)));
            } else if (type.equals(DataType.TIMESTAMP.getName())) {
                parent.put(name, new Timestamp(Long.valueOf(strValue)));
            } else if (type.equals(DataType.STRING.getName())) {
                parent.put(name, strValue);
            } else if (type.equals(DataType.BOSUUID.getName())) {
                parent.put(name, BOSUuid.read((String)strValue));
            } else if (type.equals(DataType.UUID.getName())) {
                parent.put(name, Uuid.read((String)strValue));
            } else if (type.equals("Serializable")) {
                try {
                    byte[] buffer = Base64Encoder.base64ToByteArray((String)strValue);
                    ByteArrayInputStream bis = new ByteArrayInputStream(buffer);
                    ObjectInputStream ois = new ObjectInputStream(bis);
                    Object obj = ois.readObject();
                    parent.put(name, obj);
                }
                catch (Exception e) {
                    if (!this.deleteSerializError) break block33;
                    return true;
                }
            }
        }
        return false;
    }

    private static JDOMFactory getJDOMFactory() {
        return new DefaultJDOMFactory();
    }

    private static Element createElement(String name) {
        return DataXMLRepairer.getJDOMFactory().element(name);
    }

    private static Attribute createAttribute(String name, String value) {
        return DataXMLRepairer.getJDOMFactory().attribute(name, value);
    }

    public boolean needRefreashRecord(IObjectValue ov, Element entityElem) {
        if (!CompatibleHelper.isEntity(ov.getBOSType())) {
            return false;
        }
        String policy = System.getProperty("rpctrace.loader.compatibility");
        if ("force".equalsIgnoreCase(policy)) {
            return true;
        }
        if ("ignore".equalsIgnoreCase(policy)) {
            return false;
        }
        Iterator entityIt = entityElem.getChildren().iterator();
        Element propElem = null;
        while (entityIt.hasNext()) {
            propElem = (Element)entityIt.next();
            if (propElem.getName().equals(OWNPROPERTY)) {
                String name = propElem.getAttributeValue(NAME);
                String type = propElem.getAttributeValue(TYPE);
                int c = CompatibleHelper.onwerPropertyExist(ov.getBOSType(), name, type);
                switch (c) {
                    case -1: 
                    case 1: 
                    case 2: {
                        return true;
                    }
                    case 0: {
                        break;
                    }
                }
                continue;
            }
            if (!propElem.getName().equals(REFOBJECT)) continue;
        }
        if (CompatibleHelper.hasNewProperty(ov.getBOSType(), entityElem)) {
            return true;
        }
        logger.info((Object)"ov\u6ca1\u6709\u5c5e\u6027\u6539\u53d8");
        try {
            if (!CompatibleHelper.dataExistByPK(ov)) {
                return true;
            }
        }
        catch (BOSException e) {
            logger.error((Object)"\u67e5\u627e\u6570\u636e\u7684\u65f6\u5019\u51fa\u9519!", (Throwable)e);
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean prepare() {
        File f;
        Logger root;
        Logger logger = root = Logger.getRootLogger();
        synchronized (logger) {
            if (!root.getAllAppenders().hasMoreElements()) {
                BasicConfigurator.configure();
            }
        }
        if (this.ais == null || this.username == null || this.ais == null || this.file == null) {
            DataXMLRepairer.printUseage();
            return false;
        }
        if (this.file != null && !(f = new File(this.file)).exists()) {
            DataXMLRepairer.logger.info((Object)("file:" + this.file + " not a file or not a dir!"));
            DataXMLRepairer.printUseage();
            return false;
        }
        if (this.metasdir == null) {
            DataXMLRepairer.logger.info((Object)"metasdir not set !");
            DataXMLRepairer.printUseage();
            return false;
        }
        File metaDataFile = new File(this.metasdir);
        if (!metaDataFile.exists()) {
            DataXMLRepairer.logger.info((Object)("Can't find metadata : " + this.metasdir));
            return false;
        }
        DataXMLRepairer.logger.debug((Object)("Client metadatapath : " + this.metasdir));
        MetaDataLoaderFactory.setClientMetaDataPath(this.metasdir);
        try {
            LoginUtils.login(this.server, this.username, this.password, this.solution, this.ais, BOSLocaleUtil.getLocale(this.locale));
        }
        catch (BOSException e1) {
            e1.printStackTrace();
            return false;
        }
        return true;
    }

    void repairDir(File dir) {
        File[] children = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() ? file.getAbsolutePath().toLowerCase().endsWith("xml") : file.isDirectory();
            }
        });
        for (int i = 0; i < children.length; ++i) {
            if (children[i].isDirectory()) {
                this.repairDir(children[i]);
                continue;
            }
            this.repairFile(children[i]);
        }
    }

    void repairFile(File file) {
        if (file != null) {
            try {
                logger.info((Object)("start parsing xml file[" + file.getAbsolutePath() + "]..."));
                Document doc = this.repairXML(new FileInputStream(file));
                if (this.xmlDirty) {
                    XMLOutputter out = new XMLOutputter("    ", true);
                    out.setTrimAllWhite(true);
                    out.output(doc, (OutputStream)new FileOutputStream(file));
                    logger.info((Object)("end repair xml file[" + file.getAbsolutePath() + "]"));
                } else {
                    logger.info((Object)("no modification to xml file[" + file.getAbsolutePath() + "]"));
                }
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
            catch (JDOMException e) {
                logger.error((Object)e);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            return;
        }
    }

    public static void main(String[] args) {
        DataXMLRepairer repairer = new DataXMLRepairer();
        repairer.parseArguments(args);
        if (repairer.prepare()) {
            repairer.repair();
        }
    }

    private void repair() {
        if (this.file != null) {
            if (new File(this.file).isFile()) {
                this.repairFile(new File(this.file));
            } else if (new File(this.file).isDirectory()) {
                this.repairDir(new File(this.file));
            }
        }
    }

    private void parseArguments(String[] args) throws IllegalArgumentException {
        try {
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if ("-f".equalsIgnoreCase(arg)) {
                    DataXMLRepairer.checkIndex(++i, args);
                    this.file = args[i];
                    continue;
                }
                if ("-server".equalsIgnoreCase(arg)) {
                    DataXMLRepairer.checkIndex(++i, args);
                    this.server = args[i];
                    continue;
                }
                if ("-ais".equalsIgnoreCase(arg)) {
                    DataXMLRepairer.checkIndex(++i, args);
                    this.ais = args[i];
                    continue;
                }
                if ("-metasdir".equalsIgnoreCase(arg)) {
                    DataXMLRepairer.checkIndex(++i, args);
                    this.metasdir = args[i];
                    continue;
                }
                if ("-username".equalsIgnoreCase(arg)) {
                    DataXMLRepairer.checkIndex(++i, args);
                    this.username = args[i];
                    continue;
                }
                if ("-password".equalsIgnoreCase(arg)) {
                    DataXMLRepairer.checkIndex(++i, args);
                    this.password = args[i];
                    if (this.password.length() < 2 || !this.password.startsWith("'") || !this.password.endsWith("'")) continue;
                    StringBuffer buffer = new StringBuffer(this.password);
                    buffer.delete(0, 1);
                    buffer.delete(buffer.length() - 1, buffer.length());
                    this.password = buffer.toString();
                    continue;
                }
                if ("-solution".equalsIgnoreCase(arg)) {
                    DataXMLRepairer.checkIndex(++i, args);
                    this.solution = args[i];
                    continue;
                }
                if (!"-locale".equalsIgnoreCase(arg)) continue;
                DataXMLRepairer.checkIndex(++i, args);
                this.locale = args[i];
            }
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    private static void checkIndex(int index, String[] args) {
        if (index >= args.length) {
            throw new IllegalArgumentException("invalid index");
        }
    }

    private static void printUseage() {
        System.out.println("DataXMLRepairer -f          :xml File");
        System.out.println("                -metasdir   :client metas");
        System.out.println("                -ais        :ais");
        System.out.println("                -username   :username");
        System.out.println("                -password   :password");
        System.out.println("                [-solution] :solutionName, default=eas");
        System.out.println("                [-locale]   :locale, default=l2");
    }
}

