/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.service.IBatchServiceAdaptor;
import com.kingdee.bos.service.IServiceAdapter;
import com.kingdee.bos.service.IServiceAdapterFilter;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.bos.service.IServiceManager;
import com.kingdee.bos.service.ServiceExecutionException;
import com.kingdee.bos.service.ServiceStateManager;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractServiceManager
implements IServiceManager {
    private static Logger logger = Logger.getLogger(AbstractServiceManager.class);
    protected final Map<String, IServiceAdapter> services = new HashMap<String, IServiceAdapter>(5);
    protected final Map<String, Boolean> servicesState = new HashMap<String, Boolean>(5);

    protected abstract void doService(IServiceAdapter var1, IServiceContext var2) throws BOSException;

    @Override
    public void execute(IServiceContext[] arrServiceContext) throws ServiceExecutionException, BOSException {
        this.innerExecute(arrServiceContext);
    }

    @Override
    public void execute(IServiceContext serviceContext) throws ServiceExecutionException, BOSException {
        this.innerExecute(new IServiceContext[]{serviceContext});
    }

    public void innerExecute(IServiceContext[] arrServiceContext) throws ServiceExecutionException, BOSException {
        int i;
        if (arrServiceContext == null || arrServiceContext.length == 0) {
            return;
        }
        IServiceContext svcCtx = null;
        for (int i2 = 0; i2 < arrServiceContext.length; ++i2) {
            if (arrServiceContext[i2] == null) continue;
            svcCtx = arrServiceContext[i2];
            break;
        }
        if (svcCtx == null) {
            return;
        }
        Object[] adaptors = this.getServices();
        Arrays.sort(adaptors);
        if (svcCtx.getExecutionMode() == 1) {
            for (i = 0; i < adaptors.length / 2; ++i) {
                Object temp = adaptors[i];
                adaptors[i] = adaptors[adaptors.length - 1 - i];
                adaptors[adaptors.length - 1 - i] = temp;
            }
        }
        if (adaptors == null || adaptors.length <= 0) {
            return;
        }
        if ((MetaDataTypeList.FACADE.equals((Object)svcCtx.getMetaType()) || MetaDataTypeList.ENTITY.equals((Object)svcCtx.getMetaType())) && svcCtx.getServiceParameter("STATEMGMT", "EXECUTE") == null) {
            IServiceAdapterFilter filter = ServiceStateManager.getInstance().getServiceAdapterFilter();
            for (int i3 = 0; i3 < adaptors.length; ++i3) {
                if (!filter.accept((IServiceAdapter)adaptors[i3])) continue;
                this.doService((IServiceAdapter)adaptors[i3], arrServiceContext);
            }
        } else {
            for (i = 0; i < adaptors.length; ++i) {
                this.doService((IServiceAdapter)adaptors[i], arrServiceContext);
            }
        }
    }

    private final void doService(IServiceAdapter adapter, IServiceContext[] arrSvcCtx) throws BOSException {
        assert (arrSvcCtx != null && arrSvcCtx.length > 0);
        if (arrSvcCtx.length == 1 && arrSvcCtx[0] != null) {
            this.doService(adapter, arrSvcCtx[0]);
            return;
        }
        if (adapter instanceof IBatchServiceAdaptor) {
            ((IBatchServiceAdaptor)adapter).batchExecute(arrSvcCtx);
        } else {
            int n = arrSvcCtx.length;
            for (int i = 0; i < n; ++i) {
                if (arrSvcCtx[i] == null) continue;
                try {
                    this.doService(adapter, arrSvcCtx[i]);
                    continue;
                }
                catch (BOSException bose) {
                    arrSvcCtx[i].setServiceResult(adapter.getName(), (Object)bose);
                }
            }
        }
    }

    @Override
    public void clearServices() {
        this.services.clear();
        this.servicesState.clear();
    }

    @Override
    public IServiceAdapter getService(String serviceName) {
        return this.services.get(serviceName);
    }

    @Override
    public IServiceAdapter[] getServices() {
        Map.Entry[] entries = this.services.entrySet().toArray(new Map.Entry[0]);
        IServiceAdapter[] adapters = new IServiceAdapter[entries.length];
        for (int i = 0; i < entries.length; ++i) {
            adapters[i] = (IServiceAdapter)entries[i].getValue();
        }
        return adapters;
    }

    @Override
    public void registerService(IServiceAdapter service) {
        this.services.put(service.getName(), service);
        this.servicesState.put(service.getName(), Boolean.TRUE);
    }

    @Override
    public void registerService(String serviceClass) {
        block2: {
            try {
                IServiceAdapter adapter = (IServiceAdapter)Class.forName(serviceClass).newInstance();
                this.registerService(adapter);
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)("Cannot register service [" + serviceClass + "]"));
            }
        }
    }

    @Override
    public void unregisterService(IServiceAdapter service) {
        this.unregisterService(service.getName());
    }

    @Override
    public void unregisterService(String serviceName) {
        this.services.remove(serviceName);
        this.servicesState.remove(serviceName);
    }

    @Override
    public boolean contains(IServiceAdapter adapter) {
        return this.contains(adapter.getName());
    }

    @Override
    public boolean contains(String serviceName) {
        return this.services.containsKey(serviceName);
    }

    @Override
    public void disableService(IServiceAdapter service) {
        this.disableService(service.getName());
    }

    @Override
    public void disableService(String serviceName) {
        this.servicesState.put(serviceName, Boolean.FALSE);
    }

    @Override
    public void enableService(IServiceAdapter service) {
        this.enableService(service.getName());
    }

    @Override
    public void enableService(String serviceName) {
        this.servicesState.put(serviceName, Boolean.TRUE);
    }

    @Override
    public boolean isEnable(IServiceAdapter service) {
        return this.isEnable(service.getName());
    }

    @Override
    public boolean isEnable(String name) {
        Boolean flag = this.servicesState.get(name);
        if (flag == null) {
            return false;
        }
        return flag;
    }
}

